//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <x11/WSDunixExternal.h>
#include <stdio.h>
#ifndef MacOS
#include <dlfcn.h>
#else //MacOS
#include <Carbon/Carbon.h>
#include <Strings.h>
//#include <TextUtils.h>
//#include <CodeFragments.h>
//#include <Aliases.h>

#include <mach-o/dyld.h>
#define RTLD_LAZY 0
void* dlopen(char* fname,long){
  CFragConnectionID cid;
  Str255 buffer;
  c2pstrcpy(buffer, fname);
//  c2pstr(buffer);

  FSSpec libspec;
  OSErr err = FSMakeFSSpec(0, 0, buffer, &libspec);
printf("FSMakeFSSpec ret =%d\n",err);
  Boolean dust1,dust2;
  err = ResolveAliasFile(&libspec, 1, &dust1, &dust2);
  if (err) {
    printf("ResolveAliasFile error:%s\n", fname);
    return NULL;
  }

  char err_msg[1024];
  Str63 fragname;
  fragname[0] = 0;
  Ptr maddr;
  err = GetDiskFragment(&libspec, 0, 0, fragname,
                kLoadCFrag, &cid, &maddr, err_msg);
  if (err) {
    printf("GetDiskFragment error:%s file:%s\n",err_msg,fname);
    return NULL;
  }
  return cid;
};
void* dlsym(void* ptr,char* procn){
  char err_msg[1024];
  Str255 buf;
  c2pstrcpy(buf,procn);
//  c2pstr(buf);
  Ptr ret;
  CFragSymbolClass cdata;
  OSErr err = FindSymbol( (CFragConnectionID) ptr, buf, &ret, &cdata);
  if (err) {
printf("FindSymbol error:%s\n",procn);
  }
  return (void*)ret;
}
#endif //MacOS

WSMFclassInit(WSDunixExternal,WSDexternal);

WSDexternal* _unix_external_create(){
  return new WSDunixExternal;
}

class _unix_external_init {
  public: _unix_external_init(){
    WSDexternal::setCreateInstanceHandler((void*)_unix_external_create);
  };
};

_unix_external_init  _unix_external_init_execute;

WSDunixExternal::WSDunixExternal(){
  _dl_ptr = NULL;
}

WSDunixExternal::~WSDunixExternal(){
  if (_dl_ptr != NULL){
    close();
  }
}

long WSDunixExternal::open(char* name){
  _ptr = NULL;
  WSDexternal::setTempData(NULL); 

  _dll_name.setString(name);
  _dl_ptr = dlopen(name,RTLD_LAZY);
  if (_dl_ptr != NULL){
    _ptr = WSDexternal::getTempData();
    return WS_NO_ERR;
  }
#ifndef MacOS
fprintf(stderr,"Error: WSDunixExternal::open  dll open error:%s\n",dlerror());
#endif //MacOS
  return WS_ERR;
}

long WSDunixExternal::close(){
  if (_dl_ptr != NULL){
#ifndef MacOS
    dlclose(_dl_ptr);
#endif //MacOS
    _dl_ptr = NULL;
    _ptr = NULL;
  }
  return WS_NO_ERR;
}

WSCstring* WSDunixExternal::getObjectSymbols(){
  if (_ptr != NULL){
    WSCstring* str = new WSCstring;
    char** sym = (char**) _ptr;
    long i=0;
    while(1){
      if (sym[i] == NULL){
        break;
      }
      str->addString(sym[i]);
      str->addString(" ");
      i++;
      str->addString(sym[i]);
      str->addString("\n");
      i++;
      str->addString(sym[i]);
      str->addString("\n");
      i++;
    }
    return str;
  }
  return NULL;
}

