//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCRBASE_H
#define WSCRBASE_H

#include <WScom.h>
#include <WSCRroot.h>
#include <WSCstring.h>
#include <WSDserialize.h>
#include <WSCconductor.h>
#include <WSCindexData.h>

class WSCRbase :public WSCRroot{

 protected:
  WSCbase* _local;
static WSCindexData* _create_handlers;

 public:
  WSDLEX32 WSCRbase();
  WSDLEX32 virtual ~WSCRbase();
  WSDLEX32 void setLocalInstance(WSCbase*);

  WSDLEX32 static  void setCreateHandler(char* cn,WSCRbase* (*hd)());
  WSDLEX32 static  WSCRbase* getNewInstance(char* cn);

  WSDLEX32 void    setVisible(WSCbool fl);
  WSDLEX32 WSCbool getVisible();
  WSDLEX32 void    setSensitive(WSCbool fl);
  WSDLEX32 WSCbool getSensitive();

  WSDLEX32 long clear();
  WSDLEX32 long draw();
  WSDLEX32 long redraw();
  WSDLEX32 long cdraw();

  WSDLEX32 void onMouseIn(WSCpoint*);
  WSDLEX32 void onMouseOut();
  WSDLEX32 void onMouseMove(WSCpoint*);
  WSDLEX32 void onMousePress(WSCpoint*);
  WSDLEX32 void onMouseRelease(WSCpoint*);
  WSDLEX32 void onExpose(WSCrect*);
  WSDLEX32 void onResize(WSCrect*);
  WSDLEX32 void onVisibleChange(WSCbool);
  WSDLEX32 void onSensitiveChange(WSCbool);
  WSDLEX32 void onParentVisibleChange(WSCbool);
  WSDLEX32 void onParentSensitiveChange(WSCbool);
  WSDLEX32 void onEditModeChange(WSCbool);
  WSDLEX32 void onFocusChange(WSCbool);
  WSDLEX32 void onSpecialFocusChange(WSCbool);
  WSDLEX32 void onSelectionChange(WSCbool);

  WSDLEX32 void execProcedure(char*);
  WSDLEX32 void execProcedure(long);

  WSDLEX32 WSCbool    setProperty(char *name,const WSCvariant&);
  WSDLEX32 WSCvariant getProperty(char* name);

  WSDLEX32 WSCbool getFocus();
  WSDLEX32 WSCbool getSpecialFocus();
  WSDLEX32 long setFocus(WSCbool fl = True);
  WSDLEX32 long setSpecialFocus(WSCbool fl = True);

  WSMFclassDef(WSCRbase,WSCRroot);
};

#define WSMFremoteClassInit(RCN,CN) \
  WSCRbase* RCN ## _create(){ \
    return new RCN(); \
  };\
  class RCN ## _init{ \
    public: \
      RCN ## _init(){ \
        WSCRbase::setCreateHandler(#CN,RCN ## _create ); \
      }; \
  }; \
  static RCN ## _init RCN ## _init_run_constructor;

#endif
