//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 

#ifndef WSCBASEDIALOG_H
#define WSCBASEDIALOG_H

#include <WScom.h>
#include <WSCwindow.h>

class WSCvbtn;
class WSCvlabel;
class WSCform;

#define WSCbaseDialog_VER  1000

class WSCbaseDialog :public WSCwindow{

  private:
  protected:
    WSCvbtn*  _end_btn;
    WSCvbtn*  _ok_btn;
    WSCvbtn*  _no_btn;
    WSCform*  _cmd_form;
    WSCvlabel* _title_label;
#ifndef NO_WINDOW_TITLE
    WSCvlabel* _title_labels1;
    WSCvlabel* _title_labels2;
#endif
    void*     _rep;
    char*     _ok_str;
    char*     _no_str;
    char*     _cancel_str;
    char*     _tb_name;
    char*     _btb_name;

    short     _title_pixmap;
    char      _focus_btn;
    unsigned  _ok:1;
    unsigned  _no:1;
    unsigned  _cancel:1;
    unsigned  _status:2;
    unsigned  _modal:1;
    unsigned  _default_pos:1;
    unsigned  _popuped:1;
    unsigned  _enable_esc:1;
    unsigned  _enable_close_on_cancel:1;
    unsigned  _font:4;

    WSMFpropertyDef(WSNok,              WSCbool, _ok);
    WSMFpropertyDef(WSNno,              WSCbool, _no);
    WSMFpropertyDef(WSNcancel,              WSCbool, _cancel);
    WSMFpropertyDef(WSNlabelPixmap,     short,   _title_pixmap);
    WSMFpropertyDef(WSNokString,        char*,   _ok_str);
    WSMFpropertyDef(WSNnoString,        char*,   _no_str);
    WSMFpropertyDef(WSNcancelString,        char*,   _cancel_str);
    WSMFpropertyDef(WSNreplyHandler,    void*,   _rep);
    WSMFpropertyDef(WSNmodal,           WSCbool, _modal);
    WSMFpropertyDef(WSNdefaultPosition, WSCbool, _default_pos);
    WSMFpropertyDef(WSNkeepPixmapCache, WSCbool, _keep_pixmap_cache);
    WSMFpropertyDef(WSNtab, char*, _tb_name);
    WSMFpropertyDef(WSNbacktab, char*, _btb_name);
    WSMFpropertyDef(WSNfont,         WSCuchar,   _font         );

    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);
#ifndef NO_WINDOW_TITLE
    WSDLEX32 virtual void setWorkWSNtitleString(char*);
#endif
    WSDLEX32 static void _ok_btn_work(WSCbase*);
    WSDLEX32 static void _no_btn_work(WSCbase*);
    WSDLEX32 static void _end_btn_work(WSCbase*);

     WSDLEX32 virtual long _device_initialize();

  public:
    WSDLEX32 WSCbaseDialog(WSCbase*,char*);
    WSDLEX32 virtual  ~WSCbaseDialog();
    WSDLEX32 virtual  long initialize();

    WSDLEX32 virtual void onResize(WSCrect*);
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onGuiPolicyChange(long);
    WSDLEX32 virtual void onFocusChange(WSCbool);
    WSDLEX32 virtual void onSpecialFocusChange(WSCbool);

    WSDLEX32 WSCbase* getFormObject();
    WSDLEX32 WSCbase* getCmdFormObject();
    WSDLEX32 long     getStatus();
    WSDLEX32 virtual  long popup();
    WSDLEX32 void     setFocusBtn(long); //WS_DIALOG_OK / WS_DIALOG_NO / WS_DIALOG_CANCEL
    WSDLEX32 void     setEnableEscapeKey(WSCbool);
    WSDLEX32 WSCbool  getEnableEscapeKey();
    WSDLEX32 void     setEnableCloseOnCancel(WSCbool);
    WSDLEX32 WSCbool  getEnableCloseOnCancel();
    WSDLEX32 virtual WSCbase* getFocusMoveInternalInstance(long);

    WSMFguiClassDef(WSCbaseDialog,WSCwindow);
    WSMFversionDef(WSCbaseDialog);
};
#endif
