//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 

#ifndef WSCBASELIST_H
#define WSCBASELIST_H

#include <WScom.h>
#include <WSCstring.h>
#include <WSClistData.h>
#include <WSCRroot.h>
#include <WSCRbase.h>

class WSCbase;
//class WSClistData;
class WSCremoteInstanceData{
  public:
    WSCstring _addr;
    WSCushort _port;
    WSCstring _public_instance_name;
    WSCstring _instance_name;
    WSCstring _class_name;

    WSDLEX32 WSCremoteInstanceData();
    WSDLEX32 ~WSCremoteInstanceData();

    WSDLEX32 void setPublicInstanceName(char*);
    WSDLEX32 void setInstanceName(char*);
    WSDLEX32 void setClassName(char*);
    WSDLEX32 void setAddr(char*);
    WSDLEX32 void setPort(WSCushort);

    WSDLEX32 WSCstring getPublicInstanceName();
    WSDLEX32 WSCstring getInstanceName();
    WSDLEX32 WSCstring getClassName();
    WSDLEX32 WSCstring getAddr();
    WSDLEX32 WSCushort getPort();

};
#define WS_BASE_LIST_MAX_ARRAY 64
class WSCbaseList{

 private:
  void*         _search_handler;
  WSClistData*  _base_list;
  WSClistData*  _need_update;
  WSClistData*  _need_init;
  WSClistData   _event_list;
  WSClistData   _event_client_list;
#ifndef NO_REMOTE_INSTANCE
  WSClistData   _remote_instance_list;
  WSClistData   _export_instance_list;
  WSClistData   _export_instance_update_list;
  WSClistData   _export_instance_delete_list;
  WSCbool       _remote_data_list_updated;
#endif
//  WSCbase*      _tmp_array[WS_BASE_LIST_MAX_ARRAY];
//  WSCbase**     _tmp_list;
//  long          _tmp_list_len;

#ifndef NO_MWT_FUNCTION
  WSClistData   _root_instance_list;
  WSClistData   _selected_instance_list;
  WSCulong      _target_instance_id;
#endif
#ifndef WS_EMBED
  WSClistData   _event_proc_list;
  WSClistData   _event_proc_fname_list;
  WSClistData   _event_proc_trg_list;
  WSClistData   _event_proc_data_list;
  void (*_event_proc_handler)(char*,void*);
  WSCstring     _instance_position_cname;
  WSCbool       _instance_position_mode;
#endif

 public:
  WSDLEX32 WSCbaseList();
  WSDLEX32 virtual ~WSCbaseList();

  WSDLEX32 WSCbase* getInstance(char* class_name,char* objname);
  WSDLEX32 WSClistData* getClassList();

  WSDLEX32 void addClient(WSCbase*,void* bases = NULL);
  WSDLEX32 void delClient(WSCbase* ,void* bases = NULL);

  WSDLEX32 long countObject(char* );
  WSDLEX32 void addNeedUpdate(WSCbase*);
  WSDLEX32 void addNeedInitialize(WSCbase*);
  WSDLEX32 void execUpdate();
  WSDLEX32 void execInitialize();
  WSDLEX32 void  setUserData(char*,void *);
  WSDLEX32 void* getUserData(char*);
  WSDLEX32 void  setUserLongData(char*,WSCulong);
  WSDLEX32 WSCulong  getUserLongData(char*);
  WSDLEX32 void  setUserStringData(char*,char*);
  WSDLEX32 char* getUserStringData(char*);

  WSDLEX32 WSClistData* getInstanceList(char*);
#ifndef NO_REMOTE_INSTANCE
  WSDLEX32 WSCRbase*    getRemoteInstance(char*);
#endif

  WSDLEX32 void         setSearchInstanceHandler(void*);
  WSDLEX32 WSCbase*     searchInstance(char* class_name,char* objname);
  WSDLEX32 WSCbool      existInstance(WSCbase*);
  WSDLEX32 void     addEvent(WSCbase*,long ev = WSEV_NONE);
  WSDLEX32 void     delEvent(WSCbase*,long ev = WSEV_NONE);
  WSDLEX32 void     execEvent(long,void*);
  WSDLEX32 void     execEvent(long);
  WSDLEX32 void     execEvent(char*);

#ifndef WS_EMBED
  WSDLEX32 void     addEventProc(char* fname,char*,long);
  WSDLEX32 void     addEventProc(char* fname,char*,void*);
  WSDLEX32 void     delEventProc(char* fname,char*);
  WSDLEX32 void     addEventProc(void(*hd)(void*),char*,void*);
  WSDLEX32 void     delEventProc(void(*hd)(void*),char*);
  WSDLEX32 void     execEventProc(char*);
  WSDLEX32 void     delAllEventProc();
  WSDLEX32 void     setEventProcHandler(void(*hd)(char*,void*));
#endif

#ifndef NO_REMOTE_INSTANCE
  WSDLEX32 long     addRemoteInstanceData(WSCremoteInstanceData* idata);
  WSDLEX32 long     delRemoteInstanceData(WSCremoteInstanceData* idata);
  WSDLEX32 WSCbool  getRemoteInstanceListUpdated();
  WSDLEX32 void     setRemoteInstanceListUpdated(WSCbool);
#endif

#ifndef NO_REMOTE_INSTANCE
  WSDLEX32 long     addExportInstanceList(WSCbase* inst);
  WSDLEX32 long     delExportInstanceList(WSCbase* inst);
  WSDLEX32 long     addExportInstanceUpdateList(WSCbase* inst);
  WSDLEX32 long     delExportInstanceUpdateList(WSCbase* inst);

  WSDLEX32 long     addExportInstanceDeleteList(WSCbase* inst);
  WSDLEX32 long     delExportInstanceDeleteList(WSCbase* inst);

  WSDLEX32 WSClistData* getExportInstanceDeleteList();
  WSDLEX32 WSClistData* getExportInstanceUpdateList();
  WSDLEX32 WSClistData* getExportInstanceList();
#endif

#ifndef NO_MWT_FUNCTION
#ifndef WS_EMBED
  WSDLEX32 void      setInstanceId(long kind,WSCulong data);
  WSDLEX32 WSCulong  getInstanceId(WSCulong id,long kind,WSCulong data);
  WSDLEX32 WSCstring getInstanceData(WSCulong id,long kind,WSCulong data);
  WSDLEX32 WSCbase*  getInstanceFromId(WSCulong id);
  WSDLEX32 WSCulong  getIdFromInstance(WSCbase* inst);
#endif
#endif

#ifndef NO_MWT_FUNCTION
  WSDLEX32 static void      setInternalWindowCreateHandler(void(*)(WSCbase*));
  WSDLEX32 static void*     getInternalWindowCreateHandler();
  WSDLEX32 static void      setInternalWindowVisibleHandler(void(*)(WSCbase*));
  WSDLEX32 static void*     getInternalWindowVisibleHandler();
  WSDLEX32 static void      setInternalWindowUnvisibleHandler(void(*)(WSCbase*));
  WSDLEX32 static void*     getInternalWindowUnvisibleHandler();
  WSDLEX32 static void      setInternalWindowDestroyHandler(void(*)(WSCbase*));
  WSDLEX32 static void*     getInternalWindowDestroyHandler();
#endif
#ifndef WS_EMBED
  WSDLEX32 void      setNewInstancePositionMode(WSCbool fl);
  WSDLEX32 WSCbool   getNewInstancePositionMode();
  WSDLEX32 void      setNewInstanceClassName(char*);
  WSDLEX32 WSCstring getNewInstanceClassName();
#endif

#ifndef NO_REMOTE_INSTANCE
  WSDLEX32 WSCremoteInstanceData*  getRemoteInstanceData(char* pname);
  WSDLEX32 WSClistData* getRemoteInstanceList();
#endif
};

extern WSDLEX WSCbaseList* WSGIappObjectList();
#endif
