//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCCONDUCTOR_H
#define WSCCONDUCTOR_H
#include <WSdrDef.h>
#include <WSCtypeServer.h>
#include <WSClistData.h>
#include <WSCindexData.h>

class WSDserialize;
class WSDsocket;

struct WSCremoteCall{
  WSCushort _port;
  WSCstring _addr;
  char* _class;
  char* _instance;
  char* _op;
  WSCstring _dest_addr;
  WSDLEX32 void setOperationName(char* opname);
  WSDLEX32 void setClassName(char* cname);
  WSDLEX32 void setInstanceName(char* cname);
  WSDLEX32 WSCremoteCall();
  WSDLEX32 ~WSCremoteCall();
};


class WSCconductor{

 protected:
  WSClistData   _serialize_list;
  WSClistData   _type_server_list;
  WSCstring     _serialize_path;
  WSCstring _addr;
  WSCushort _port;
  WSDsocket* _sock;
  WSDsocket* _csock;
  WSCulong _timeout;
  WSCbool _accepted;
  WSCbool _need_update;
  WSCindexData   _net_server_handler_list;
  long _timer_id;
  long _timer_cnt;

  WSDLEX32 static void _timer_work(WSCuchar,void*);
  WSDLEX32 static void _accepted_work(WSDsocket* sock,void* socket,WSCulong addr);

 public:
  WSDLEX32 WSCconductor();
  WSDLEX32 virtual ~WSCconductor();

  WSDLEX32 WSCtypeServer* searchTypeServer(char*);
  WSDLEX32 char* getSerializePath();
  WSDLEX32 void  setSerializePath(char*);

  WSDLEX32 long add(WSCtypeServer*);
  WSDLEX32 long addSerialize(WSDserialize* );
  WSDLEX32 long del(WSCtypeServer*);
  WSDLEX32 WSDserialize*   getSerialize(char* serialize_type);
  WSDLEX32 WSDserialize*   getNewSerialize(char* serialize_type);

  WSDLEX32 long  save(WSDserialize*, char* type, char* nm, void* ptr);        
  WSDLEX32 long  load(WSDserialize*, char* type, char* nm, void* ptr);   
  WSDLEX32 long  loadAlloc(WSDserialize*,char* type,char* nm,void** ptr,void* cdata); 

  WSDLEX32 WSDserialize* beginTransaction(char* stype,char* sname,WSDserialize*,int fl = WS_RW);
  WSDLEX32 WSDserialize* beginTransaction(char* stype,char* sname,int fl = WS_RW);
  WSDLEX32 long         endTransaction(WSDserialize*);

  WSDLEX32 long  saveGUI(WSDserialize*,char* name,WSCbase*);
  WSDLEX32 long  loadGUI(WSDserialize*,WSCbase**,WSCbase*);

  WSDLEX32 void setPort(WSCushort port);
  WSDLEX32 WSCushort getPort();

  WSDLEX32 void setAddr(char* addr);
  WSDLEX32 WSCstring getAddr();

  WSDLEX32 void setTimeout(WSCulong t);
  WSDLEX32 long startDispatch();
  WSDLEX32 long stopDispatch();

  WSDLEX32 WSDserialize* beginRemoteCall(WSCremoteCall*);
  WSDLEX32 long endRemoteCall(WSDserialize*);

  WSDLEX32 void addNetServerHandler(char* cname,void* handler);

  WSDLEX32 void clearUpdateCounter();
};
extern WSDLEX WSCconductor* WSGIconductor();

class WSCbinType{

protected:
  WSCbool _need_swap;
public:
  WSDLEX32 WSCbinType();
  WSDLEX32 void memcpy2b(char* dest,short src);
  WSDLEX32 void memcpy4b(char* dest,long src);
  WSDLEX32 void memcpy8b(char* dest,void* src);
  WSDLEX32 void memcpy16b(char* dest,void* src);
  WSDLEX32 void memcpy32b(char* dest,void* src);
  WSDLEX32 void memscan2b(short* src,char* dest);
  WSDLEX32 void memscan4b(long* src, char* dest);
  WSDLEX32 void memscan8b(void* src, char* dest);
  WSDLEX32 void memscan16b(void* src,char* dest);
  WSDLEX32 void memscan32b(void* src,char* dest);
};

extern WSDLEX WSCbinType*   WSGIbinType();

#define WSMFdefineDrNetServer(CTYPE,FN) \
class CTYPE ## _dr_net_server { \
  public: \
  CTYPE ## _dr_net_server() { \
    WSGIconductor()->addNetServerHandler( #CTYPE, (void*)FN); \
  }; \
}; \
CTYPE ## _dr_net_server _exec_ ##  CTYPE ## _dr_net_server;

#endif
