#ifndef WSCDB_H
#define WSCDB_H

#define FACTORY_METHOD			// factory method handler use

#include <WScom.h>
#include <WSCvariant.h>
#include <WSCstring.h>
#include <WSCindexData.h>

/* SQL_CONCURRENCY options */
#define WSCDB_SQL_CONCUR_READ_ONLY            1
#define WSCDB_SQL_CONCUR_LOCK                 2
#define WSCDB_SQL_CONCUR_ROWVER               3
#define WSCDB_SQL_CONCUR_VALUES               4
#define WSCDB_SQL_CONCUR_DEFAULT              WSCDB_SQL_CONCUR_READ_ONLY

/* SQL_CURSOR_TYPE options */
#define WSCDB_SQL_CURSOR_FORWARD_ONLY         0UL
#define WSCDB_SQL_CURSOR_KEYSET_DRIVEN        1UL
#define WSCDB_SQL_CURSOR_DYNAMIC              2UL
#define WSCDB_SQL_CURSOR_STATIC               3UL
#define WSCDB_SQL_CURSOR_TYPE_DEFAULT         WSCDB_SQL_CURSOR_FORWARD_ONLY

// FIELD TYPE
#define WSCDB_FIELD_TYPE_CHAR                 1
#define WSCDB_FIELD_TYPE_NUMERIC              2
#define WSCDB_FIELD_TYPE_DECIMAL              3
#define WSCDB_FIELD_TYPE_INTEGER              4
#define WSCDB_FIELD_TYPE_SMALLINT             5
#define WSCDB_FIELD_TYPE_FLOAT                6
#define WSCDB_FIELD_TYPE_REAL                 7
#define WSCDB_FIELD_TYPE_DOUBLE               8
#define WSCDB_FIELD_TYPE_DATE                 9
#define WSCDB_FIELD_TYPE_TIME                 10
#define WSCDB_FIELD_TYPE_TIMESTAMP            11
#define WSCDB_FIELD_TYPE_NONE                 99

#define WS_DB_BUSY        1

class WSCdbDrvDatabase;
class WSCdbDrvRecord;
class WSCdbRecord;
class WSCvdb;

class WSCdbDatabase
{
protected:
	static WSCindexData* _factory_list;
        char* _err_msg;
public:
	WSDLEX32 WSCdbDatabase();
	WSDLEX32 virtual ~WSCdbDatabase();

#ifdef FACTORY_METHOD
	WSDLEX32 static	void setCreateHandler(void* hd,char* drvame);
#endif

	WSDLEX32 virtual long WSCdbDatabase::setDatabase(const char* drvName);
	WSDLEX32 virtual long    open(char* host, char* uid, char* pwd, char* dbname = NULL, char* port = NULL);
	WSDLEX32 virtual long    close();
	WSDLEX32 virtual long    beginTran();
	WSDLEX32 virtual long    commitTran();
	WSDLEX32 virtual long    abortTran();
	WSDLEX32 virtual long    sqlExecute(const char* stmt);
	WSDLEX32 virtual WSCbool isOpen();
	WSDLEX32 virtual void    getErrorMsg(char* szState, char* szMsg);
	WSDLEX32 virtual void    getErrorMsg(char* szMsg,long size);
	WSDLEX32 virtual void    setEncode(long code);
	WSDLEX32 virtual long    getEncode();
	
	        WSDLEX32 char*   getDriverName();
	        WSDLEX32 void    addRecord(WSCdbRecord* pDb);
	        WSDLEX32 void    removeRecord(WSCdbRecord* pDb);

public:
	WSCdbDrvDatabase*	_db;
	char				_driver[80];
	WSCulong*			_rs;
	int					_rscount;
};

class WSCdbRecord
{
protected:
	WSDLEX32 static WSCindexData* _record_factory_list;
	WSDLEX32 long _init_record();

public:
	WSDLEX32 WSCdbRecord(WSCdbDatabase* pDatabase);
	WSDLEX32 WSCdbRecord(WSCvdb* inst);
	WSDLEX32 virtual ~WSCdbRecord();

#ifdef FACTORY_METHOD
	WSDLEX32 static	void setCreateHandler(void* hd,char* drvame);
#endif

	WSDLEX32 virtual long    open(const char* stmt);
	WSDLEX32 virtual long    open(const char* stmt, short eCousor, short eAccess = WSCDB_SQL_CONCUR_LOCK);
	WSDLEX32 virtual long    close();
	WSDLEX32 virtual WSCbool isEOF();
	WSDLEX32 virtual WSCbool isOpen();
	WSDLEX32 virtual long    getColValue(long index, WSCvariant* var);
	WSDLEX32 virtual long    getColValue(const char* name, WSCvariant* var);
	WSDLEX32 virtual long    getColStringValue(long index, char* var);
	WSDLEX32 virtual long    getColStringValue(const char* name, char* var);
	WSDLEX32 virtual long    setColValue(long index, WSCvariant var);
	WSDLEX32 virtual long    setColValue(const char* name, WSCvariant var);
	WSDLEX32 virtual long    edit();
	WSDLEX32 virtual long    update();
	WSDLEX32 virtual long    addnew();
	WSDLEX32 virtual long    deleterow();
	WSDLEX32 virtual long    moveNext();
	WSDLEX32 virtual long    movePrevious();
	WSDLEX32 virtual long    moveFirst();
	WSDLEX32 virtual long    moveLast();
	WSDLEX32 virtual long    getColName(long index, char* name);
	WSDLEX32 virtual long    getColIndex(const char* name);
	WSDLEX32 virtual long    getColType(long index);
	WSDLEX32 virtual long    getColType(const char* name);
	WSDLEX32 virtual long    getColLength(long index);
	WSDLEX32 virtual long    getColLength(const char* name);
	WSDLEX32 virtual long    getRowCount();
	WSDLEX32 virtual long    getColCount();
	WSDLEX32 virtual void    getErrorMsg(char* szState, char* szMsg);
	WSDLEX32 virtual WSCstring getErrorMessage();

	WSDLEX32 virtual long    sendQuery(const char* stmt);
	WSDLEX32 virtual long    sendQuery(const char* stmt, short eCousor, short eAccess = WSCDB_SQL_CONCUR_LOCK);

	WSDLEX32 virtual long    getResult(WSCbool wait);
	WSDLEX32 virtual long    cancelQuery();
    WSDLEX32 virtual WSCbool isBusy();
 
private:
	WSDLEX32 void Cleanup(WSCdbDatabase* pDatabase);

public:
	WSCdbDatabase*	_pDB;
	WSCdbDrvRecord*	_rs;
};

#endif		// WSCDB_H
