#ifndef WSCDBMYSQL_H
#define WSCDBMYSQL_H

#ifdef MSW
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql.h>

#include <WScom.h>
#include <WSCvariant.h>

struct _MysqlCol {
	WSCuchar	colName[32];
	short		colType;
	int			buffLen;
	void*		buff;
};

#define MYSQL_ACCESS_MODE_READ			0
#define MYSQL_ACCESS_MODE_EDIT			1
#define MYSQL_ACCESS_MODE_ADDNEW		2
#define MYSQL_MAX_MESSAGE_LENGTH		255
#define MYSQL_TRAN_FUNCTION				1
#define MYSQL_TRAN_RECORD_FUNCTION		2


class WSCdbDrvDatabase;
class WSCdbDrvRecord;
class WSCdbMysqlRecord;
class WSDthread;
class WSDsemaphore;

class WSCdbMysqlDatabase : public  WSCdbDrvDatabase
{
public:
	WSDLEX32 WSCdbMysqlDatabase();
	WSDLEX32 virtual ~WSCdbMysqlDatabase();
	
	WSDLEX32 virtual long     open(char* host, char* uid, char* pwd, char* dbname, char* port = NULL);
	WSDLEX32 virtual long     close();
	WSDLEX32 virtual long     beginTran();
	WSDLEX32 virtual long     commitTran();
	WSDLEX32 virtual long     abortTran();
	WSDLEX32 virtual long     sqlExecute(const char* stmt);
	WSDLEX32 virtual WSCbool  isOpen();
	WSDLEX32 virtual void     getErrorMsg(char* szState, char* szMsg);
	WSDLEX32 virtual void     getErrorMsg(char* szMsg,long size);
	WSDLEX32 virtual void    setEncode(long code);
	WSDLEX32 virtual long    getEncode();

	        WSDLEX32 int      getProcessId();
	        WSDLEX32 WSCulong getCursor();
	        WSDLEX32 short    getbeginTranmode();
	        WSDLEX32 void     setbeginTranmode(short begin);
	        WSDLEX32 char*    getDbName();
private:
	void getError();
	void getServerEncoding();
	char* decode(const char* buf);

public:
	WSCbool		_open;
	short		_begin;
	MYSQL*		_hconn;
	MYSQL*		_hconn2;
	WSCuchar	_szSqlState[6];
	WSCuchar	_szErrorMsg[MYSQL_MAX_MESSAGE_LENGTH + 1];
	char		_dbName[80];
	long		_encoding;
};

class WSCdbMysqlRecord  : public  WSCdbDrvRecord
{
public:
	WSDLEX32 WSCdbMysqlRecord(WSCdbMysqlDatabase* pDatabase);
	WSDLEX32 virtual ~WSCdbMysqlRecord();
	WSDLEX32 virtual long    open(const char* stmt);
	WSDLEX32 virtual long    open(const char* stmt, short eCousor, short eAccess = WSCDB_SQL_CONCUR_LOCK);
	WSDLEX32 virtual long    close();
	WSDLEX32 virtual WSCbool isEOF();
	WSDLEX32 virtual WSCbool isOpen();
	WSDLEX32 virtual long    getColValue(long index, WSCvariant* var);
	WSDLEX32 virtual long    getColValue(const char* name, WSCvariant* var);
	WSDLEX32 virtual long    getColStringValue(long index, char* var);
	WSDLEX32 virtual long    getColStringValue(const char* name, char* var);
	WSDLEX32 virtual long    setColValue(long index, WSCvariant var);
	WSDLEX32 virtual long    setColValue(const char* name, WSCvariant var);
	WSDLEX32 virtual long    edit();
	WSDLEX32 virtual long    update();
	WSDLEX32 virtual long    addnew();
	WSDLEX32 virtual long    deleterow();
	WSDLEX32 virtual long    moveNext();
	WSDLEX32 virtual long    movePrevious();
	WSDLEX32 virtual long    moveFirst();
	WSDLEX32 virtual long    moveLast();
	WSDLEX32 virtual long    getColName(long index, char* name);
	WSDLEX32 virtual long    getColIndex(const char* name);
	WSDLEX32 virtual long    getColType(long index);
	WSDLEX32 virtual long    getColType(const char* name);
	WSDLEX32 virtual long    getColLength(long index);
	WSDLEX32 virtual long    getColLength(const char* name);
	WSDLEX32 virtual long    getRowCount();
	WSDLEX32 virtual long    getColCount();
	WSDLEX32 virtual void    getErrorMsg(char* szState, char* szMsg);
	WSDLEX32 virtual WSCstring getErrorMessage();
	WSDLEX32 virtual long    isNull(long index);
	WSDLEX32 virtual long    isNull(const char* name);

    WSDLEX32 virtual long    sendQuery(const char* stmt);
    WSDLEX32 virtual long    sendQuery(const char* stmt, short eCousor, short eAccess = WSCDB_SQL_CONCUR_LOCK);
    WSDLEX32 virtual long    getResult(WSCbool wait);
    WSDLEX32 virtual long    cancelQuery();
    WSDLEX32 virtual WSCbool isBusy();

private:
	void  Cleanup(WSCdbMysqlDatabase* pDatabase);
	long  BindCols();
	void  ReleaseCols();
	void  getValue(int index, WSCvariant* var);
	void  setValue(int index, WSCvariant* var);
	void  getError();
	char* makeINSERT();
	char* makeUPDATE();
	char* makeDELETE();
	void  getTableName(char* p, char* tbl, int size);
	long  setRowPos(WSCulong pos);
	int   getBufflen(int type);
	char* getSqlString(int i);
	void  encode(char* buf, char* str);
	char* decode(char* buf);
	char* getSelectSQL(const char* p, long rowiduse);
	long  getColTypeConv(long index);

public:
	WSCdbMysqlDatabase*	_pDB;
	MYSQL_RES*			_res_stmt;
	WSCbool				_open;
	short				_Cols;
	_MysqlCol*			_fd;
	short				_access_mode;
	WSCuchar			_szSqlState[6];
	WSCuchar			_szErrorMsg[MYSQL_MAX_MESSAGE_LENGTH + 1];
	int					_access;
	int					_Cursor;
	WSCulong			_RowCount;
	WSCulong			_FetchRowPos;
	long				_encoding;
	char				_tableName[80];
	long				_rowiduse;

    WSDthread*          _async_thread;
    WSDsemaphore*       _wait_sem;
    WSCbool             _is_busy;
    const char*         _tmp_stmt;
    short               _tmp_ecursor;
    short               _tmp_eaccess;
    long                _ret_query;
    int                 _tid;

};

#endif		// WSCDBMYSQL_H
