#ifndef WSCDBODBC_H
#define WSCDBODBC_H

#ifdef MSW
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sql.h>
#include <sqlext.h>

#include <WScom.h>
#include <WSCvariant.h>

class WSCodbcDatabase;
class WSCodbcRecord;
class WSCdbDrvDatabase;
class WSCdbDrvRecord;
class WSCdbOdbcRecord;
class WSCvodbc;
class WSDthread;
class WSDsemaphore;

class WSCdbOdbcDatabase : public WSCdbDrvDatabase
{
public:
	WSDLEX32 WSCdbOdbcDatabase();
	WSDLEX32 virtual ~WSCdbOdbcDatabase();
	
	WSDLEX32 virtual long    open(char* host, char* uid, char* pwd, char* dbname = NULL, char* port = NULL);
	WSDLEX32 virtual long    close();
	WSDLEX32 virtual long    beginTran();
	WSDLEX32 virtual long    commitTran();
	WSDLEX32 virtual long    abortTran();
	WSDLEX32 virtual long    sqlExecute(const char* stmt);
	WSDLEX32 virtual WSCbool isOpen();
	WSDLEX32 virtual void    getErrorMsg(char* szState, char* szMsg);
	WSDLEX32 virtual void    getErrorMsg(char* szMsg,long size);
	WSDLEX32 virtual void    setEncode(long code);
	WSDLEX32 virtual long    getEncode();

public:
	WSCodbcDatabase* _db;
};

class WSCdbOdbcRecord : public WSCdbDrvRecord
{
public:
	WSDLEX32 WSCdbOdbcRecord(WSCdbOdbcDatabase* pDatabase);
	WSDLEX32 WSCdbOdbcRecord(WSCvodbc* obj);
	WSDLEX32 virtual ~WSCdbOdbcRecord();
	WSDLEX32 virtual long    open(const char* stmt);
	WSDLEX32 virtual long    open(const char* stmt, short eCousor, short eAccess = SQL_CONCUR_LOCK);
	WSDLEX32 virtual long    close();
	WSDLEX32 virtual WSCbool isEOF();
	WSDLEX32 virtual WSCbool isOpen();
	WSDLEX32 virtual long    getColValue(long index, WSCvariant* var);
	WSDLEX32 virtual long    getColValue(const char* name, WSCvariant* var);
	WSDLEX32 virtual long    getColStringValue(long index, char* var);
	WSDLEX32 virtual long    getColStringValue(const char* name, char* var);
	WSDLEX32 virtual long    setColValue(long index, WSCvariant var);
	WSDLEX32 virtual long    setColValue(const char* name, WSCvariant var);
	WSDLEX32 virtual long    edit();
	WSDLEX32 virtual long    update();
	WSDLEX32 virtual long    addnew();
	WSDLEX32 virtual long    deleterow();
	WSDLEX32 virtual long    moveNext();
	WSDLEX32 virtual long    movePrevious();
	WSDLEX32 virtual long    moveFirst();
	WSDLEX32 virtual long    moveLast();
	WSDLEX32 virtual long    getColName(long index, char* name);
	WSDLEX32 virtual long    getColIndex(const char* name);
	WSDLEX32 virtual long    getColType(long index);
	WSDLEX32 virtual long    getColType(const char* name);
	WSDLEX32 virtual long    getColLength(long index);
	WSDLEX32 virtual long    getColLength(const char* name);
	WSDLEX32 virtual long    getRowCount();
	WSDLEX32 virtual long    getColCount();
	WSDLEX32 virtual void    getErrorMsg(char* szState, char* szMsg);
	WSDLEX32 virtual WSCstring getErrorMessage();
	WSDLEX32 virtual long    isNull(long index);
	WSDLEX32 virtual long    isNull(const char* name);

    WSDLEX32 virtual long    sendQuery(const char* stmt);
    WSDLEX32 virtual long    sendQuery(const char* stmt, short eCursor, short eAccess = WSCDB_SQL_CONCUR_LOCK);
    WSDLEX32 virtual long    getResult(WSCbool wait);
    WSDLEX32 virtual long    cancelQuery();
    WSDLEX32 virtual WSCbool isBusy();

public:
	WSCdbOdbcDatabase*	_pDB;
	WSCodbcRecord*		_rs;
    WSDthread*          _async_thread;
    WSDsemaphore*       _wait_sem;
    WSCbool             _is_busy;
    const char*         _tmp_stmt;
    short               _tmp_ecursor;
    short               _tmp_eaccess;
    long                _ret_query;
};

#endif		// WSCDBODBC_H
