//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCFILESELECT_H
#define WSCFILESELECT_H

#include <WScom.h>
#include <WSCbaseDialog.h>

class WSCscrForm;
class WSCvbtn;
class WSCform;
class WSCvlabel;
class WSCoption;
class WSCvtoggle;
class WSCvifield;
class WSCbaseDialog;
class WSCinputDialog;

#define WSCfileSelect_VER  1001

class WSCfileSelect :public WSCbaseDialog{

  protected:
    char* _dir_name;
    char* _file_name;
    char* _mask_name;
    WSClistData _icon_list;
    WSClistData _label_list;
    WSCscrForm*  _form;
    WSCform*     _form2;
    WSCvifield*  _dir_if;
    WSCvifield*  _file_if;
    WSCvifield*  _mask_if;
    WSCscrForm*  _scr_form;
//    WSCform*     _scr_form2;
    WSCvlabel*   _sp1;
    WSCvlabel*   _sp2;
    WSCbase*     _dtitle2;
    WSCbase*     _dtitle3;
    WSCvbtn*     _up_btn;
    WSCvbtn*     _mkdir_btn;
    WSCinputDialog*  _mkdir_dlg;
    short     _wbg_no;
    WSCstring _provider_name;
    WSCstring _workgroup_name;


    unsigned     _select_dir:1;
    unsigned     _need_update_fl:1;
    unsigned     _desktop:1;
    unsigned     _network:1;
    WSMFpropertyDef(WSNdirName,     char*, _dir_name ); 
    WSMFpropertyDef(WSNfileName,    char*, _file_name); 
    WSMFpropertyDef(WSNmaskFileName,char*, _mask_name); 
    WSMFpropertyDef(WSNselectDir,   WSCbool, _select_dir); 
    WSMFpropertyDef(WSNworkBackColor,  short,      _wbg_no );

    void _adjust();
    void _update_list();

    WSDLEX32 static  void _mkdir_btn_work(WSCbase*);
    WSDLEX32 static  void _up_btn_work(WSCbase*);
    WSDLEX32 static  void _set_btn_work(WSCbase*);
    WSDLEX32 static  void _label_btn_work(WSCbase*);
    WSDLEX32 static  void _dir_if_work(WSCbase*);
    WSDLEX32 static  void _label_btn_key_work(WSCbase*);

    WSDLEX32 virtual void setWorkWSNwidth(WSCushort );
    WSDLEX32 virtual void setWorkWSNheight(WSCushort );
  public:
    WSDLEX32 WSCfileSelect(WSCbase*,char*);
    WSDLEX32 virtual ~WSCfileSelect();

    WSDLEX32 virtual long initialize();
    WSDLEX32 char* getFileName();

    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onResize(WSCrect*);
    WSDLEX32 virtual void onGuiPolicyChange(long);
    WSDLEX32 virtual void update();

    WSMFguiClassDef(WSCfileSelect,WSCbaseDialog);
    WSMFversionDef(WSCfileSelect);
};
extern WSDLEX WSCfileSelect* WSGIappFileSelect();
#endif
