//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCLIST_H
#define WSCLIST_H

#include <WScom.h>
#include <WSCscrForm.h>
#include <WSCsform.h>

#define WSClist_VER 1000
class WSDkeyboard;

class WSClist :public WSCscrForm{

  protected:
     WSCsform*   _btn_area;
     char*       _bar_pos;
     char*       _title_string;
     char*       _data;
     char*       _data_source_name;
     WSCbase*    _input_instance;
     char*       _separator;
     WSClistData _lb_list;
     WSCstring   _lb_class;
     WSCulong    _wy_pos_bak;
     short       _select_color;
     short       _select_fore_color;
     short       _icon_pixmap;
     short       _icon_pixmap_old;

     char*     _upname;
     char*     _dwname;
     char*     _lname;
     char*     _rname;
     char*     _rtname;
     char*     _tbname;
     char*     _btbname;

     WSCushort   _w_bk;
//     WSCushort   _h_bk;
     WSCushort   _lb_width;
     WSCushort   _work_height_bk;
     short   _pre_select;
     WSCuchar   _lb_height;
     WSCuchar   _lb_height_bk;
     char        _sort_pos;
     unsigned    _font:4;
     unsigned    _disp_type:2;
     unsigned    _data_source_type:2;
     unsigned    _mselect:1;
     unsigned    _select_item_changed:1;
     unsigned    _activate:1;
     unsigned    _reverse_select:1;
     unsigned    _absolute_select_change:1;
     unsigned    _use_icon:1;
     unsigned    _need_update:1;
     unsigned    _enable_input:1;
     unsigned    _need_ds_update:1;
     unsigned    _need_scr_redraw:1;
     unsigned    _need_update_btn_area:1;
     unsigned    _enable_focus_move:1;
     unsigned    _return_key_focus:1;
 

     WSMFpropertyDef(WSNitemHeight, WSCuchar, _lb_height );
     WSMFpropertyDef(WSNfont,   WSCuchar, _font   );
     WSMFpropertyDef(WSNselectColor, short, _select_color );
     WSMFpropertyDef(WSNselectForeColor, short, _select_fore_color );
     WSMFpropertyDef(WSNtype, WSCuchar, _disp_type );
     WSMFpropertyDef(WSNmultiSelect, WSCbool, _mselect );
     WSMFpropertyDef(WSNreverseSelect, WSCbool, _reverse_select );
     WSMFpropertyDef(WSNtitleHeight,     WSCuchar, _padding  );
     WSMFpropertyDef(WSNtitleString,     char*, _title_string  );
     WSMFpropertyDef(WSNbarValue,        char*, _bar_pos  );
     WSMFpropertyDef(WSNuseIcon,     WSCbool, _use_icon  );
     WSMFpropertyDef(WSNiconPixmap,  short, _icon_pixmap  );
     WSMFpropertyDef(WSNdata,  char*, _data  );
     WSMFpropertyDef(WSNdataSource,  WSCuchar, _data_source_type  );
     WSMFpropertyDef(WSNdataSourceName,  char*, _data_source_name  );
     WSMFpropertyDef(WSNenableInput,  WSCbool, _enable_input  );
     WSMFpropertyDef(WSNseparator,  char*, _separator  );

    WSMFpropertyDef(WSNenableFocusMove,  WSCbool, _enable_focus_move );
    WSMFpropertyDef(WSNupward,    char*,   _upname);
    WSMFpropertyDef(WSNdownward, char*,   _dwname);
    WSMFpropertyDef(WSNleftward,   char*,   _lname);
    WSMFpropertyDef(WSNrightward,  char*,   _rname);
    WSMFpropertyDef(WSNreturn,     char*,   _rtname);
    WSMFpropertyDef(WSNtab,     char*,   _tbname);
    WSMFpropertyDef(WSNbacktab,     char*,   _btbname);
    WSMFpropertyDef(WSNreturnKeyFocus,   WSCbool, _return_key_focus);

    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);
    WSDLEX32 virtual void setWorkWSNworkWidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNworkHeight(WSCushort);
    WSDLEX32 virtual void setWorkWSNbackColor(short);
    WSDLEX32 virtual void setWorkWSNforeColor(short);
    WSDLEX32 virtual void setWorkWSNtopShadowColor(short);
    WSDLEX32 virtual void setWorkWSNbottomShadowColor(short);

    WSDLEX32 virtual void _adjust();
    WSDLEX32 static void _btn_area_valuech(WSCbase*);
    WSDLEX32 static void _btn_activate(WSCbase*);
    WSDLEX32 void _set_data(char*);
    WSDLEX32 void _clear_ds_instance();
    WSDLEX32 void _set_ds_instance();
    WSDLEX32 virtual void _adjust_input(WSCbase* target,long pos,
                               WSCbool vis,short x,short y);

//    static void _mouse_press_work(WSCbase*);
//    static void _mouse_release_work(WSCbase*);

    WSDLEX32 void _lb_adjust_work(long&,long,WSCbool,long&);
    WSDLEX32 virtual void _lb_adjust();
    WSDLEX32 void _update_lb_height();
    WSDLEX32 void _data_from_file(char*);
    WSDLEX32 static void _input_focus_lose(WSCbase*);
    WSDLEX32 static void _input_fix_work(WSCbase*);
    WSDLEX32 virtual void _adjust_no_scroll();
    WSDLEX32 WSCstring _get_data();

  public:
    WSDLEX32 WSClist(WSCbase*,char*);
    WSDLEX32 virtual ~WSClist();

    WSDLEX32 virtual long draw();
    WSDLEX32 virtual void update();

    //for data source
    WSDLEX32 virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT);
    WSDLEX32 virtual void setData(const WSCvariant&,long code = WS_EN_DEFAULT);

    WSDLEX32 virtual long getDataSourceType();
    WSDLEX32 virtual char* getDataSourcePropertyName();

//    virtual void onActivate();
    WSDLEX32 virtual void onSort();
    WSDLEX32 virtual void onItemSelected();
    WSDLEX32 virtual void onItemPreSelected();
    WSDLEX32 virtual void onItemDoubleClicked();
    WSDLEX32 virtual void onInputFixed(WSCstring str,long pos,long column);
    WSDLEX32 virtual void onKey(WSDkeyboard*,WSCbool);
    WSDLEX32 virtual void onValueChange();
    WSDLEX32 virtual char* getDefaultProperty();
    WSDLEX32 virtual void onScrMousePress(WSCpoint*);
    WSDLEX32 virtual void onScrMouseRelease(WSCpoint*);
    WSDLEX32 virtual void onFocusChange(WSCbool);
    WSDLEX32 void _focus_move(long direct);


    WSDLEX32 void      setLabelHeight(WSCushort h);
    WSDLEX32 void      delAll();
    WSDLEX32 WSCbase*  getLabel(long pos);
    WSDLEX32 long      getNum();
    WSDLEX32 WSCstring getItem(long pos,long col = -1);
    WSDLEX32 void      addItem(char* item,long pos = -1);
    WSDLEX32 void      replaceItem(char* item,long pos);
    WSDLEX32 void      replaceItem(char* item,long pos,long column);
    WSDLEX32 void      delPos(long pos);
    WSDLEX32 long      getPreSelectedPos();
    WSDLEX32 long      setPreSelectPos(long);
    WSDLEX32 long      getSelectedPos();
    WSDLEX32 long      setSelectPos(long ,WSCbool create_event = True);
    WSDLEX32 WSCstring getSelectedItem();
    WSDLEX32 void      setTopPos(long);
    WSDLEX32 void      setBottomPos(long);
    WSDLEX32 long      getTopPos();
    WSDLEX32 long      getBottomPos();

    WSDLEX32 void      updateList();
    WSDLEX32 void      setLabelProperty(char*,char*);
    WSDLEX32 void      setLabelClass(char*);
    WSDLEX32 WSCbool   getSelectItemChanged();
    WSDLEX32 void      setSelectItemChanged(WSCbool);
    WSDLEX32 WSClistData* getLabels();
    WSDLEX32 void      getSelectedLabels(WSClistData&);
    WSDLEX32 void      setEnableActivate(WSCbool);
    WSDLEX32 WSCbool   getEnableActivate();
    WSDLEX32 void      setAbsoluteChangeSelectFlag(WSCbool);
    WSDLEX32 WSCbool   getAbsoluteChangeSelectFlag();

    WSDLEX32 long      setItemVisible(long pos,WSCbool fl);
    WSDLEX32 long      setItemValue(long pos,long kind,long val);
    WSDLEX32 long      getItemValue(long pos,long kind,long* val);
    WSDLEX32 long      getSortPos();
    WSDLEX32 char      getSortOrder(long col_no);
    WSDLEX32 void      setSortPos(long col_no);
    WSDLEX32 void      sort(long col_no,char order = WS_LIST_REVERSING_ORDER);
    WSDLEX32 WSCstring getInputString();
    WSDLEX32 void      setInputString(WSCstring str);
    WSDLEX32 long      getInputPos(long* pos,long* col);
    WSDLEX32 long      setInputStatus(long status,long pos,long col=-1);

    WSDLEX32 void      cancelInput();
    WSDLEX32 char*     getSeparator();
    WSDLEX32 long      getSelectedNextPos(long pos);
    WSDLEX32 WSCstring getSelectedNextItem(long pos);
    WSDLEX32 WSCbool   getSelected(long pos);
    WSDLEX32 WSCbool   setSelected(long pos,WSCbool,WSCbool create_event = True);
    WSDLEX32 virtual WSCbool canFocus();
    WSDLEX32 void    resetUpdateFlag();

    WSMFguiClassDef(WSClist,WSCscrForm);
};
#endif
