//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCOPTION_H
#define WSCOPTION_H

#include <WScom.h>
#include <WSCvlabel.h>

class WSCpopupFrame;

#define WSCoption_VER  1000

class WSCoption    :public WSCvlabel{

  protected:
    WSCpopupFrame* _menu;
    WSCbool* _status_array;
    char*    _menu_str;
    long     _value;
    unsigned _press_state:1;

    WSMFpropertyDef( WSNmenuItems, char*, _menu_str); 
    WSMFpropertyDef( WSNvalue,     long,  _value); 
    //menu items = string:value:op name,
    //             string:value:op name,...

    WSDLEX32 virtual void setWorkWSNemboss(WSCbool);
    WSDLEX32 virtual void setWorkWSNshadowThickness(WSCuchar);

    WSDLEX32 virtual long _device_initialize();

    WSDLEX32 void _menu_popup(WSCpoint*);
    WSDLEX32 void _menu_popdown();
    WSDLEX32 void _menu_update();
WSDLEX32 static void      (*_ext_draw_proc)(void*);
WSDLEX32 static char* _policy_name;

  public:
    WSDLEX32 WSCoption(WSCbase*,char*);
    WSDLEX32 virtual ~WSCoption();

    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual long addProcedure(WSCprocedure*);

    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onMousePress(WSCpoint*);
    WSDLEX32 virtual void onMouseMove(WSCpoint*);
    WSDLEX32 virtual void onMouseRelease(WSCpoint*);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool);
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onValueChange(long);
    WSDLEX32 virtual void onGuiPolicyChange(long);
    WSDLEX32 virtual char* getDefaultProperty();

    WSDLEX32 long setItemSensitive(short no, WSCbool flag);
    WSDLEX32 long setSelectValue(long value, WSCbool flag);

    WSDLEX32 long     getValue();
    WSDLEX32 long     getItemValue(long pos);
    WSDLEX32 WSCbool* getSelectStatus();
    WSDLEX32 long     getItemNum();
    WSDLEX32 long     getItems();

    WSMFguiClassDef(WSCoption,WSCvlabel);
    WSMFversionDef(WSCoption);
};
struct WSCoption_draw_struct{
  WSCoption* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  long blinking;
  long blink_fore;
  long shadow_type;
  long blink_type;
  long twin_blink;
  short fore_color;
  short back_color;
  short blink_color;
  short back_blink_color;
  short top_shadow_color;
  short bottom_shadow_color;
  char* label_string;
  short label_pixmap;
  short blink_pixmap;
#ifndef NO_GRADATION
  long  gradation;
  long  gradation_margin;
#endif
  long  margin_left;
  long  margin_right;
  long  margin_top;
  long  margin_bottom;
  WSCbool  emboss;
  WSCuchar font;
  WSCbool  reverse_flag;
  WSCbool  press_state;
};



#endif
