//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCSCRFRAME_H
#define WSCSCRFRAME_H

#include <WScom.h>
#include <WSCform.h>

#define WSCscrFrame_VER  1000

class WSCscrFrame :public WSCform{

  private:
  protected:
     WSCushort _s_w;
     WSCushort _s_h;
     WSCushort _w_w;
     WSCushort _w_h;
     WSCushort _title_height;
     unsigned  _no_scroll:1;

     WSMFpropertyDef(WSNhbarValue,  WSCushort, _s_w         );
     WSMFpropertyDef(WSNvbarValue,  WSCushort, _s_h         );
     WSMFpropertyDef(WSNworkWidth,  WSCushort, _w_w         );
     WSMFpropertyDef(WSNworkHeight, WSCushort, _w_h         );
     WSMFpropertyDef(WSNtitleHeight,WSCushort, _title_height);

     WSDLEX32 virtual long _device_initialize();
  public:
    WSDLEX32 WSCscrFrame(WSCbase*,char*);

    WSDLEX32 virtual void onParentVisibleChange(WSCbool);
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onMousePress(WSCpoint*);

    WSDLEX32 virtual long clear();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual long redraw();
    WSDLEX32 virtual void update();
    WSDLEX32 virtual long cdraw();

    WSDLEX32 void setVbarValue(WSCushort);
    WSDLEX32 void setHbarValue(WSCushort);

    WSDLEX32 void _set_no_scroll(WSCbool fl);

    WSMFguiClassDef(WSCscrFrame,WSCform);
    WSMFsetUseDevice(scrFrameDev);
    WSMFversionDef(WSCscrFrame);
};
#endif
