//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCSERIALIZEDATA_H
#define WSCSERIALIZEDATA_H

#include <WSClistData.h>
#define WSCSERIALIZEDATA_MAX_BUF_LEN 16
#define WSCSERIALIZEDATA_DATA_LEN    16
class WSCserializeData{

  public:
   char*       _data_name1;
   char*       _type_name1;
   char        _data_name2[WSCSERIALIZEDATA_MAX_BUF_LEN];
   char        _type_name2[WSCSERIALIZEDATA_MAX_BUF_LEN];
   void*       _data1;
   char        _data2[WSCSERIALIZEDATA_DATA_LEN];
   long        _data_len;
   WSClistData _children;
   WSCulong    _cache_ptr;
   WSCuchar        _data_name_len;
   char        _type;
   WSCuchar        _type_name_len;

   WSDLEX32 WSCserializeData();
   WSDLEX32 virtual ~WSCserializeData();
   WSDLEX32 long size();
   WSDLEX32 void clearChildren();
   WSDLEX32 long write(WSDserialize* db);
   WSDLEX32 long read(WSDserialize* db);
};
#endif
