//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 

#ifndef WSCUNDOMANAGER_H
#define WSCUNDOMANAGER_H

#include <WScom.h>
#include <WSCindexVariantData.h>
#include <WSCroot.h>

class WSCbase;

#ifndef NO_MWT_FUNCTION
#ifndef NO_INDEX_VARIANT_DATA

class WSCundoProc: public WSCroot{
  public:
    WSDLEX32 WSCundoProc();
    WSDLEX32 virtual ~WSCundoProc();
    WSDLEX32 virtual void execute() = 0;

    WSMFclassDef(WSCundoProc,WSCroot);

};

class WSCpropUndoProc: public WSCundoProc{
  private:
    WSCindexVariantData _args;
    WSCbase* _target;
  public:
    WSDLEX32 WSCpropUndoProc();
    WSDLEX32 virtual ~WSCpropUndoProc();
    WSDLEX32 virtual void execute();
    WSDLEX32 void setTarget(WSCbase*);
    WSDLEX32 WSCbase* getTarget();

    WSMFclassDef(WSCpropUndoProc,WSCundoProc);
};

class WSCundoManager{

 private:
  WSClistData  _undo_proc;
  long _max_undo_num;

 public:
  WSDLEX32 WSCundoManager();
  WSDLEX32 virtual ~WSCundoManager();

  WSDLEX32 void addUndoProc(WSCundoProc*);
  WSDLEX32 WSCundoProc* getUndoProc(long pos);
  WSDLEX32 WSCundoProc* getLastUndoProc();
  WSDLEX32 void execUndoProc();
  WSDLEX32 void clear();
  WSDLEX32 long getNum();
};

extern WSDLEX WSCundoManager* WSGIappUndoManager();
#endif
#endif

#endif
