//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCWINDOW_H
#define WSCWINDOW_H

#include <WScom.h>
#include <WSCbase.h>
#include <WSClistData.h>

#define WSCwindow_VER  1000
#define WSEV_EXIT      32

class WSCwindow  :public WSCbase{

  protected:
#ifndef NO_WINDOW_TITLE
    char*      _title_string;
#endif
    char*      _user_string;
    char*      _group_name;
    WSClistData _children;
    long       _user_value;
    short      _x;
    short      _y;
    WSCushort  _w;
    WSCushort  _h;
    short      _fg_no;
    short      _bg_no;
    short      _ts_no;
    short      _bs_no;
    short      _bp_no;
    short      _a1_color;
    short      _a2_color;
    short      _a3_color;
    WSCushort  _mouse_no;
    WSCushort  _margin_left;
    WSCuchar   _bar_thick;
#ifndef NO_GRADATION
    WSCuchar   _grad_margin;
    unsigned   _grad_no:4;
#endif
    unsigned   _shadow_thick:4;
#ifndef NO_WINDOW_TITLE
    signed      _title_bar:4;
#endif
    signed     _shadow_type:4;
    unsigned   _unique:1;
    unsigned   _pixmap_style:2;
    unsigned   _exit:1;
    unsigned   _margin:4;
    unsigned   _update_resize:1;
    unsigned   _indicator:1;
    unsigned   _emboss:1;
    unsigned   _vis_ch_sequence:1;
    unsigned   _enable_close:1;

    WSMFpropertyDef(WSNname,char*,     _instance_name); 
#ifndef NO_WINDOW_TITLE
    WSMFpropertyDef(WSNtitleString,char*,     _title_string); 
#endif
    WSMFpropertyDef(WSNuserString, char*,     _user_string ); 
    WSMFpropertyDef(WSNuserValue,  long,      _user_value  ); 
    WSMFpropertyDef(WSNx,      short,     _x           );
    WSMFpropertyDef(WSNy,        short,     _y           );
    WSMFpropertyDef(WSNwidth,     WSCushort, _w           );
    WSMFpropertyDef(WSNheight,       WSCushort, _h           );
    WSMFpropertyDef(WSNshadowThickness, WSCuchar, _shadow_thick);
    WSMFpropertyDef(WSNforeColor,  short,      _fg_no );
    WSMFpropertyDef(WSNbackColor,   short,     _bg_no );
    WSMFpropertyDef(WSNtopShadowColor,  short, _ts_no );
    WSMFpropertyDef(WSNbottomShadowColor,short,_bs_no );
    WSMFpropertyDef(WSNbackPixmap,  short,     _bp_no       );
#ifndef NO_WINDOW_TITLE
    WSMFpropertyDef(WSNtitleBar,   char,      _title_bar   );
#endif
    WSMFpropertyDef(WSNshadowType, char,      _shadow_type );
    WSMFpropertyDef(WSNvis,        WSCbool,   _vis     );
    WSMFpropertyDef(WSNdet,        WSCbool,   _sensitive_work );
    WSMFpropertyDef(WSNpixmapStyle,WSCuchar,  _pixmap_style);
    WSMFpropertyDef(WSNgroup,   char*,     _group_name  ); 
    WSMFpropertyDef(WSNunique,  WSCbool,   _unique      ); 
    WSMFpropertyDef(WSNmouse,   WSCushort,  _mouse_no    ); 
#ifndef NO_GRADATION
    WSMFpropertyDef(WSNgradation,   WSCuchar,  _grad_no    );
    WSMFpropertyDef(WSNgradationMargin,   WSCuchar,  _grad_margin    );
#endif
    WSMFpropertyDef(WSNexit,   WSCbool,  _exit    );
    WSMFpropertyDef(WSNindicatorOn,   WSCbool,  _indicator    );
    WSMFpropertyDef(WSNmargin,   WSCuchar,  _margin    );
    WSMFpropertyDef(WSNmarginLeft,   WSCushort,  _margin_left    );
    WSMFpropertyDef(WSNbarThickness,   WSCuchar,  _bar_thick    );
    WSMFpropertyDef(WSNemboss,   WSCbool,  _emboss    );
#ifndef NO_REMOTE_INSTANCE
    WSMFpropertyDef(WSNexport,   WSCbool,  _export_    );
#endif
    WSMFpropertyDef(WSNkeepPixmapCache,   WSCbool,  _keep_pixmap_cache    );

    WSDLEX32 void _exec_child_adjust_for_anchors();

    WSDLEX32 virtual long _device_initialize();

    WSDLEX32 static WSClistData*  _workwindow_list;
    WSDLEX32 static WSClistData*  getWorkWindowList();
    WSDLEX32 static void (*_exit_handler)();
    WSDLEX32 static void _delay_visible(unsigned char,void*);
  public:
    WSDLEX32 WSCwindow(WSCbase*,char*);
    WSDLEX32 virtual ~WSCwindow();
    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long execEventProc(long ev,void*);

    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onResize(WSCrect*);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool);
    WSDLEX32 virtual void onFocusChange(WSCbool);
#ifndef WS_EMBED
    WSDLEX32 virtual void onEditModeChange(WSCbool);
#endif
    WSDLEX32 virtual void onDefaultColorChange();
    WSDLEX32 virtual void onWindowClose();

    WSDLEX32 virtual long draw();
    WSDLEX32 virtual long clear();
    WSDLEX32 virtual long redraw();
    WSDLEX32 virtual long cdraw();
    WSDLEX32 virtual void update();

    WSDLEX32 long setMapStatus(long);

    WSDLEX32 virtual long getObjectType();
    WSDLEX32 virtual WSClistData& getChildren();
    WSDLEX32 virtual WSClistData* getChildrenPtr();
    WSDLEX32 virtual void setChildren(WSClistData&);
    WSDLEX32 virtual void adjustForm();
    WSDLEX32 virtual void setVisible(WSCbool);
    WSDLEX32 virtual void internalUpdate();
#ifndef NO_RESTACK_CHILD
    WSDLEX32 virtual long restackChild(WSCbase*,int order);
#endif

    WSDLEX32 void execResizeEvent();

WSDLEX32 static void setGlobalExitHandler(void(*)());

    WSDLEX32 long setWindowStatus(long status);
    WSDLEX32 long getWindowStatus();
    WSDLEX32 long getPixmapStyle();
    WSDLEX32 WSCbool getEnableClose();
    WSDLEX32 void setEnableClose(WSCbool);

    WSMFguiClassDef(WSCwindow,WSCbase);
    WSMFsetUseDevice(windowDev);
    WSMFversionDef(WSCwindow);
};
extern WSDLEX long          WSGFsetActiveWindow(WSCbase*);
extern WSDLEX WSCbase*      WSGFgetActiveWindow();
extern WSDLEX WSCbase*      WSGFgetPreActiveWindow();
#endif
