//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDEXECUTE_H
#define WSDEXECUTE_H

#include <WSCroot.h>
#include <WSCstring.h>

class WSDexecute    :public WSCroot{

  protected:
    WSCstring _exe_name;
    WSCstring _dir_name;
    long _pid; 
    void (*_data_receive)(WSDexecute*);
    void* _handle;
    long  _mode;
    void* _data;
    static WSDexecute* (*_chandler)();

  public:
    WSDLEX32 WSDexecute();
    WSDLEX32 virtual ~WSDexecute();

    WSDLEX32 virtual long execute(char* name,long mode = WS_EXEC_NONE);
    WSDLEX32 virtual long killProcess();
    WSDLEX32 long getProcessId();
    WSDLEX32 long setReceiveProc(void (*)(WSDexecute*),void*);
    WSDLEX32 void(* getReceiveProc() )(WSDexecute*);
    WSDLEX32 void* getHandle();
    WSDLEX32 void* getUserData();
    WSDLEX32 virtual long read(char* buffer,long len);
    WSDLEX32 virtual char* gets(char* buffer,long len);
    WSDLEX32 virtual long write(char* buffer,long len);
    WSDLEX32 virtual void setCurrentDir(char*);
    WSDLEX32 virtual char* getCurrentDir();

    WSDLEX32 static WSDexecute* getNewInstance();
    WSDLEX32 static void setCreateInstanceHandler(void* hd);

    WSMFclassDef(WSDexecute,WSCroot);
};
#endif
