//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDEXTERNAL_H
#define WSDEXTERNAL_H

#include <WSCroot.h>
#include <WSCstring.h>

class WSDexternal   :public WSCroot{

  protected:
    WSCstring _dll_name;
    void*  _ptr;
    static WSDexternal* (*_chandler)();
    static void* _tmp;
    static char* _prj_name;

  public:
    WSDLEX32 virtual ~WSDexternal();
    WSDLEX32 virtual long open(char* name);
    WSDLEX32 virtual long close();
    WSDLEX32 virtual WSCstring* getObjectSymbols();
    WSDLEX32 char*  getName();

    WSDLEX32 static WSDexternal* getNewInstance();
    WSDLEX32 static void      setCreateInstanceHandler(void* hd);
    WSDLEX32 static void      setTempData(void*);
    WSDLEX32 static void*      getTempData();
    WSDLEX32 static void      setProjectName(char* pname);
    WSDLEX32 static char*     getProjectName();

    WSMFclassDef(WSDexternal,WSCroot);
};
#endif
