//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef	WSDFILESYSTEM_H
#define	WSDFILESYSTEM_H

#include <WScom.h>
class WSClistData;

#define WS_FS_FILE  1
#define WS_FS_DIR   2
#define WS_FS_READONLY 4
#define WS_FS_DRIVE    8
#define WS_FS_DRIVE_NO_MEDIA 16

#ifdef MacOS
#undef check
#endif //MacOS

class WSDfileSystem{

  public:
    WSDLEX32 WSDfileSystem();
    WSDLEX32 virtual ~WSDfileSystem();

    WSDLEX32 virtual char* adjustFileName(char*);
    WSDLEX32 virtual long  rename(char*,char*);
    WSDLEX32 virtual long  deleteFile(char*);
    WSDLEX32 virtual long  createDir(char*);
    WSDLEX32 virtual long  deleteDir(char*);
    WSDLEX32 virtual long  check(char*);
    WSDLEX32 virtual WSClistData*  showNetDir(char*,char*); //need delete list and items...
    WSDLEX32 virtual WSClistData*  showDir(char*); //need delete list and items...
    WSDLEX32 virtual WSClistData*  showFile(char*);//need delete list and items...

    WSDLEX32 static  void setCreateInstanceHandler( WSDfileSystem* (*hd)() );
};
extern WSDLEX WSDfileSystem* WSGIappFileSystem();
#endif
