//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDFONT_H
#define WSDFONT_H

#include <WScom.h>
#include <WSDres.h>
class WSCstring;

class WSDfont  :public WSDres{
    WSCstring _virtual_name;
  protected:
    WSCbool _virtual_flag;
    unsigned char _style;
  public:
    WSDLEX32 WSDfont();
    WSDLEX32 virtual ~WSDfont();

    WSDLEX32 long  getFontHeight();
    WSDLEX32 long  setFontName(char* cname); 
    WSDLEX32 char* getFontName(); 
    WSDLEX32 void  setFontStyle(unsigned char); 
    WSDLEX32 unsigned char  getFontStyle();
    
    WSDLEX32 virtual long setPrm(long kind,long val);
    WSDLEX32 virtual long getStringWidth(WSCstring*);
    WSDLEX32 virtual long getStringHeight(WSCstring*);
    WSDLEX32 virtual long getStringWidthUCS2(WSCushort*);
    WSDLEX32 virtual long getStringHeightUCS2(WSCushort*);
    WSDLEX32 virtual long getCharsByWidth(WSCstring*,WSCushort width);

    WSDLEX32 long getStringWidth(char*,long en = WS_EN_DEFAULT);
    WSDLEX32 long getStringHeight(char*,long en = WS_EN_DEFAULT);
    WSDLEX32 void setVirtualFlag(WSCbool);

    WSDLEX32 virtual long getAscent();
    WSDLEX32 virtual long getDescent();
    WSDLEX32 virtual WSCbool getReady(WSCbool loading = False);

    WSMFclassDef(WSDfont,WSDres);
};
#endif //WSDFONT_H
