//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDNWDEV_H
#define WSDNWDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>

class WSDnwDev :public WSDdev{

  protected: 
    WSDLEX32 static short _back_x;
    WSDLEX32 static short _back_y;
    WSDLEX32 static short _copy_pixmap_x;
    WSDLEX32 static short _copy_pixmap_y;
    WSDLEX32 static WSCushort _pixmap_w;
    WSDLEX32 static WSCushort _pixmap_h;
    WSDLEX32 static WSCushort _copy_pixmap_w;
    WSDLEX32 static WSCushort _copy_pixmap_h;
    unsigned _use_pixmap_:1;
    unsigned _expose_sequence_bak:1;
    unsigned _expose_sequence_ch:1;

    WSDLEX32 static void getBackXY(short*,short*);
    WSDLEX32 static void getPixmapWH(WSCushort*,WSCushort*);
    WSDLEX32 static void getCopyPixmapGeom(short*,short*,WSCushort*,WSCushort*);

    WSDLEX32 virtual long _copy_pixmap_to_window()=0;

  public: 
    WSDLEX32 WSDnwDev();

    WSDLEX32 void    setUsePixmap(WSCbool fl);
    WSDLEX32 WSCbool getUsePixmap();

    WSDLEX32 virtual long cancelEvent(WSDdev* dev);

    WSDLEX32 virtual long setEventOrder(WSDdev* dev,char top_or_bottom);
    WSDLEX32 virtual long setEvent(WSDdev* dev,WSCbool on_off);
    WSDLEX32 virtual long setEnableEvent(long ev_kind);
    WSDLEX32 virtual long setEnableEventBit(long ev_bit);
    WSDLEX32 virtual long setDisableEvent(long ev_kind);
    WSDLEX32 virtual long setValue(long kind,void* value);
    WSDLEX32 virtual long setAbsoluteAddrChangeHandler(void(*)(WSDdev*,void*),void*);

    WSDLEX32 virtual long beginDraw(short,short,WSCushort,WSCushort,WSCbool absolute,WSCbool scaling = True);
    WSDLEX32 virtual long endDraw();
    WSDLEX32 virtual long exposeArea(long,long,WSCulong,WSCulong,WSCbool scaling = True);
    WSDLEX32 virtual long clearArea(long,long,WSCulong,WSCulong,WSCbool ,WSCbool scaling = True);

    WSDLEX32 virtual void getAbsoluteAddr(short,short,short*,short*);
    WSDLEX32 virtual void getDispAddr(short*,short*);
    WSDLEX32 virtual long getAvailableEventBit();
    WSDLEX32 virtual long getDeviceResource();
    WSDLEX32 virtual long getWindowResource();
    WSDLEX32 virtual long getContextResource();
    WSDLEX32 virtual long getSpecialResource();

    WSDLEX32 virtual WSCbool getReady();
    WSDLEX32 virtual WSCbool isAvailableEvent(long ev_kind);
    WSDLEX32 virtual long copyArea(long,long,WSCulong,WSCulong,long,long);

    WSMFclassDef(WSDnwDev,WSDdev);
};
#endif //WSDNWDEV_H
