//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDSOCKET_H
#define WSDSOCKET_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSCstring.h>

class WSDsocket :public WSCroot{
  
  protected:
    WSCushort _port;
    WSCulong _addr;
    WSCstring _naddr;
    WSCulong _dest_addr;
    WSCstring _dest_naddr;
    WSCushort _dest_port;
    WSCulong _timeout;
    WSCulong _cl_timeout;
    void*    _user_data;
    WSCbool _started_accept;
    WSCbool _stop_accept;
    WSCbool _udp;
    WSCbool _udp_binded;

    WSClistData _sock_list;

    WSDLEX32 virtual long destroy();
    WSDLEX32 virtual long initialize();
WSDLEX32 static WSDsocket* (*_chandler)();

  public:
    WSDLEX32 void _set_dest_addr_(WSCulong addr); 

    WSDLEX32 WSDsocket();
    WSDLEX32 virtual ~WSDsocket();

    WSDLEX32 long setPort(WSCushort);
    WSDLEX32 long setAddr(char* addr);

    WSDLEX32 long setDestPort(WSCushort);
    WSDLEX32 long setDestAddr(char* addr); 

    WSDLEX32 WSCushort getPort();
    WSDLEX32 WSCushort getDestPort();

    WSDLEX32 WSCstring getAddr();
    WSDLEX32 WSCstring getDestAddr();

    WSDLEX32 virtual void* accept();

    WSDLEX32 virtual long acceptEx(void(*)(WSDsocket*,void*,WSCulong));
    WSDLEX32 virtual long _continue_udp_read_accept();

    WSDLEX32 virtual long stopAcceptEx();
    WSDLEX32 virtual long listen();
    WSDLEX32 virtual long connect();
    WSDLEX32 virtual long close(void* sock= NULL);

//    virtual WSCbool checkData();
    WSDLEX32 virtual long read(void* handle,WSCuchar* buffer,long size);
    WSDLEX32 virtual long write(void* handle,WSCuchar* buffer,long size);
    WSDLEX32 virtual long read(WSCuchar* buffer,long size);
    WSDLEX32 virtual long write(WSCuchar* buffer,long size);

    WSDLEX32 WSCbool getAcceptStarted();

WSDLEX32 static void setCreateHandler(WSDsocket* (*)());

WSDLEX32 static WSDsocket* getNewInstance();
     WSDLEX32 void setTimeout(WSCulong timeout);
     WSDLEX32 void setClTimeout(WSCulong timeout);

     WSDLEX32 WSCulong getTimeout();
     WSDLEX32 WSCulong getClTimeout();

     WSDLEX32 void setUserData(void*);
     WSDLEX32 void* getUserData();

     WSDLEX32 void setIsUdp(WSCbool);
     WSDLEX32 WSCbool getIsUdp();
     WSDLEX32 virtual WSCstring getLastError();

    WSMFclassDef(WSDsocket,WSDres);
};
#endif //WSDSOCKET_H
