//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDTHREAD_H
#define WSDTHREAD_H

#include <WSCroot.h>

#define WS_THREAD_STOPPED 0
#define WS_THREAD_RUNNING 1

#define WS_ERR_TIMEDOUT   -2

class WSDthread :public WSCroot{

  protected:
    void*      _ptr;
    void*      (*_proc)(WSDthread*,void*);
//    void*      _callback_data;
    void      (*_callback_proc)(WSDthread*,void*);

    static WSDthread* (*_create_handler)();

  public:
    WSDLEX32 WSDthread();
    WSDLEX32 virtual ~WSDthread();

    WSDLEX32 void setFunction(void*(*func)(WSDthread*,void*));
    WSDLEX32 void* getFunction();

    WSDLEX32 void setCallbackFunction(void(*func)(WSDthread*,void*));
    WSDLEX32 void* getCallbackFunction();
//    WSDLEX32 void* getCallbackData();

    WSDLEX32 virtual long    createThread(void* data);
    WSDLEX32 virtual long    detachThread();
    WSDLEX32 virtual long    joinThread(void**);
    WSDLEX32 virtual long    terminateThread();
    WSDLEX32 virtual long    getStatus();
    WSDLEX32 virtual long    execCallback(void*);

    WSDLEX32 static WSDthread* getNewInstance();
    WSDLEX32 static void      setCreateInstanceHandler(void* hd);
    WSDLEX32 static void*     getCreateInstanceHandler();

    WSMFclassDef(WSDthread,WSCroot);
};
typedef void* (*WSthreadProc)(WSDthread*,void*);
typedef void (*WSthreadCallbackProc)(WSDthread*,void*);

#endif
