//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCPROJECTEDITOR_H
#define WSCPROJECTEDITOR_H

#include <WScom.h>
#include <WSCbaseDialog.h>
#include <WSCindexData.h>

class WSCindexForm;
class WSCform;
class WSCvbtn;
class WSCvlabel;
class WSCvifield;
class WSClist;
class WSCvslider;
class WSCvtoggle;
//class WSCinputDialog;
class WSCobjectBox;
class WSCoption;
class WSCvradio;

#define WSCprojectEditor_VER 1000

class WSCprojectEditor :public WSCbaseDialog{

  protected:
    char* _file_name;
    char* _file_name2;
    WSCindexData  _project_data;
    WSCindexData  _object_index;
    WSCindexData  _project_data2;
    WSCindexData  _object_index2;
    WSCindexData  _project_data3;
    WSCindexData  _object_index3;
    WSCstring _locale_name;
    WSCindexData  _lib_opts;
    WSCindexData  _lib_opts_st;

    WSCform*   _area1;
    WSCindexForm*  _area2;
    WSCvlabel* _pe_sp1;
    WSCform* _pe_ca1;
    WSCvbtn* _pe_cbt1;
    WSCform* _pe_ca2;
    WSCvbtn* _pe_cbt2;
    WSCform* _pe_ca3;
    WSCvbtn* _pe_cbt3;
    WSCform* _pe_ca4;
    WSCvbtn* _pe_cbt4;
    WSCvlabel* _pe_ct1;
    WSCvlabel* _pe_ct2;
    WSCvlabel* _pe_ct3;
    WSCvlabel* _pe_ct4;
    WSCvlabel* _pe_lb1;
    WSCvlabel* _pe_lb2;
    WSCvifield* _pe_if1;
    WSCvifield* _pe_if2;
    WSCvifield* _pe_if3;
    WSCvifield* _pe_if5;
    WSCvifield* _pe_if6;
    WSCvlabel* _pe_gt1;
    WSCvlabel* _pe_gt2;
    WSCvlabel* _pe_gt3;
    WSCvlabel* _pe_gt4;
    WSClist* _pe_elist;
    WSClist* _pe_elist2;
    WSCvslider* _pe_sl1;
    WSCvslider* _pe_sl2;
    WSCvslider* _pe_sl3;
    WSCvslider* _pe_sl5;
    WSCvslider* _pe_sl6;
    WSCvifield* _pe_cif1;
    WSCvifield* _pe_cif2;
    WSCvifield* _pe_cif3;
    WSCvifield* _pe_cif4;
    WSCvifield* _pe_ifi002;
    WSCvtoggle* _pe_tgl004;
//    WSCvtoggle* _pe_tgl007;
    WSCoption*  _pe_opt007;
    WSCvifield* _pe_ifi003;
    WSCvifield* _pe_ifi004;
    WSCvifield* _pe_ifi005;
    WSCvifield* _pe_ifi006;
    WSCvifield* _pe_ifi007;
    WSCvifield* _pe_ifi008;
    WSCvifield* _pe_ifi009;
    WSCvifield* _pe_ifi010;
    WSCvifield* _pe_ifi011;
    WSCvifield* _pe_ifi012;
    WSCvifield* _pe_ifi013;
    WSCvifield* _pe_ifi014;
    WSCvbtn*    fdiavbtn000;
    WSCvbtn*    fdiavbtn001;
    WSCvbtn*    fdiavbtn002;
    WSCvbtn*    fdiavbtn003;
    WSCvbtn*    fdiavbtn004;
    WSCvbtn*    fdiavbtn005;
    WSCvbtn*    fdiavbtn006;
    WSCvbtn*    fdiavbtn007;
    WSClistData _dll_list;
    WSCstring   _dll_str;
    WSCobjectBox* _obox;
    WSCindexForm* index002;
    WSCindexForm* index0052;
    WSCvbtn*    _pe_bt1;
    WSCvbtn*    _pe_btn3;
    WSCvbtn*    _pe_bt2;
    WSCvbtn*    _pe_btn4;
    WSCoption*  _opt1;
//    WSCvradio*  _pe_radio1;
    WSCoption*  _opt4;
    WSCvradio*  _pe_radio2;
//    WSCvradio*  _pe_radio3;
//    WSCvradio*  _polvrad_002;
//    WSCvradio*  _polvrad_003;
    WSCoption*   _polvopti000;
    WSCvifield*  _pe_obj1;
    long _policy;
    WSCstring _expolicy_name;
    WSCoption*  _opt2;
    WSCoption*  _opt3;

    WSClistData  _look_and_feel_name_list;
    WSClistData  _look_and_feel_value_list;
    WSCindexData  _target_suffix_name_list;
    WSCindexData  _target_env_name_list;

    WSCvifield* _cpe_ifi001;
    WSCvifield* _cpe_ifi002;
    WSCvifield* _cpe_ifi003;
    WSCvifield* _cpe_ifi004;
    WSCvifield* _cpe_ifi005;
    WSCstring _linkoptions_fname;
    WSCstring _default_prj_fname;
    long _target_no;
    WSCvifield* _pe_ifi015;
//    WSCinputDialog* _pe_inputd;
//WSCcolorSelect* _pe_colord;

//    WSMFpropertyDef( WSNfileName,   char*,   _file_name ); 
    WSDLEX32 static void _ifnum_op(WSCbase*);
    WSDLEX32 static void _sldnum_op(WSCbase*);
    WSDLEX32 static void _feditop(WSCbase*);
    WSDLEX32 static void _pe_btn1_work(WSCbase*);
    WSDLEX32 static void _pe_btn2_work(WSCbase*);
    WSDLEX32 static void _pe_btn3_work(WSCbase*);
    WSDLEX32 static void _pe_btn4_work(WSCbase*);
    WSDLEX32 static void _policy_select_work(WSCbase*);
    WSDLEX32 static void _pe_fbt1_work(WSCbase*);
    WSDLEX32 static void _pe_fbt2_work(WSCbase*);
    WSDLEX32 static void _pe_fbt3_work(WSCbase*);
    WSDLEX32 static void _pe_fbt4_work(WSCbase*);
    WSDLEX32 static void _pe_fbt5_work(WSCbase*);
    WSDLEX32 static void _pe_fbt6_work(WSCbase*);
    WSDLEX32 static void _pe_fbt7_work(WSCbase*);
    WSDLEX32 static void _pe_fbt8_work(WSCbase*);
    WSDLEX32 static void _pe_fbt9_work(WSCbase*);
    WSDLEX32 static void _cpe_fbt_work(WSCbase*);

    WSDLEX32 static void _editor_option_work(WSCbase*);
    WSDLEX32 static void _target_option_work(WSCbase*);

    WSDLEX32 virtual void onResize(WSCrect* rect);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 long  _open(char* ,WSCindexData*,WSCindexData*);
    WSDLEX32 long  _save(char* ,WSCindexData*,WSCindexData*);
    WSDLEX32 void  _update_data(WSCindexData*,WSCindexData*);
    WSDLEX32 void  _cancel_data(WSCindexData*,WSCindexData*);
    WSDLEX32 static void  _compat_work(WSCbase*);
    WSDLEX32 long  _reload_project();
    WSDLEX32 void _loadLinkOptions(WSCstring*);

  public:
    WSDLEX32 WSCprojectEditor(WSCbase*,char*);
    WSDLEX32 virtual ~WSCprojectEditor();
    WSDLEX32 virtual  long initialize();

    WSDLEX32 virtual void adjustForm();
    WSDLEX32 virtual void onGuiPolicyChange(long);
    WSDLEX32 virtual void onVisibleChange(WSCbool);

    WSDLEX32 void  setDefaultProjectName(char* );
    WSDLEX32 long  open(char* );
    WSDLEX32 long  save(char* );
    WSDLEX32 long  open_global(char* );
    WSDLEX32 long  save_global(char* );

    WSDLEX32 WSCstring getProjectDataFromFile(char* fname,char* index);
    WSDLEX32 char* getProjectData(char* index = NULL);
    WSDLEX32 char* getProjectData(char* index,WSCindexData*,WSCindexData*);
    WSDLEX32 void  updateData();
    WSDLEX32 void  cancelData();
    WSDLEX32 void  setProjectData(char*,char*);
    WSDLEX32 void  setMenu(long no);
    WSDLEX32 void  setUseDll(char*);
    WSDLEX32 void  setUseFiles(char*);
    WSDLEX32 void  clearUseDll();
    WSDLEX32 void  setObjectBox(WSCobjectBox*);
    WSDLEX32 void  setUseLocaleName(char*);
    WSDLEX32 char*  getUseLocaleName();
    WSDLEX32 void  setEncodingMenu(char* menu,long default_value);
    WSDLEX32 long getLanguage();
    WSDLEX32 void setLanguage(long);
//    WSDLEX32 WSCbool getOldSwigMapping(); //removed..
    WSDLEX32 WSCbool useMpfcMapping(); //removed..

    WSDLEX32 WSCstring getGuiPolicy();
    WSDLEX32 void setGuiPolicy(char*);

    WSDLEX32 void loadEditorOptions(char*);
    WSDLEX32 void loadLinkOptions(char*);
    WSDLEX32 WSCstring getLinkOptions(long);
    WSDLEX32 WSCstring getStaticLinkOptions(long);

    WSDLEX32 WSCstring getTargetSuffixName();
    WSDLEX32 WSCstring getTargetEnvironment();

    WSMFguiClassDef(WSCprojectEditor,WSCbaseDialog);
    WSMFversionDef(WSCprojectEditor);
};
#endif
