//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDDFBSOCKET_H
#define WSDDFBSOCKET_H

#include <WScom.h>
#include <WSDsocket.h>

class WSDdfbSocket  :public WSDsocket{
 protected:
  int _socket;
  WSCbool _listened;
  void*   _sem;
  WSCstring _error_str;
  WSCbool _no_delay;

  virtual long initialize();
  virtual long destroy();

  static void* _accept_thread_(void* ptr);
  static void* _udp_read_thread_(void* ptr);
  void seterr(int val = -1);
 public:
  WSDdfbSocket();
  virtual ~WSDdfbSocket();
  virtual long connect();
  virtual long listen();
  virtual void* accept();
  virtual long acceptEx(void(*)(WSDsocket*,void*,WSCulong));
  virtual long _continue_udp_read_accept();

  virtual long read(void* handle,WSCuchar* buf,long size);
  virtual long write(void* handle,WSCuchar* buf,long size);
  virtual long read(WSCuchar* buf,long);
  virtual long write(WSCuchar* buf,long);

  virtual long close(void* sock = NULL);

  virtual WSCstring getLastError();  

  WSMFclassDef(WSDdfbSocket,WSDsocket);
};
struct _accept_send_type{
  WSDdfbSocket* sock;
  int         socket;
  WSCulong    addr;
  void(*hd)(WSDsocket*,void*,WSCulong);
};

#endif //WSDXSOCKET_H
