//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#if !defined(_timing_h)
#define _timing_h

#ifndef WIN32
#include <sys/time.h>
#endif
#ifndef _WSWINCE
#include <unistd.h>
#endif
#ifdef WS
#ifdef WIN32
#include <windows.h>
#ifndef _WSWINCE
#include <sys/timeb.h>
#endif
#include <time.h>
#include <winsock.h>
#endif //WIN32
#ifdef TE
#include <net/sock_com.h>
#endif
#endif //WS

class cTiming {
#ifdef WIN32
    SYSTEMTIME start_st;
    SYSTEMTIME loss_st;
    SYSTEMTIME now_st;
#else //WIN32
    timeval  start, now, losstime;
    struct timezone tzone;
#endif //WIN32
    long   msec;
  public:
    cTiming() {}
    ~cTiming() {}
#ifdef WIN32
    void StartTimer() {
      GetLocalTime(&start_st);
    }
    void PauseTimer() {
      GetLocalTime(&loss_st);
    }
    void RestartTimer() {
      GetLocalTime(&now_st);
      start_st.wYear += now_st.wYear - loss_st.wYear;
      start_st.wMonth += now_st.wMonth - loss_st.wMonth;
      start_st.wDayOfWeek += now_st.wDayOfWeek - loss_st.wDayOfWeek;
      start_st.wDay += now_st.wDay - loss_st.wDay;
      start_st.wHour += now_st.wHour - loss_st.wHour;
      start_st.wMinute += now_st.wMinute - loss_st.wMinute;
      start_st.wSecond += now_st.wSecond - loss_st.wSecond;
      start_st.wMilliseconds += now_st.wMilliseconds - loss_st.wMilliseconds;
    }
    long GetTime() {
      GetLocalTime(&now_st);
      long ret = (now_st.wDay - start_st.wDay)*24*60*60*1000;
      ret += (now_st.wHour - start_st.wHour)*60*60*1000;
      ret += (now_st.wMinute - start_st.wMinute)*60*1000;
      ret += (now_st.wSecond - start_st.wSecond)*1000;
      ret += now_st.wMilliseconds - start_st.wMilliseconds;
      return ret;
    }
#else //WIN32
    void StartTimer() { gettimeofday(&start, &tzone); }
    void PauseTimer() { gettimeofday(&losstime, &tzone); }
    void RestartTimer() {
        gettimeofday(&now, &tzone);
        start.tv_sec += now.tv_sec - losstime.tv_sec;
        start.tv_usec += now.tv_usec - losstime.tv_usec;
    }
    long GetTime() {
        gettimeofday(&now, &tzone);
        msec = (now.tv_sec - start.tv_sec)*1000 +
                    long((now.tv_usec - start.tv_usec)/1000);
        return msec;
    }
#endif //WIN32
    long GetTick() { return 1; }
    long GetPeriodInTick () { return GetTime(); }
};

#endif
