//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#if !defined(_vertex_h)
#define _vertex_h

#include "misc3d.h"

class
  TVertex {
    int    Max;
    int    Count;
    int    Offset;
    Vector rposition;
  public:
    VectorSet **vert;
    TVertex(int vn);
    ~TVertex();

    int  GetCount() { return Count;}

    int  GetMaxCount() { return Max;}

    void Add(Vector v);

    void Assign(int pos, Vector v);

    void Query(int pos, Vector &v);

    void SetPosition(Vector v) { rposition = v;}

    void Transpose(int pos, Vector v);

    void UpdateOffset() { Offset = Count;}

    void ResetOffset() { Offset = 0;}

    int  GetOffset() { return Offset;}

  };

#endif
