//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.


#ifndef WSDWINKEYBOARD_H
#define WSDWINKEYBOARD_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSkeysym.h>
#include <WSCstring.h>
#include <WSClistData.h>
#include <WSDkeyboard.h>
#include <imm.h>


class WSDwinKeyboard  :public WSDkeyboard{

  protected:
    HIMC   _himc;
    HWND   _hwnd;
    short  _font_no;
    static void _device_move_handler(WSDdev*,void*);
    WSDdev* _dev;
    WSCbool _focused;
    WSCbool _fep_status_bk;
    char    _buf[32];
    long    _pos;
    DWORD   _sent_bk;
  public:
    WSDLEX32 WSDwinKeyboard();
    WSDLEX32 virtual ~WSDwinKeyboard();

    WSDLEX32 virtual long initialize();

    WSDLEX32 WSCbool _dispatch_key(MSG*);

    WSDLEX32 virtual long startFep(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    WSDLEX32 virtual long startAscii(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    WSDLEX32 virtual long setFepPos (WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    WSDLEX32 virtual long resetFep(WSDdev*);
    WSDLEX32 virtual long setFepStatus(long);

    WSDLEX32 virtual void setEnableFep(WSDdev*,WSCbool);

    WSDLEX32 void setModeWindowPos(short x,short y,WSDdev*);
    WSDLEX32 virtual void setSelectedString(char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 virtual char* getSelectedString(long encode = WS_EN_DEFAULT);
WSMFclassDef(WSDwinKeyboard,WSDkeyboard);
    WSDLEX32 void updateFepStatus();
//    WSDLEX32 HIMC   getHimc();
    WSDLEX32 void   setHwnd(HWND);
};
extern WSDLEX32 WSDwinKeyboard* WSGIwinKeyboard();
#endif
