//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDFILESERIALIZE_H
#define WSDFILESERIALIZE_H

#include <WScom.h>
#include <WSDserialize.h>
#ifdef USE_WSMFILE
#include <WSCmfile.h>
#endif
class WSDfileSerialize  :public WSDserialize{
  protected:
    FILE* _fp;
#ifdef USE_WSMFILE
    WSCmfile* _mfp;
#endif

virtual long _open(char* name,long mode);
virtual long _close();
virtual long _eof();
virtual long _read(void*,long len);
virtual long _write(void*,long len);
virtual long _seek(long addr);
virtual long _seek_set();
virtual long _seek_end();
virtual long _size();
virtual long _tell();

  public:
    WSDfileSerialize();
virtual          ~WSDfileSerialize();
virtual   WSCbool       type(char*);
virtual   WSDserialize* createSerialize();
virtual   long endTransaction();

    WSMFclassDef(WSDfileSerialize,WSDserialize);
};

#endif //WSDFILESERIALIZE_H
