//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDXWINDEV_H
#define WSDXWINDEV_H

#include <WSDmwindowDev.h>
#include <X11/Intrinsic.h>

class WSDxmwinDev   :public WSDmwindowDev{
 protected:
  Pixmap    _pixmap;
  Pixmap    _pixmap_for_img;
  GC        _gc;
  XImage*   _image;
  Display*  _display;
  char      _bit;
  long _copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,Pixmap);
 public:
  WSDxmwinDev();
  virtual ~WSDxmwinDev();

  virtual long createPixmap(WSCushort w,WSCushort h);
  virtual long destroyPixmap();
  long createContext();
  long destroyContext();

  virtual long copyToWindow(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short);
  virtual long copyFromWindow(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short);
  virtual long copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,WSDimage*);
  virtual long copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,WSDmwindowDev*);

  virtual long getWindowResource();
  virtual long getDeviceResource();
  virtual long getSpecialResource();
  virtual long getContextResource();

  virtual long initBuffer();
  virtual long setBufferRGB(WSCushort x,WSCushort y,
                            WSCuchar r,WSCuchar g,WSCuchar b);
  virtual long getBufferRGB(WSCushort x,WSCushort y,
                            WSCuchar* r,WSCuchar* g,WSCuchar* b);
  virtual long putBufferToPixmap();
  virtual long saveFile(char*,long);

  WSMFclassDef(WSDxmwinDev,WSDmwindowDev);
};
#endif
