//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSDXWINDEV_H
#define WSDXWINDEV_H

#include <x11/WSDxformDev.h>
#include <X11/Intrinsic.h>

class WSDxwinDev   :public WSDxformDev{
 protected:
  Widget _swidget;
  XSizeHints* _sizehints;
#ifndef NO_MWT_FUNCTION
  int _rebase_handle;
#endif
  long   _timer_handle;
  char   _title_bar;
  char   _title_bar_style;
  unsigned _no_frame:1;
  unsigned _requested_top:1;
  unsigned _no_frame_first_time:1;
  unsigned _transient:1;
  unsigned _top_float:1;
  unsigned _modal:1;

 public:
  virtual long createWindow();
  virtual long destroyWindow();
 protected:
  static  void _evh_client_message(Widget,void*,XEvent*,WSCbool* );
  static  void _evh_delete2(Widget,void*,void*);
  static  void _evh_resize(Widget,void*,XEvent*,WSCbool* );
  static  void _evh_expose(Widget,void*,XEvent*,WSCbool* );
  static  void _evh_focus_ch(Widget,void*,XEvent*,WSCbool* );
  static  void _evh_mouse_in(Widget,void*,XEvent*,WSCbool* );
  static  void _float_top_timer_proc(WSCuchar,void*);
  static WSClistData  _no_frame_list;
  static void _add_list(WSDxwinDev*);
  static void _del_list(WSDxwinDev*);
  static void _popup_window(WSDxwinDev*);
  static WSCbool _chk_popup(WSDxwinDev*);
 public:
  WSDxwinDev();
  virtual ~WSDxwinDev();
  virtual long setVisible(WSCbool fl);
  virtual long setValue(long kind,void*);
  virtual long getValue(long kind,void*);

  virtual WSDdev* getParentDev();
  virtual WSDdev* getVisibleParentDev();
  virtual void _clear_widget();

  Widget getShell();

#ifndef NO_MWT_FUNCTION
  WSDLEX32 virtual void getDiffCoordinates(long* x,long* y);
#endif

  WSMFclassDef(WSDxwinDev,WSDxformDev);
};
#endif
