//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <advance/WSCclassRMethodEditor.h>
#include <advance/WSadcom.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCscrForm.h>
#include <WSCvlabel.h>
#include <WSCoption.h>
#include <WSCvlabel.h>
#include <WSCvifield.h>
#include <WSCvbtn.h>
#include <WSCvfbtn.h>
#include <WSDkeyboard.h>
#include <WSCimageSet.h>
#include <WSCcolorSet.h>
#include <WSCmessageDialog.h>
#include <WSCfileSelect.h>
#include <WSCvtoggle.h>
#include <WSDfile.h>
#include <WSCballoonHelp.h>
#include <WSClist.h>
#include <WSCpopupMenu.h>
#include <WSDappDev.h>

#define WS_WARNING_STR  WSGFgettext("L3:WSSTR Warning")

#define WS_DIALOG_PIX1  WS_PIXMAP_DIR "bi23.xpm"
#define WS_DIALOG_PIX2  WS_PIXMAP_DIR "ope.xpm"
#define WS_CREATE_PIX   WS_PIXMAP_DIR "wcreate.xpm"
#define WS_TRASH_PIX    WS_PIXMAP_DIR "wtrash.xpm"
#define WS_EDIT_PIX     WS_PIXMAP_DIR "edit.xpm"


#define WS_PEDBGCOLOR1 "#C5C5D5"
#define WS_PEDTITLE2   "Class:"

#define WS_PEDLB_W      550
#define WS_PEDLB_HEIGHT 250
#define WS_PEDLB_COL    16
#define WS_PEDLB_COL2   7


#define WS_PEDLD_WIDTH     340
#define WS_PEDLD_HEIGHT    330
#define WS_PEDLD_TWIDTH  170
#define WS_PEDLD_T       25
#define WS_PEDLD_LX      190
#define WS_PEDLD_LWIDTH  140
#define WS_PEDLD_ATTMENU WSGFgettext("C3:WSSTR Normal:0:,Invisible:4:,Deleted:1:,Default changed:2:,Hidden:3:")

#define WS_PEDLD_TGRMENU    \
"char:4:,WSCuchar:5:,short:2:,WSCushort:3:,\
int:12:,WSCuint:13:,long:0:,WSCulong:1:,\
WSCbool:11:,char*(string):9:,float:6,\
double:7:,void*:8:"

#define WS_PEDLD_TGRMENU2    \
"char:4:,WSCuchar:5:,short:2:,WSCushort:3:,\
int:12:,WSCuint:13:,long:0:,WSCulong:1:,\
WSCbool:11:,char*(string):9:,float:6,\
double:7:"

extern char* get_type_name(long num);
extern long get_type_value(char*);

#define WS_PEDLDTITLE1   WSGFgettext("D3:WSSTR Target class:")
#define WS_PEDLDTITLE2   WSGFgettext("E3:WSSTR Method name:")
#define WS_PEDLDTITLE3   WSGFgettext("F3:WSSTR Return value type:")
#define WS_PEDLDTITLE4   WSGFgettext("G3:WSSTR Parameters")

#define WS_PEDLDTITLE5   WSGFgettext("H3:WSSTR Name/Type")
#define WS_PEDLDTITLE6   WSGFgettext("I3:WSSTR Attribute:")
#define WS_PEDLDTITLE7   WSGFgettext("J3:WSSTR Builder title:")
#define WS_PEDLDTITLE8   WSGFgettext("K3:WSSTR Select menu:")

WSMFguiClassInitialize(WSCclassRMethodEditor,WSCbaseDialog);

WSCclassRMethodEditor::WSCclassRMethodEditor(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){

  _client = NULL;
  _end_btn = NULL;
  _cmd_area1 = NULL;
  _tlbs4 = NULL;
  _oname = NULL;
  _msg = NULL;
  _voidp_client = NULL;
  _darea1 = NULL;
  _pmenu = NULL;
  _opt1 = NULL;
  _opt2 = NULL;
  WSMFpropertyCreateStart
    WSMFpropertyCreate(WSNclient, void*, _voidp_client,WSSclient );
    WSMFaddTrigger(WSEV_VALUE_CH);
  WSMFpropertyCreateEnd
}

WSMFproperty( WSCclassRMethodEditor, WSNclient, void*,   _voidp_client,   NULL);

void WSCclassRMethodEditor::setWorkWSNclient(void* data){
  WSCbase* client = (WSCbase*)data;
  setUserData("PCLIENT",client);
  setEditClient(client);
}

void WSCclassRMethodEditor::getWorkWSNclient(void** data){
  WSCbase* client = getEditClient();
  *data = (void*)client;
}

void WSCclassRMethodEditor::_end_btn_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");
  op_edit->setVisible(False);
}

void WSCclassRMethodEditor::_dialog_set_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");
  if (op_edit->_dialog1->getStatus() != WS_DIALOG_OK){
    return;
  }
  long no = (long)op_edit->_dialog1->getUserData("RMETHOD NO");
  WSCstring opname;
  opname.setString(op_edit->_if2->getProperty(WSNlabelString));
  opname.delLineFeed();
  opname.delHeadSpace();
  opname.delTailSpace();
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);


  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);

  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)320);
  if (opname.getWords() != 1 || 
      WSGFcheckNameString(opname.getString()) != True){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("S3:WSSTR Invalid method name."));
    op_edit->_msg->setVisible(True);
    return;
  }

  long val;
  op_edit->_opt1->getPropertyV(WSNvalue,&val);
  op_edit->_dialog1->setVisible(False);

  if (no == -1 && op_edit->_client != NULL){ //ɲ
#if 0
    char* rcname = (char*)op_edit->_client->getUserData(WS_RCLASS_NAME);
    if (rcname == NULL){
      WSCstring tmp;
      tmp = op_edit->_client->getInstanceName();
      if (!strncmp((char*)tmp,"WSC",3)){
        tmp.replaceString("WSC","WSCR",1);
      }else{
        WSCstring tmp2;
        tmp2 << "WSCR" << tmp;
        tmp = tmp2;
      }
      rcname = WSGFstrdup((char*)tmp);
    }

    char* rbcname = (char*)op_edit->_client->getUserData(WS_RCLASS_BNAME);
    if (rcname == NULL){
      WSCstring tmp;
      tmp = op_edit->_client->getClassName();
      if (!strncmp((char*)tmp,"WSC",3)){
        tmp.replaceString("WSC","WSCR",1);
      }else{
        WSCstring tmp2;
        tmp2 << "WSCR" << tmp;
        tmp = tmp2;
      }
      rbcname = WSGFstrdup((char*)tmp);
    }

    op_edit->_cif1->setProperty(WSNlabelString,rcname);
    op_edit->_cif2->setProperty(WSNlabelString,rbcname);
#endif

    WSClistData* rmethod_list = (WSClistData*)op_edit->_client->getUserData(WS_RMETHOD_LIST);
    if (rmethod_list == NULL){
      rmethod_list = new WSClistData();
      op_edit->_client->setUserData(WS_RMETHOD_LIST,(void*)rmethod_list);
    }

    long i;
    long num = rmethod_list->getNum();
    for(i=0; i<num; i++){
        rmethod_data* rmdata =  (rmethod_data*)(*rmethod_list)[i];
        if (!strcmp(rmdata->name.getString(),opname.getString())){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("R3:WSSTR The method name is already used."));
          op_edit->_msg->setVisible(True);
          return;
        }
    }

    rmethod_data* rmdata = new rmethod_data();
    rmethod_list->add((void*)rmdata);

    rmdata->name.setString( opname.getString() );
    rmdata->type_name.setString( get_type_name(val) );

    num = op_edit->_plist->getNum();
    WSCstring prms;
    for(i=0; i<num; i++){
      WSCstring tmp = op_edit->_plist->getItem(i);
      if (i>0){
        prms << ",";
      }
      prms << tmp;
    }
    rmdata->params.setString( prms.getString() );

    WSGFmarkChanged(op_edit->_client);
    op_edit->updateProperties();

  }else if (op_edit->_client != NULL){
    char* rcname = (char*)op_edit->_client->getUserData(WS_RCLASS_NAME);
    if (rcname == NULL){
      WSCstring tmp;
      tmp = op_edit->_client->getInstanceName();
      if (!strncmp((char*)tmp,"WSC",3)){
        tmp.replaceString("WSC","WSCR",1);
      }else{
        WSCstring tmp2;
        tmp2 << "WSCR" << tmp;
        tmp = tmp2;
      }
      rcname = WSGFstrdup((char*)tmp);
    }

    char* rbcname = (char*)op_edit->_client->getUserData(WS_RCLASS_BNAME);
    if (rcname == NULL){
      WSCstring tmp;
      tmp = op_edit->_client->getClassName();
      if (!strncmp((char*)tmp,"WSC",3)){
        tmp.replaceString("WSC","WSCR",1);
      }else{
        WSCstring tmp2;
        tmp2 << "WSCR" << tmp;
        tmp = tmp2;
      }
      rbcname = WSGFstrdup((char*)tmp);
    }

    op_edit->_cif1->setProperty(WSNlabelString,rcname);
    op_edit->_cif2->setProperty(WSNlabelString,rbcname);

    WSClistData* rmethod_list = (WSClistData*)op_edit->_client->getUserData(WS_RMETHOD_LIST);
    if (rmethod_list == NULL){
        rmethod_list = new WSClistData();
        op_edit->_client->setUserData(WS_RMETHOD_LIST,(void*)rmethod_list);
    }
    if (rmethod_list->getNum() > no){
      long i;
      long num = rmethod_list->getNum();
      for(i=0; i<num; i++){
        if (i== no){
          continue;
        }
        rmethod_data* rmdata =  (rmethod_data*)(*rmethod_list)[i];

        if (!strcmp(rmdata->name.getString(),opname.getString())){
          op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("S3:WSSTR The method name is already used."));
          op_edit->_msg->setVisible(True);
          return;
        }
      }
      rmethod_data* rmdata =  (rmethod_data*)(*rmethod_list)[no];

      rmdata->name.setString( opname.getString() );
      rmdata->type_name.setString( get_type_name(val) );

      num = op_edit->_plist->getNum();
      WSCstring prms;
      for(i=0; i<num; i++){
        WSCstring tmp = op_edit->_plist->getItem(i);
        if (i>0){
          prms << ",";
        }
        prms << tmp;
      }
      rmdata->params.setString( prms.getString() );


      WSGFmarkChanged(op_edit->_client);
      op_edit->updateProperties();
    }
  }
  op_edit->onValueChange();
}

//void WSCclassRMethodEditor::setSrcPath(char* path){
//  _src_path.setString(path);
//}

void WSCclassRMethodEditor::_ibtn1_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");

  if (op_edit->_client != NULL){
    op_edit->_if2->setPropertyV(WSNlabelString,"method1");
    op_edit->_pname_if->setPropertyV(WSNlabelString,"");
//    op_edit->_value_if->setPropertyV(WSNlabelString,"");
//    op_edit->_bname_if->setPropertyV(WSNlabelString,"");
//    op_edit->_vsname_if->setPropertyV(WSNlabelString,"");
    op_edit->_opt1->setPropertyV(WSNvalue,(long)0);
    op_edit->_opt2->setPropertyV(WSNvalue,(long)0);
    op_edit->_dialog1->setPropertyV(WSNokString,WSGFgettext("T3:WSSTR Create"));
    op_edit->_plist->delAll();
    op_edit->_dialog1->setUserData("RMETHOD NO",(void*)-1);
    op_edit->_dialog1->setVisible(True);

  }else{
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);

    op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);

    op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
  
}

void WSCclassRMethodEditor::_ibtn3_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);

  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);

  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
 
  if ( op_edit->getSelectedPropObj() == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("V3:WSSTR Please select the property."));
    op_edit->_msg->setVisible(True);
    return;
  }else{
    op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX2);
    op_edit->_msg->setPropertyV(WSNtitleString,WSGFgettext("W3:WSSTR Question"));
    op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)350);
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("X3:WSSTR Is it OK to delete the property?"));
    op_edit->_msg->setPropertyV(WSNuserValue,(long)op_edit);
    if (op_edit->_msg->popup() == WS_DIALOG_OK){
      WSCbase* client = op_edit->_client;
      if (client != NULL){
        WSClistData* rmethod_list = (WSClistData*)client->getUserData(WS_RMETHOD_LIST);
        if (rmethod_list != NULL){
          long num = rmethod_list->getNum();
          long no = op_edit->getSelectedPropObj();
          if (no < num){
            rmethod_data* rmdata = (rmethod_data*)(*rmethod_list)[no];
            rmethod_list->del((void*)rmdata);
            delete rmdata;
          }
          WSGFmarkChanged(client);
          op_edit->updateProperties();
        }
      }
    }
  }
}

void WSCclassRMethodEditor::_ibtn2_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");
  op_edit->_msg->setPropertyV(WSNlabelPixmap,WS_DIALOG_PIX1);

  op_edit->_msg->setPropertyV(WSNtitleString,WS_WARNING_STR);

  op_edit->_msg->setPropertyV(WSNreplyHandler,(void*)NULL);
  op_edit->_msg->setPropertyV(WSNwidth,(WSCushort)300);
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }
 
  if ( op_edit->getSelectedPropObj() == -1){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("V3:WSSTR Please select the property."));
    op_edit->_msg->setVisible(True);
    return;
  }
  if (op_edit->_client == NULL){
    op_edit->_msg->setPropertyV(WSNlabelString,WSGFgettext("U3:WSSTR Please specify the target class window."));
    op_edit->_msg->setVisible(True);
    return;
  }

  WSClistData* rmethod_list = (WSClistData*)op_edit->_client->getUserData(WS_RMETHOD_LIST);

  rmethod_data* rmdata = (rmethod_data*)(*rmethod_list)[op_edit->getSelectedPropObj()];
  op_edit->_if2->setPropertyV(WSNlabelString,rmdata->name.getString());
  op_edit->_opt1->setProperty(WSNvalue,
                               (long)get_type_value((char*)rmdata->type_name));

  op_edit->_plist->delAll();
  long num = rmdata->params.getWords(",");
  long i;
  for(i=0; i<num; i++){
    WSCstring val = rmdata->params.getWord(i,",");
    i++;
    WSCstring val2 = rmdata->params.getWord(i,",");
    val << "," << val2;
    op_edit->_plist->addItem(val);
  }


  op_edit->_dialog1->setPropertyV(WSNokString,WSGFgettext("Y3:WSSTR Update"));

  //-1 is create mode,the other is edit mode.
  op_edit->_dialog1->setUserData("RMETHOD NO",(void*)op_edit->getSelectedPropObj());
  op_edit->_dialog1->setVisible(True);
}

long WSCclassRMethodEditor::getSelectedPropObj(){
  return _list->getSelectedPos();
}

long WSCclassRMethodEditor::initialize(){
  WSCbaseDialog::initialize();

  setPropertyV(WSNwidth,(WSCushort)WS_PEDLB_W);
  setPropertyV(WSNheight,(WSCushort)WS_PEDLB_HEIGHT);
  setPropertyV(WSNshadowThickness,(WSCuchar)1);
  setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
//  setPropertyV(WSNtitleBar,(char)WS_ONLY_TITLE);
//  setPropertyV(WSNok,(WSCbool)False);
  setPropertyV(WSNno,(WSCbool)False);
  setPropertyV(WSNcancel,(WSCbool)False);
  setPropertyV(WSNtitleString,"Remote Method Setup");

  _cmd_area1 = new WSCform(this,"pe-area1");
  _cmd_area1->initialize();
  _cmd_area1->setInternalObject(True);
  _cmd_area1->setPropertyV(WSNx,     (short)1 );
  _cmd_area1->setPropertyV(WSNy,     (short)5 );
  _cmd_area1->setPropertyV(WSNwidth, (WSCushort)(_w));
  _cmd_area1->setPropertyV(WSNheight,(WSCushort)30);
  _cmd_area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cmd_area1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _cmd_area1->setVisible(True);

  WSCvlabel* sp2 = new WSCvlabel(_cmd_area1,"pe-tlb");
  sp2->initialize();
  sp2->setInternalObject(True);
  sp2->setPropertyV(WSNx,     (short)0 );
  sp2->setPropertyV(WSNy,     (short)30 );
  sp2->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp2->setPropertyV(WSNheight,(WSCushort)2 );
  sp2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp2->setVisible(True);

  WSCvfbtn* ibtn1 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn1->initialize();
  ibtn1->setInternalObject(True);
  ibtn1->setPropertyV(WSNx,         (short)1                  );
  ibtn1->setPropertyV(WSNy,         (short)1                  );
  ibtn1->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn1->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn1->setPropertyV(WSNlabelPixmap,WSGFimage(WS_CREATE_PIX));
  ibtn1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn1->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn1,0);
  WSGIappBalloonHelp()->registerClient(ibtn1,WSGFgettext("Z3:WSSTR Create new property"));

  WSCprocedure* iop1 = new WSCprocedure("iop1",WSEV_ACTIVATE);
  iop1->setFunction(_ibtn1_work,"_ibtn1_work");
  ibtn1->addProcedure(iop1);
  ibtn1->setVisible(True);

  WSCvfbtn* ibtn2 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn2->initialize();
  ibtn2->setInternalObject(True);
  ibtn2->setPropertyV(WSNx,         (short)31                 );
  ibtn2->setPropertyV(WSNy,         (short)1                  );
  ibtn2->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn2->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn2->setPropertyV(WSNlabelPixmap,WSGFimage(WS_EDIT_PIX));
  ibtn2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn2->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn2,0);
  WSGIappBalloonHelp()->registerClient(ibtn2,WSGFgettext("a3:WSSTR Edit property"));

  WSCprocedure* iop2 = new WSCprocedure("iop2",WSEV_ACTIVATE);
  iop2->setFunction(_ibtn2_work,"_ibtn2_work");
  ibtn2->addProcedure(iop2);
  ibtn2->setVisible(True);

  WSCvfbtn* ibtn3 = new WSCvfbtn(_cmd_area1,"pe-ibtn1");
  ibtn3->initialize();
  ibtn3->setInternalObject(True);
  ibtn3->setPropertyV(WSNx,         (short)61                 );
  ibtn3->setPropertyV(WSNy,         (short)1                  );
  ibtn3->setPropertyV(WSNwidth,     (WSCushort)28        );
  ibtn3->setPropertyV(WSNheight,    (WSCushort)28        );
  ibtn3->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  ibtn3->setPropertyV(WSNlabelPixmap,WSGFimage(WS_TRASH_PIX));
  ibtn3->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  ibtn3->setUserData("WIN EDIT",(void*)this); 
  WSGFsetMargin(ibtn3,0);
  WSGIappBalloonHelp()->registerClient(ibtn3,WSGFgettext("b3:WSSTR Delete property"));

  WSCprocedure* iop3 = new WSCprocedure("iop3",WSEV_ACTIVATE);
  iop3->setFunction(_ibtn3_work,"_ibtn3_work");
  ibtn3->addProcedure(iop3);
  ibtn3->setVisible(True);

  _tlbs4 = new WSCvlabel(_cmd_area1,"pe-tlbs4");
  _tlbs4->initialize();
  _tlbs4->setPropertyV(WSNx,     (short)135 );
  _tlbs4->setPropertyV(WSNy,     (short)5 );
  _tlbs4->setPropertyV(WSNwidth, (WSCushort)60 );
  _tlbs4->setPropertyV(WSNheight,(WSCushort)20 );
  _tlbs4->setPropertyV(WSNforeColor,"black" );
  _tlbs4->setPropertyV(WSNlabelString,WS_PEDTITLE2);
  _tlbs4->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _tlbs4->setVisible(True);

  _oname = new WSCvlabel(_cmd_area1,"pe-tlb");
  _oname->initialize();
  _oname->setPropertyV(WSNx,     (short)200 );
  _oname->setPropertyV(WSNy,     (short)4 );
  _oname->setPropertyV(WSNwidth, (WSCushort)100 );
  _oname->setPropertyV(WSNheight,(WSCushort)21 );
  _oname->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _oname->setPropertyV(WSNforeColor,"blue4");
  _oname->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _oname->setVisible(True);

  _list = new WSClist(_cmd_area1,"pe-area2");
  _list->initialize();
  _list->setInternalObject(True);
  _list->setPropertyV(WSNx,     (short)5 );
  _list->setPropertyV(WSNy,     (short)35 );
  _list->setPropertyV(WSNwidth, (WSCushort)(_w - 10));
  _list->setPropertyV(WSNheight,(WSCushort)(_h -35));
  _list->setPropertyV(WSNscrollHeight,(WSCushort)5);
  _list->setPropertyV(WSNhbarVisible,(WSCbool)False);
  _list->setPropertyV(WSNtype,(WSCuchar)WS_VERBOSE);
  _list->setPropertyV(WSNbarValue,"150");
  _list->setPropertyV(WSNtitleHeight,(WSCuchar)22);
  _list->setPropertyV(WSNtitleString,WSGFgettext("c3:WSSTR Return type,Method name"));
  _list->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _list->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _list->setPropertyV(WSNreverseSelect,(WSCbool)False);
  _list->setVisible(True);

  _clb1 = new WSCvlabel(_cmd_area1,"pe-tlb");
  _clb1->initialize();
  _clb1->setInternalObject(True);
  _clb1->setPropertyV(WSNx,     (short)5 );
  _clb1->setProperty(WSNanchorBottomFlag,True);
  _clb1->setProperty(WSNanchorBottom,25);
//  _clb1->setPropertyV(WSNy,     (short)180 );
  _clb1->setPropertyV(WSNwidth, (WSCushort)230 );
  _clb1->setPropertyV(WSNheight,(WSCushort)20 );
  _clb1->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  _clb1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _clb1->setPropertyV(WSNlabelString, WSGFgettext("d3:WSSTR RemoteClassName:"));
  _clb1->setVisible(True);
//XXZZ

  _clb2 = new WSCvlabel(_cmd_area1,"pe-tlb");
  _clb2->initialize();
  _clb2->setInternalObject(True);
  _clb2->setPropertyV(WSNx,     (short)5 );
//  _clb2->setPropertyV(WSNy,     (short)180 );
  _clb2->setProperty(WSNanchorBottomFlag,True);
  _clb2->setProperty(WSNanchorBottom,5);
  _clb2->setPropertyV(WSNwidth, (WSCushort)230 );
  _clb2->setPropertyV(WSNheight,(WSCushort)20 );
  _clb2->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  _clb2->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _clb2->setPropertyV(WSNlabelString, WSGFgettext("d3:WSSTR BaseClassName:"));
  _clb2->setVisible(True);

//XXXXXZZZZZ


  _cif1 = new WSCvifield(_cmd_area1,"pe-cif1");
  _cif1->initialize();
  _cif1->setInternalObject(True);
  _cif1->setPropertyV(WSNx,     (short)240 );
//  _cif1->setPropertyV(WSNy,     (short)35 );
  _cif1->setProperty(WSNanchorBottomFlag,True);
  _cif1->setProperty(WSNanchorBottom,25);
  _cif1->setPropertyV(WSNwidth, (WSCushort)200);
  _cif1->setPropertyV(WSNheight,(WSCushort)20 );
  _cif1->setPropertyV(WSNcolumns,(WSCushort)18 );
  _cif1->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _cif1->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _cif1->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _cif1->setPropertyV(WSNfillSpace,(WSCbool)False);
  _cif1->setPropertyV(WSNinterCur,(WSCbool)True);
  _cif1->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _cif1->setVisible(True);

  _cif2 = new WSCvifield(_cmd_area1,"pe-cif1");
  _cif2->initialize();
  _cif2->setInternalObject(True);
  _cif2->setPropertyV(WSNx,     (short)240 );
  _cif2->setProperty(WSNanchorBottomFlag,True);
  _cif2->setProperty(WSNanchorBottom,5);
  _cif2->setPropertyV(WSNwidth, (WSCushort)200);
  _cif2->setPropertyV(WSNheight,(WSCushort)20 );
  _cif2->setPropertyV(WSNcolumns,(WSCushort)18 );
  _cif2->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _cif2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _cif2->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _cif2->setPropertyV(WSNfillSpace,(WSCbool)False);
  _cif2->setPropertyV(WSNinterCur,(WSCbool)True);
  _cif2->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _cif2->setVisible(True);


  _pmenu = new WSCpopupMenu(NULL,"menu");
  _pmenu->initialize();
  _pmenu->setPropertyV(WSNmenuItemHeight,(WSCushort)20);
  _pmenu->setPropertyV(WSNmenuItems,WSGFgettext("d3:WSSTR New:NEW:,Edit:EDIT:,Delete:DEL:"));
  _pmenu->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _pmenu->setEmboss(True);
  _pmenu->setUserData("WIN EDIT",(void*)this); 

  WSCprocedure* pmop = new WSCprocedure("NEW",WSEV_NONE);
  pmop->setFunction(_ibtn1_work,"_ibtn1_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("EDIT",WSEV_NONE);
  pmop->setFunction(_ibtn2_work,"_ibtn2_work");
  _pmenu->addProcedure(pmop);

  pmop = new WSCprocedure("DEL",WSEV_NONE);
  pmop->setFunction(_ibtn3_work,"_ibtn3_work");
  _pmenu->addProcedure(pmop);

  _pmenu->registerClient(_list->getScrFrame());

  _msg = new WSCmessageDialog(NULL,"wl-md");
  _msg->initialize();
  _msg->setPropertyV(WSNx,(short)300);
  _msg->setPropertyV(WSNy,(short)300);
  _msg->setPropertyV(WSNwidth,(WSCushort)300);
  _msg->setPropertyV(WSNheight,(WSCushort)100);
  _msg->setPropertyV(WSNtitleString,"Warring");
  _msg->setPropertyV(WSNmodal,(WSCbool)True);

  //---------- PROCEDURE CREATE DIALOG -------------------- 
  _dialog1 = new WSCbaseDialog(this,"dlg_base");
  _dialog1->initialize();
  _dialog1->setInternalObject(True);
  _dialog1->setPropertyV(WSNx,(short)300);
  _dialog1->setPropertyV(WSNy,(short)300);
  _dialog1->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_WIDTH);
  _dialog1->setPropertyV(WSNheight,(WSCushort)WS_PEDLD_HEIGHT);
  _dialog1->setPropertyV(WSNtitleString,"RemoteMethodCreate");
  _dialog1->setPropertyV(WSNno,(WSCbool)False);
  _dialog1->setUserData("WIN EDIT",(void*)this); 
  WSCprocedure* dop1 = new WSCprocedure("dop1",WSEV_ACTIVATE);
  dop1->setFunction(_dialog_set_work,"_dialog_set_work");
  _dialog1->addProcedure(dop1);
  WSCprocedure* dop11 = new WSCprocedure("dop11",WSEV_RESIZE);
  dop11->setFunction(_dialog1_resize_work,"_dialog1_resize_work");
  _dialog1->addProcedure(dop11);

  _darea1 = new WSCform(_dialog1->getFormObject(),"pe-_darea1");
  _darea1->initialize();
  _darea1->setInternalObject(True);
  _darea1->setPropertyV(WSNx,     (short)1 );
  _darea1->setPropertyV(WSNy,     (short)0 );
  _darea1->setPropertyV(WSNwidth, (WSCushort)(WS_PEDLD_WIDTH -2));
  _darea1->setPropertyV(WSNheight,(WSCushort)(WS_PEDLD_HEIGHT -45));
  _darea1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _darea1->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _darea1->setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
  _darea1->setVisible(True);

  WSCvlabel* sp1 = new WSCvlabel(_darea1,"pe-tlb");
  sp1->initialize();
  sp1->setInternalObject(True);
  sp1->setPropertyV(WSNx,     (short)0 );
  sp1->setPropertyV(WSNy,     (short)30 );
  sp1->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp1->setPropertyV(WSNheight,(WSCushort)2 );
  sp1->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp1->setVisible(True);

  _if1 = new WSCvlabel(_darea1,"pe-tlb");
  _if1->initialize();
  _if1->setInternalObject(True);
  _if1->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _if1->setPropertyV(WSNy,     (short)5 );
  _if1->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if1->setPropertyV(WSNheight,(WSCushort)20 );
  _if1->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _if1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _if1->setVisible(True);

  _if2 = new WSCvifield(_darea1,"pe-tlb");
  _if2->initialize();
  _if2->setInternalObject(True);
  _if2->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _if2->setPropertyV(WSNy,     (short)35 );
  _if2->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _if2->setPropertyV(WSNheight,(WSCushort)20 );
  _if2->setPropertyV(WSNcolumns,(WSCushort)18 );
  _if2->setPropertyV(WSNmaxLength,(WSCushort)32 );
  _if2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _if2->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _if2->setPropertyV(WSNfillSpace,(WSCbool)False);
  _if2->setPropertyV(WSNinterCur,(WSCbool)True);
  _if2->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _if2->setVisible(True);
#if 0
  _var_if = new WSCvifield(_darea1,"pe-tlb");
  _var_if->initialize();
  _var_if->setInternalObject(True);
  _var_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _var_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*2) );
  _var_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _var_if->setPropertyV(WSNheight,(WSCushort)20 );
  _var_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _var_if->setPropertyV(WSNmaxLength,(WSCushort)16 );
  _var_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _var_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _var_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _var_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _var_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _var_if->setVisible(True);

  _value_if = new WSCvifield(_darea1,"pe-tlb");
  _value_if->initialize();
  _value_if->setInternalObject(True);
  _value_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _value_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*3) );
  _value_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _value_if->setPropertyV(WSNheight,(WSCushort)20 );
  _value_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _value_if->setPropertyV(WSNmaxLength,(WSCushort)512 );
  _value_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _value_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _value_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _value_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _value_if->setPropertyV(WSNlabelString,"");
  _value_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _value_if->setVisible(True);
#endif

  _opt1 = new WSCoption(_darea1,"typeopt");
  _opt1->initialize();
  _opt1->setInternalObject(True);
  _opt1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _opt1->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _opt1->setPropertyV(WSNy,(short)(35 + WS_PEDLD_T));
  _opt1->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _opt1->setPropertyV(WSNheight,(WSCushort)20);
  _opt1->setPropertyV(WSNmenuItems,WS_PEDLD_TGRMENU);
  _opt1->setPropertyV(WSNemboss,(WSCbool)True);
  _opt1->setVisible(True);




  _pname_if = new WSCvifield(_darea1,"pe-tlb");
  _pname_if->initialize();
  _pname_if->setInternalObject(True);
  _pname_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _pname_if->setPropertyV(WSNy,     (short)(40 + WS_PEDLD_T*3) );
  _pname_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _pname_if->setPropertyV(WSNheight,(WSCushort)20 );
  _pname_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _pname_if->setPropertyV(WSNmaxLength,(WSCushort)512 );
  _pname_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _pname_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _pname_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _pname_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _pname_if->setPropertyV(WSNlabelString,"");
  _pname_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _pname_if->setProperty(WSNanchorRight,10);
  _pname_if->setProperty(WSNanchorRightFlag,True);
  _pname_if->setVisible(True);


  _opt2 = new WSCoption(_darea1,"popt");
  _opt2->initialize();
  _opt2->setInternalObject(True);
  _opt2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _opt2->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _opt2->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*4));
  _opt2->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _opt2->setPropertyV(WSNheight,(WSCushort)20);
  _opt2->setPropertyV(WSNmenuItems,WS_PEDLD_TGRMENU2);
  _opt2->setPropertyV(WSNemboss,(WSCbool)True);
  _opt2->setProperty(WSNanchorRight,10);
  _opt2->setProperty(WSNanchorRightFlag,True);
  _opt2->setVisible(True);


  _add_btn = new WSCvbtn(_darea1,"popt");
  _add_btn->initialize();
  _add_btn->setInternalObject(True);
  _add_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _add_btn->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _add_btn->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*5));
  _add_btn->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _add_btn->setPropertyV(WSNheight,(WSCushort)20);
  _add_btn->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Add"));
  _add_btn->setPropertyV(WSNemboss,(WSCbool)True);
  _add_btn->setProperty(WSNanchorRight,10);
  _add_btn->setProperty(WSNanchorRightFlag,True);
  _add_btn->setUserData("WIN EDIT",(void*)this); 
  _add_btn->setVisible(True);

  WSCprocedure* p_op1 = new WSCprocedure("p_op1",WSEV_ACTIVATE);
  p_op1->setFunction(_add_work,"_add_work");
  _add_btn->addProcedure(p_op1);


  _del_btn = new WSCvbtn(_darea1,"popt");
  _del_btn->initialize();
  _del_btn->setInternalObject(True);
  _del_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _del_btn->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _del_btn->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*6));
  _del_btn->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _del_btn->setPropertyV(WSNheight,(WSCushort)20);
  _del_btn->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Del"));
  _del_btn->setPropertyV(WSNemboss,(WSCbool)True);
  _del_btn->setProperty(WSNanchorRight,10);
  _del_btn->setProperty(WSNanchorRightFlag,True);
  _del_btn->setUserData("WIN EDIT",(void*)this); 
  _del_btn->setVisible(True);

  WSCprocedure* p_op2 = new WSCprocedure("p_op2",WSEV_ACTIVATE);
  p_op2->setFunction(_del_work,"_del_work");
  _del_btn->addProcedure(p_op2);

  _up_btn = new WSCvbtn(_darea1,"popt");
  _up_btn->initialize();
  _up_btn->setInternalObject(True);
  _up_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _up_btn->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _up_btn->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*7));
  _up_btn->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _up_btn->setPropertyV(WSNheight,(WSCushort)20);
  _up_btn->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Up"));
  _up_btn->setPropertyV(WSNemboss,(WSCbool)True);
  _up_btn->setProperty(WSNanchorRight,10);
  _up_btn->setProperty(WSNanchorRightFlag,True);
  _up_btn->setUserData("WIN EDIT",(void*)this); 
  _up_btn->setVisible(True);

  WSCprocedure* p_op3 = new WSCprocedure("p_op3",WSEV_ACTIVATE);
  p_op3->setFunction(_up_work,"_up_work");
  _up_btn->addProcedure(p_op3);

  _down_btn = new WSCvbtn(_darea1,"popt");
  _down_btn->initialize();
  _down_btn->setInternalObject(True);
  _down_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _down_btn->setPropertyV(WSNx,(short)WS_PEDLD_LX);
  _down_btn->setPropertyV(WSNy,(short)(40 + WS_PEDLD_T*8));
  _down_btn->setPropertyV(WSNwidth,(WSCushort)WS_PEDLD_LWIDTH);
  _down_btn->setPropertyV(WSNheight,(WSCushort)20);
  _down_btn->setPropertyV(WSNlabelString, WSGFgettext("W3:WSSTR Down"));
  _down_btn->setPropertyV(WSNemboss,(WSCbool)True);
  _down_btn->setProperty(WSNanchorRight,10);
  _down_btn->setProperty(WSNanchorRightFlag,True);
  _down_btn->setUserData("WIN EDIT",(void*)this); 
  _down_btn->setVisible(True);

  WSCprocedure* p_op4 = new WSCprocedure("p_op4",WSEV_ACTIVATE);
  p_op4->setFunction(_down_work,"_down_work");
  _down_btn->addProcedure(p_op4);

#if 0
  _bname_if = new WSCvifield(_darea1,"pe-tlb");
  _bname_if->initialize();
  _bname_if->setInternalObject(True);
  _bname_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _bname_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*5) );
  _bname_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _bname_if->setPropertyV(WSNheight,(WSCushort)20 );
  _bname_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _bname_if->setPropertyV(WSNmaxLength,(WSCushort)512 );
  _bname_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _bname_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _bname_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _bname_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _bname_if->setPropertyV(WSNlabelString,"");
  _bname_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _bname_if->setVisible(True);

  _vsname_if = new WSCvifield(_darea1,"pe-tlb");
  _vsname_if->initialize();
  _vsname_if->setInternalObject(True);
  _vsname_if->setPropertyV(WSNx,     (short)WS_PEDLD_LX );
  _vsname_if->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*6) );
  _vsname_if->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_LWIDTH );
  _vsname_if->setPropertyV(WSNheight,(WSCushort)20 );
  _vsname_if->setPropertyV(WSNcolumns,(WSCushort)16 );
  _vsname_if->setPropertyV(WSNmaxLength,(WSCushort)512 );
  _vsname_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN );
  _vsname_if->setPropertyV(WSNshadowThickness,(WSCuchar)1 );
  _vsname_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _vsname_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _vsname_if->setPropertyV(WSNlabelString,"");
  _vsname_if->setPropertyV(WSNreturnKeyFocus,(WSCbool)True);
  _vsname_if->setVisible(True);
#endif

  WSCvlabel* tlbs1 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs1->initialize();
  tlbs1->setPropertyV(WSNx,     (short)5 );
  tlbs1->setPropertyV(WSNy,     (short)5 );
  tlbs1->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs1->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs1->setPropertyV(WSNforeColor,"black" );
  tlbs1->setPropertyV(WSNlabelString,WS_PEDLDTITLE1);
  tlbs1->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs1->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs1,0);
  tlbs1->setVisible(True);
 
  WSCvlabel* tlbs2 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs2->initialize();
  tlbs2->setPropertyV(WSNx,     (short)5 );
  tlbs2->setPropertyV(WSNy,     (short)35 );
  tlbs2->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs2->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs2->setPropertyV(WSNforeColor,"black" );
  tlbs2->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs2->setPropertyV(WSNlabelString,WS_PEDLDTITLE2);
  tlbs2->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs2,0);
  tlbs2->setVisible(True);
 
  WSCvlabel* tlbs3 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs3->initialize();
  tlbs3->setPropertyV(WSNx,     (short)5 );
  tlbs3->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T) );
  tlbs3->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs3->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs3->setPropertyV(WSNforeColor,"black" );
  tlbs3->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs3->setPropertyV(WSNlabelString,WS_PEDLDTITLE3);
  tlbs3->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs3,0);
  tlbs3->setVisible(True);

  WSCvlabel* sp3 = new WSCvlabel(_darea1,"pe-tlb");
  sp3->initialize();
  sp3->setInternalObject(True);
  sp3->setPropertyV(WSNx,     (short)0 );
  sp3->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*2) );
  sp3->setPropertyV(WSNwidth, (WSCushort)1280 );
  sp3->setPropertyV(WSNheight,(WSCushort)2 );
  sp3->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
  sp3->setVisible(True);


  WSCvlabel* tlbs4 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs4->initialize();
  tlbs4->setPropertyV(WSNx,     (short)5 );
  tlbs4->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*2 +5) );
  tlbs4->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs4->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs4->setPropertyV(WSNforeColor,"black" );
  tlbs4->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  tlbs4->setPropertyV(WSNlabelString,WS_PEDLDTITLE4);
  tlbs4->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs4,0);
  tlbs4->setVisible(True);

  _plist = new WSClist(_darea1,"pe-area2");
  _plist->initialize();
  _plist->setInternalObject(True);
  _plist->setPropertyV(WSNx,     (short)5 );
  _plist->setPropertyV(WSNy,     (short)(40 + WS_PEDLD_T*3) );
  _plist->setPropertyV(WSNwidth, (WSCushort)(WS_PEDLD_WIDTH -170));
  _plist->setPropertyV(WSNheight,(WSCushort)((WS_PEDLD_HEIGHT -45)-(40 + WS_PEDLD_T*3)) );
  _plist->setProperty(WSNanchorTopFlag,True);
  _plist->setProperty(WSNanchorTop, (40 + WS_PEDLD_T*3));
  _plist->setProperty(WSNanchorBottom,(WSCushort)(10));
  _plist->setProperty(WSNanchorBottomFlag,True);
  _plist->setProperty(WSNanchorRightFlag,True);
  _plist->setProperty(WSNanchorRight,(WSCushort)(170));
  _plist->setProperty(WSNanchorLeftFlag,True);
  _plist->setProperty(WSNanchorLeft,(WSCushort)(5));

  _plist->setPropertyV(WSNscrollHeight,(WSCushort)5);
  _plist->setPropertyV(WSNhbarVisible,(WSCbool)False);
  _plist->setPropertyV(WSNtype,(WSCuchar)WS_VERBOSE);
  _plist->setPropertyV(WSNbarValue,"80");
  _plist->setPropertyV(WSNtitleHeight,(WSCuchar)20);
  _plist->setPropertyV(WSNtitleString,WSGFgettext("c3:WSSTR Type,Name"));
  _plist->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _plist->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _plist->setPropertyV(WSNreverseSelect,(WSCbool)False);
  _plist->setVisible(True);

 
  WSCvlabel* tlbs5 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs5->initialize();
  tlbs5->setPropertyV(WSNx,     (short)5 );
  tlbs5->setPropertyV(WSNy,     (short)(40 + WS_PEDLD_T*2) );
  tlbs5->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs5->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs5->setPropertyV(WSNforeColor,"black" );
  tlbs5->setPropertyV(WSNlabelString,WS_PEDLDTITLE5);
  tlbs5->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  tlbs5->setPropertyV(WSNanchorRight,10);
  tlbs5->setPropertyV(WSNanchorRightFlag,True);
  WSGFsetMargin(tlbs5,0);
  tlbs5->setVisible(True);

#if 0 
  WSCvlabel* tlbs6 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs6->initialize();
  tlbs6->setPropertyV(WSNx,     (short)5 );
  tlbs6->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*4) );
  tlbs6->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs6->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs6->setPropertyV(WSNforeColor,"black" );
  tlbs6->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs6->setPropertyV(WSNlabelString,WS_PEDLDTITLE6);
  tlbs6->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs6,0);
  tlbs6->setVisible(True);

  WSCvlabel* tlbs7 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs7->initialize();
  tlbs7->setPropertyV(WSNx,     (short)5 );
  tlbs7->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*5) );
  tlbs7->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs7->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs7->setPropertyV(WSNforeColor,"black" );
  tlbs7->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs7->setPropertyV(WSNlabelString,WS_PEDLDTITLE7);
  tlbs7->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs7,0);
  tlbs7->setVisible(True);

  WSCvlabel* tlbs8 = new WSCvlabel(_darea1,"pe-tlbs1");
  tlbs8->initialize();
  tlbs8->setPropertyV(WSNx,     (short)5 );
  tlbs8->setPropertyV(WSNy,     (short)(35 + WS_PEDLD_T*6) );
  tlbs8->setPropertyV(WSNwidth, (WSCushort)WS_PEDLD_TWIDTH );
  tlbs8->setPropertyV(WSNheight,(WSCushort)20 );
  tlbs8->setPropertyV(WSNforeColor,"black" );
  tlbs8->setPropertyV(WSNalignmentH,(WSCuchar)WS_RIGHT);
  tlbs8->setPropertyV(WSNlabelString,WS_PEDLDTITLE8);
  tlbs8->setPropertyV(WSNshadowType,WS_SHADOW_TRANS);
  WSGFsetMargin(tlbs8,0);
  tlbs8->setVisible(True);
#endif

      //-------END BTN SETTING ---------//
#if 0
  _use_file = new WSCvtoggle(_darea1,"ope-use_file");
  _use_file->initialize();
  _use_file->setInternalObject(True);
  _use_file->setPropertyV(WSNx, (short)5);
  _use_file->setPropertyV(WSNy, (short)(35 + WS_PEDLD_T*7)  );
  _use_file->setPropertyV(WSNwidth, (WSCushort)320);
  _use_file->setPropertyV(WSNheight,(WSCushort)24);
  _use_file->setPropertyV(WSNlabelString, WSGFgettext("e3:WSSTR  Use the handler defined by user"));
  _use_file->setPropertyV(WSNmarginLeft, (WSCuchar)10);
  _use_file->setPropertyV(WSNalignmentH, (WSCuchar)WS_LEFT);
  _use_file->setPropertyV(WSNindicatorPixmap,WS_TG1_PIX);
  _use_file->setPropertyV(WSNselectPixmap,WS_TG2_PIX);
  _use_file->setPropertyV(WSNindicatorType,WS_IN);
  _use_file->setPropertyV(WSNindicatorSize,(WSCuchar)16);
  _use_file->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _use_file->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  WSGFsetMargin(_use_file,0);
  _use_file->setVisible(True);
#endif
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  _adjust(); 
  return WS_NO_ERR;
}

void WSCclassRMethodEditor::setEditClient(WSCbase* client){
//WSMFtrace("WSCclassRMethodEditor::setEditClient\n");
  if (_client != client){
    _client = client;
//WSMFtrace("WSCclassRMethodEditor::setEditClient  dialgo1->setVisible(False)\n");
    _dialog1->setVisible(False);
    if (client != NULL){
      char* rcname = (char*)client->getUserData(WS_RCLASS_NAME);
      if (rcname == NULL){
        WSCstring tmp;
        tmp = client->getInstanceName();
        if (!strncmp((char*)tmp,"WSC",3)){
          tmp.replaceString("WSC","WSCR",1);
        }else{
          WSCstring tmp2;
          tmp2 << "WSCR" << tmp;
          tmp = tmp2;
        }
        rcname = WSGFstrdup((char*)tmp);
      }

      char* rbcname = (char*)client->getUserData(WS_RCLASS_BNAME);
      if (rbcname == NULL){
        WSCstring tmp;
        WSCbase* b = WSGFgetClassBase(client);
        tmp = b->getClassName();
        WSGFresetClassBase(client);
        if (!strncmp((char*)tmp,"WSC",3)){
          tmp.replaceString("WSC","WSCR",1);
        }else{
          WSCstring tmp2;
          tmp2 << "WSCR" << tmp;
          tmp = tmp2;
        }
        rbcname = WSGFstrdup((char*)tmp);
      }
      _cif1->setProperty(WSNlabelString,rcname);
      _cif2->setProperty(WSNlabelString,rbcname);
    }
    updateProperties();
  }
}

WSCbase* WSCclassRMethodEditor::getEditClient(){
  return _client;
}

void WSCclassRMethodEditor::updateProperties(){
  _list->delAll();

  WSCbase* client = getEditClient();

  if (client == NULL){
    _oname->setPropertyV(WSNlabelString,"");
    _oname->update();
    _if1->setPropertyV(WSNlabelString,"");
    _if1->update();
//    _var_if->setPropertyV(WSNlabelString,"");
//    _var_if->update();
//    _value_if->setPropertyV(WSNlabelString,"");
//    _value_if->update();
    _dialog1->setVisible(False);
    return;
  }

  _oname->setPropertyV(WSNlabelString,client->getInstanceName());
  _oname->update();
  _if1->setPropertyV(WSNlabelString,client->getInstanceName());
  _if1->update();
  _dialog1->setVisible(False);


  WSCstring rcn;
  rcn = _cif1->getProperty(WSNlabelString);

  char* tmp1 = (char*)client->getUserData(WS_RCLASS_NAME);
  if (tmp1 != NULL){
    if (strcmp((char*)tmp1,rcn)){
      WSGFmarkChanged(client);
    }
    delete tmp1; 
  }
  client->setUserData(WS_RCLASS_NAME,WSGFstrdup((char*)rcn));

  WSCstring brcn;
  brcn = _cif2->getProperty(WSNlabelString);

  char* tmp2 = (char*)client->getUserData(WS_RCLASS_BNAME);
  if (tmp2 != NULL){
    if (strcmp((char*)tmp2,brcn)){
      WSGFmarkChanged(client);
    }
    delete tmp2; 
  }
  client->setUserData(WS_RCLASS_BNAME,WSGFstrdup((char*)brcn));

  WSClistData* rmethod_list = (WSClistData*)client->getUserData(WS_RMETHOD_LIST);
  if (rmethod_list == NULL){
    rmethod_list = new WSClistData();
    client->setUserData(WS_RMETHOD_LIST,(void*)rmethod_list);
  }
  _list->setLabelHeight(20);

  long num = rmethod_list->getNum();
  long i;
  for(i=0; i< num; i++){
     rmethod_data* rmdata = (rmethod_data*)(*rmethod_list)[i];
     WSCstring str;
extern char* WSGFvalueToType(long);
//     str = WSGFvalueToType(rmdata->type);
     str = rmdata->type_name;
     str << "," << rmdata->name.getString() << "," ;
//     str << rmdata->params.getString();
     
     _list->addItem((char*)str);
     WSCbase* lb = _list->getLabel(-1);
     lb->setPropertyV(WSNmarginLeft,(WSCuchar)5);
  }
  _list->updateList();
  _list->redraw();
}

void WSCclassRMethodEditor::onValueChange(){
  execProcedure(WSEV_VALUE_CH);
}

void WSCclassRMethodEditor::onResize(WSCrect* rect){
  WSCbaseDialog::onResize(rect);
  _adjust();
}

void WSCclassRMethodEditor::_adjust(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }
  if (_w > 2){
    _cmd_area1->setPropertyV(WSNwidth,(WSCushort)(_w -2));
  }else{
    _cmd_area1->setPropertyV(WSNwidth,(WSCushort)(1));
  }
  if (_w > 12){
    _list->setPropertyV(WSNwidth,(WSCushort)(_w -12));
  }else{
    _list->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (_h +diff > 45){
    _cmd_area1->setPropertyV(WSNheight,(WSCushort)(_h +diff -45));
  }else{
    _cmd_area1->setPropertyV(WSNheight,(WSCushort)(1));
  }

  if (_h +diff > 85+50){
//    _list->setPropertyV(WSNheight,(WSCushort)(_h +diff -85));
    _list->setPropertyV(WSNheight,(WSCushort)(_h +diff -85 -50));
  }else{
    _list->setPropertyV(WSNheight,(WSCushort)(1));
  }
}
void WSCclassRMethodEditor::_dialog1_resize_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");
  WSCushort w,h;
  op_edit->_dialog1->getPropertyV(WSNwidth,&w);
  op_edit->_dialog1->getPropertyV(WSNheight,&h);
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if (w > 2){
    op_edit->_darea1->setPropertyV(WSNwidth,(WSCushort)(w -2));
  }else{
    op_edit->_darea1->setPropertyV(WSNwidth,(WSCushort)(1));
  }

  if (h+diff > 45){
    op_edit->_darea1->setPropertyV(WSNheight,(WSCushort)(h+diff -45));
  }else{
    op_edit->_darea1->setPropertyV(WSNheight,(WSCushort)(1));
  }

}

void WSCclassRMethodEditor::onGuiPolicyChange(long policy){
  if (_opt1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_GRADATION){
      _opt1->setProperty(WSNgradation,WS_GR_LT_RB);
      _opt2->setProperty(WSNgradation,WS_GR_LT_RB);
      _add_btn->setProperty(WSNgradation,WS_GR_T_B);
      _del_btn->setProperty(WSNgradation,WS_GR_T_B);
      _up_btn->setProperty(WSNgradation,WS_GR_T_B);
      _down_btn->setProperty(WSNgradation,WS_GR_T_B);
    }else{
      _opt1->setProperty(WSNgradation,WS_GR_NONE);
      _opt2->setProperty(WSNgradation,WS_GR_NONE);
      _add_btn->setProperty(WSNgradation,WS_GR_NONE);
      _del_btn->setProperty(WSNgradation,WS_GR_NONE);
      _up_btn->setProperty(WSNgradation,WS_GR_NONE);
      _down_btn->setProperty(WSNgradation,WS_GR_NONE);
    }
    if (policy & WS_POLICY_ORIGINAL){
      _cmd_area1->setProperty(WSNy,5);
      _cmd_area1->setProperty(WSNshadowThickness,1);
      _darea1->setProperty(WSNy,5);
      _darea1->setProperty(WSNshadowThickness,1);
      _list->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else
    if (policy & WS_POLICY_WINDOWS){
      _cmd_area1->setProperty(WSNy,0);
      _cmd_area1->setProperty(WSNshadowThickness,0);
      _darea1->setProperty(WSNy,0);
      _darea1->setProperty(WSNshadowThickness,0);
      _list->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    }
    
    _adjust();
  }
}
WSCbool WSCclassRMethodEditor::_check_param_name(char* pname){
  long num = _plist->getNum();
  long i;
  for(i=0; i<num; i++){
    WSCstring str = _plist->getItem(i,1);
    if (!strcmp((char*)str,pname)){
      return False;
    }
  }
  return True;
}
void WSCclassRMethodEditor::_add_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");
  WSCstring tmp = op_edit->_pname_if->getProperty(WSNlabelString);
  if (op_edit->_check_param_name((char*)tmp) == False){
    WSGIappMessageDialog()->setProperty(WSNwidth,550);
    WSGIappMessageDialog()->setProperty(WSNheight,130);
    WSGIappMessageDialog()->setProperty(WSNlabelString, WSGFgettext("S3:WSSTR The variable is already used."));
    WSGIappMessageDialog()->popup();
    return;
  }
  long val = op_edit->_opt2->getValue();
  WSCstring typen = get_type_name(val);
  typen << "," << tmp;

  op_edit->_plist->addItem(typen);
}
void WSCclassRMethodEditor::_del_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");

  long pos = op_edit->_plist->getSelectedPos();
  if (pos < 0){
    return;
  }
  op_edit->_plist->delPos(pos);
  op_edit->_plist->updateList();

}
void WSCclassRMethodEditor::_up_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");

  long pos = op_edit->_plist->getSelectedPos();
  if (pos < 1){
    return;
  }
  WSCstring tmp = op_edit->_plist->getItem(pos);
  op_edit->_plist->delPos(pos);
  op_edit->_plist->addItem((char*)tmp,pos-1);
  op_edit->_plist->setSelectPos(pos-1);

}
void WSCclassRMethodEditor::_down_work(WSCbase* obj){
  WSCclassRMethodEditor* op_edit = (WSCclassRMethodEditor*)obj->getUserData("WIN EDIT");
  long pos = op_edit->_plist->getSelectedPos();
  if (pos < 0){
    return;
  }
  long num = op_edit->_plist->getNum();
  if (pos == num-1){
    return;
  }
  WSCstring tmp = op_edit->_plist->getItem(pos);
  op_edit->_plist->delPos(pos);
  op_edit->_plist->addItem((char*)tmp,pos+1);
  op_edit->_plist->setSelectPos(pos+1);
}

void WSCclassRMethodEditor::onActivate(){
  WSCbaseDialog::onActivate();
  setVisible(False);
}

void WSCclassRMethodEditor::onVisibleChange(WSCbool fl){
  if (fl == False){
    if (_client != NULL){
      updateProperties();
    }
  }
  WSCbaseDialog::onVisibleChange(fl);
}

