//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCbaseDialog.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCform.h>
#include <WSCvbtn.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>
#include <WSCfontSet.h>

WSMFguiClassInitialize(WSCbaseDialog,WSCwindow);
WSMFversion(WSCbaseDialog,WSCwindow);
static WSCushort D_BTN_WIDTH = 60;

WSMFpropertyValueChange(WSCbaseDialog,WSNshadowThickness,WSCuchar,0);
WSMFpropertyValueChange(WSCbaseDialog,WSNheight,WSCushort,100);
WSMFpropertyValueChange(WSCbaseDialog,WSNindicatorOn,WSCbool,False);



WSCbaseDialog::WSCbaseDialog(WSCbase* base,char* objname):
                WSCwindow(base,objname){
  _cmd_form = NULL;
  _end_btn  = NULL;
  _ok_btn   = NULL;
  _no_btn   = NULL;
  _ok_str = WSGFstrdup("OK");
  _no_str = WSGFstrdup("NO");
  _cancel_str = WSGFstrdup("Cancel");
  _ok = True;
  _no = True;
  _cancel = True;
  _title_pixmap = -1;
  _rep = NULL;
//  _shadow_thick = 1;
  _shadow_thick = 0;
  _modal = 0;
  _default_pos = 0;
  _popuped = 0;
  _h = 100;
  _indicator = 0;
  _focus_btn = WS_DIALOG_DEFAULT;
  _status = WS_DIALOG_CANCEL;
  _enable_esc = True;
  _enable_close_on_cancel = True;
  _tb_name = NULL;
  _btb_name = NULL;
  _font = (char)WSGIappFontSet()->getDefaultFontNo();

  WSGIappObjectList()->addEvent(this,WSEV_GUI_POLICY_CH);

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCbaseDialog);

    WSMFpropertyCreate(WSNok,              WSCbool, _ok,WSSok );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNno,              WSCbool,  _no,WSSno );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNcancel,              WSCbool,  _cancel,WSScancel );
      WSMFpropertySetSelection(WSRbool2,WSRbool2D);
    WSMFpropertyCreate(WSNlabelPixmap,     short,  _title_pixmap,WSSlabelPixmap );
    WSMFpropertyCreate(WSNokString,   char*,_ok_str,WSSokString );
    WSMFpropertyCreate(WSNnoString,   char*,_no_str,WSSnoString );
    WSMFpropertyCreate(WSNcancelString,   char*,_cancel_str,WSScancelString );
    WSMFpropertyCreate(WSNmodal,              WSCbool,  _modal,WSSmodal );
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);
    WSMFpropertyCreate(WSNdefaultPosition,    WSCbool,  _default_pos,WSSdefaultPosition );
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);
    WSMFpropertyCreate(WSNreplyHandler, void*,_rep,WSSreplyHandler );
    WSMFpropertyVisible( False );
    WSMFpropertyCreate(WSNkeepPixmapCache,WSCbool,_keep_pixmap_cache,WSSkeepPixmapCache );
      WSMFpropertySetSelection(WSRbool4,WSRbool4D);
    WSMFpropertyCreate(WSNtab,  char*,   _tb_name,WSStab);
    WSMFpropertyCreate(WSNbacktab,  char*,   _btb_name,WSSbacktab);
    WSMFpropertyCreate(WSNfont,         WSCuchar,   _font,WSSfont  );

    WSMFpropertyValueChangeDef(WSCbaseDialog,WSNshadowThickness,WSCuchar);
    WSMFpropertyValueChangeDef(WSCbaseDialog,WSNheight,WSCushort);
    WSMFpropertyValueChangeDef(WSCbaseDialog,WSNindicatorOn,WSCbool);
    WSMFpropertyVisibleOff( WSNindicatorOn );
    WSMFpropertyVisibleOff( WSNmargin );
    WSMFpropertyVisibleOff( WSNmarginLeft );
    WSMFpropertyVisibleOff( WSNbarThickness );
    WSMFpropertyVisibleOff( WSNemboss );

    WSMFaddExtTrigger(WSEV_GUI_POLICY_CH,"GUI_POLICY_CH");

  WSMFpropertyCreateEnd
}
WSCbaseDialog::~WSCbaseDialog(){
  WSGIappDev()->setFocusDialog(this,False);
  WSGIappObjectList()->delEvent(this,WSEV_GUI_POLICY_CH);
  if (_ok_str != NULL){
    delete[] _ok_str;
    _ok_str = NULL;
  }
  if (_no_str != NULL){
    delete[] _no_str;
    _no_str = NULL;
  }
  if (_cancel_str != NULL){
    delete[] _cancel_str;
    _cancel_str = NULL;
  }
  if (_tb_name != NULL){
    delete[] _tb_name;
    _tb_name = NULL;
  }
  if (_btb_name != NULL){
    delete[] _btb_name;
    _btb_name = NULL;
  }
}
WSMFproperty( WSCbaseDialog, WSNok, WSCbool,   _ok     ,True );
WSMFproperty( WSCbaseDialog, WSNno, WSCbool,   _no     ,True );
WSMFproperty( WSCbaseDialog, WSNcancel, WSCbool,   _cancel     ,True );
WSMFproperty( WSCbaseDialog, WSNlabelPixmap, short,  _title_pixmap,-1 );
WSMFproperty( WSCbaseDialog, WSNokString, char*,  _ok_str,WSGFstrdup("OK") );
WSMFproperty( WSCbaseDialog, WSNnoString, char*,  _no_str,WSGFstrdup("NO") );
WSMFproperty( WSCbaseDialog, WSNcancelString, char*,  _cancel_str,WSGFstrdup("Cancel") );
WSMFproperty( WSCbaseDialog, WSNreplyHandler, void*,  _rep,NULL );
WSMFproperty( WSCbaseDialog, WSNmodal, WSCbool,  _modal,False );
WSMFproperty( WSCbaseDialog, WSNdefaultPosition, WSCbool,  _default_pos,False );
WSMFproperty( WSCbaseDialog, WSNkeepPixmapCache, WSCbool,  _keep_pixmap_cache,True );
WSMFproperty( WSCbaseDialog, WSNtab,  char*,   _tb_name, NULL);
WSMFproperty( WSCbaseDialog, WSNbacktab,  char*,   _btb_name, NULL);
WSMFproperty( WSCbaseDialog, WSNfont,        WSCuchar, _font,(char)WSGIappFontSet()->getDefaultFontNo());

void WSCbaseDialog::setWorkWSNreplyHandler(void*){}
void WSCbaseDialog::getWorkWSNreplyHandler(void**){}
void WSCbaseDialog::setWorkWSNokString(char* str){
  if (_ok_btn != NULL){
    _ok_btn->setPropertyV(WSNlabelString,str);
  }
}
void WSCbaseDialog::getWorkWSNokString(char**){}
void WSCbaseDialog::setWorkWSNnoString(char* str){
  if (_no_btn != NULL){
    _no_btn->setPropertyV(WSNlabelString,str);
  }
}
void WSCbaseDialog::getWorkWSNnoString(char**){}
void WSCbaseDialog::setWorkWSNcancelString(char* str){
  if (_end_btn != NULL){
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      _end_btn->setPropertyV(WSNlabelString,str);
    }
  }
}
void WSCbaseDialog::getWorkWSNcancelString(char**){}
#ifndef NO_WINDOW_TITLE
void WSCbaseDialog::setWorkWSNtitleString(char* str){
  WSCwindow::setWorkWSNtitleString(str);
  if (_title_labels1 != NULL){
    _title_labels1->setPropertyV(WSNlabelString,str);
    _title_labels2->setPropertyV(WSNlabelString,str);
  }
}
#endif
void WSCbaseDialog::setWorkWSNok(WSCbool fl){
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  if (fl == False){
    _ok_btn->setPropertyV(WSNvis,(WSCbool)False);
  }else{
    _ok_btn->setPropertyV(WSNvis,(WSCbool)True);
  }
  _cmd_form->needUpdate();
}
void WSCbaseDialog::getWorkWSNok(WSCbool*){}
void WSCbaseDialog::setWorkWSNno(WSCbool fl){
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  if (fl == False){
    if (_no_btn != NULL){
      _no_btn->setPropertyV(WSNvis,(WSCbool)False);
    }
  }else{
    if (_no_btn != NULL){
      _no_btn->setPropertyV(WSNvis,(WSCbool)True);
    }
  }
  _cmd_form->needUpdate();
}
void WSCbaseDialog::getWorkWSNno(WSCbool*){}

void WSCbaseDialog::setWorkWSNcancel(WSCbool fl){
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  if (fl == False){
    if (_end_btn != NULL){
      _end_btn->setPropertyV(WSNvis,(WSCbool)False);
    }
  }else{
    if (_end_btn != NULL){
      _end_btn->setPropertyV(WSNvis,(WSCbool)True);
    }
  }
  _cmd_form->needUpdate();
}
void WSCbaseDialog::getWorkWSNcancel(WSCbool*){}

void WSCbaseDialog::setWorkWSNlabelPixmap(short no){
  if (_title_label != NULL){
    _title_label->clear();
    _title_label->setPropertyV(WSNlabelPixmap,no );
    _title_label->redraw();
  }
}
void WSCbaseDialog::getWorkWSNlabelPixmap(short*){}
void WSCbaseDialog::setWorkWSNwidth(WSCushort width){
  WSCwindow::setWorkWSNwidth(width);
  if (_cmd_form != NULL){
    _cmd_form->setPropertyV(WSNwidth, (WSCushort)(width -2));
//    _cmd_form->setPropertyV(WSNbackPixmap,WSGFgetBarPixmap(width,WS_HORIZONTAL));
#ifndef NO_WINDOW_TITLE
    _title_labels1->clear();
    _title_labels2->clear();
    _title_labels1->setPropertyV(WSNwidth,(WSCushort)(_w - 20));
    _title_labels2->setPropertyV(WSNwidth,(WSCushort)(_w - 20));
    _title_labels1->redraw();
    _title_labels2->redraw();
#endif
    long ediff = 0;
    if (_cancel != False){
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
        ediff = 0;
      }else
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        ediff = D_BTN_WIDTH -26 + 10;
      }
    }
    if (_cancel != False){
      _end_btn->clear();
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
        _end_btn->setPropertyV(WSNx,(short)(width -40));
      }else
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        _end_btn->setPropertyV(WSNx,(short)(width - D_BTN_WIDTH -14));
      }
      _end_btn->redraw();
    }
    short pos = width -40 -ediff;

    if (_no != False){ 
      pos -= D_BTN_WIDTH;
      _no_btn->clear();
      _no_btn->setPropertyV(WSNx,(short)(pos));
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        pos -= 10;
      }
      _no_btn->redraw();
    }
    if (_ok != False){ 
      pos -= D_BTN_WIDTH;
      _ok_btn->clear();
      _ok_btn->setPropertyV(WSNx,(short)(pos));
      _ok_btn->redraw();
    }
    _cmd_form->update();
  }
}
void WSCbaseDialog::setWorkWSNheight(WSCushort height){
  WSCwindow::setWorkWSNheight(height);
  if (_cmd_form != NULL){
    _cmd_form->setPropertyV(WSNy,(short)(height - 35));
    _cmd_form->update();
  }
}
void WSCbaseDialog::setWorkWSNmodal(WSCbool fl){
#ifndef WS_EMBED
  if (getPropertyEditMode() == False){
#endif
    WSDdev* dev = getowndev();
    if (dev != NULL){
      dev->setValue(WSDEV_FLOAT_ON_TOP,&fl);
      dev->setValue(WSDEV_MODAL,&fl);
    }
    if (getVisible() != False){
      WSGIappDev()->setModalClient(this);
    }
#ifndef WS_EMBED
  }
#endif
}
void WSCbaseDialog::getWorkWSNmodal(WSCbool* fl){}
void WSCbaseDialog::setWorkWSNdefaultPosition(WSCbool){}
void WSCbaseDialog::getWorkWSNdefaultPosition(WSCbool*){}
void WSCbaseDialog::setWorkWSNkeepPixmapCache(WSCbool){}
void WSCbaseDialog::getWorkWSNkeepPixmapCache(WSCbool*){}
void WSCbaseDialog::setWorkWSNtab(char* cl){
  if (_end_btn != NULL){
    _end_btn->setProperty(WSNtab,cl);
  }
}
void WSCbaseDialog::getWorkWSNtab(char**){}
void WSCbaseDialog::setWorkWSNbacktab(char* cl){
  if (_ok_btn != NULL){
    _ok_btn->setProperty(WSNbacktab,cl);
  }
}
void WSCbaseDialog::getWorkWSNbacktab(char**){}
long WSCbaseDialog::_device_initialize(){
  WSCwindow::_device_initialize();
  WSDdev* dev = getowndev();
  if (dev != NULL){
#ifndef WS_EMBED
    if (getPropertyEditMode() == False){
#endif
      WSCbool fl = _modal; 
      dev->setValue(WSDEV_FLOAT_ON_TOP,&fl);
      dev->setValue(WSDEV_MODAL,&fl);
#ifndef WS_EMBED
    }
#endif
  }else{
    return WS_ERR;
  }
  return WS_NO_ERR;
}
void WSCbaseDialog::setWorkWSNfont(WSCuchar fn){
  if (_ok_btn != NULL){
    _ok_btn->setProperty(WSNfont,fn);
  }
  if (_no_btn != NULL){
    _no_btn->setProperty(WSNfont,fn);
  }
  if (_end_btn != NULL){
    _end_btn->setProperty(WSNfont,fn);
  }
}
void WSCbaseDialog::getWorkWSNfont(WSCuchar*){}

static void _setup_btn(WSCbase* btn,WSCbase* dlg){
  btn->initialize();
  btn->setInternalObject(True);
  btn->setPropertyV(WSNy,         (short)4                  );
  btn->setPropertyV(WSNheight,    (WSCushort)23        );
//  btn->setPropertyV(WSNforeColor, WSGFcolor("black")        );
//  btn->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  btn->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
  btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  btn->setPropertyV(WSNenableFocusMove,(WSCbool)1);
  btn->setUserData("DLG_BASE",(void*)dlg); 
  WSGFsetMargin(btn,0);
 
}
long WSCbaseDialog::initialize(){
  WSCwindow::initialize();

  _cmd_form = new WSCform(this,"bd-cform");
  _cmd_form->setInternalObject(True);
  _cmd_form->setUseParentBaseDev(True);
  _cmd_form->initialize();
  _cmd_form->setPropertyV(WSNx,     (short)1 );
  _cmd_form->setPropertyV(WSNy,     (short)(_h - 35) );
  _cmd_form->setPropertyV(WSNwidth, (WSCushort)(_w -2));
  _cmd_form->setPropertyV(WSNheight,(WSCushort)30);
  _cmd_form->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _cmd_form->setPropertyV(WSNshadowType,(char)WS_SHADOW_OUT);
//  _cmd_form->setPropertyV(WSNforeColor,WSGFcolor("gray55"));
//  _cmd_form->setPropertyV(WSNbackColor,WSGFcolor("gray80"));
  _cmd_form->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
//  _cmd_form->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _cmd_form->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray55"));
//  _cmd_form->setPropertyV(WSNbackPixmap,WSGFgetBarPixmap(_w,WS_HORIZONTAL));
//  _cmd_form->setProperty(WSNpixmapStyle,WS_DYNAMIC_PIXMAP);
  _cmd_form->setVisible(True);

  _title_label = new WSCvlabel(_cmd_form,"bd-t");
  _title_label->setInternalObject(True);
  _title_label->initialize();
  _title_label->setPropertyV(WSNx,     (short)3 );
  _title_label->setPropertyV(WSNy,     (short)1 );
  _title_label->setPropertyV(WSNwidth, (WSCushort)32 );
  _title_label->setPropertyV(WSNheight,(WSCushort)28 );
  _title_label->setPropertyV(WSNlabelPixmap,_title_pixmap);
  _title_label->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  WSGFsetMargin(_title_label,0);
  _title_label->setVisible(True);

#ifndef NO_WINDOW_TITLE
  _title_labels1 = new WSCvlabel(_cmd_form,"bd-ts1");
  _title_labels1->setInternalObject(True);
  _title_labels1->initialize();
  _title_labels1->setPropertyV(WSNx,     (short)35 );
  _title_labels1->setPropertyV(WSNy,     (short)5 );
  _title_labels1->setPropertyV(WSNwidth,(WSCushort)(_w - 20) );
  _title_labels1->setPropertyV(WSNheight,(WSCushort)20 );
  _title_labels1->setPropertyV(WSNforeColor,"#ffffff" );
  _title_labels1->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT );
  _title_labels1->setPropertyV(WSNlabelString,_title_string);
  _title_labels1->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _title_labels1->setVisible(True);
  WSGFsetMargin(_title_labels1,0);

  _title_labels2 = new WSCvlabel(_cmd_form,"bd-ts2");
  _title_labels2->setInternalObject(True);
  _title_labels2->initialize();
  _title_labels2->setPropertyV(WSNx,     (short)36 );
  _title_labels2->setPropertyV(WSNy,     (short)6 );
  _title_labels2->setPropertyV(WSNwidth,(WSCushort)(_w - 20) );
  _title_labels2->setPropertyV(WSNheight,(WSCushort)20 );
  _title_labels2->setPropertyV(WSNforeColor,"#000000" );
  _title_labels2->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT );
  _title_labels2->setPropertyV(WSNlabelString,_title_string);
  _title_labels2->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  _title_labels2->setVisible(True);
  WSGFsetMargin(_title_labels2,0);
#endif
  WSCstring ok_name;
  ok_name << getInstanceName() << "-ok-btn";
  WSCstring no_name;
  no_name << getInstanceName() << "-no-btn";
  WSCstring end_name;
  end_name << getInstanceName() << "-end-btn";
  _ok_btn = new WSCvbtn(_cmd_form,ok_name);
  _ok_btn->setInternalObject(True);
  _setup_btn(_ok_btn,this);
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    D_BTN_WIDTH = 60;
  }else{
    D_BTN_WIDTH = 80;
  }
  _ok_btn->setPropertyV(WSNwidth,     (WSCushort)D_BTN_WIDTH        );
//  _ok_btn->setPropertyV(WSNlabelPixmap,WS_BTN_PIX);
//  _ok_btn->setProperty(WSNusePixmap,True);
  _ok_btn->setPropertyV(WSNlabelString,_ok_str);
  _ok_btn->setProperty(WSNfont,_font);
  if (_btb_name != NULL){
    _ok_btn->setProperty(WSNbacktab,_btb_name);
  }
  if (_ok != False){
    if (_no != False){
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
        _ok_btn->setPropertyV(WSNx, (short)(_w -40 - D_BTN_WIDTH*2)  );
      }else{
        _ok_btn->setPropertyV(WSNx, (short)(_w -50 - D_BTN_WIDTH*2)  );
      }
    }else{
      _ok_btn->setPropertyV(WSNx,         (short)(_w -40 - D_BTN_WIDTH)  );
    }
    _ok_btn->setVisible(True);
  }
  WSCprocedure* op1 = new WSCprocedure("op1",WSEV_ACTIVATE);
  op1->setInternal(True);
  op1->setFunction(_ok_btn_work,"_ok_btn_work");
  _ok_btn->addProcedure(op1);
  _no_btn = new WSCvbtn(_cmd_form,no_name);
  _no_btn->setInternalObject(True);
  _setup_btn(_no_btn,this);
//  _no_btn->setPropertyV(WSNwidth,     (WSCushort)26        );
//  _no_btn->setPropertyV(WSNlabelPixmap,WS_BTN_PIX);
//  _no_btn->setProperty(WSNusePixmap,True);
  _no_btn->setPropertyV(WSNlabelString,_no_str);
  _no_btn->setPropertyV(WSNwidth,     (WSCushort)D_BTN_WIDTH        );
  _no_btn->setProperty(WSNfont,_font);

  WSCprocedure* op2 = new WSCprocedure("op1",WSEV_ACTIVATE);
  op2->setInternal(True);
  op2->setFunction(_no_btn_work,"_no_btn_work");
  _no_btn->addProcedure(op2);
  _no_btn->setProperty(WSNbacktab,ok_name);

  if (_no != False){
    _no_btn->setVisible(True);
    _no_btn->setPropertyV(WSNx,         (short)(_w -40 - D_BTN_WIDTH)  );
  }
  _end_btn = new WSCvbtn(_cmd_form,end_name);
  _end_btn->setInternalObject(True);
  _setup_btn(_end_btn,this);
  _end_btn->setPropertyV(WSNx,         (short)(_w -40)  );
  _end_btn->setPropertyV(WSNwidth,     (WSCushort)26        );
//  _end_btn->setProperty(WSNusePixmap,True);
  _end_btn->setPropertyV(WSNlabelPixmap,WS_EBTN_PIX);
  _end_btn->setProperty(WSNfont,_font);
  if (_tb_name != NULL){
    _end_btn->setProperty(WSNtab,_tb_name);
  }
  _end_btn->setProperty(WSNbacktab,no_name);
  _ok_btn->setProperty(WSNtab,no_name);
  _no_btn->setProperty(WSNtab,end_name);
  if (_cancel != False){
    _end_btn->setVisible(True);
  }

  WSCprocedure* op3 = new WSCprocedure("op1",WSEV_ACTIVATE);
  op3->setInternal(True);
  op3->setFunction(_end_btn_work,"_end_btn_work");
  _end_btn->addProcedure(op3);

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());

  return WS_NO_ERR;
}
void WSCbaseDialog::onParentVisibleChange(WSCbool fl){
  WSCwindow::onParentVisibleChange(fl);
  if (fl != False){
    onGuiPolicyChange( WSGIappDev()->getGuiPolicy());
#ifndef WS_EMBED
    if (_modal == True && getPropertyEditMode() == False){
      if (getVisible() != False){
        WSGIappDev()->setModalClient(this);
      }
    }
#else
    if (_modal == True){
      if (getVisible() != False){
        WSGIappDev()->setModalClient(this);
      }
    }
#endif
  }else{
//    if (_modal == True && getPropertyEditMode() == False &&
    if (this == WSGIappDev()->getModalClient()){
      WSGIappDev()->setModalClient(NULL);
    }
    _popuped = 0;
    if (_status == 0){
      _status = WS_DIALOG_CANCEL;
    }
  }
}
void WSCbaseDialog::onVisibleChange(WSCbool fl){
  if (fl != False){
    _status = 0;
    _status = WS_DIALOG_CANCEL;
#ifndef WS_EMBED
    if (_modal == True && getPropertyEditMode() == False){
      WSGIappDev()->setModalClient(this);
    }
#else
    if (_modal == True){
      WSGIappDev()->setModalClient(this);
    }
#endif
    if (_enable_esc != False){
      WSGIappDev()->setFocusDialog(this,True);
    }
#ifndef WS_EMBED
    if (_default_pos != False && getPropertyEditMode() == False){
#else
    if (_default_pos != False){
#endif
      WSCushort theight = 0;
      if (getowndev() != NULL){
        getowndev()->getValue(WSDEV_TITLE_HEIGHT,&theight);
      }
      short offsetx = WSGIappDev()->getXOffset();
      short offsety = WSGIappDev()->getYOffset();
      short x = (WSGIappDev()->getWidth() - _w)/2 + offsetx;
      short y = (WSGIappDev()->getHeight() - theight - _h)/2 + offsety;
      setPropertyV(WSNx,x);
      setPropertyV(WSNy,y);
    }
  }else{
//    if (_modal == True && getPropertyEditMode() == False &&
//      this == WSGIappDev()->getModalClient()){
    if (this == WSGIappDev()->getModalClient()){
      WSGIappDev()->setModalClient(NULL);
    }
    _popuped = 0;
    if (_status == 0){
      _status = WS_DIALOG_CANCEL;
    }
  }
  WSCwindow::onVisibleChange(fl);

  if (_focus_btn == WS_DIALOG_DEFAULT){
    if (_ok != False){
      _ok_btn->setFocus();
    }else
    if (_no != False){
      _no_btn->setFocus();
    }else{
      _end_btn->setFocus();
    }
  }else
  if (_focus_btn == WS_DIALOG_CANCEL){
    _end_btn->setFocus();
  }else
  if (_focus_btn == WS_DIALOG_NO){
    if (_no != False){
      _no_btn->setFocus();
    }
  }else
  if (_focus_btn == WS_DIALOG_OK){
    if (_ok != False){
      _ok_btn->setFocus();
    }
  }

}
void WSCbaseDialog::onResize(WSCrect* rect){
  if (_w != rect->width){
    if (_cmd_form != NULL){
      _cmd_form->setPropertyV(WSNwidth, (WSCushort)(rect->width -2));
//      _cmd_form->setPropertyV(WSNbackPixmap,WSGFgetBarPixmap(rect->width,WS_HORIZONTAL));
#ifndef NO_WINDOW_TITLE
      _title_labels1->clear();
      _title_labels2->clear();
      _title_labels1->setPropertyV(WSNwidth,(WSCushort)(_w - 20));
      _title_labels2->setPropertyV(WSNwidth,(WSCushort)(_w - 20));
      _title_labels1->redraw();
      _title_labels2->redraw();
#endif
      long ediff = 0;
      if (_cancel != False){
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          ediff = 0;
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          ediff = D_BTN_WIDTH -26 + 10;
        }
      }
      if (_cancel != False){
        _end_btn->clear();
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          _end_btn->setPropertyV(WSNx,(short)(rect->width -40));
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          _end_btn->setPropertyV(WSNx,(short)(rect->width - D_BTN_WIDTH -14));
        }
        _end_btn->redraw();
      }
      short pos = rect->width -40 -ediff;
      if (_no != False){
        pos -= D_BTN_WIDTH;
        _no_btn->clear();
        _no_btn->setPropertyV(WSNx,(short)(pos));
        _no_btn->setProperty(WSNwidth,D_BTN_WIDTH);
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pos -=10;
        }
        _no_btn->redraw();
      }
      if (_ok != False){
        pos -= D_BTN_WIDTH;
        _ok_btn->clear();
        _ok_btn->setPropertyV(WSNx,(short)(pos));
        _ok_btn->setProperty(WSNwidth,D_BTN_WIDTH);
        _ok_btn->redraw();
      }
      _cmd_form->update();
    }
  }

  if (_h != rect->height){
    if (_cmd_form != NULL){
      _cmd_form->setPropertyV(WSNy,(short)(rect->height - 35));
      _cmd_form->update();
    }
  }

  WSCwindow::onResize(rect);
}
WSCbase* WSCbaseDialog::getFormObject(){
  return this;
}
WSCbase* WSCbaseDialog::getCmdFormObject(){
  return _cmd_form;
}
void WSCbaseDialog::onActivate(){
  if (_rep != NULL){
     void (*hd)(WSCbase*) = (void(*)(WSCbase*))_rep;
     hd(this);
  }
  execProcedure(WSEV_ACTIVATE);
}
void WSCbaseDialog::_ok_btn_work(WSCbase* obj){
  WSCbaseDialog* dlb_base = (WSCbaseDialog*)obj->getUserData("DLG_BASE");
//  dlb_base->_popuped = 0;
#ifndef WS_EMBED
  if (dlb_base->getPropertyEditMode() == False){
#endif
    dlb_base->_status = WS_DIALOG_OK;
    dlb_base->onActivate();
    if (dlb_base->getVisible() != False){
      dlb_base->_status = WS_DIALOG_CANCEL;
    }
//    dlb_base->execEventProc(WSEV_ACTIVATE,NULL);
#ifndef WS_EMBED
  }
#endif
}
void WSCbaseDialog::_no_btn_work(WSCbase* obj){
  WSCbaseDialog* dlb_base = (WSCbaseDialog*)obj->getUserData("DLG_BASE");
//  dlb_base->_popuped = 0;
#ifndef WS_EMBED
  if (dlb_base->getPropertyEditMode() == False){
#endif
    dlb_base->_status = WS_DIALOG_NO;
    dlb_base->onActivate();
    if (dlb_base->getVisible() != False){
      dlb_base->_status = WS_DIALOG_CANCEL;
    }
//    dlb_base-> execEventProc(WSEV_ACTIVATE,NULL);
#ifndef WS_EMBED
  }
#endif
}
void WSCbaseDialog::_end_btn_work(WSCbase* obj){
  WSCbaseDialog* dlb_base = (WSCbaseDialog*)obj->getUserData("DLG_BASE");
  if (dlb_base->_enable_close_on_cancel != False){
    dlb_base->_popuped = 0;
  }
#ifndef WS_EMBED
  if (dlb_base->getPropertyEditMode() == False){
#endif
    dlb_base->_status = WS_DIALOG_CANCEL;
    dlb_base->onActivate();
//    dlb_base-> execEventProc(WSEV_ACTIVATE,NULL);
    if (dlb_base->_enable_close_on_cancel == False){
      dlb_base->_popuped = 1;
    }else{
      dlb_base->setVisible(False);
    }
#ifndef WS_EMBED
  }
#endif
}
long WSCbaseDialog::getStatus(){
  return _status;
}
long WSCbaseDialog::popup(){
  setVisible(True);
  update();
  WSGIappObjectList()->execUpdate();

  if (getVisible() == False){
    return WS_ERR;
  }
  _popuped = 1;
  if (_enable_esc != False){
    WSGIappDev()->setFocusDialog(this,True);
  }
  while(1){
    if (_popuped == 0){
      break;
    }
    if (_enable_esc != False){
      WSGIappDev()->setFocusDialog(this,True);
    }
    WSGIappDev()->dispatchEvent();
    WSGIappDevice()->clearDeleteList();
  }
  setVisible(False);
  WSGIappDev()->dispatchEvent();
  WSGIappDevice()->clearDeleteList();
  WSGIappDev()->update();
  return _status;
}

void WSCbaseDialog::onGuiPolicyChange(long policy){
  if (policy & WS_POLICY_ORIGINAL){
    D_BTN_WIDTH = 60;
    _title_label->setVisible(True);
#ifndef NO_WINDOW_TITLE
    _title_labels1->setVisible(True);
    _title_labels2->setVisible(True);
#endif
    _cmd_form->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _cmd_form->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
    if (policy & WS_POLICY_GRADATION){
      _cmd_form->setProperty(WSNgradation,WS_GR_LT_RB);
    }else{
      _cmd_form->setProperty(WSNgradation,WS_GR_NONE);
    }
//    _ok_btn->setPropertyV(WSNy,         (short)4        );
//    _ok_btn->setPropertyV(WSNheight,    (WSCushort)23   );
    _ok_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//    _no_btn->setPropertyV(WSNy,         (short)4        );
//    _no_btn->setPropertyV(WSNheight,    (WSCushort)23   );
    _no_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _end_btn->setProperty(WSNlabelString,"");
//    _end_btn->setVisible(True);
    _end_btn->setProperty(WSNx,_w - 40);
    _end_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _end_btn->setPropertyV(WSNwidth,     (WSCushort)26        );
    _end_btn->setPropertyV(WSNlabelPixmap,WS_EBTN_PIX);
  }else{
    D_BTN_WIDTH = 80;
    _title_label->setVisible(False);
#ifndef NO_WINDOW_TITLE
    _title_labels1->setVisible(False);
    _title_labels2->setVisible(False);
#endif
    _cmd_form->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    _cmd_form->setProperty(WSNbackColor,WS_DF_BACKCOLOR);
    _cmd_form->setProperty(WSNgradation,WS_GR_NONE);
//    _ok_btn->setPropertyV(WSNy,         (short)0        );
//    _ok_btn->setPropertyV(WSNheight,    (WSCushort)30   );
    _ok_btn->setPropertyV(WSNshadowThickness,(WSCuchar)2);
//    _no_btn->setPropertyV(WSNy,         (short)0        );
//    _no_btn->setPropertyV(WSNheight,    (WSCushort)30   );
    _no_btn->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    _end_btn->setProperty(WSNlabelString,_cancel_str);
//    _end_btn->setVisible(False);
    _end_btn->setProperty(WSNx,_w - D_BTN_WIDTH -14);
    _end_btn->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    _end_btn->setProperty(WSNwidth,D_BTN_WIDTH);
    _end_btn->setProperty(WSNlabelPixmap,"");
  }
  if (policy & WS_POLICY_GRADATION){
    _ok_btn->setProperty(WSNgradation,WS_GR_T_B);
    _no_btn->setProperty(WSNgradation,WS_GR_T_B);
    _end_btn->setProperty(WSNgradation,WS_GR_T_B);
  }else{
    _ok_btn->setProperty(WSNgradation,WS_GR_NONE);
    _no_btn->setProperty(WSNgradation,WS_GR_NONE);
    _end_btn->setProperty(WSNgradation,WS_GR_NONE);
  }

  _ok_btn->setProperty(WSNwidth,D_BTN_WIDTH);
  _no_btn->setProperty(WSNwidth,D_BTN_WIDTH);
  long ediff = 0;
  if (_cancel != False){
    if (policy & WS_POLICY_ORIGINAL){
      ediff = 0;
    }else
    if (policy & WS_POLICY_WINDOWS){
      ediff = D_BTN_WIDTH -26 + 10;
    }
  }
  if (_no == False){
    if (_no_btn != NULL){
      _no_btn->setProperty(WSNvis,(WSCbool)False);
      _ok_btn->setProperty(WSNx,  (short)(_w -40 - D_BTN_WIDTH -ediff));
    }
  }else{
    if (_no_btn != NULL){
      _no_btn->setProperty(WSNx,(short)(_w -40 - D_BTN_WIDTH -ediff) );
      _no_btn->setProperty(WSNvis,(WSCbool)True);

      _ok_btn->clear();
      if (policy & WS_POLICY_ORIGINAL){
        _ok_btn->setProperty(WSNx,(short)(_w -40 - D_BTN_WIDTH*2 )  );
      }else{
        _ok_btn->setProperty(WSNx,(short)0);
        _ok_btn->setProperty(WSNx,(short)(_w -50 - D_BTN_WIDTH*2 -ediff)  );
      }
      _ok_btn->redraw();
    }
  }
  //to destroy internal pixmap..
  _cmd_form->internalUpdate();
  WSCbase::onGuiPolicyChange(policy);
}
void WSCbaseDialog::onSpecialFocusChange(WSCbool fl){
  if (fl != False){
    if (_ok_btn != NULL){
      WSCbool fl = _ok_btn->getProperty(WSNvis);
      if (fl != False){
        _ok_btn->setSpecialFocus();
        WSCwindow::onSpecialFocusChange(fl);
        return;
      }
    }
    if (_no_btn != NULL){
      WSCbool fl = _no_btn->getProperty(WSNvis);
      if (fl != False){
        _no_btn->setSpecialFocus();
        WSCwindow::onSpecialFocusChange(fl);
        return;
      }
    }
    if (_end_btn != NULL){
      WSCbool fl = _end_btn->getProperty(WSNvis);
      if (fl != False){
        _end_btn->setSpecialFocus();
        WSCwindow::onSpecialFocusChange(fl);
        return;
      }
    }
  }
  WSCwindow::onSpecialFocusChange(fl);
}
void WSCbaseDialog::onFocusChange(WSCbool fl){
  if (fl != False){
    if (_enable_esc != False){
      WSGIappDev()->setFocusDialog(this,True);
    }
  }else{
    WSGIappDev()->setFocusDialog(this,False);
  }
}
void WSCbaseDialog::setFocusBtn(long fcmd){
  switch(fcmd){
    case WS_DIALOG_NONE:{
      _focus_btn = fcmd;
      break;
    }
    case WS_DIALOG_DEFAULT:{
      _focus_btn = fcmd;
      if (getVisible() != False){
        if (_ok != False){
          _ok_btn->setFocus();
        }else
        if (_no != False){
          _no_btn->setFocus();
        }else{
          _end_btn->setFocus();
        }
      }
      break;
    }
    case WS_DIALOG_CANCEL:{
      _focus_btn = fcmd;
      if (getVisible() != False){
        _end_btn->setFocus();
      }
      break;
    }
    case WS_DIALOG_NO:{
      _focus_btn = fcmd;
      if (getVisible() != False){
        if (_no != False){
          _no_btn->setFocus();
        }
      }
      break;
    }
    case WS_DIALOG_OK:{
      _focus_btn = fcmd;
      if (getVisible() != False){
        if (_ok != False){
          _ok_btn->setFocus();
        }
      }
      break;
    }
  }
}
void WSCbaseDialog::setEnableEscapeKey(WSCbool fl){
  _enable_esc = fl;
  if (_enable_esc == False){
    WSCbase* target = WSGIappDev()->getFocusDialog();
    if (target == this){
      WSGIappDev()->setFocusDialog(this,False);
    }
  }
}
WSCbool WSCbaseDialog::getEnableEscapeKey(){
  return _enable_esc;
}
void WSCbaseDialog::setEnableCloseOnCancel(WSCbool fl){
  _enable_close_on_cancel = fl;
}
WSCbool WSCbaseDialog::getEnableCloseOnCancel(){
  return _enable_close_on_cancel;
}
WSCbase* WSCbaseDialog::getFocusMoveInternalInstance(long direction){
  if (direction == WS_TAB){
    WSCbool fl = _ok_btn->getProperty(WSNvis);
    if (fl != False){
      return _ok_btn;
    }
    fl = _no_btn->getProperty(WSNvis);
    if (fl != False){
      return _no_btn;
    }
    fl = _end_btn->getProperty(WSNvis);
    if (fl != False){
      return _end_btn;
    }
  }else
  if (direction == WS_STAB){
    WSCbool fl = _end_btn->getProperty(WSNvis);
    if (fl != False){
      return _end_btn;
    }
    fl = _no_btn->getProperty(WSNvis);
    if (fl != False){
      return _no_btn;
    }
    fl = _ok_btn->getProperty(WSNvis);
    if (fl != False){
      return _ok_btn;
    }
  }
  return NULL;
}
