//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSClocaleSet.h>
#include <WSDenv.h>

long _wsgv_default_encoding = WS_EN_LOCALE;
long _wsgv_system_default_encoding = WS_EN_NONE;

static WSDcodeConvert* _the_app_code_convert = NULL;
static WSDcodeConvert* (*_c_handler)() = NULL;
WSDcodeConvert* WSGIappCodeConvert(){
  if ( _the_app_code_convert == NULL){
    if ( _c_handler == NULL){
      printf("ERROR: WSDcodeConvert create global instance..\n");
#ifdef DEBUG_TRAP
assert(0);
#endif
    }
    _the_app_code_convert = _c_handler();
  }
  return _the_app_code_convert;
}
void WSDcodeConvert::_set_code_convert_handler(WSDcodeConvert*(*hd)()){
  _c_handler = hd;
}
static WSClocaleSet* _the_app_locale_list = NULL;
WSClocaleSet* WSGIappLocaleSet(){
  if (_the_app_locale_list == NULL){
    _the_app_locale_list = new WSClocaleSet();
  }
  return _the_app_locale_list;
}

WSClocaleSet::WSClocaleSet(){
  _default_locale = NULL;
  _init = False;
  _encoding = WS_EN_LOCALE;
//  _executed = False;
}
#if 0
void WSClocaleSet::addInitializeProc(void(*hd)()){
  if (_executed == False){
    _init_procs.add((void*)hd);
  }else{
    hd();
  }
}
void WSClocaleSet::execInitializeProcs(){
  long num = _init_procs.getNum();
  long i;
  for(i=0; i<num; i++){
    void(*hd)() = (void(*)())_init_procs[i];
    hd();
  }
  _executed = False;
}
#endif
WSClocaleSet::~WSClocaleSet(){
  long num = _locale_list._num;
  long i;
  WSClocale** locales = (WSClocale**)_locale_list._data;
  for(i=0; i<num; i++){
    WSClocale* locale = locales[i];
    if (locale != NULL){
      delete locale;
    }
  }
}

void WSClocaleSet::initialize(){
  if (_init != False){
    return;
  }

  _init = True;
//  long locale_value = WSGIappCodeConvert()->getSystemLocale();
//  if (locale_value == WS_EN_NONE){
//fprintf(stderr,"ERROR: LANG not supported... using locale=C.\n");
//    locale_value = WS_EN_ISO8859_1;
//  }
//printf("WSClocaleSet::initialize systemlocale=%s\n",WSGFgetLocaleName(locale_value));
  long i;
  long num = _locale_list._num;
  WSClocale** locales = (WSClocale**)_locale_list._data;
  for(i=0; i<num; i++){
    WSClocale* locale = locales[i];
    if (locale != NULL && !strcmp(locale->_name,WSGIappCodeConvert()->getSystemLocaleName())){
      _default_locale = locale;
      break;
    }
  }
  if (_default_locale == NULL){
    _default_locale = new WSClocale();
    _default_locale->setLocaleName(WSGIappCodeConvert()->getSystemLocaleName());
    _locale_list.add((void*)_default_locale);
  }
}
char* WSClocaleSet::getDefaultLocaleName(){
  if (_init == False){
    initialize();
  }
  if (_default_locale == NULL){
    return WSN_EN_ISO8859_1;
  }

//printf("WSClocaleSet::getDefaultLocaleName() 0x%x\n",_default_locale);
//printf("WSClocaleSet::getDefaultLocaleName() 0x%x\n",_default_locale->getLocaleName());
//printf("WSClocaleSet::getDefaultLocaleName() #%s#\n",_default_locale->getLocaleName());
  return _default_locale->_name;
}

WSClocale* WSClocaleSet::getDefaultLocale(){
  if (_init == False){
    initialize();
  }
  return _default_locale;
}
long WSClocaleSet::setDefaultLocale(char* locale_str){
  long num = _locale_list._num;
  long i;
  WSClocale** locales = (WSClocale**)_locale_list._data;
  for(i=0; i<num; i++){
    WSClocale* locale = locales[i];
    if (locale != NULL && !strcmp(locale->_name,locale_str)){
      _default_locale = locale;
      return WS_NO_ERR;
    }
  }
  _default_locale = new WSClocale();
  _default_locale->setLocaleName(locale_str);
  _locale_list.add((void*)_default_locale);
  return WS_NO_ERR;
}
WSClocale* WSClocaleSet::getLocale(char* locale_str){
  long num = _locale_list._num;
  long i;
  WSClocale** locales = (WSClocale**)_locale_list._data;
  for(i=0; i<num; i++){
    WSClocale* locale = locales[i];
    if (locale != NULL && !strcmp(locale->_name,locale_str)){
      return locale;
    }
  }
  return NULL;
}

void WSClocaleSet::setLocaleString(char* locale_str,char* index,char* str){
  WSClocale* locale = getLocale(locale_str);
//printf("WSClocaleSet::setLocaleString locale=0x%x\n",locale);
  if (locale == NULL){
    locale = new WSClocale();
    locale->setLocaleName(locale_str);
    _locale_list.add((void*)locale);
  }
//printf("WSClocaleSet::setLocaleString loc=%s index=%s\n",locale_str,index);
  locale->setString(index,str);
}
char* WSClocaleSet::getLocaleString(char* locale_str,char* index,long encode){
  WSClocale* locale = getLocale(locale_str);
  if (locale == NULL){
    return locale_str;
  }
  return locale->getString(index,encode);
}
WSClocale::WSClocale(){
//printf("this=0x%x\n",this);
  _name = NULL;
  _locale = WS_EN_NONE;
  long i;
  for(i=0; i<WS_MAX_HASH_VALUE; i++){
    _hash[i] = NULL;
    _hash_string[i] = NULL;
  }
}
WSClocale::~WSClocale(){
  long i;
  for(i=0; i<WS_MAX_HASH_VALUE; i++){
    if (_hash[i] != NULL){
      WSCindexData* list = (WSCindexData*)_hash[i];
      long num = list->getNum();
#if 0
      long j;
      for(j=0; j<num; j++){
        WSCstring* item = (WSCstring*)list->getData(j);
        delete item;
      }
#endif
      delete list;
    }
    if (_hash_string[i] != NULL){
      WSCindexData* list = (WSCindexData*)_hash_string[i];
      long num = list->getNum();
      long j;
      for(j=0; j<num; j++){
        WSCstring* item = (WSCstring*)list->getData(j);
        delete item;
      }
      delete list;
    }
  }
  if (_name != NULL){
    delete _name;
    _name = NULL;
  }
}
void WSClocale::setLocaleName(char* lname){
//printf("this=0x%x\n",this);
  _locale = WSGFgetEncoding(lname);
//printf("WSClocale::setLocaleName #%s# %d\n",lname,_locale);
  if (_locale == WS_EN_NONE){
//printf("WSClocale::setString Error encoding=%s not found.\n",index);
    _locale = WS_EN_ISO8859_1; 
  }
//printf("_locale=%d name=%s\n",_locale,WSGFgetLocaleName(_locale));
//  _name.setString(lname);
  if (_name != NULL){
    delete _name;
    _name = NULL;
  }
  _name = WSGFstrdup(lname);
}

char* WSClocale::getLocaleName(){
  return _name;
}
void WSClocale::setString(char* index,char* str){
//printf("this=0x%x\n",this);
  long val = WSGFgetHashValue(index);
  WSCindexData* list = _hash[val];
  if (list == NULL){
    list = new WSCindexData();
    list->setNoAllocIndex(True);
    _hash[val] = list;
  }
#if 0
  WSCstring* str2 = new WSCstring;
//printf("setstring _locale=%d name=%s\n",_locale,WSGFgetLocaleName(_locale));
  str2->setString(str,_locale);
  list->setData(index,str2);
//printf("this=0x%x index=%s str=%s list=0x%x hash=%d\n",this,index,str,list,val);
#endif
  list->setData(index,str);
}
char* WSClocale::getString(char* index,long encode){
  long val = WSGFgetHashValue(index);

  WSCindexData* list = _hash[val];
  char* ret = NULL;
  if (list == NULL || (ret = (char*)list->getData(index)) == NULL ){
    WSCstring tmp;
    tmp.setStaticString(index);
    if (tmp.isExist(":WSSTR") <0){
    }else{
      WSClocale* locale = WSGIappLocaleSet()->getLocale("en_US");
      if (locale != NULL && this != locale){
        return locale->getString(index,encode);
      }
fprintf(stderr,"WSClocale::getString locale=%s index=%s not found.\n",getLocaleName(),index);
    }
    return index;
  }
  if (encode == WS_EN_DEFAULT){
    encode = _wsgv_default_encoding;
  } 
  if (encode == WS_EN_LOCALE){
    encode = _wsgv_system_default_encoding;
  } 
  if (encode == WS_EN_NONE){
    return ret;
  }

  if (_locale == encode){
    return ret;
  }

  WSCindexData* list2 = _hash_string[val];
  if (list2 == NULL){
    list2 = new WSCindexData();
    list2->setNoAllocIndex(True);
    _hash_string[val] = list2;
  }
  WSCstring* str2 = (WSCstring*)list2->getData(index);
  if (str2 == NULL){
    str2 = new WSCstring;
    str2->setString(ret,_locale);
    list2->setData(index,str2);
  }
  return str2->getString(encode);
}
char* WSGFgettext(char* index){
//printf("WSGFgettext index=%s\n",index);
  WSClocale* locale = WSGIappLocaleSet()->getDefaultLocale();
  if (locale == NULL){
fprintf(stderr,"ERROR. WSGFgettext default locale does not found. use locale=C\n");
    locale = WSGIappLocaleSet()->getLocale(WSN_EN_ISO8859_1);
    if (locale == NULL){
fprintf(stderr,"ERROR. WSGFgettext locale C does not found.\n");
      return index;
    }
  }
//  return locale->getString(index,WSGIappLocaleSet()->getSystemLocaleEncoding());
//printf("WSGFgettext %d index=%s %s\n",WSGIappLocaleSet()->getDefaultEncoding(),index,locale->getString(index,WSGIappLocaleSet()->getDefaultEncoding()));
//  return locale->getString(index,WSGIappLocaleSet()->getDefaultEncoding());
  return locale->getString(index,_wsgv_default_encoding);
}
long WSClocaleSet::getSystemLocaleEncoding(){
  return WSGIappCodeConvert()->getSystemEncoding();
}
char* WSClocaleSet::getSystemLocaleName(){
  return WSGIappCodeConvert()->getSystemLocaleName();
}
long WSClocaleSet::getDefaultEncoding(){
  if (_encoding == WS_EN_LOCALE){
    return WSGIappCodeConvert()->getSystemEncoding();
  }
  return _encoding;
}
void WSClocaleSet::setDefaultEncoding(long encoding){
  _encoding = encoding;
  if (WSGIappLocaleSet() == this){
    _wsgv_default_encoding = encoding;
  }
}
void WSGFsetDefaultEncoding(long en){
  _wsgv_default_encoding = en;
  WSGIappLocaleSet()->setDefaultEncoding(en);
}
long WSGFgetDefaultEncoding(){
  return _wsgv_default_encoding;
}
void WSGFsetSystemDefaultEncoding(long en){
  _wsgv_system_default_encoding = en;
}
long WSGFgetSystemDefaultEncoding(){
  return _wsgv_system_default_encoding;
}



WSDcodeConvert::WSDcodeConvert(){
  strcpy(_locale_name,"en_US");
}
WSDcodeConvert::~WSDcodeConvert(){
}

void WSDcodeConvert::setSystemLocaleName(char* val,long encoding){
  char buf[32];
  memset(buf,0,sizeof(buf));
  strcpy(buf,val);
  int i;
  for(i=0; i<32; i++){
    if (buf[i] == '.'){
      buf[i] = 0;
      break;
    }
  }
  char* suffix = "";
  if (encoding == WS_EN_UTF8){
    suffix = ".utf8";
  }
  if (encoding == WS_EN_EUCJP){
    strcpy(_locale_name,"ja_JP.eucjp");
    return;
  }
  if (encoding == WS_EN_SJIS){
    strcpy(_locale_name,"ja_JP.sjis");
    return;
  }
  if (encoding == WS_EN_EUCKR){
    strcpy(_locale_name,"ko_KR.euckr");
    return;
  }
  if (encoding == WS_EN_EUCCN){
    strcpy(_locale_name,"zh_CN");
    return;
  }
  if (!strcmp(buf,"ja") && encoding == WS_EN_UTF8){
    strcpy(_locale_name,"ja_JP.utf8");
  }

  if (!strcmp(buf,"") || !strcmp(buf,"C")){
    strcpy(_locale_name,"en_US");
  }else{
    strcpy(_locale_name,buf);
  }

  if (!strcmp(buf,"es")){
    strcpy(buf,"es_ES");
  }
  if (!strcmp(buf,"cs")){
    strcpy(buf,"cs_CZ");
  }
  if (!strcmp(buf,"he")){
    strcpy(buf,"he_IL");
  }
  if (!strcmp(buf,"hr")){
    strcpy(buf,"hr_HR");
  }
  if (!strcmp(buf,"hu")){
    strcpy(buf,"hu_HU");
  }
  if (!strcmp(buf,"pl")){
    strcpy(buf,"pl_PL");
  }
  if (!strcmp(buf,"ro")){
    strcpy(buf,"ro_RO");
  }
  if (!strcmp(buf,"ru")){
    strcpy(buf,"ru_RU");
  }
  if (!strcmp(buf,"zh")){
    strcpy(buf,"zh_CN");
  }
  if (!strcmp(buf,"af")){
    strcpy(buf,"af_ZA");
  }
  if (!strcmp(buf,"be")){
    strcpy(buf,"be_BY");
  }
  if (!strcmp(buf,"bg")){
    strcpy(buf,"bg_BG");
  }
  if (!strcmp(buf,"br")){
    strcpy(buf,"br_FR");
  }
  if (!strcmp(buf,"bs")){
    strcpy(buf,"bs_BA");
  }
  if (!strcmp(buf,"ca")){
    strcpy(buf,"ca_ES");
  }
  if (!strcmp(buf,"cy")){
    strcpy(buf,"cy_GB");
  }
  if (!strcmp(buf,"da")){
    strcpy(buf,"da_DK");
  }
  if (!strcmp(buf,"de")){
    strcpy(buf,"de_DE");
  }
  if (!strcmp(buf,"el")){
    strcpy(buf,"el_GR");
  }
  if (!strcmp(buf,"et")){
    strcpy(buf,"et_EE");
  }
  if (!strcmp(buf,"eu")){
    strcpy(buf,"eu_ES");
  }
  if (!strcmp(buf,"fa")){
    strcpy(buf,"fa_IR");
  }
  if (!strcmp(buf,"fi")){
    strcpy(buf,"fi_FI");
  }
  if (!strcmp(buf,"fo")){
    strcpy(buf,"fo_FO");
  }
  if (!strcmp(buf,"fr")){
    strcpy(buf,"fr_FR");
  }
  if (!strcmp(buf,"ga")){
    strcpy(buf,"ga_IE");
  }
  if (!strcmp(buf,"gl")){
    strcpy(buf,"gl_ES");
  }
  if (!strcmp(buf,"gv")){
    strcpy(buf,"gv_GB");
  }
  if (!strcmp(buf,"hi")){
    strcpy(buf,"hi_IN");
  }
  if (!strcmp(buf,"id")){
    strcpy(buf,"id_ID");
  }
  if (!strcmp(buf,"is")){
    strcpy(buf,"is_IS");
  }
  if (!strcmp(buf,"it")){
    strcpy(buf,"it_IT");
  }
  if (!strcmp(buf,"iw")){
    strcpy(buf,"iw_IL");
  }
  if (!strcmp(buf,"ka")){
    strcpy(buf,"ka_GE");
  }
  if (!strcmp(buf,"kl")){
    strcpy(buf,"kl_GL");
  }
  if (!strcmp(buf,"kw")){
    strcpy(buf,"kw_GB");
  }
  if (!strcmp(buf,"lt")){
    strcpy(buf,"lt_LT");
  }
  if (!strcmp(buf,"mi")){
    strcpy(buf,"mi_NZ");
  }
  if (!strcmp(buf,"mk")){
    strcpy(buf,"mk_MK");
  }
  if (!strcmp(buf,"mr")){
    strcpy(buf,"mr_IN");
  }
  if (!strcmp(buf,"ms")){
    strcpy(buf,"ms_MY");
  }
  if (!strcmp(buf,"mt")){
    strcpy(buf,"mt_MT");
  }
  if (!strcmp(buf,"nl")){
    strcpy(buf,"nl_NL");
  }
  if (!strcmp(buf,"nn")){
    strcpy(buf,"nn_NO");
  }
  if (!strcmp(buf,"no")){
    strcpy(buf,"no_NO");
  }
  if (!strcmp(buf,"oc")){
    strcpy(buf,"oc_FR");
  }
  if (!strcmp(buf,"pt")){
    strcpy(buf,"pt_PT");
  }
  if (!strcmp(buf,"se")){
    strcpy(buf,"se_NO");
  }
  if (!strcmp(buf,"sk")){
    strcpy(buf,"sk_SK");
  }
  if (!strcmp(buf,"sl")){
    strcpy(buf,"sl_SI");
  }
  if (!strcmp(buf,"sq")){
    strcpy(buf,"sq_AL");
  }
  if (!strcmp(buf,"sr")){
    strcpy(buf,"sr_YU");
  }
  if (!strcmp(buf,"ta")){
    strcpy(buf,"ta_IN");
  }
  if (!strcmp(buf,"tg")){
    strcpy(buf,"tg_IN");
  }
  if (!strcmp(buf,"th")){
    strcpy(buf,"th_TH");
  }
  if (!strcmp(buf,"tl")){
    strcpy(buf,"tl_PH");
  }
  if (!strcmp(buf,"tr")){
    strcpy(buf,"tr_TR");
  }
  if (!strcmp(buf,"uk")){
    strcpy(buf,"uk_UA");
  }
  if (!strcmp(buf,"ur")){
    strcpy(buf,"ur_PK");
  }
  if (!strcmp(buf,"uz")){
    strcpy(buf,"uz_UZ");
  }
  if (!strcmp(buf,"vi")){
    strcpy(buf,"vi_VN");
  }
  if (!strcmp(buf,"wa")){
    strcpy(buf,"wa_BE");
  }
  if (!strcmp(buf,"yi")){
    strcpy(buf,"yi_US");
  }
  strcpy(_locale_name,buf);
  if (strcmp(suffix,"")){
    long len = strlen(_locale_name);
    strcpy(&_locale_name[len],suffix);
  }
}

char* WSDcodeConvert::getSystemLocaleName(){
  return _locale_name;
}

