//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCnwbase.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCcolorSet.h>
#include <WSCblink.h>
#include <WSDtimer.h>
#include <WSDmouse.h>

WSMFguiClassInitialize(WSCnwbase, WSCbase);
WSMFversion(WSCnwbase, WSCbase);
WSMFdefineUseDevice(WSCnwbase,nwDev);

WSCnwbase::WSCnwbase(WSCbase* base, char* objname): WSCbase(base, objname){
  _mouse_enter = False;
  _out_side_mouse_press = False; 
  _out_side_mouse_move = False; 
  _out_side_mouse_release = False; 
  _user_value = 0;
  _user_string = NULL;
  _x = 0;
  _y = 0;
  _w = 100;
  _h = 30;
  _bl_fl = False;
  _tw_fl = False;
#ifndef NO_NWBASE_MOUSE_PROPERTY
  _mouse_no = 0;
#endif
//  _fore_color = WSGFcolor("black");
//  _blink_color = WSGFcolor("gray85");
  _fore_color = WS_DF_NWFORECOLOR;
  _blink_color = WS_DF_NWBACKCOLOR;
  _blink_rate = WS250MS;
  _bl_refreshing = False;
  _vis = False;
  _sensitive = True;
  _sensitive_work = True;
  _event_mask |= WSEV_EXPOSE;
  _mouse_grabed = 0;
  _anchor_top = 0;
  _anchor_bottom= 0;
  _anchor_left = 0;
  _anchor_right = 0;
  _anchor_top_use = False;
  _anchor_bottom_use = False;
  _anchor_left_use = False;
  _anchor_right_use = False;
  _anchor_under_refreshing = False;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCnwbase);

    WSMFpropertyCreate(WSNname,      char*,   _instance_name,WSSname);
    WSMFpropertyCreate(WSNuserString,      char*,   _user_string,WSSuserString);
    WSMFpropertyCreate(WSNuserValue,       long,    _user_value, WSSuserValue);
    WSMFpropertyCreate(WSNblinkRefreshing, WSCbool, _bl_refreshing, WSSblinkRefreshing);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    WSMFpropertyCreate(WSNvis,             WSCbool, _vis,WSSvis );
    WSMFpropertySetSelection(WSRbool2, WSRbool2D);

    WSMFpropertyCreate(WSNdet,             WSCbool, _sensitive_work,WSSdet);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
    WSMFpropertyCreate(WSNx,             short,  _x,WSSx  );
    WSMFpropertyCreate(WSNy,             short,  _y,WSSy  );
    WSMFpropertyCreate(WSNwidth,         WSCushort,_w,WSSwidth   );
    WSMFpropertyCreate(WSNheight,        WSCushort,_h,WSSheight  );
    WSMFpropertyCreate(WSNforeColor,     short,  _fore_color,WSSforeColor );
    WSMFpropertyCreate(WSNtwinBlink,     WSCbool, _tw_fl,WSStwinBlink);
    WSMFpropertySetSelection( WSRbool4, WSRbool4D);
    WSMFpropertyCreate(WSNblinkColor,    short,     _blink_color,WSSblinkColor );
    WSMFpropertyCreate(WSNblinkRate,     WSCuchar,  _blink_rate,WSSblinkRate);
    WSMFpropertySetSelection(WSRrateType, WSRrateTypeD);
    WSMFpropertyCreate(WSNblinkFlag,     WSCbool,       _bl_fl,WSSblinkFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);

    WSMFpropertyCreate(WSNanchorTop, WSCushort, _anchor_top,WSSanchorTop);
    WSMFpropertyCreate(WSNanchorBottom,WSCushort,_anchor_bottom,WSSanchorBottom);
    WSMFpropertyCreate(WSNanchorLeft,WSCushort,_anchor_left,WSSanchorLeft);
    WSMFpropertyCreate(WSNanchorRight,WSCushort,_anchor_right,WSSanchorRight);

    WSMFpropertyCreate(WSNanchorTopFlag, WSCbool, _anchor_top_use,WSSanchorTopFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    WSMFpropertyCreate(WSNanchorBottomFlag,WSCbool,_anchor_bottom_use,WSSanchorBottomFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    WSMFpropertyCreate(WSNanchorLeftFlag,WSCbool,_anchor_left_use,WSSanchorLeftFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
    WSMFpropertyCreate(WSNanchorRightFlag,WSCbool,_anchor_right_use,WSSanchorRightFlag);
    WSMFpropertySetSelection(WSRbool3, WSRbool3D);
#ifndef NO_REMOTE_INSTANCE
    WSMFpropertyCreate(WSNexport,WSCbool,_export_,WSSexport);
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
#endif
#ifndef NO_NWBASE_MOUSE_PROPERTY
    WSMFpropertyCreate(WSNmouse,   WSCushort,  _mouse_no,WSSmouse );
#endif
    WSMFaddTrigger(WSEV_INITIALIZE  );
    WSMFaddTrigger(WSEV_EXPOSE      );
    WSMFaddTrigger(WSEV_VISIBLE_CH  );
    WSMFaddTrigger(WSEV_MOUSE_MOVE  );
    WSMFaddTrigger(WSEV_MOUSE_IN    );
    WSMFaddTrigger(WSEV_MOUSE_OUT   );
    WSMFaddTrigger(WSEV_MOUSE_PRESS   );
    WSMFaddTrigger(WSEV_MOUSE_RELEASE );
    WSMFaddTrigger(WSEV_VISIBLE_CH  );
    WSMFaddTrigger(WSEV_PARENT_VISIBLE_CH  );

  WSMFpropertyCreateEnd
}

WSMFproperty( WSCnwbase, WSNname, char*, _instance_name ,NULL);
WSMFproperty( WSCnwbase, WSNuserString, char*, _user_string ,NULL);
WSMFproperty( WSCnwbase, WSNuserValue,  long,  _user_value  ,0);
WSMFproperty( WSCnwbase, WSNblinkRefreshing, WSCbool, _bl_refreshing ,False    );
WSMFproperty( WSCnwbase, WSNvis,   WSCbool,  _vis ,False   );
WSMFproperty( WSCnwbase, WSNdet,   WSCbool,  _sensitive_work  ,True   );
WSMFproperty( WSCnwbase, WSNx,           short,          _x           ,0     );
WSMFproperty( WSCnwbase, WSNy,           short,          _y           ,0     );
WSMFproperty( WSCnwbase, WSNwidth,       WSCushort, _w           ,100   );
WSMFproperty( WSCnwbase, WSNheight,      WSCushort, _h           ,30    );
//WSMFproperty( WSCnwbase, WSNforeColor,   short,        _fore_color  ,WSGFcolor("black")     );
WSMFproperty( WSCnwbase, WSNforeColor,   short,          _fore_color  ,WS_DF_NWFORECOLOR);
WSMFproperty( WSCnwbase, WSNblinkFlag,   WSCbool,        _bl_fl       ,False );
WSMFproperty( WSCnwbase, WSNtwinBlink,   WSCbool,        _tw_fl       ,False );
//WSMFproperty( WSCnwbase, WSNblinkColor,  short,        _blink_color   ,WSGFcolor("gray85") );
WSMFproperty( WSCnwbase, WSNblinkColor,  short,          _blink_color       ,WS_DF_NWBACKCOLOR);
WSMFproperty( WSCnwbase, WSNblinkRate,   WSCuchar,    _blink_rate     ,WS250MS );
#ifndef NO_NWBASE_MOUSE_PROPERTY
WSMFproperty( WSCnwbase, WSNmouse,    WSCushort,          _mouse_no   ,0     );
#endif
WSMFproperty( WSCnwbase, WSNanchorTop,WSCushort,_anchor_top,0 );
WSMFproperty( WSCnwbase, WSNanchorBottom,WSCushort,_anchor_bottom,0 );
WSMFproperty( WSCnwbase, WSNanchorLeft,WSCushort,_anchor_left,0 );
WSMFproperty( WSCnwbase, WSNanchorRight,WSCushort,_anchor_right,0 );
WSMFproperty( WSCnwbase, WSNanchorTopFlag,WSCbool,_anchor_top_use,False );
WSMFproperty( WSCnwbase, WSNanchorBottomFlag,WSCbool,_anchor_bottom_use,False );
WSMFproperty( WSCnwbase, WSNanchorLeftFlag,WSCbool,_anchor_left_use,False );
WSMFproperty( WSCnwbase, WSNanchorRightFlag,WSCbool,_anchor_right_use,False );
#ifndef NO_REMOTE_INSTANCE
WSMFproperty( WSCnwbase, WSNexport,WSCbool,_export_,False );
#endif
void WSCnwbase::setWorkWSNname(char*){}
void WSCnwbase::getWorkWSNname(char**){}
void WSCnwbase::setWorkWSNuserString(char*){}
void WSCnwbase::getWorkWSNuserString(char**){}
void WSCnwbase::setWorkWSNuserValue(long){}
void WSCnwbase::getWorkWSNuserValue(long*){}

void WSCnwbase::setWorkWSNblinkRefreshing(WSCbool){
  if (_bl_fl != False) {
    WSGIappBlink()->delBlinkInstance(this);
    WSGIappBlink()->addBlinkInstance(this,_blink_rate,_bl_refreshing);
  }
}

void WSCnwbase::getWorkWSNblinkRefreshing(WSCbool*){}
void WSCnwbase::setWorkWSNvis(WSCbool data){
  setVisible(data);
}

void WSCnwbase::getWorkWSNvis(WSCbool*){} 
void WSCnwbase::setWorkWSNdet(WSCbool data){
#ifndef WS_EMBED
  if (getPropertyEditMode() == False){
#endif
    setSensitive(data);
#ifndef WS_EMBED
//  }else{
//    long val =(long)data;
//    setUserData(WS_DET,(void*)val);
  }
#endif
}

void WSCnwbase::getWorkWSNdet(WSCbool* data){
#ifndef WS_EMBED
//  if (getPropertyEditMode() != False){
//    long tmp = (long)getUserData(WS_DET);
//    WSCbool fl = (WSCbool)tmp;
//    *data = fl;
//  }
#endif
}

void WSCnwbase::setWorkWSNx(short){
  if (_anchor_left_use != False){
    WSCbase* parent = getParent();
    if (parent != NULL && parent->adjustAnchor() != False){
        _x = _anchor_left;
    }
  }else if (_anchor_right_use != False){
    WSCbase* parent = getParent();
    if (parent != NULL && parent->adjustAnchor() != False){
      parent->setGeometryChanged(True);
      parent->needUpdate();
    }
  }
  _geometry_changed = True;
}

void WSCnwbase::getWorkWSNx(short*){}
void WSCnwbase::setWorkWSNy(short){
  if (_anchor_top_use != False){
    WSCbase* parent = getParent();
    if (parent != NULL && parent->adjustAnchor() != False){
      _y = _anchor_top;
    }
  }else if (_anchor_bottom_use != False){
    WSCbase* parent = getParent();
    if (parent != NULL && parent->adjustAnchor() != False){
      parent->setGeometryChanged(True);
      parent->needUpdate();
      return; 
    }
  }
  _geometry_changed = True;
}

void WSCnwbase::getWorkWSNy(short*){}
void WSCnwbase::setWorkWSNwidth(WSCushort){
  if (_anchor_left_use != False && _anchor_right_use != False){
    WSCbase* parent = getParent();
    if (parent != NULL && parent->adjustAnchor() != False){
      parent->setGeometryChanged(True);
      parent->needUpdate();
    }
  }
  _geometry_changed = True;
}

void WSCnwbase::getWorkWSNwidth(WSCushort*){}
void WSCnwbase::setWorkWSNheight(WSCushort){
  if (_anchor_top_use != False && _anchor_bottom_use != False){
    WSCbase* parent = getParent();
    if (parent != NULL && parent->adjustAnchor() != False){
      parent->setGeometryChanged(True);
      parent->needUpdate();
    }
  }
  _geometry_changed = True;
}

void WSCnwbase::getWorkWSNheight(WSCushort*){}
#ifndef NO_NWBASE_MOUSE_PROPERTY
void WSCnwbase::setWorkWSNmouse(WSCushort){
}
void WSCnwbase::getWorkWSNmouse(WSCushort*){
}
#endif
void WSCnwbase::setWorkWSNforeColor(short){}
void WSCnwbase::getWorkWSNforeColor(short*){}

void WSCnwbase::setWorkWSNblinkColor(short no){
  if (_bl_fl != False) {
    WSGIappBlink()->delBlinkInstance(this);
  }
}

void WSCnwbase::getWorkWSNblinkColor(short*){}

void WSCnwbase::setWorkWSNblinkFlag(WSCbool fl){
  if (fl != False) {
    WSGIappBlink()->addBlinkInstance(this,_blink_rate,_bl_refreshing);
  }else{
    WSGIappBlink()->delBlinkInstance(this);
  }
}

void WSCnwbase::getWorkWSNblinkFlag(WSCbool*){}
void WSCnwbase::setWorkWSNtwinBlink(WSCbool){}
void WSCnwbase::getWorkWSNtwinBlink(WSCbool*){}

void WSCnwbase::setWorkWSNblinkRate(WSCuchar data){
  if (_bl_fl != False) {
    WSGIappBlink()->delBlinkInstance(this);
    WSGIappBlink()->addBlinkInstance(this,_blink_rate,_bl_refreshing);
  }
}

void WSCnwbase::getWorkWSNblinkRate(WSCuchar* data){}

void WSCnwbase::setWorkWSNanchorTop(WSCushort data){
  if (_anchor_top_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}

void WSCnwbase::getWorkWSNanchorTop(WSCushort* data){}
void WSCnwbase::setWorkWSNanchorBottom(WSCushort data){
  if (_anchor_bottom_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCnwbase::getWorkWSNanchorBottom(WSCushort* data){}
void WSCnwbase::setWorkWSNanchorLeft(WSCushort data){
  if (_anchor_left_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCnwbase::getWorkWSNanchorLeft(WSCushort* data){}
void WSCnwbase::setWorkWSNanchorRight(WSCushort data){
  if (_anchor_right_use != False){
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCnwbase::getWorkWSNanchorRight(WSCushort* data){}
void WSCnwbase::setWorkWSNanchorTopFlag(WSCbool data){
  if (_anchor_top_use != False){
    setGeometryChanged(True);
    needUpdate();
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCnwbase::getWorkWSNanchorTopFlag(WSCbool* data){}
void WSCnwbase::setWorkWSNanchorBottomFlag(WSCbool data){
  if (_anchor_bottom_use != False){
    setGeometryChanged(True);
    needUpdate();
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCnwbase::getWorkWSNanchorBottomFlag(WSCbool* data){}
void WSCnwbase::setWorkWSNanchorLeftFlag(WSCbool data){
  if (_anchor_left_use != False){
    setGeometryChanged(True);
    needUpdate();
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCnwbase::getWorkWSNanchorLeftFlag(WSCbool* data){}
void WSCnwbase::setWorkWSNanchorRightFlag(WSCbool data){
  if (_anchor_right_use != False){
    setGeometryChanged(True);
    needUpdate();
    if (getParent() != NULL){
      getParent()->setGeometryChanged(True);
      getParent()->needUpdate();
    }
  }
}
void WSCnwbase::getWorkWSNanchorRightFlag(WSCbool* data){}

#ifndef NO_REMOTE_INSTANCE
void WSCnwbase::setWorkWSNexport(WSCbool data){
  setExported(data);
}
void WSCnwbase::getWorkWSNexport(WSCbool* data){
}
#endif

WSCnwbase::~WSCnwbase(){
#ifndef WS_EMBED
  clearGriphand();
#endif
//  WSClistData* ghlist = (WSClistData*)getUserData("GH-LIST");
//  if (ghlist != NULL){
//    delete ghlist;
//    setUserData("GH-LIST",(void*)0);
//  }

  if (_bl_fl != False) {
    WSGIappBlink()->delBlinkInstance(this);
  }
  if (_user_string != NULL){
    delete[] _user_string;
  }
}

long WSCnwbase::_device_initialize(){
  WSCbase::_device_initialize();
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  dev->setEnableEvent(WSEV_EXPOSE);
  char fl = False;
  dev->setValue(WSDEV_USE_PIXMAP,&fl);

  return WS_NO_ERR;
}

long WSCnwbase::execEventProc(long ev, void* data){
  if (ev == WSEV_EXPOSE){
    if (_x + _w < 0 || _y + _h < 0){
      return WS_NO_ERR;
    }
    WSCbool absolute = getAbsoluteDraw();
    long ret = draw();
    if (ret == WS_ERR){
      return WS_ERR;
    }
    WSDdev* dev = getowndev();
    if (dev == NULL){
      return WS_ERR;
    }
    if (absolute == False && dev->isExposed(_x,_y,_w,_h) == False){
      return WS_NO_ERR;
    }
    if (data == NULL){

      WSCrect area;
      area.setRect(_x,_y,_w,_h);
      onExpose(&area); 
//      draw();
      if (_expose_op == 1){
        execProcedure(ev);
      }
      return WS_NO_ERR;
    }else{
      WSCrect* area = (WSCrect*)data;
      onExpose(area);
      if (_expose_op == 1){
        execProcedure(ev);
      }
    }
    return WS_NO_ERR;
  }else if (ev == WSEV_MOUSE_PRESS  || ev == WSEV_MOUSE_RELEASE ||
      ev == WSEV_MOUSE_DOUBLE_CLICK ||
      ev == WSEV_MOUSE_IN     || ev == WSEV_MOUSE_OUT    ||
      ev == WSEV_MOUSE_MOVE ){

    if (ev == WSEV_MOUSE_OUT){
      if (_mouse_enter == True){
        _mouse_enter = False;
        WSCbase::execEventProc(WSEV_MOUSE_OUT, NULL);
      }
      return WS_NO_ERR;

    }else{
      if (data == NULL){
        return WS_ERR;
      }
      WSCpoint* pt = (WSCpoint*)data;

      if ( pt->x >= _x && pt->x < _x+_w &&
           pt->y >= _y && pt->y < _y+_h ){
        WSCpoint vpdata;
        vpdata.x = pt->x - _x;
        vpdata.y = pt->y - _y;
        if (ev == WSEV_MOUSE_PRESS){
          _mouse_grabed = True;
        }else if (ev == WSEV_MOUSE_RELEASE){
          _mouse_grabed = False;
        }
        WSCbase::execEventProc(ev, &vpdata);
        if (_mouse_enter == False){
          _mouse_enter = True;
          WSCbase::execEventProc(WSEV_MOUSE_IN, &vpdata);
        }
        if (ev == WSEV_MOUSE_PRESS ||
            ev == WSEV_MOUSE_DOUBLE_CLICK || ev == WSEV_MOUSE_RELEASE){
          return WS_NO_ERR;
        }
        return WS_ERR;
      }else{
        WSCpoint vpdata;
        vpdata.x = pt->x - _x;
        vpdata.y = pt->y - _y;
        if (_out_side_mouse_move == True &&  ev == WSEV_MOUSE_MOVE  ){
//printf("WSCnwbase::execEventProc WSEV_MOUSE_MOVE ext. %s here\n",getInstanceName());
          if (_mouse_grabed != False){
//printf("WSCnwbase::execEventProc WSEV_MOUSE_MOVE ext. %s execute\n",getInstanceName());
            WSCbase::execEventProc(ev, &vpdata);
            return WS_ERR;
          }
        }
        if (_out_side_mouse_release == True &&  ev == WSEV_MOUSE_RELEASE ){
          if (_mouse_grabed != False){
            WSCbase::execEventProc(ev, &vpdata);
            return WS_NO_ERR;
          }
        }
        if (_out_side_mouse_press == True &&  ev == WSEV_MOUSE_PRESS ){
          if (_mouse_grabed != False){
            WSCbase::execEventProc(ev, &vpdata);
            return WS_NO_ERR;
          }
        }
        if (_mouse_enter == True){
          _mouse_enter = False;
          WSCbase::execEventProc(WSEV_MOUSE_OUT, NULL);
        }
        return WS_ERR;
      }
      return WS_ERR;
    }
  }
  return WSCbase::execEventProc(ev, data);
}
long WSCnwbase::clear(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  dev->clearArea(_x, _y, _w, _h, False);
  return WS_NO_ERR;
}
long WSCnwbase::cdraw(){
  needUpdate();
  setAbsoluteDraw(True);
  return draw();
}
long WSCnwbase::redraw(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  WSDdev* pdev = dev->getParentDev();
  if (pdev != NULL){
    WSCbase* parent = pdev->getAttachedClient();
    if (parent != NULL && parent->getAbsoluteDraw() != False){
      parent->setAbsoluteDraw(False);
      parent->redraw();
      return WS_NO_ERR;
    }
  }
  dev->clearArea(_x, _y, _w, _h, True);
  return WS_NO_ERR;
}

void WSCnwbase::update(){
  if (isNeedUpdate() == True){
    redraw();
    WSCbase::update();
  }
}
long WSCnwbase::addProcedure(WSCprocedure* ac){
  long trg = ac->getTrigger();
  if (existTrigger(trg) == False  && ac->getInternal() == False){
WSMFtrace("WSCnwbase::addProcedure trigger=%d not supported.\n", trg);
     return WS_ERR;
  }

  if (trg == WSEV_MOUSE_IN || trg == WSEV_MOUSE_OUT){

    ac->setEffectiveTriggerMask( WSEV_MOUSE_MOVE_BIT | WSEV_MOUSE_IN_BIT | WSEV_MOUSE_OUT_BIT);

    _event_mask |= ac->getEffectiveTriggerMask();
    _add_prcs(ac);

    WSDdev* dev = getowndev();
    if (dev != NULL){
      dev->setEnableEventBit( WSEV_MOUSE_MOVE_BIT | WSEV_MOUSE_IN | WSEV_MOUSE_OUT);
    }
    return WS_NO_ERR;
  }
  WSCbase::addProcedure(ac);
  return WS_NO_ERR;
}
void WSCnwbase::setXOffsetPtr(short* ptr){
  WSCbase::setXOffsetPtr(ptr);
  WSClistData children = getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children.getData(i);
    if (child->getInternalObject() == True &&
        !strcmp(child->getUseDevName(),"nwDev")){
      child->setXOffsetPtr(ptr);
    }
  }
}
void WSCnwbase::setYOffsetPtr(short* ptr){
  WSCbase::setYOffsetPtr(ptr);
  WSClistData children = getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children.getData(i);
    if (child->getInternalObject() == True &&
        !strcmp(child->getUseDevName(),"nwDev")){
      child->setYOffsetPtr(ptr);
    }
  }
}
void WSCnwbase::setScaleOffsetPtr(double* ptr){
  WSCbase::setScaleOffsetPtr(ptr);
  WSClistData children = getChildren();
  long i;
  long num = children.getNum();
  for(i=0; i<num; i++){
    WSCbase* child = (WSCbase*)children.getData(i);
    if (child->getInternalObject() == True &&
        !strcmp(child->getUseDevName(),"nwDev")){
      child->setScaleOffsetPtr(ptr);
    }
  }
}
void WSCnwbase::setOutSideMousePress(WSCbool fl){
  if (fl != 0){
    _out_side_mouse_press = True;
  }else{
    _out_side_mouse_press = False;
  }
}
void WSCnwbase::setOutSideMouseRelease(WSCbool fl){
  if (fl != 0){
    _out_side_mouse_release = True;
  }else{
    _out_side_mouse_release = False;
  }
}
void WSCnwbase::setOutSideMouseMove(WSCbool fl){
  if (fl != 0){
    _out_side_mouse_move = True;
  }else{
    _out_side_mouse_move = False;
  }
}
WSCbool WSCnwbase::getOutSideMousePress(){
  return _out_side_mouse_press;
}
WSCbool WSCnwbase::getOutSideMouseRelease(){
  return _out_side_mouse_release;
}
WSCbool WSCnwbase::getOutSideMouseMove(){
  return _out_side_mouse_move;
}
void WSCnwbase::onChildAdded(WSCbase* child){
  if (getXOffsetPtr() != NULL){
    child->setXOffsetPtr(getXOffsetPtr());
  }
  if (getYOffsetPtr() != NULL){
    child->setYOffsetPtr(getYOffsetPtr());
  }
  WSCbase::onChildAdded(child);
}
void WSCnwbase::setMouseGrabed(WSCbool fl){
  if (fl == False){
    _mouse_grabed = False;
  }else{
    _mouse_grabed = True;
  }
}
WSCbool WSCnwbase::getMouseGrabed(){
  return _mouse_grabed;
}
void WSCnwbase::_adjust_for_anchors(WSCushort w,WSCushort h){
  WSCbool cleared = False;
  if (w != 0){
    if (_anchor_left_use == 0){
      if (_anchor_right_use != 0){
        long nx = w - _anchor_right - _w;
        if (_x != nx){
          clear();
          cleared = True;
        }
        _anchor_right_use = False;
        setProperty(WSNx,nx);
        _anchor_right_use = True;
      }
    }else{
      if (_anchor_right_use != 0){
        _anchor_left_use = False;
        _anchor_right_use = False;
        if (w < _anchor_right + _anchor_left){
          if (_w != 2){
            clear();
            cleared = True;
          }
          setProperty(WSNwidth,2);
        }else{
          long val = w - _anchor_right - _anchor_left;
          if (_x != _anchor_left){
            clear();
            cleared = True;
          }
          setProperty(WSNx,_anchor_left);
          if (val > 5 ){
            if (_w != val && cleared == False){
              clear();
              cleared = True;
            }
            setProperty(WSNwidth,val);
          }else{
            if (_w != 5 && cleared == False){
              clear();
              cleared = True;
            }
            setProperty(WSNwidth,5);
          }
        }
        _anchor_left_use = True;
        _anchor_right_use = True;
      }else{
        if (_anchor_left != _x){
          clear();
          cleared = True;
          setProperty(WSNx,_anchor_left);
        }
      }
    }
  }

  if (h != 0){
    if (_anchor_top_use == 0){
      if (_anchor_bottom_use != 0){
        long ny = h - _anchor_bottom - _h;
        if (ny != _h){
          clear();
          cleared = True;
        }
        _anchor_bottom_use = False;
        setProperty(WSNy,ny);
        _anchor_bottom_use = True;
      }
    }else{
      if (_anchor_bottom_use != 0){
        _anchor_top_use = False;
        _anchor_bottom_use = False;
        if (h < _anchor_bottom + _anchor_top){
          if (5 != _h && cleared == False){
            clear();
            cleared = True;
          }
          setProperty(WSNheight,5);
        }else{
          long val = h - _anchor_top - _anchor_bottom;
          if (_y != _anchor_top && cleared == False){
            clear();
            cleared = True;
          }
          setProperty(WSNy,_anchor_top);
          if (val > 5 ){
            if (val != _h && cleared == False){
              clear();
              cleared = True;
            }
            setProperty(WSNheight,val);
          }else{
            if (5 != _h && cleared == False){
              clear();
              cleared = True;
            }
            setProperty(WSNheight,5);
          }
        }
        _anchor_top_use = True;
        _anchor_bottom_use = True;
      }else{
        if (_anchor_top != _y && cleared == False){
          cleared = True;
          setProperty(WSNy,_anchor_top);
        }
      }
    }
  }
  if (cleared != False){
    if (_anchor_under_refreshing != True){
      _anchor_under_refreshing = True;
      update();
      _anchor_under_refreshing = False;
    }
    return;
  }
}
#ifndef NO_NWBASE_MOUSE_PROPERTY
WSCbase* WSCnwbase::_get_child_with_point(WSCpoint* pt,WSCbool in){
  if (getParent() == NULL){
    return NULL;
  }
  WSClistData* children = getParent()->getChildrenPtr();
  if (children == NULL){
    return NULL;
  }
  int num = children->getNum();
  WSCbase* target = NULL;
  int i;
  WSCbase** child_l = (WSCbase**)children->getBuf();
  for(i=0; i<num; i++){
    WSCbase* child = child_l[i];
    short x = 0;
    short y = 0;
    WSCushort w = 0;
    WSCushort h = 0;
    if (child->existProperty(WSNx) != False){
      child->getPropertyV(WSNx,&x);
    }
    if (child->existProperty(WSNy) != False){
      child->getPropertyV(WSNy,&y);
    }
    if (child->existProperty(WSNwidth) != False){
      child->getPropertyV(WSNwidth,&w);
    }
    if (child->existProperty(WSNheight) != False){
      child->getPropertyV(WSNheight,&h);
    }
    if (in == False){
      if (x < pt->x && pt->x < x+w && y < pt->y && pt->y < y+h){
        target = child;
      }
    }else{
      if (x <= pt->x && pt->x <= x+w && y <= pt->y && pt->y <= y+h){
        target = child;
      }
    }
  }
  return target;
}
void WSCnwbase::onMouseIn(WSCpoint* pt){
  WSDdev* pdev = getParentDev();
  if (pdev != NULL && pdev->getVisible() != False){
//printf("WSCnwbase::onMouseIn val=%d\n",_mouse_no);
    WSCpoint pt2;
    pt2.x = pt->x + _x;
    pt2.y = pt->y + _y;
    WSCbase* target = _get_child_with_point(&pt2,True);
    if (target == NULL || target == this){
      pdev->setValue(WSDEV_MOUSE_NO,&_mouse_no);
    }
  }
}
void WSCnwbase::onMouseOut(){
  WSCbase* parent = getParent();
  if (parent == NULL){
    return;
  }
  WSDdev* pdev = getParentDev();
  if (pdev != NULL && pdev->getVisible() != False){
    WSCpoint pt2;
    short x,y;
    WSGIappMouse()->getMousePosition(&x,&y,this);
    pt2.x = x + _x;
    pt2.y = y + _y;
    WSCbase* target = _get_child_with_point(&pt2,False);
    WSCushort val = 0;
    if (target != NULL && target->existProperty(WSNmouse) != False){
      val = target->getProperty(WSNmouse);
//printf("WSCnwbase::onMouseOut val=%d\n",val);
      pdev->setValue(WSDEV_MOUSE_NO,&val);
    }else if (parent->existProperty(WSNmouse) != False){
      val = parent->getProperty(WSNmouse);
//printf("WSCnwbase::onMouseOut val2=%d\n",val);
      pdev->setValue(WSDEV_MOUSE_NO,&val);
    }
  }
}
#endif
long WSCnwbase::getBlinkRate(){
  return (long)_blink_rate;
}
WSCbool WSCnwbase::getBlinkRefresh(){
  return (long)_bl_refreshing;
}

