//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>
#include <WSDmessage.h>
#include <WSCbase.h>
#include <WSDenv.h>
#include <WSCguiPolicy.h>

WSDappDev*    WSDappDev::_instance = NULL;
WSMFclassInit(WSDappDev,WSDdev);
WSCbool WSDappDev::_trace_output = False;
WSCbool WSDappDev::getInstanceExist(){
  if (_instance != NULL){
    return True;
  }else{
    return False;
  }
}
void WSDappDev::setInstance(WSDappDev* dev){
dbprintf("WSDappDev::setInstance() %s:%d start dev=0x%x\n",__FILE__,__LINE__,dev);
  _instance = dev;
}

WSDappDev::WSDappDev(){
  if (_instance != NULL){
WSMFtrace("Error! too many instances of WSDappDev.\n");
    WSGFexit(1);
  }
  _name = NULL;
  _modal_client = NULL;
  _modal_proc = NULL;
  _popup_modal_client = NULL;
  _iprm = 0;
  _cprm = 0;
  _policy = -1;
  _focus_dialog = NULL;
  _selection_owner = NULL;
  _mode = WS_MODE_NORMAL;
  _alt_context = NULL;
  _alt_context2 = NULL;
  _rebase_handle = 0;
  _under_exec_init = False;
  _exit_event_loop = False;
  _locked = False;
}

WSDappDev::~WSDappDev(){
  if (_name != NULL){
    delete _name;
    _name = NULL;
  }
//  destroy();
}
void WSDappDev::exitEventLoop(){
  _exit_event_loop = True;
}
int WSDappDev::getArgc(){
  return _iprm;
}
char** WSDappDev::getArgv(){
  return _cprm;
}

void WSDappDev::setInstanceName(char* name){
  if (_name != NULL){
    delete _name;
    _name = NULL;
  }
  _name = WSGFstrdup(name);
}

char* WSDappDev::getInstanceName(){
  if (_name != NULL){
    return _name;
  }
  return "";
}

long WSDappDev::initialize(){
dbprintf("WSDappDev::initialize() %s:%d start this=0x%x\n",__FILE__,__LINE__,this);
  setInstance(this);
  return WS_NO_ERR;
}

void WSDappDev::_trace_msg(char* data){
//printf("WSDappDev::_trace_msg!!!  here\n");
#ifndef WS_EMBED
  if (data[0] == '1'){
//printf("WSDappDev::_trace_msg!!!\n");
    _trace_output = True;
    WSDmessage::extSendMessage(NULL,"TR-START","0");
  }else{
    _trace_output = False;
  }
#endif
}

WSCbool WSDappDev::_init_executed = False;
WSClistData*    WSDappDev::_init_handler = NULL;
WSClistData* WSDappDev::getInitHandler(){
  if (_init_handler == NULL){
    _init_handler = new WSClistData();
  }
  return _init_handler;
}

long WSDappDev::execInitHandler(){
dbprintf("WSDappDev::execInitHandler() %s:%d start this=0x%x inst=0x%x\n",__FILE__,__LINE__,this,_instance);
  if (_instance == NULL){
dbprintf("WSDappDev::execInitHandler() %s:%d No WSDappDev exists. exit..\n",__FILE__,__LINE__);
WSMFtrace("Error! No instance of WSDappDev exists.\n");
    WSGFexit(0);
    return WS_ERR;
  }
  _under_exec_init = True;
  _init_executed = True;
  long num = getInitHandler()->getNum();
  long i;
  for(i=0; i< num; i++){
dbprintf("WSDappDev::execInitHandler() %s:%d call init function[%d]\n",__FILE__,__LINE__,i);
    void(*hd)() = (void(*)())getInitHandler()->getData(i);
    hd();
dbprintf("WSDappDev::execInitHandler() %s:%d call init function[%d] done.\n",__FILE__,__LINE__,i);
  }
  WSGIappObjectList()->execInitialize();
#ifndef WS_EMBED
  WSDmessage* msg1 = WSDmessage::getNewInstance();
  msg1->setupMessage(getInstanceName(),_trace_msg);
#endif
dbprintf("WSDappDev::execInitHandler() %s:%d done. \n",__FILE__,__LINE__);
  _under_exec_init = False;
  return WS_NO_ERR;
}

void WSDappDev::setInitHandler(void (*hd)() ){
  if (_instance == NULL){
    getInitHandler()->add((void*)hd);
    return ;
  }
  hd();
}

WSCushort WSDappDev::getWidth(){
  return (WSCushort)1024;
}
WSCushort WSDappDev::getXOffset(){
  return (WSCushort)0;
}

WSCushort WSDappDev::getHeight(){
  return (WSCushort)768;
}
WSCushort WSDappDev::getYOffset(){
  return (WSCushort)0;
}

WSCbool WSDappDev::getTraceMode(){
  return _trace_output;
}

void WSDappDev::setTraceMode(WSCbool fl){
  _trace_output = fl;
}

static WSDappDev* (*_create_handler)() = NULL;
void WSDappDev::setCreateInstanceHandler( WSDappDev* (*hd)()){
  _create_handler = hd;
}
static WSDappDev* theAppDev = NULL;
WSDappDev* WSGIappDev(){
  if (theAppDev == NULL){
    if (_create_handler == NULL){
      return NULL;
WSMFtrace("WSGIappDev() ERROR. cannot create WSDappDev class instance.\n");
    }
    theAppDev = _create_handler();
  }
  return theAppDev;
}

//void WSDappDev::setLockStatus(WSCbool fl){
//  _lock_status = fl;
//}
//
//WSCbool WSDappDev::getLockStatus(){
//  return _lock_status;
//}
void WSDappDev::setModalClient(WSCbase* client){
  _modal_client = client;
}
WSCbase* WSDappDev::getModalClient(){
  return _modal_client;
}
void WSDappDev::setPopupModalClient(WSCbase* client){
  _popup_modal_client = client;
}
WSCbase* WSDappDev::getPopupModalClient(){
  return _popup_modal_client;
}
void WSDappDev::update(){
WSMFtrace("WSDappDev::update() This system does not supprt.\n");
}
void WSDappDev::setModalProc(void(*proc)(WSDdev*,long,void*)){
  _modal_proc = (void*)proc;
}
void* WSDappDev::getModalProc(){
  return _modal_proc;
}
void WSDappDev::setSelectionOwner(WSCbase* owner){
  if ( _selection_owner != owner){
    WSCbase* bk = _selection_owner;
    _selection_owner = owner;
    if (bk != NULL){
      bk->onSelectionChange(False);
    }
    if (_selection_owner != NULL){
      owner->onSelectionChange(True);
    }
  }
}
WSCbase* WSDappDev::getSelectionOwner(){
  return _selection_owner;
}

void WSDappDev::setGuiPolicy(long val,WSCbool create_event){
  WSGIappGuiPolicy()->setGuiPolicy(val,create_event);
#if 0
  _policy = val;
  if (!(val & WS_POLICY_ORIGINAL) && 
      !(val & WS_POLICY_WINDOWS)){
    _policy |= WS_POLICY_WINDOWS;
  }
  if ((val & WS_POLICY_ORIGINAL) && 
      (val & WS_POLICY_WINDOWS)){
    long val2 = ~WS_POLICY_ORIGINAL;
    _policy &= val2;
  }
  if (create_event != False){
    WSGIappObjectList()->execEvent(WSEV_GUI_POLICY_CH,(void*)_policy);
  }
#endif
}
long WSDappDev::getGuiPolicy(){
  return WSGIappGuiPolicy()->getGuiPolicy();
#if 0
  if (_policy == -1){
    return (WS_POLICY_WINDOWS | WS_POLICY_GRADATION);
  }
  return _policy;
#endif
}

void WSDappDev::setFocusDialog(WSCbase* client,WSCbool fl){
  if (fl == False && _focus_dialog == client){
    _focus_dialog = NULL;
    return;
  }
  if (fl != False){
    _focus_dialog = client;
    return;
  }
}

WSCbase* WSDappDev::getFocusDialog(){
  return _focus_dialog;
}
void WSDappDev::addMenu(WSCbase* menu){
  _pld_menu_list.add((void*)menu);
}
void WSDappDev::delMenu(WSCbase* menu){
  _pld_menu_list.del((void*)menu);
}
WSClistData& WSDappDev::getMenuList(){
  return _pld_menu_list;
}
void WSDappDev::addAltFocusInstance(WSCbase* inst){
  _alt_focus_list.add((void*)inst);
}
void WSDappDev::delAltFocusInstance(WSCbase* inst){
  _alt_focus_list.del((void*)inst);
}
WSClistData& WSDappDev::getAltFocusInstanceList(){
  return _alt_focus_list;
}


void WSDappDev::exit(long val){
  WSGFexit(val);
}
void WSDappDev::setMode(long mode){
  _mode = mode;
}
long WSDappDev::getMode(){
  return _mode;
}
void WSDappDev::setContext(void* context){
  _alt_context = context;
}
void* WSDappDev::getContext(){
  return _alt_context;
}
void WSDappDev::setContext2(void* context){
  _alt_context2 = context;
}
void* WSDappDev::getContext2(){
  return _alt_context2;
}
#ifndef NO_MWT_FUNCTION
void WSDappDev::setRebaseHandle(long context){
  _rebase_handle = context;
}
long WSDappDev::getRebaseHandle(){
  return _rebase_handle;
}
#endif
WSCstring WSDappDev::getExtGuiPolicyName(){
  return WSGIappGuiPolicy()->getExtGuiPolicyName();
#if 0
  return _ext_policy_name;
#endif
}
WSCbool WSDappDev::getExtGuiPolicySelected(){
  return WSGIappGuiPolicy()->getExtGuiPolicySelected();
#if 0
  if (_policy & WS_POLICY_OTHER){
    return True;
  }
  return False;
#endif
}
void WSDappDev::setExtGuiPolicy(char* pname,WSCbool fl){
  WSGIappGuiPolicy()->setExtGuiPolicy(pname,fl);
#if 0
  if (pname == NULL || !strcmp(pname,"")){
    _ext_policy_name.setString("");
    _policy &= ~WS_POLICY_OTHER;
    _current_policy_fn_list = NULL;
  }else{
    _ext_policy_name.setString(pname);
    _policy |= WS_POLICY_OTHER;
    _current_policy_fn_list = (WSCindexData*)_ext_policy_list[_ext_policy_name.getString()];
  }
  if (fl != False){
    WSGIappObjectList()->execEvent(WSEV_GUI_POLICY_CH,(void*)_policy);
    WSGIappObjectList()->execUpdate();
  }
#endif
}
void WSDappDev::setExtGuiPolicyProc(char* plname,char* pname,void(*fn)(void*)){
  WSGIappGuiPolicy()->setExtGuiPolicyProc(plname,pname,fn);
#if 0
  if (plname == NULL || pname == NULL){
    return;
  }

  WSCindexData* plist = (WSCindexData*)_ext_policy_list[plname];
  if (plist == NULL){
    plist = new WSCindexData;
    _ext_policy_list[plname] = (void*)plist;
  }
  if (plist == NULL){
    return;
  }
  (*plist)[pname] = (void*)fn;
#endif
}

void* WSDappDev::getExtGuiPolicyProc(char* pname){
  return WSGIappGuiPolicy()->getExtGuiPolicyProc(pname);
#if 0
  if (getExtGuiPolicySelected() == False){
    return NULL;
  }
  if (_current_policy_fn_list == NULL){
    _current_policy_fn_list = (WSCindexData*)_ext_policy_list[_ext_policy_name.getString()];
  }
  if (_current_policy_fn_list == NULL){
    return NULL;
  }
  return (*_current_policy_fn_list)[pname];
#endif
}
WSCindexData* WSDappDev::getExtGuiPolicyList(){
  return WSGIappGuiPolicy()->getExtGuiPolicyList();
#if 0
  return &_ext_policy_list;
#endif
}
WSCbool WSDappDev::getUnderExecInitialize(){
  return _under_exec_init;
}
WSCbool WSDappDev::getInitializeExecuted(){
  return _init_executed;
}
long WSDappDev::lock(){
  fprintf(stderr,"WSDappDev::lock() this version does not supported.\n");
  return WS_ERR;
}
long WSDappDev::unlock(){
  fprintf(stderr,"WSDappDev::unlock() this version does not supported.\n");
  return WS_ERR;
}
WSCbool WSDappDev::getLockStatus(){
  return _locked;
}
void WSDappDev::checkThreadSafe(){
}
