//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSDenv.h>

static WSDenv* (*_chandler)() = NULL;
void WSDenv::setCreateInstanceHandler( WSDenv* (*hd)()){
  _chandler = hd;
}

static WSDenv* _the_app_environment = NULL;
WSDenv* WSGIappEnvironment(){
  if (_the_app_environment == NULL){
    if (_chandler == NULL){
      return NULL;
WSMFtrace("WSGIappEnvironment() ERROR. cannot create WSDenv class instance.\n");
    }
    _the_app_environment = _chandler();
  }
  return _the_app_environment;
}

WSDenv::~WSDenv(){}
#define ENV_STR_MAX_LEN 8192
char* WSDenv::getPlaneString(char* src){
static char buf[ENV_STR_MAX_LEN];

  long i;
  long slen = strlen(src);
  for(i =0; i < slen; i++){
    if (src[i] == '$'){
      if (i != 0 && src[i-1] == '\\'){
        continue;
      }else{
        char tbuf[ENV_STR_MAX_LEN];
        long c =0; 
        long j;
        for(j = i+1; j < slen; j++){
          if(src[j] !=' ' && src[j] !='\n' &&
             src[j] !='\t' && src[j] !=')'){
            tbuf[c] = src[j];
            c++;
          }else{
            if (src[j] == ')'){
              tbuf[c] = src[j];
              c++;
              j++;
            }
            break;
          }
        }
        tbuf[c] = 0;

        if (j == i+1){
          continue;
        }else{
          char tbuf2[ENV_STR_MAX_LEN];
          char* ret = getPlaneString(&src[j]);
          char* env = getEnv(tbuf);
          long total_len = i + strlen(env) + strlen(ret)+1;
          if (total_len < ENV_STR_MAX_LEN){
            strncpy(tbuf2,src,i);
            tbuf2[i] = 0;
            strcat(tbuf2,env);
            strcat(tbuf2,ret);
            strcpy(buf,tbuf2);
          }else{
            buf[0] = 0;
          }
          return buf;
        }
      }
    }
  }
  if (slen < ENV_STR_MAX_LEN){
    strcpy(buf,src);
  }else{
    buf[0] = 0;
  }
  return buf;
}
