//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSDfile.h>

WSMFclassInit(WSDfile,WSCroot);

WSDfile* (*WSDfile::_create_handler)() = NULL;

WSDfile::WSDfile(){
  _read_only = False;
  _type = WS_TEXT;
}

//WSDfile::~WSDfile(){
//}

void WSDfile::setType(char type){
  _type = type;
};
char WSDfile::getType(){
  return _type;
}
void WSDfile::setReadOnly(WSCbool fl){
  if (fl != False){
    fl = True;
  }
  _read_only = fl;
}

WSCbool WSDfile::isReadOnly(){
  return _read_only;
}

WSDfile* WSDfile::getNewInstance(){
  if (_create_handler == NULL){
    return new WSDfile();
  }
  return _create_handler();
}

void* WSDfile::getCreateInstanceHandler(){
  return (void*)_create_handler;
}

void WSDfile::setCreateInstanceHandler(void* hd){
  _create_handler = (WSDfile* (*)())hd;
}

long WSDfile::open(char* fname,char*){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS){
    _vf_size = 0;
    _vf_pos = 0;
    _vf_ptr = WSDfile::getFileHandle(fname,&_vf_size);
    if (_vf_ptr == NULL){
      _vf_size = 0;
      return WS_ERR;
    }
    _file_name = fname;
    return WS_NO_ERR;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support open().\n");
  return WS_ERR;
}

long WSDfile::close(){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    _vf_size = 0;
    _vf_pos = 0;
    _vf_ptr = NULL;
    _file_name = "";
    _type = WS_TEXT;
    return WS_NO_ERR;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support close().\n");
  return WS_ERR;
}

long WSDfile::read(void* buf,long size){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    long rsize = size;
    if (_vf_size - _vf_pos < (WSCulong)size){
      rsize = _vf_size - _vf_pos;
    }
    memcpy(buf,&_vf_ptr[_vf_pos],rsize);
    _vf_pos += rsize;
    return rsize;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support read().\n");
  return 0;
}

long WSDfile::write(void* buf,long size){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    long rsize = size;
    if (_vf_size - _vf_pos < (WSCulong)size){
      rsize = _vf_size - _vf_pos;
    }
    memcpy(&_vf_ptr[_vf_pos],buf,rsize);
    _vf_pos += rsize;
    return rsize;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support write().\n");
  return 0;
}

WSCbool WSDfile::eof(){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    if (_vf_size == _vf_pos){
      return True;
    }
    return False;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support eof().\n");
  return True;
}

long WSDfile::seek(long pos){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    _vf_pos = pos;
    if (_vf_pos > _vf_size){ 
      _vf_pos = _vf_size;
    }
    return 0;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support seek().\n");
  return 0;
}

long WSDfile::seekSet(){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    _vf_pos = 0;
    return _vf_pos;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support seekSet().\n");
  return 0;
}

long WSDfile::seekEnd(){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    _vf_pos = _vf_size;
    return _vf_pos;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support seekEnd().\n");
  return 0;
}

long WSDfile::getSize(){
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    return _vf_size;
  }
#endif
WSMFtrace("WSDfile Warring. This system does not support getSize().\n");
  return 0;
}

long WSDfile::tell(){
WSMFtrace("WSDfile Warring. This system does not support tell().\n");
#ifndef NO_VIRTUAL_FS
  if (_type == WS_VFS && _vf_ptr != NULL){
    return _vf_pos;
  }
#endif
  return 0;
}

#ifndef NO_VIRTUAL_FS
WSClistData _fname_list;
WSClistData _fptr_list;
WSClistData _fptr_size_list;
WSCuchar* WSDfile::getFileHandle(char* fname,WSCulong* size){
  if (fname == NULL){
    return NULL;
  }
  long num = _fname_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* fn = (char*)_fname_list[i];
    if (!strcmp(fname,fn)){
      *size = (WSCulong)_fptr_size_list[i];
      return (WSCuchar*)_fptr_list[i];
    }
  }
  return NULL;
}
WSCbool WSDfile::getFileHandleRegistered(){
  if (_fname_list.getNum() == 0){
    return False;
  }
  return True;
}
long WSDfile::delFileHandle(char* fname){
  return setFileHandle(fname,NULL,0);
}
long WSDfile::setFileHandle(char* fname,unsigned char* ptr,WSCulong size){
  if (fname == NULL){
    return WS_ERR;
  }

  long num = _fname_list.getNum();
  long i;
  for(i=0; i<num; i++){
    char* fn = (char*)_fname_list[i];
    if (!strcmp(fname,fn)){
      delete fn;
      if (ptr == NULL){
        _fname_list.delPos(i);
        _fptr_list.delPos(i);
        _fptr_size_list.delPos(i);
        return WS_NO_ERR;
      }else{
        fn = WSGFstrdup(fname);
        _fname_list.setData(i,fn);
        _fptr_list.setData(i,ptr);
        _fptr_size_list.setData(i,ptr);
      }
      return WS_NO_ERR;
    }
  }
  if (ptr == NULL){
    return WS_NO_ERR;
  }else{
    char* fn = WSGFstrdup(fname);
    _fname_list.add(fn);
    _fptr_list.add(ptr);
    _fptr_size_list.add((void*)size);
  }
  return WS_NO_ERR;
}
#endif // NO_FILE_ON_FILE_SYSTEM
