//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSDserialize.h>
#include <WSClistData.h>
#include <WSCconductor.h>
#include <WSCserializeData.h>

WSMFclassInit(WSDserialize,WSCroot);

#define WS_SERIALIZE_SHORT_SIZE   2
#define WS_SERIALIZE_INT_SIZE     4
#define WS_SERIALIZE_LONG_SIZE    4
#define WS_SERIALIZE_FLOAT_SIZE   4
#define WS_SERIALIZE_DOUBLE_SIZE  8

WSCserializeData::WSCserializeData(){
  _data_name1 = NULL;
  _data_name_len = 0;
  _type = WS_DcLong;
  _type_name_len = 0;
  _type_name1 = NULL;
  _data_len = 0;
  _data1 = NULL;
  _cache_ptr = 0;
  _children._seg_size = 16;
};

void WSCserializeData::clearChildren(){
  long num = _children._num;
#if 1
  if (num > 0){
    WSCserializeData* serialize = (WSCserializeData*)_children.getData(0);
    delete serialize;
  }
#endif
#if 0
  long i;
  for(i=0; i< num; i++){
    WSCserializeData* serialize = (WSCserializeData*)_children.getData(i);
    delete serialize;
  }
#endif
  _children.clear();
};

WSCserializeData::~WSCserializeData(){
  if (_data1 != NULL && _data1 != _data2){
    delete (char*)_data1;
  }
  if (_type_name1 != NULL && _type_name1 != _type_name2){
    delete _type_name1;
  }
  if (_data_name1 != NULL && _data_name1 != _data_name2){
    delete _data_name1;
  }

  clearChildren();
};

long WSCserializeData::size(){
#ifdef NO_FILE_SERIALIZE
  return 0;
#else
   long ret = 1; //data_name_len

   if (_data_name1 != NULL){
     ret += strlen(_data_name1); //data_name
   }

   ret += 2; //type,_type_name_len

   if (_type_name1 != NULL){
     ret += strlen(_type_name1); //_type_name
   }

   ret += 4; //_data_len

   ret += _data_len; //_data

   long num = _children._num;
   long i;
   for(i=0; i< num; i++){
     WSCserializeData* cdata = (WSCserializeData*)_children.getData(i);
     ret += cdata->size();
   }
   return ret;
#endif
};

long WSCserializeData::write(WSDserialize* serialize){
#ifdef NO_FILE_SERIALIZE
  return 0;
#else
//printf("WSCserializeData::write len=%d %d\n",sizeof(char),_data_name_len);
  serialize->_write(&_data_name_len,sizeof(char));
//printf("WSCserializeData::write len=%d #%s#\n",_data_name_len,_data_name);
  serialize->_write(_data_name1,_data_name_len);

  serialize->_write(&_type,sizeof(char));
  serialize->_write(&_type_name_len,sizeof(char));

  if (_type == WS_DcObject){
    serialize->_write(_type_name1,_type_name_len);
    char tmp2[4];
    long num = _children._num;
    WSGIbinType()->memcpy4b(tmp2,num);
    long ret = serialize->_write(tmp2,sizeof(char)*4);
    long i;
    WSCserializeData* dt;
    for(i=0; i< num; i++){
      dt = (WSCserializeData*)_children.getData(i);
      dt->write(serialize);
    }
    return ret;
  }else{
    char tmp[4];
    WSGIbinType()->memcpy4b(tmp,_data_len);
    serialize->_write(tmp,sizeof(char)*4);
    long ret = serialize->_write(_data1,_data_len);
    return ret;
  }
#endif
};

long WSCserializeData::read(WSDserialize* serialize){
#ifdef NO_FILE_SERIALIZE
  return 0;
#else
//printf("WSCserializeData::read read start size=%d\n",sizeof(char));
  long len = serialize->_read(&_data_name_len,sizeof(char));
//printf("WSCserializeData::read len=%d %d\n",len,_data_name_len);
  if (len < (long)sizeof(char)){
    return 0;
  }
  if (_data_name1 != NULL && _data_name1 != _data_name2){
    delete _data_name1;
    _data_name1 = NULL;
  }
  if (_data_name_len < WSCSERIALIZEDATA_MAX_BUF_LEN){
    _data_name1 = _data_name2;
  }else{
    _data_name1 = new char[_data_name_len+1];
  }
  len = serialize->_read(_data_name1,_data_name_len);
//printf("WSCserializeData::read len=%d _data_name_len\n",len,_data_name_len);
  if (len <_data_name_len){
    _data_name1[0] = 0;
    return 0;
  }
  _data_name1[_data_name_len] = 0;
//printf("WSCserializeData::read len=%d #%s#\n",_data_name_len,_data_name);

  len = serialize->_read(&_type,sizeof(char));
  if (len <(long)sizeof(char)){
    _type = 0;
    return 0;
  }
  len = serialize->_read(&_type_name_len,sizeof(char));
  if (len <(long)sizeof(char)){
    _type_name_len = 0;
    return 0;
  }

  if (_type_name1 != NULL && _type_name1 != _type_name2){
    delete _type_name1;
    _type_name1 = NULL;
  }
  if (_type == WS_DcObject){
    if (_type_name_len < WSCSERIALIZEDATA_MAX_BUF_LEN){
      _type_name1 = _type_name2;
    }else{
      _type_name1 = new char[_type_name_len+1];
    }
    len = serialize->_read(_type_name1,_type_name_len);
    if (len < _type_name_len){
      _type_name1[0] = 0;
      return 0;
    }
    _type_name1[_type_name_len] = 0;

    char tmp2[4];
    long ret = serialize->_read(tmp2,sizeof(char)*4);
    if (ret < (long)sizeof(char)*4){
      return 0;
    }
    long num;
    WSGIbinType()->memscan4b(&num,tmp2);
#if 1
    long i;
    clearChildren();
    WSCserializeData* dt = new WSCserializeData[num];
    for(i=0; i< num; i++){
      len = dt[i].read(serialize);
      if (len == 0){
        return 0;
      }
      _children.add(&dt[i]);
    }
#endif
#if 0
    long i;
    WSCserializeData* dt;
    for(i=0; i< num; i++){
      dt = new WSCserializeData;
      len = dt->read(serialize);
      if (len == 0){
        return 0;
      }
      _children.add(dt);
    }
#endif
    return ret;
  }else{
    char tmp[4];
    len = serialize->_read(tmp,sizeof(char)*4);
    if (len < (long)sizeof(char)*4 && _data1 != NULL && _data1 != _data2){
      delete (char*)_data1;
      _data1 = NULL;
      return 0;
    }
    WSGIbinType()->memscan4b(&_data_len,tmp);
    if (_data1 != NULL && _data1 != _data2){
      delete (char*)_data1;
      _data1 = NULL;
    }
    if (_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
      _data1 = _data2;
    }else{
      _data1 = new char[_data_len];
    }
    long ret = serialize->_read(_data1,_data_len);
    if(ret < _data_len){
      return 0;
    }
    return ret;
  }
#endif
};



WSDserialize::WSDserialize(){
  _current_data = NULL;
  _transact = False;
  _need_save = False;
  _path.setString("./",WS_EN_ISO8859_1);
  _use_socket = False;
}

WSDserialize::~WSDserialize(){
  long i;
  long num = _data_list._num;
  WSCserializeData* dt;
  for(i=0; i< num; i++){
    dt  = (WSCserializeData*)_data_list.getData(i);
    if (dt != NULL){
      delete dt;
    }
  }
}

char* WSDserialize::getPath(){
  return _path.getString();
}

void WSDserialize::setPath(char* path){
  _path.setString(path);
}

long WSDserialize::_write_data(WSCserializeData* dt,char* type,void* data, long items){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOTYPE;
#else
  if (dt->_data1 != NULL && dt->_data1 != dt->_data2){
      delete (char*)dt->_data1;
      dt->_data1 = NULL;
  }
  if (type[0] == '#'){
    if (!strcmp(type,WS_DcRString)){
      dt->_type_name_len = 0;
      dt->_type = WS_DcString;
      dt->_data_len = strlen((char*)data)+1;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN){
        dt->_data1 = dt->_data2;
        strcpy((char*)dt->_data1,(char*)data);
      }else{
        dt->_data1 = WSGFstrdup((char*)data);
      }
    }else
    if (!strcmp(type,WS_DcRShort)){
      dt->_type = WS_DcShort;
      dt->_type_name_len = 0;
      dt->_data_len = WS_SERIALIZE_SHORT_SIZE*items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[WS_SERIALIZE_SHORT_SIZE*items];
      }
      short* dat = (short*)data;
      long i;
      char* d = (char*)dt->_data1;
      for(i=0; i < items; i++){
        WSGIbinType()->memcpy2b(&d[WS_SERIALIZE_SHORT_SIZE*i],dat[i]);
      }
    }else
    if (!strcmp(type,WS_DcRUShort)){
      dt->_type = WS_DcUShort;
      dt->_type_name_len = 0;
      dt->_data_len = WS_SERIALIZE_SHORT_SIZE*items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[WS_SERIALIZE_SHORT_SIZE*items];
      }
      WSCushort* dat = (WSCushort*)data;
      long i;
      char* d = (char*)dt->_data1;
      for(i=0; i < items; i++){
        WSGIbinType()->memcpy2b(&d[WS_SERIALIZE_SHORT_SIZE*i],dat[i]);
      }
    }else
    if (!strcmp(type,WS_DcRChar)){
      dt->_type = WS_DcChar;
      dt->_type_name_len = 0;
      dt->_data_len = items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[items];
      }
      memcpy(dt->_data1,data,items);
    }else
    if (!strcmp(type,WS_DcRLong)){
      dt->_type = WS_DcLong;
      dt->_type_name_len = 0;
      dt->_data_len = WS_SERIALIZE_LONG_SIZE*items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[WS_SERIALIZE_LONG_SIZE*items];
      }
      long* dat = (long*)data;
      char* d = (char*)dt->_data1;
      long i;
      for(i=0; i < items; i++){
        WSGIbinType()->memcpy4b(&d[WS_SERIALIZE_LONG_SIZE*i],dat[i]);
      }
    }else
    if (!strcmp(type,WS_DcRUChar)){
      dt->_type = WS_DcUChar;
      dt->_type_name_len = 0;
      dt->_data_len = items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[items];
      }
      memcpy(dt->_data1,data,items);
    }else
    if (!strcmp(type,WS_DcRULong)){
      dt->_type = WS_DcULong;
      dt->_type_name_len = 0;
      dt->_data_len = WS_SERIALIZE_LONG_SIZE*items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[WS_SERIALIZE_LONG_SIZE*items];
      }
      WSCulong* dat = (WSCulong*)data;
      char* d = (char*)dt->_data1;
      long i;
      for(i=0; i < items; i++){
        WSGIbinType()->memcpy4b(&d[WS_SERIALIZE_LONG_SIZE*i],dat[i]);
      }
    }else
    if (!strcmp(type,WS_DcRInt) ){
      dt->_type = WS_DcInt;
      dt->_type_name_len = 0;
      dt->_data_len = WS_SERIALIZE_INT_SIZE*items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[WS_SERIALIZE_INT_SIZE*items];
      }
      int* dat = (int*)data;
      char* d = (char*)dt->_data1;
      long i;
      for(i=0; i < items; i++){
        WSGIbinType()->memcpy4b(&d[WS_SERIALIZE_INT_SIZE*i],dat[i]);
      }
    }else
    if (!strcmp(type,WS_DcRUInt)){
      dt->_type = WS_DcUInt;
      dt->_type_name_len = 0;
      dt->_data_len = WS_SERIALIZE_INT_SIZE*items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[WS_SERIALIZE_INT_SIZE*items];
      }
      WSCuint* dat = (WSCuint*)data;
      char* d = (char*)dt->_data1;
      long i;
      for(i=0; i < items; i++){
        WSGIbinType()->memcpy4b(&d[WS_SERIALIZE_INT_SIZE*i],dat[i]);
      }
    }else
    if (!strcmp(type,WS_DcRFloat)){
      dt->_type = WS_DcFloat;
      dt->_type_name_len = 0;
      dt->_data_len = WS_SERIALIZE_FLOAT_SIZE*items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[WS_SERIALIZE_FLOAT_SIZE*items];
      }
      float* dat = (float*)data;
      char* d = (char*)dt->_data1;
      long i;
      for(i=0; i < items; i++){
        WSGIbinType()->memcpy4b(&d[WS_SERIALIZE_FLOAT_SIZE*i],(long)dat[i]);
      }
    }else
    if (!strcmp(type,WS_DcRDouble)){
      dt->_type = WS_DcDouble;
      dt->_type_name_len = 0;
      dt->_data_len = WS_SERIALIZE_DOUBLE_SIZE*items;
      if (dt->_data_len < WSCSERIALIZEDATA_DATA_LEN+1){
        dt->_data1 = dt->_data2;
      }else{
        dt->_data1 = new char[WS_SERIALIZE_DOUBLE_SIZE*items];
      }
      double* dat = (double*)data;
      char* d = (char*)dt->_data1;
      long i;
      for(i=0; i < items; i++){
        WSGIbinType()->memcpy8b(&d[WS_SERIALIZE_DOUBLE_SIZE*i],&dat[i]);
      }
    }
  }else{

    WSCtypeServer* sv = WSGIconductor()->searchTypeServer(type);
    if (sv == NULL){
      return WS_ERR_NOTYPE;
    }

    //DEVELOLP//XXXXXXXXXXXXXXX   ηѴǤʤ...
    long num = sv->getParentClassNum();
    long i;
    for(i=0; i< num; i++){
      char* ptype = sv->getParentClassName(i);
      void* pptr = sv->getParentClassPtr(ptype,data);
      if (ptype[0] == '#'){
        _write_data(dt, ptype, pptr, items);
      }else{
        _write_sub_class(dt, ptype, pptr, items);
      }
    }

    void (*svh)(WSDserialize*,void*);
    svh = (void (*)(WSDserialize*,void*))sv->getSaveHandler();
    WSCserializeData* bk = _current_data;
    _current_data = dt;
    svh(this,data); //ϥɥǥ...
    _current_data = bk;
  }
  return WS_NO_ERR;
#endif
}

long WSDserialize::_write_sub_class(WSCserializeData* dt,char* type,void* data,long items){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOTYPE;
#else

  WSCtypeServer* sv = WSGIconductor()->searchTypeServer(type);
  if (sv == NULL){
    return WS_ERR_NOTYPE;
  }

  //DEVELOP//XXXXXXXXXXXXXXX   ηѴǤʤ...
  long num = sv->getParentClassNum();
  long i;
  for(i=0; i< num; i++){
    char* ptype = sv->getParentClassName(i);
    void* pptr = sv->getParentClassPtr(ptype,data);
    if (ptype[0] == '#'){
      _write_data(dt, ptype, pptr, items);
    }else{
      _write_sub_class(dt, ptype, pptr,items);
    }
  }

  void (*svh)(WSDserialize*,void*);
  svh = (void (*)(WSDserialize*,void*))sv->getSaveHandler();
  WSCserializeData* bk = _current_data;
  _current_data = dt;
  svh(this,data); //ϥɥǥ...
  _current_data = bk;
  return WS_NO_ERR;
#endif
}

long WSDserialize::_save(WSClistData* dt_list,char* type,char* name,void* data){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR;
#else

  long num = dt_list->_num;
  long i;
  //DEVELOP//®򤹤 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)dt_list->getData(i);
    if (!strcmp(dt->_data_name1,name)){
      dt->clearChildren();
      dt->_type = WS_DcObject;
      dt->_type_name_len = strlen(type);
      dt->_data_len = 0;
      if (dt->_type_name1 != NULL && dt->_type_name1 != dt->_type_name2){
          delete dt->_type_name1;
          dt->_type_name1 = NULL;
      }
      if (dt->_type_name_len < WSCSERIALIZEDATA_MAX_BUF_LEN){
        dt->_type_name1 = dt->_type_name2;
        strcpy(dt->_type_name1,type);
      }else{
        dt->_type_name1 = WSGFstrdup(type);
      }
      _write_data(dt,type,data,1);
      return WS_NO_ERR;
    }
  }

  WSCserializeData* dt = new WSCserializeData;
  dt->_data_name_len = strlen(name);
  if (dt->_data_name_len < WSCSERIALIZEDATA_MAX_BUF_LEN ){
    dt->_data_name1 = dt->_data_name2;
    strcpy(dt->_data_name1,name);
  }else{
    dt->_data_name1 = WSGFstrdup(name);
  }
  dt->_type = WS_DcObject;
  dt->_type_name_len = strlen(type);
  if (dt->_type_name_len < WSCSERIALIZEDATA_MAX_BUF_LEN ){
    dt->_type_name1 = dt->_type_name2;
    strcpy(dt->_type_name1,type);
  }else{
    dt->_type_name1 = WSGFstrdup(type);
  }
  dt->_data_len = 0;

  dt_list->add(dt);
  _write_data(dt,type,data,1);
  return WS_NO_ERR;
#endif
}

long WSDserialize::save(char* type,char* name,void* data){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR;
#else
  if (_use_socket != False){
    WSClistData tmp_list;
    _current_data = NULL;
    long ret = _save(&tmp_list,type,name,data);
    if (ret == WS_NO_ERR){
      WSCserializeData* dt = (WSCserializeData*)tmp_list[0];
      if (dt != NULL){
//printf("WSDserialize::save call dt->write\n");
        ret = dt->write(this);
        delete dt;
        return ret;
      }
    }
    return WS_ERR;
  }
  _need_save = True;
  _current_data = NULL;
  return _save(&_data_list,type,name,data);
#endif
}

long WSDserialize::saveData(char* type,char* name,void* data){
  _need_save = True;
  return _save(&_current_data->_children,type,name,data);
}

long WSDserialize::_read_data(WSCserializeData* dt,char* type,void* data, long items){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOTYPE;
#else
  if (type[0] == '#'){
    if (!strcmp(type,WS_DcRString)){
      //TEST  //array ̤б...
      strcpy((char*)data,(char*)dt->_data1);
    }else
    if (!strcmp(type,WS_DcRShort)){
      long i;
      char* dat = (char*)dt->_data1;
      short* outd = (short*)data;
      for(i=0; i < items; i++){
        WSGIbinType()->memscan2b((short*)&outd[i],&dat[WS_SERIALIZE_SHORT_SIZE*i]);
      }
    }else
    if (!strcmp(type,WS_DcRUShort)){
      long i;
      char* dat = (char*)dt->_data1;
      WSCushort* outd = (WSCushort*)data;
      for(i=0; i < items; i++){
        WSGIbinType()->memscan2b((short*)&outd[i],&dat[WS_SERIALIZE_SHORT_SIZE*i]);
      }
    }else
    if (!strcmp(type,WS_DcRChar)){
      memcpy(data,dt->_data1,items);
    }else
    if (!strcmp(type,WS_DcRLong)){
      long i;
      char* dat = (char*)dt->_data1;
      long* outd = (long*)data;
      for(i=0; i < items; i++){
        WSGIbinType()->memscan4b(&outd[i],&dat[WS_SERIALIZE_LONG_SIZE*i]);
      }
    }else
    if (!strcmp(type,WS_DcRUChar)){
      memcpy(data,dt->_data1,items);
    }else
    if (!strcmp(type,WS_DcRULong)){
      long i;
      char* dat = (char*)dt->_data1;
      long* outd = (long*)data;
      for(i=0; i < items; i++){
        WSGIbinType()->memscan4b(&outd[i],&dat[WS_SERIALIZE_LONG_SIZE*i]);
      }
    }else
    if (!strcmp(type,WS_DcRInt) ){
      long i;
      char* dat = (char*)dt->_data1;
      long* outd = (long*)data;
      for(i=0; i < items; i++){
        WSGIbinType()->memscan4b(&outd[i],&dat[WS_SERIALIZE_INT_SIZE*i]);
      }
    }else
    if (!strcmp(type,WS_DcRUInt)){
      long i;
      char* dat = (char*)dt->_data1;
      long* outd = (long*)data;
      for(i=0; i < items; i++){
        WSGIbinType()->memscan4b(&outd[i],&dat[WS_SERIALIZE_INT_SIZE*i]);
      }
    }else
    if (!strcmp(type,WS_DcRFloat)){
      long i;
      char* dat = (char*)dt->_data1;
      float* outd = (float*)data;
      for(i=0; i < items; i++){
        WSGIbinType()->memscan4b((long*)&outd[i],&dat[WS_SERIALIZE_FLOAT_SIZE*i]);
      }
    }else
    if (!strcmp(type,WS_DcRDouble)){
      long i;
      char* dat = (char*)dt->_data1;
      double* outd = (double*)data;
      for(i=0; i < items; i++){
        WSGIbinType()->memscan8b(&outd[i],&dat[WS_SERIALIZE_DOUBLE_SIZE*i]);
      }
    }
  }else{
    //DEVELOP//XXXXXXXXXXXXXXX   ȤǤбˤ롣...
    WSCtypeServer* sv = WSGIconductor()->searchTypeServer(dt->_type_name1);
    if (sv == NULL){
      return WS_ERR_NOTYPE;
    }

    //DEVELOP//XXXXXXXXXXXXXXX   ηѴǤʤ...
    long num = sv->getParentClassNum();
    long i;
    for(i=0; i< num; i++){
      char* ptype = sv->getParentClassName(i);
      void* pptr = sv->getParentClassPtr(ptype,data);
      if (ptype[0] == '#'){
        _read_data(dt, ptype, pptr, items);
      }else{
        _read_sub_class(dt, ptype, pptr, items);
      }
    }

    void (*lvh)(WSDserialize*,void*);
    lvh = (void (*)(WSDserialize*,void*))sv->getLoadHandler();
    WSCserializeData* bk = _current_data;
    _current_data = dt;
    lvh(this,data); //ϥɥǥ...
    _current_data = bk;
  }
  return WS_NO_ERR;
#endif
}

long WSDserialize::_read_sub_class(WSCserializeData* dt,char* type,void* data,long items){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOTYPE;
#else
  WSCtypeServer* sv = WSGIconductor()->searchTypeServer(type);
  if (sv == NULL){
    return WS_ERR_NOTYPE;
  }

  //DEVELOP//XXXXXXXXXXXXXXX   ηѴǤʤ...
  long num = sv->getParentClassNum();
  long i;
  for(i=0; i< num; i++){
    char* ptype = sv->getParentClassName(i);
    void* pptr = sv->getParentClassPtr(ptype,data);
    if (ptype[0] == '#'){
      _read_data(dt, ptype, pptr, items);
    }else{
      _read_sub_class(dt, ptype, pptr,items);
    }
  }

  void (*lvh)(WSDserialize*,void*);
  lvh = (void (*)(WSDserialize*,void*))sv->getLoadHandler();
  WSCserializeData* bk = _current_data;
  _current_data = dt;
  lvh(this,data); //ϥɥǥ...
  _current_data = bk;
  return WS_NO_ERR;
#endif
}


long WSDserialize::_load(WSCserializeData* pdt,WSClistData* dt_list,char* type,char* name,void* data){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOOBJ;
#else
  long num = dt_list->_num;
//printf("here0..num=%d\n",num);
  long i;
  if (pdt != NULL && pdt->_cache_ptr < (WSCulong)num){
    //󸡺꤫鸡...
    //ʤȤȡ̤Ͻ֤˥ǡɤ߽ФΤ...
    //곺Ψƹ⤤...
    for( i= pdt->_cache_ptr; i< num; i++){ 
      WSCserializeData* dt = (WSCserializeData*)dt_list->getData(i);
      if (dt->_data_name1 == NULL){
        continue;
      }
      if ((dt->_data_name1[0] == name[0] && !strcmp(dt->_data_name1,name)) ||
          (name[0] == '*' && name[1] == 0 )){
        pdt->_cache_ptr++;
//printf("here1..\n");
        _read_data(dt,type,data,1);
        return WS_NO_ERR;
      }
    }
  }

  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)dt_list->getData(i);
    if (dt->_data_name1 == NULL){
      continue;
    }
//printf("dt->_data_name=#%s# #%s#\n",dt->_data_name,name);
    if ((dt->_data_name1[0] == name[0] && !strcmp(dt->_data_name1,name)) ||
          (name[0] == '*' && name[1] == 0 )){
//    if (!strcmp(dt->data_name,name) || !strcmp(name,"*")){
      if (pdt != NULL){
        pdt->_cache_ptr = i+1;
      }
      _read_data(dt,type,data,1);
      return WS_NO_ERR;
    }
  }
  return WS_ERR_NOOBJ;
#endif
}

long WSDserialize::load(char* type,char* name,void* data){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOOBJ;
#else
  if (_use_socket){
    _current_data = NULL;
    WSCserializeData* dt = new WSCserializeData();
    dt->read(this);
//printf("WSDserialize::load call dt->read type=#%s#\n",type);
    WSClistData tmp_list;
    tmp_list.add((void*)dt);

    long ret = _load(NULL,&tmp_list,type,name,data);
    delete dt;
    return ret;
  }

  _current_data = NULL;
  return _load(NULL,&_data_list,type,name,data);
#endif
}

long WSDserialize::loadData(char* type,char* name,void* data){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOOBJ;
#else
  return _load(_current_data,&_current_data->_children,type,name,data);
#endif
}

long WSDserialize::_load_alloc(WSCserializeData* pdt,WSClistData* dt_list,char* type,char* name,void** ptr,void* construct_data){
#ifdef NO_FILE_SERIALIZE
   return WS_ERR_NOTYPE;
#else
  long num = dt_list->_num;
  long i;
  WSCulong cpoint = 0;
  if (pdt != NULL && pdt->_cache_ptr < (WSCulong)num){
    //󸡺꤫鸡...
    //ʤȤȡ̤Ͻ֤˥ǡɤ߽ФΤ...
    //곺Ψƹ⤤...
    cpoint = 0;
  }

  WSCserializeData** buf = (WSCserializeData**)dt_list->_data;
  for( i= cpoint; i< num; i++){ 
    WSCserializeData* dt = buf[i];
    if (dt->_data_name1 == NULL){
      continue;
    }
    if ((dt->_data_name1[0] == name[0] && !strcmp(dt->_data_name1,name)) ||
          (name[0] == '*' && name[1] == 0 )){
//    if (!strcmp(_dt->data_name,name) || !strcmp(name,"*") ){
      char* target_type = dt->_type_name1;
      if (target_type == NULL){
        switch(dt->_type){
          case WS_DcInt:    target_type = "#int";break;
          case WS_DcShort:  target_type = "#sht";break;
          case WS_DcLong:   target_type = "#lng";break;
          case WS_DcChar:   target_type = "#chr";break;
          case WS_DcString: target_type = "#str";break;
          case WS_DcFloat:  target_type = "#flt";break;
          case WS_DcDouble: target_type = "#dbl";break;
          default: return WS_ERR_NOTYPE;
        }
      }

      if (!strcmp(type,target_type)){ //ƱǤ...
        if (type[0] == '#'){   //ǥեȤηǤ...
          if (!strcmp(type,WS_DcRString)){
              *ptr = new char[strlen((char*)dt->_data1)+1];
              strcpy((char*)*ptr,(char*)dt->_data1);
              return WS_NO_ERR;
          }else if (!strcmp(type,WS_DcRShort)){
              *ptr = new char[2];
              char* dat = (char*)dt->_data1;
              short* outd = (short*)*ptr;
              WSGIbinType()->memscan2b(outd,dat);
              return WS_NO_ERR;
          }else if (!strcmp(type,WS_DcRChar)){
              *ptr = new char[1];
              *((char*)*ptr) = *((char*)dt->_data1);
              return WS_NO_ERR;
          }else if (!strcmp(type,WS_DcRLong) || !strcmp(type,WS_DcRInt) || !strcmp(type,WS_DcRFloat)){
              *ptr = new char[4];
              char* dat = (char*)dt->_data1;
              long* outd = (long*)*ptr;
              WSGIbinType()->memscan4b(outd,dat);
              return WS_NO_ERR;

          }else if (!strcmp(type,WS_DcRDouble)){
            *ptr = new char[8];
            char* dat = (char*)dt->_data1;
            WSGIbinType()->memscan8b(*ptr,dat);
            return WS_NO_ERR;
          }
          if (pdt != NULL){
            pdt->_cache_ptr = i+1;
          }
          _read_data(dt,target_type,*ptr,1);
          return WS_NO_ERR;
        }else{ //桼ηǤ...
          WSCtypeServer* sv = WSGIconductor()->searchTypeServer(target_type);
          if (sv == NULL){
            return WS_ERR_NOTYPE;
          }
          *ptr = sv->createInstance(construct_data);
          if (*ptr == NULL){
            return WS_ERR_NOTYPE;
          }
          if (pdt != NULL){
            pdt->_cache_ptr = i+1;
          }
          _read_data(dt,target_type,*ptr,1);
          return WS_NO_ERR;
        }
      }else{
        if (type[0] == '#'){   //ǥեȤηǤФ(㤦)...
          *ptr = NULL;
          return WS_ERR_INVALID_DATA;
        }

        WSCtypeServer* sv = WSGIconductor()->searchTypeServer(target_type);
        if (sv == NULL){
          return WS_ERR_NOTYPE;
        }
        void* tmp = sv->createInstance(construct_data);
        if (tmp == NULL){
          return WS_ERR_NOTYPE;
        }
        if (pdt != NULL){
          pdt->_cache_ptr = i+1;
        }
        _read_data(dt,target_type,tmp,1);
        *ptr = sv->getParentClassPtr(type,tmp); //㤦ΤǥС...
        if (*ptr == NULL){
//          delete tmp;
          sv->deleteInstance(tmp);
          return WS_ERR_INVALID_DATA;
        }
        return WS_NO_ERR;
      }
    }
  }

  //ǽ餫鸡Ƥ⸫Ĥʤä...
  if (pdt == NULL || cpoint == 0){
    return WS_ERR_NOOBJ;
  }

  //Ƹʤ...
  pdt->_cache_ptr = 0;
  return _load_alloc(pdt,dt_list, type, name, ptr, construct_data);
#endif
}

long WSDserialize::loadAlloc(char* type,char* name,void** ptr,void* construct_data){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOOBJ;
#else
  if (_use_socket){
    _current_data = NULL;
    WSCserializeData* dt = new WSCserializeData();
//printf("WSDserialize::loadAlloc call dt->read type=#%s#\n",type);
    dt->read(this);

    WSClistData tmp_list;
    tmp_list.add((void*)dt);

    long ret = _load_alloc(NULL,&tmp_list,type,name,ptr,construct_data);
    delete dt;
    return ret;
  }

  _current_data = NULL;
  return _load_alloc(NULL,&_data_list,type,name,ptr,construct_data);
#endif
}

long WSDserialize::loadAllocData(char* type,char* name,void** ptr,void* construct_data){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOOBJ;
#else
  return _load_alloc(_current_data,&_current_data->_children,type,name,ptr,construct_data);
#endif
}

long WSDserialize::searchInstance(char* type,char mode,char*** otype,char*** onames,long* num){
  _current_data = NULL;
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOOBJ;
#else
  return _search_instance(&_data_list,type,mode,otype,onames,num);
#endif
}

long WSDserialize::searchInstanceData(char* type,char mode,char*** otype,char*** onames,long* num){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOOBJ;
#else
  return _search_instance(&_current_data->_children,type,mode,otype,onames,num);
#endif
}

long WSDserialize::_search_instance(WSClistData* dt_list,char* type,char mode,char*** otype,char*** onames,long* num){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR_NOOBJ;
#else
  long n = dt_list->_num;
  long i;
  WSClistData nlist;
  WSClistData clist;


  //DEVEOP//®򤹤 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
  WSCserializeData** dt_buf = (WSCserializeData**)dt_list->_data;
  for(i=0; i< n; i++){
    WSCserializeData* dt = dt_buf[i];
    char* target_type = dt->_type_name1;
    if (target_type == NULL){
      switch(dt->_type){
        case WS_DcInt:    target_type = "#int";break;
        case WS_DcShort:  target_type = "#sht";break;
        case WS_DcLong:   target_type = "#lng";break;
        case WS_DcChar:   target_type = "#chr";break;
        case WS_DcString: target_type = "#str";break;
        case WS_DcFloat:  target_type = "#flt";break;
        case WS_DcDouble: target_type = "#dbl";break;
        default:   continue;
      }
    }
    if ( !strcmp(type,target_type)){ 
    //ƱǤ ....
       nlist.add(type);
       clist.add(dt->_data_name1);
    }else if ( target_type[0] == '#' ){ 
    //C++ ɤηʤФ ...
       continue;

    }else if ( mode == WS_SEARCH_INHERIT ){
       //ѾطθڤԤäƤߤ ...
       WSCtypeServer* sv = WSGIconductor()->searchTypeServer(target_type);
       if (sv == NULL){
          continue;
       }
       if (sv->isParentClass(type) != False){
       //Ѿطä ...
         clist.add(target_type);
         nlist.add(dt->_data_name1);
       }
    }
  }
  n = nlist._num;
  *num = n;

  if (n != 0){
    char** otypelist = *otype  = new char*[n];
    char** onamelist = *onames = new char*[n];

    for(i=0; i < n; i++){
      otypelist[i] = (char*)clist.getData(i);
      onamelist[i] = (char*)nlist.getData(i);
    }
    return WS_NO_ERR;
  }else{
    *otype  = 0;
    *onames = 0;
    return WS_ERR_NOOBJ;
  }
#endif
}

WSCbool WSDserialize::underTransaction(){
  return _transact;
}

void WSDserialize::setUnderTransaction(WSCbool fl){
  if (fl != False){
    _transact = True;
  }else{
    _transact = False;
  }
}

long WSDserialize::beginTransaction(char* field,int fl){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR;
#else
  _field.setString(field);
  long ret = 0;
  if (fl == WS_READ_ONLY){
    ret = _open(field,WS_READ_ONLY);
  }else{
    ret = _open(field,WS_RW);
  }
  if (ret != WS_NO_ERR){
    return ret;
  }

  setUnderTransaction(True);

  char tmp[4];
  long num = 0;
  ret = _read(tmp,sizeof(char)*4);
  if (ret == 0){
    return WS_NO_ERR;
  }

  WSGIbinType()->memscan4b(&num,tmp);
  long i;
  for(i=0; i< num; i++){
    WSCserializeData* dt = new WSCserializeData();
    _data_list.add(dt);
    dt->read(this);
  }

  return WS_NO_ERR;
#endif
}

long WSDserialize::endTransaction(){
#ifdef NO_FILE_SERIALIZE
  return WS_ERR;
#else
  if (_need_save == False){
    return WS_NO_ERR;
  }
  _need_save = False;
  _seek(0);
  long num = _data_list._num;
  char tmp[4];
  WSGIbinType()->memcpy4b(tmp,num);
  _write(tmp,sizeof(char)*4);

  setUnderTransaction(False);

  long i;
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)_data_list.getData(i);
    dt->write(this);
  }
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)_data_list.getData(i);
    delete dt;
  }
  _data_list.clear();
  _close();
  return WS_NO_ERR;
#endif
}
