//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCpulldownMenuPopup.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSDmouse.h>
#include <WSCfontSet.h>
#include <WSCcolorSet.h>
#include <WSCbaseList.h>
#include <WSDappDev.h>
#include <WSDkeyboard.h>
#include <string.h>
#include <WSCguiPolicy.h>
//--- [20041015]
#include <WSCimageSet.h>
//---

#define WS_ERR2 -2
#define WS_NO_SELECTED -2

WSMFguiClassInitialize(WSCpulldownMenuPopup, WSCwindow);

WSCpulldownData::WSCpulldownData(){
  _id = -1;
  _separator = 0;
  _cascaded = 0;
  _sensitive = 1;
  _toggle = 0;
  _toggle_state = 0;
  _next = NULL;
  _cascade_data = NULL;
}

WSCpulldownData::~WSCpulldownData(){
  if (_next != NULL){
    delete _next;
  }
  if (_cascade_data != NULL){
    delete _cascade_data;
  }
}

WSCbool WSCpulldownData::getSensitive(long no){
  WSCpulldownData* data = getItem(no);
  if (data != NULL){
    return data->_sensitive;
  }
  return False;
}
WSCbool WSCpulldownData::_get_sensitive(long no,void* ptr){
//printf("WSCpulldownData::getSensitive no=%d ptr=0x%x\n",no,ptr);
  WSCpulldownData* data = getItem(no);
  WSCpulldownData* parent_pld = (WSCpulldownData*)ptr;
  if (data != NULL){
//printf("WSCpulldownData::getSensitive data->id=%d fl=%d\n",data->_id, parent_pld->getSensitiveWithId(data->_id));
    if (data->_id > -1 && parent_pld != NULL){
      return parent_pld->getSensitiveWithId(data->_id);
    }
    return data->_sensitive;
  }
  return False;
}

WSCbool WSCpulldownData::getToggle(long no){
  WSCpulldownData* data = getItem(no);
  if (data != NULL){
    return data->_toggle;
  }
  return False;
}
WSCbool WSCpulldownData::_get_toggle(long no,void* ptr){
//printf("WSCpulldownData::getSensitive no=%d ptr=0x%x\n",no,ptr);
  WSCpulldownData* data = getItem(no);
  WSCpulldownData* parent_pld = (WSCpulldownData*)ptr;
  if (data != NULL){
//printf("WSCpulldownData::getSensitive data->id=%d fl=%d\n",data->_id, parent_pld->getSensitiveWithId(data->_id));
    if (data->_id > -1 && parent_pld != NULL){
      return parent_pld->getToggleWithId(data->_id);
    }
    return data->_toggle;
  }
  return False;
}

WSCbool WSCpulldownData::_is_toggle(void* ptr){
  WSCpulldownData* parent_pld = (WSCpulldownData*)ptr;
  if (parent_pld != NULL){
//printf("WSCpulldownData::_is_toggle this=0x%x pld=0x%x _toggle=%d\n",this,ptr,parent_pld->isToggle());
    WSCpulldownData* _this = this;
    while(1){
      if (_this->_id > -1 && parent_pld->getToggleWithId(_this->_id) != False){
        return True;
      }
      _this = _this->_next;
      if (_this == NULL){
        return False;
      }
    }
  }
//printf("WSCpulldownData::_is_toggle this=0x%x pld=0x%x _toggle=%d\n",this,ptr,isToggle());
  return isToggle();
}


WSCbool WSCpulldownData::isToggle(){
//printf("WSCpulldownData::isToggle _id=%d _toggle=%d 0x%x\n",_id,_toggle,this);
  if (_toggle != False){
//printf("WSCpulldownData::isToggle this=0x%x True\n",this);
    return True;
  }
  if (_next == NULL){
//printf("WSCpulldownData::isToggle this=0x%x False\n",this);
    return False;
  }
  return _next->isToggle();
}

WSCbool WSCpulldownData::getToggleState(long no){
  WSCpulldownData* data = getItem(no);
  if (data != NULL){
    return data->_toggle_state;
  }
  return False;
}
WSCbool WSCpulldownData::_get_toggle_state(long no,void* ptr){
//printf("WSCpulldownData::getSensitive no=%d ptr=0x%x\n",no,ptr);
  WSCpulldownData* data = getItem(no);
  WSCpulldownData* parent_pld = (WSCpulldownData*)ptr;
  if (data != NULL){
//printf("WSCpulldownData::getSensitive data->id=%d fl=%d\n",data->_id, parent_pld->getSensitiveWithId(data->_id));
    if (data->_id > -1 && parent_pld != NULL){
      return parent_pld->getToggleStateWithId(data->_id);
    }
    return data->_toggle_state;
  }
  return False;
}





WSCbool WSCpulldownData::_get_sensitive_with_id(long id,void* ptr){
//printf("WSCpulldownData::getSensitive no=%d ptr=0x%x\n",no,ptr);
  WSCpulldownData* data = getItemWithId(id);
  WSCpulldownData* parent_pld = (WSCpulldownData*)ptr;
  if (data != NULL){
//printf("WSCpulldownData::getSensitive data->id=%d fl=%d\n",data->_id, parent_pld->getSensitiveWithId(data->_id));
    if (data->_id > -1 && parent_pld != NULL){
      return parent_pld->getSensitiveWithId(data->_id);
    }
    return data->_sensitive;
  }
  return False;
}
WSCbool WSCpulldownData::getSensitiveWithId(long id){
    WSCpulldownData* data = getItemWithId(id);
    if (data != NULL){
      return data->_sensitive;
    }
    return False;
};

WSCbool WSCpulldownData::_get_toggle_with_id(long id,void* ptr){
//printf("WSCpulldownData::getSensitive no=%d ptr=0x%x\n",no,ptr);
  WSCpulldownData* data = getItemWithId(id);
  WSCpulldownData* parent_pld = (WSCpulldownData*)ptr;
  if (data != NULL){
//printf("WSCpulldownData::getSensitive data->id=%d fl=%d\n",data->_id, parent_pld->getSensitiveWithId(data->_id));
    if (data->_id > -1 && parent_pld != NULL){
      return parent_pld->getToggleWithId(data->_id);
    }
    return data->_toggle;
  }
  return False;
}
WSCbool WSCpulldownData::getToggleWithId(long id){
    WSCpulldownData* data = getItemWithId(id);
    if (data != NULL){
//printf("WSCpulldownData::getToggleWithId id=%d %d 0x%x\n",id,data->_toggle,data);
      return data->_toggle;
    }
//printf("WSCpulldownData::getToggleWithId id=%d False!\n",id);
    return False;
};

WSCbool WSCpulldownData::_get_toggle_state_with_id(long id,void* ptr){
//printf("WSCpulldownData::getSensitive no=%d ptr=0x%x\n",no,ptr);
  WSCpulldownData* data = getItemWithId(id);
  WSCpulldownData* parent_pld = (WSCpulldownData*)ptr;
  if (data != NULL){
//printf("WSCpulldownData::getSensitive data->id=%d fl=%d\n",data->_id, parent_pld->getSensitiveWithId(data->_id));
    if (data->_id > -1 && parent_pld != NULL){
      return parent_pld->getToggleStateWithId(data->_id);
    }
    return data->_toggle_state;
  }
  return False;
}
WSCbool WSCpulldownData::getToggleStateWithId(long id){
    WSCpulldownData* data = getItemWithId(id);
    if (data != NULL){
      return data->_toggle_state;
    }
    return False;
};



WSCpulldownData* WSCpulldownData::getItem(long no){
     if (no < 0){
       return NULL;
     }
     if (_separator != False){
       if (_next != NULL){
         return _next->getItem(no);
       }
       return NULL;
     }else
     if (no == 0){
       return this;
     }else{
       if (_next != NULL){
         return _next->getItem(no-1);
       }
       return NULL;
     }
}
WSCpulldownData* WSCpulldownData::getItemWithId(long no){
  if (_id == no){
    return this;
  }else if ( _cascade_data != NULL){
    WSCpulldownData* ret =  _cascade_data->getItemWithId(no);
    if (ret != NULL){
      return ret;
    }
  }
  if (_next != NULL){
    return _next->getItemWithId(no);
  }
  return NULL;
}

long WSCpulldownData::setSensitive(long no,WSCbool fl ){
  if (no < 0){
    return WS_ERR;
  }
  WSCpulldownData* data = getItem(no);
  if (data != NULL){
    data->_sensitive = fl;
    return WS_NO_ERR;
  }
  return WS_ERR2;
}
long WSCpulldownData::setSensitiveWithId(long id,WSCbool fl ){
  WSCpulldownData* data = getItemWithId(id);
  if (data != NULL){
    data->_sensitive = fl;
    return WS_NO_ERR;
  }
  return WS_ERR2;
}

long WSCpulldownData::setToggle(long no,WSCbool fl ){
  if (no < 0){
    return WS_ERR;
  }
  WSCpulldownData* data = getItem(no);
  if (data != NULL){
    data->_toggle = fl;
//printf("WSCpulldownData::setToggle id=%d fl=%d\n",no,fl);
    return WS_NO_ERR;
  }
//printf("WSCpulldownData::setToggle id=%d fl=%d error!\n",no,fl);
  return WS_ERR2;
}
long WSCpulldownData::setToggleWithId(long id,WSCbool fl ){
  WSCpulldownData* data = getItemWithId(id);
  if (data != NULL){
    data->_toggle = fl;
//printf("WSCpulldownData::setToggleWithId id=%d fl=%d ok! 0x%x\n",id,fl,data);
    return WS_NO_ERR;
  }
//printf("WSCpulldownData::setToggleWithId id=%d fl=%d error!\n",id,fl);
  return WS_ERR2;
}

long WSCpulldownData::setToggleState(long no,WSCbool fl ){
  if (no < 0){
    return WS_ERR;
  }
  WSCpulldownData* data = getItem(no);
  if (data != NULL){
    data->_toggle_state = fl;
    return WS_NO_ERR;
  }
  return WS_ERR2;
}
long WSCpulldownData::setToggleStateWithId(long id,WSCbool fl ){
  WSCpulldownData* data = getItemWithId(id);
  if (data != NULL){
    data->_toggle_state = fl;
    return WS_NO_ERR;
  }
  return WS_ERR2;
}




void WSCpulldownData::setCascaded(WSCbool fl,char* separator,char* separator2){
  _cascaded = fl;
  if (fl != False){
    _cascade_data = parse(_op.getString(),separator,separator2);
  }else{
    delete _cascade_data;
    _cascade_data = NULL;
  }
}
void WSCpulldownData::add(WSCpulldownData* data){
  if (_next == NULL){
    _next = data;
  }else{
    _next->add(data);
  }
}
long WSCpulldownData::getItems(){
  long cnt = 0;
  if (_separator == False){
    cnt++;
  }
  if (_next != NULL){
    cnt += _next->getItems();
  }
  return cnt;
}

WSCpulldownData* WSCpulldownData::parse(char* menu_string,char* separator,char* separator2){
    WSCpulldownData* ptr = NULL;
    WSCstring str(menu_string);
    long i;
    long num = str.getWords(separator2);
    WSCpulldownData* data;
    for(i=0; i<num; i++){
      WSCstring item = str.getWord(i,separator2);
      if (strcmp(item.getString(),"")){
        data = new WSCpulldownData;
        if ( ptr == NULL ){
          ptr = data;
        }else{
          ptr->add(data);
        }

        WSCstring item_str = item.getWord(0, separator);

        if (!strcmp(item_str.getString(),"SP") ||
            !strcmp(item_str.getString(),"SEPARATOR")){
          data->_separator = True;
        }else{
          data->_label.setString(item_str.getString());
         
          WSCstring opstr = item.getWord(1,separator);
          if (!strncmp(opstr.getString(),"{",1)){
            long wpos = str.getWordCharPos(i, separator2);
//printf("WSCpulldownMenuPopup::parse ,getwordcharpos=%d\n",wpos);
            WSCstring tmp(menu_string);
            if (wpos > -1){
              tmp.deleteChars(0,wpos);
            }
            wpos = tmp.getWordCharPos(1,"{");
            if (wpos > -1){
              tmp.deleteChars(0,wpos);
            }
            char* tstr = tmp.getString(WS_EN_UTF8);
            long len = strlen(tstr);
            long num_of_conma = 0;
            long j;
            long layers = 0;

            for(j=0; j< len; j++){
              if (tstr[j] == '}'){
                if (layers == 0){
                  tstr[j] = 0;
                  break;
                }else{
                  layers--;
                }
              }
              if (tstr[j] == '{'){
                 layers++;
              }
              if (tstr[j] == separator2[0]){
                num_of_conma++;
              }
            }

            tstr[j] = 0;
            WSCstring t(tstr,WS_EN_UTF8);
            data->_op.setString(t.getString());
            data->setCascaded(True,separator,separator2);
            i +=(t.getWords(separator2)-1);
            
          }else{
            data->_op.setString(opstr.getString());

            WSCstring scstr = item.getWord(2,separator);
            data->_sc.setString(scstr.getString());
            WSCstring idstr = item.getWord(3,separator);
            data->_id = atoi(idstr.getString());
            //--- [20041015]
            WSCstring pxstr = item.getWord(4,separator);
            data->_px.setString(pxstr.getString());
            //---
          }
        }
      }
    }
    return ptr;
};

WSMFpropertyValueChange( WSCpulldownMenuPopup, WSNpixmapStyle, WSCuchar, WS_DYNAMIC_PIXMAP ) ;
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNforeColor,short,WS_DF_MENUFORECOLOR);
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNbackColor,short,WS_DF_MENUBACKCOLOR);
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNtopShadowColor,short,WS_DF_MENUTOPSHADOWCOLOR);
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNbottomShadowColor,short,WS_DF_MENUBOTTOMSHADOWCOLOR);
WSMFpropertyValueChange(WSCpulldownMenuPopup,WSNshadowThickness,WSCuchar,2);



WSCpulldownMenuPopup::WSCpulldownMenuPopup(WSCbase* base, char* objname):
                  WSCwindow(base, objname){
  _next_popup = False;
  _id_value = 0;
  _parent_pld_menu = NULL;
  _selected = False;
  _pld_data = NULL;
  _menu_string = WSGFstrdup(""); 
  _item_height = 30;
  _font = (char)WSGIappFontSet()->getDefaultFontNo();
  _selected_item = WS_NO_SELECTED;
  _items = 0;
  _wait_child_popup = 0;
//--- [20041015]
  _use_pixmap = False;
//---

  _fg_no = WS_DF_MENUFORECOLOR;
  _bg_no = WS_DF_MENUBACKCOLOR;
  _ts_no = WS_DF_MENUTOPSHADOWCOLOR;
  _bs_no = WS_DF_MENUBOTTOMSHADOWCOLOR;
  _separator = WSGFstrdup(":"); 
  _separator2 = WSGFstrdup(","); 

  _shadow_thick = 2;
  _mouse_no_check = 0;
  _emboss = False;

  WSGIappObjectList()->addEvent(this,WSEV_GUI_POLICY_CH);

  WSMFpropertyCreateStart
  
    WSMFpropertyCreate(WSNmenuItems,   char*,    _menu_string,WSSmenuItems );
    WSMFpropertyCreate(WSNmenuItemHeight,WSCushort,_item_height,WSSmenuItemHeight);
    WSMFpropertyCreate(WSNfont, WSCuchar, _font,WSSfont );
    WSMFpropertyCreate(WSNseparator,   char*,    _separator,WSSseparator );
    WSMFpropertyCreate(WSNseparator2,   char*,    _separator2,WSSseparator2 );
    WSMFpropertyValueChangeDef( WSCpulldownMenuPopup, WSNpixmapStyle, WSCuchar ) ;
    WSMFpropertyDelete(WSNtitleBar);

    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNforeColor,short);
    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNbackColor,short);
    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNtopShadowColor,short);
    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNbottomShadowColor,short);
    WSMFpropertyValueChangeDef(WSCpulldownMenuPopup,WSNshadowThickness,WSCuchar);
    WSMFpropertyVisibleOff( WSNindicatorOn );
    WSMFpropertyVisibleOff( WSNmargin );
    WSMFpropertyVisibleOff( WSNmarginLeft );
    WSMFpropertyVisibleOff( WSNbarThickness );
//   WSMFpropertyVisibleOff( WSNemboss );

  WSMFpropertyCreateEnd
}

WSMFproperty( WSCpulldownMenuPopup, WSNmenuItems,      char*,          _menu_string,WSGFstrdup("")); 
WSMFproperty( WSCpulldownMenuPopup, WSNmenuItemHeight, WSCushort, _item_height,30); 
WSMFproperty( WSCpulldownMenuPopup, WSNfont,           WSCuchar,           _font,       (char)WSGIappFontSet()->getDefaultFontNo()); 
WSMFproperty( WSCpulldownMenuPopup, WSNseparator, char*, _separator,WSGFstrdup(":")); 
WSMFproperty( WSCpulldownMenuPopup, WSNseparator2, char*, _separator2,WSGFstrdup(",")); 

void WSCpulldownMenuPopup::setWorkWSNemboss(WSCbool fl){
  setEmboss(fl);
}
void WSCpulldownMenuPopup::setWorkWSNwidth(WSCushort data){
  WSCwindow::setWorkWSNwidth(data);
  if (getVisible() != False){
    setAbsoluteDraw(True);
    redraw();
  }
}
void WSCpulldownMenuPopup::setWorkWSNheight(WSCushort data){
  WSCwindow::setWorkWSNheight(data);
  if (getVisible() != False){
    setAbsoluteDraw(True);
    redraw();
  }
}
void WSCpulldownMenuPopup::setWorkWSNmenuItems(char* data){
  if (_pld_data != NULL){
    WSCpulldownData* old = (WSCpulldownData*)_pld_data;
    delete old;
  }
  _pld_data = WSCpulldownData::parse(data,_separator,_separator2);
}

void WSCpulldownMenuPopup::getWorkWSNmenuItems(char** ){}
void WSCpulldownMenuPopup::setWorkWSNseparator(char* data){
  if (_pld_data != NULL){
    WSCpulldownData* old = (WSCpulldownData*)_pld_data;
    delete old;
  }
  _pld_data = WSCpulldownData::parse(_menu_string,_separator,_separator2);
}
void WSCpulldownMenuPopup::getWorkWSNseparator(char** ){}

void WSCpulldownMenuPopup::setWorkWSNseparator2(char* data){
  if (_pld_data != NULL){
    WSCpulldownData* old = (WSCpulldownData*)_pld_data;
    delete old;
  }
  _pld_data = WSCpulldownData::parse(_menu_string,_separator,_separator2);
}
void WSCpulldownMenuPopup::getWorkWSNseparator2(char** ){}

void WSCpulldownMenuPopup::setWorkWSNmenuItemHeight(WSCushort ){}
void WSCpulldownMenuPopup::getWorkWSNmenuItemHeight(WSCushort* ){}
void WSCpulldownMenuPopup::setWorkWSNfont(WSCuchar){}
void WSCpulldownMenuPopup::getWorkWSNfont(WSCuchar* ){}

long WSCpulldownMenuPopup::initialize(){
  WSCwindow::initialize();
  setPropertyV(WSNpixmapStyle, (WSCuchar)WS_DYNAMIC_PIXMAP);

  return WS_NO_ERR;
}

WSCpulldownMenuPopup::~WSCpulldownMenuPopup(){
  WSGIappObjectList()->delEvent(this,WSEV_GUI_POLICY_CH);

  long num = _child_pld_list.getNum();
  long i;
  for(i=0; i <num; i++){
    WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
    delete child_popup;
  }
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    delete data;
  }
  delete[] _menu_string;
}

void WSCpulldownMenuPopup::onResize(WSCrect* rect){
//printf("WSCpulldownMenuPopup::onResize %d,%d,%d,%d XXZZy16\n",rect->x,rect->y,rect->width,rect->height);
}
long WSCpulldownMenuPopup::_device_initialize(){
  WSCwindow::_device_initialize();
  WSCbool val = True;
  if (_dev != NULL){
    _dev->setValue(WSDEV_NO_FRAME,(void*)&val);
    _dev->setValue(WSDEV_FLOAT_ON_TOP,(void*)&val);
  }
  return WS_NO_ERR;
}

long WSCpulldownMenuPopup::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  short x = _x;
  short y = _y;
  short px = 0, py = 0;
  WSCushort w = _w;
  WSCushort h = _h;
  WSGIappMouse()->getMousePosition(&px, &py);
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  if (_pld_data == NULL){
    return WS_NO_ERR;
  }
  WSCbool absolute = getAbsoluteDraw(); 
  if (absolute == False && dev->isExposed(0, 0, w, h) == False){
    return WS_NO_ERR;
  }
  if (WSGIappDev()->getExtGuiPolicySelected() != False){
    if (_ext_draw_proc == NULL){
      _ext_draw_proc = (void(*)(void*))WSGIappDev()->
                             getExtGuiPolicyProc("WSCpulldownMenuPopup::draw");
    }
    if (_ext_draw_proc != NULL){
      WSCpulldownMenuPopup_draw_struct st;
      st._this = this;
      st.dev = dev;
      st.x = _x;
      st.y = _y;
      st.width = _w;
      st.height = _h;
      st.shadow_thickness = _shadow_thick;
      st.shadow_type = _shadow_type;
      st.fore_color = _fg_no;
      st.back_color = _bg_no;
      st.top_shadow_color = _ts_no;
      st.bottom_shadow_color = _bs_no;
      st.back_pixmap = _bp_no;
#ifndef NO_GRADATION
      st.gradation = _grad_no;
      st.gradation_margin = _grad_margin;
#endif
      st.menu_string = _menu_string;
      st.separator = _separator;
      st.separator2 = _separator2;
      st.item_height = _item_height;
      st.prc_name = _prc_name;
      st.id_value = _id_value;
      st.selected_item = _selected_item;
      st.items = _items;
      st.font =  _font;
      st.selected = _selected;
      st.next_popup = _next_popup;
      st.emboss = _emboss;
      st.mouse_no_check = _mouse_no_check;
      st.wait_child_popup = _wait_child_popup;
      st.child_popup_waited = _child_popup_waited;

      _ext_draw_proc(&st);

      updateChild();
      _mouse_no_check = 0;

      return WS_NO_ERR;
    }
  }
  WSCushort st = _shadow_thick;

  if (st > 0){
    long err = dev->beginDraw(0, 0, w, h, absolute);
    if (err != WS_NO_ERR){
      return WS_NO_ERR;
    }

    WSCbase::update();
    setAbsoluteDraw(False);

    dev->setForeColor(_bg_no);
    dev->drawFillRect(0, 0, w, h);
    WSGFdrawShadow(dev,_shadow_type,st,_fg_no, _ts_no, _bs_no,_bg_no,0,0,w,h);

    WSCstring str(_menu_string);  
    long num = str.getWords(_separator2);    
    long i;
    short posy = st;
    long child_cnt = 0;

    WSCpulldownMenuPopup* target = this;
    while(target->getParentMenu() != NULL){
      target = target->getParentMenu();
    }
    target->_prc_name.setString("");
    target->_selected = False;

    WSCpulldownData* own_pld = (WSCpulldownData*)_pld_data;
    WSCpulldownData* pld = (WSCpulldownData*)target->_pld_data;

    if (pld == NULL || own_pld == NULL){
WSMFtrace("WSCpulldownMenuPopup::draw ERROR.target->_pld_data is NULL!    %s\n",getInstanceName());
    }
    _child_popup_waited = False;
    WSCbool exist_toggle =  own_pld->_is_toggle(get_parent_pld_data());
    long cnt = 0;
    for(i=0; i < num; i++){
      WSCpulldownData* targetitem = own_pld->getItem(cnt);
      long itemid = -1;
      if (targetitem != NULL){
        itemid = targetitem->_id;
      }

      WSCstring item = str.getWord(i, _separator2);
      WSCstring item_str = item.getWord(0, _separator);

      WSCstring space(" ");
      WSCushort smargin = WSGIappFontSet()->getStringWidth(_font,&space);

      if (!strcmp(item_str.getString(),"SP") ||
          !strcmp(item_str.getString(),"SEPARATOR")){

        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          posy += 2;
        }
        dev->setForeColor(_bs_no);
        dev->setLineDashType(0);
        dev->setLineWidth(1);
        dev->setHatchPattern(0);

        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          dev->drawLine(st,posy,w-st,posy);
          dev->setForeColor(_ts_no);
          dev->drawLine(st,posy+1,w-st,posy+1);
        }else if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          dev->drawLine(st+1,posy,w-st-2,posy);
          dev->setForeColor(_ts_no);
          dev->drawLine(st+1,posy+1,w-st*2-2,posy+1);
        }
        posy += st*2;
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          posy += 2;
        }
      }else{
        WSCbool is_toggle =  own_pld->_get_toggle(cnt,get_parent_pld_data());
        if ( _selected_item == -1){
          _selected_item = _items -1;
        }else
        if ( _selected_item > _items -1){
          _selected_item = 0;
        }
        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + _item_height && _mouse_no_check == 0) ||
             (_mouse_no_check != 0 && cnt == _selected_item) ){

          if (own_pld->_get_sensitive(cnt,get_parent_pld_data()) != False){ 
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
              dev->setHatchPattern(0);
              dev->setForeColor(
                   WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTCOLOR));
              dev->drawFillRect( st+1,posy+1,w-st*2 -2, _item_height-2);
              dev->setForeColor(_fg_no);
            }
          }
        }

        WSCstring _accel_str(item_str);
        _accel_str.to_lower();
        WSCstring _accel_char = item.getWord(2, _separator);
        _accel_char.to_lower();
        // We determinate _sc_str position
        int _char_pos = _accel_str.isExist(_accel_char);
#if 0
        int _accel_x;
        int _char_long;
        WSCstring str1 = "__";
        WSDfont* _accel_font = WSGIappFontSet()->getFont(_font);
#endif
        dev->setForeColor(_fg_no);
        if ( own_pld->_get_sensitive(cnt,get_parent_pld_data()) == False) {
          if (getEmboss() != False){
            dev->setForeColor(_ts_no);

            // If it is in on string, we have a short cut key to show
            long offsetx = 0;
            if (get_use_pixmap() != False){
              offsetx = 32;
            }
            //for toggle function.
            if (exist_toggle != False){
              offsetx += 32;
            }
	
            if(_char_pos > -1 ){
#if 0
              _accel_str = item_str;
              _accel_str.cutString(_char_pos);
              _accel_x = _accel_font->getStringWidth(_accel_str);
              _accel_char = item_str;
              _accel_char.deleteChars(0,_char_pos);
              _accel_char.cutString(1);
              _char_long = _accel_font->getStringWidth(_accel_char);
              dev->drawString((st*2 + smargin/2)+_accel_x+offsetx,
                              posy +st+2,
                              _char_long, _item_height -st*2,
                              &str1, _font, WS_LEFT, -1, False);
#endif
              dev->setUnderLineChar(_char_pos,1);
            }else{
              dev->setUnderLineChar(0,0);
	        }

            dev->drawString(st*2 + smargin/2+1+offsetx, posy +st+1,
                     w -st*4 - smargin, _item_height -st*2, &item_str,
                     _font, WS_LEFT, -1, False);
          }else{
            dev->setHatchPattern(8);
          }
        } else {
          dev->setHatchPattern(0);
        }
        if (is_toggle != False){
          long xpos = st*2 ;
          long ih = _item_height *2/3;
          long ypos = posy + (_item_height - ih)/2;
          WSGFdrawShadow(dev, WS_SHADOW_IN, st,
                   _fg_no, _ts_no, _bs_no,_bg_no,
                   xpos, ypos , ih, ih);
        }
        if (getEmboss() != False &&
            own_pld->_get_sensitive(cnt,get_parent_pld_data()) == False){
          dev->setForeColor(_bs_no);
        }else{
          dev->setForeColor(_fg_no);
        }
        if (is_toggle != False){
          long xpos = st*2 ;
          long ih = _item_height *2/3;
          long ypos = posy + (_item_height - ih)/2;
          if ( own_pld->_get_toggle_state(cnt,get_parent_pld_data()) != False){
            WSCpoint pt[6];
            long iw = ih -st*2;
            pt[0].x = xpos + st + iw/4;
            pt[0].y = ypos + st + iw/4;
            pt[1].x = xpos + st;
            pt[1].y = ypos + st + iw/2;
            pt[2].x = xpos + ih/2;
            pt[2].y = ypos + ih - st;
            pt[3].x = xpos + ih - st;
            pt[3].y = ypos + st;
            pt[4].x = xpos + ih/2;
            pt[4].y = ypos + ih/2;
            dev->drawFillPoly(pt,5);
          }
        }
        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + _item_height && _mouse_no_check == 0) ||
             (_mouse_no_check != 0 && cnt == _selected_item) ){

          if (own_pld->_get_sensitive(cnt,get_parent_pld_data()) != False){ 
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
              dev->setForeColor(
               WSGIappColorSet()->getDefaultColorNo(WS_DF_MENUSELECTFORECOLOR));
            }
          }
        }

        long offsetx = 0;
        if (get_use_pixmap() != False){
          offsetx = 32;
        }
        //for toggle function.
        if (exist_toggle != False){
          offsetx += 32;
        }
        // If it is in on string, we have a short cut key to show
        if(_char_pos > -1 ){
#if 0
          _accel_str = item_str;
          _accel_str.cutString(_char_pos);

          _accel_x = _accel_font->getStringWidth(_accel_str);
          _accel_char = item_str;
          _accel_char.deleteChars(0,_char_pos);
          _accel_char.cutString(1);
          _char_long = _accel_font->getStringWidth(_accel_char);
          dev->drawString((st*2 + smargin/2)+_accel_x+offsetx, posy +st+1,
                           _char_long, _item_height -st*2,
                           &str1, _font, WS_LEFT, -1, False);
#endif
          dev->setUnderLineChar(_char_pos,1);
        }else{
          dev->setUnderLineChar(0,0);
        }

        if ( is_toggle != False) {
        }else
        if (get_use_pixmap() != False){
          WSCstring tmp_second_opt = item.getWord(1, _separator);
          if ((strlen(item.getWord(4, _separator).getString()) > 0) &&
              !(strchr(tmp_second_opt.getString(), '{'))){
            WSDimage *image = NULL;
            image = WSGIappImageSet()->getImage(item.getWord(4, _separator));
            dev->drawImage (st*2 + smargin/2-smargin/2,posy +st,
                            offsetx, _item_height -st*2, image, WS_LEFT);
          }
        }
        dev->drawString(st*2 + smargin/2+offsetx, posy +st, w -st*4 - smargin,
                   _item_height -st*2, &item_str, _font, WS_LEFT, -1, False);

        if ( (x < px && px < x+w && y + posy < py &&
              py < y + posy + _item_height && _mouse_no_check == 0) ||
             (_mouse_no_check != 0 && cnt == _selected_item) ){

          if (own_pld->_get_sensitive(cnt,get_parent_pld_data()) != False){
            _selected_item = cnt;
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              WSGFdrawBtnShadow(dev, _shadow_type, st, _fg_no, _ts_no,
                         _bs_no,_bg_no,
                         st, posy, w-st*2, _item_height);
            }
          }
          WSCstring item_prc_name = item.getWord(1, _separator);
          if (!strncmp(item_prc_name.getString(),"{",1)){
            
            WSCpoint pt[3];
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              pt[0].x = w - 15;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 15;
              pt[1].y = _item_height /2 -5 + posy;
              pt[2].x = w - 15 +10;
              pt[2].y = _item_height /2 + posy;
              dev->setForeColor(_fg_no);
              dev->drawFillPoly(pt,3);
              dev->setLineWidth(1);
              dev->setForeColor(_bs_no);
              dev->drawPoly(pt,3);
            }else if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
              pt[0].x = w - 10;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 10;
              pt[1].y = _item_height /2 -5 + posy;
              pt[2].x = w - 10 +5;
              pt[2].y = _item_height /2 + posy;
              dev->setForeColor(_fg_no);
              dev->drawFillPoly(pt,3);
            }

            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              pt[0].x = w - 15;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 15 +10;
              pt[1].y = _item_height /2 + posy;
              dev->setForeColor(_ts_no);
              dev->drawPoly(pt,2);
            }
            long wpos = str.getWordCharPos(i, _separator2);
            WSCstring tmp(_menu_string);
            if (wpos > -1){
              tmp.deleteChars(0,wpos);
            }
            wpos = tmp.getWordCharPos(1,"{");
            if (wpos > -1){
              tmp.deleteChars(0,wpos);
            }
            char* tstr = tmp.getString(WS_EN_UTF8);
            long len = strlen(tstr);
            long num_of_conma = 0;
            long j;
            long layers = 0;
            for(j=0; j< len; j++){
              if (tstr[j] == '}'){
                if (layers == 0){
                  tstr[j] = 0;
                  break;
                }else{
                  layers--;
                }
              }
              if (tstr[j] == '{'){
                layers++;
              }
              if (tstr[j] == _separator2[0]){
                num_of_conma++;
              }
            }

            i += num_of_conma;
            if (_wait_child_popup == 0){
              if (own_pld->_get_sensitive(cnt,get_parent_pld_data()) != False){
                WSCstring t(tstr,WS_EN_UTF8);
                popupChildPld(child_cnt,t.getString(),x+w,y+posy);
              }
            }else{
              _child_popup_waited = True;
            }
            child_cnt++;

          }else{
            if ( checkChildStatus() == False &&
                 own_pld->_get_sensitive(cnt,get_parent_pld_data()) != False) {
              target->_prc_name.setString( item_prc_name.getString() );
              target->_selected = True;
            }
          }

          WSCstring id_str = item.getWord(3, _separator);
          target->_id_value = atoi(id_str.getString());
        }else{
          WSCstring item_prc_name = item.getWord(1, _separator);
          if (!strncmp(item_prc_name.getString(),"{",1)){

            WSCpoint pt[3];
            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              pt[0].x = w - 15;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 15;
              pt[1].y = _item_height /2 -5 + posy;
              pt[2].x = w - 15 +10;
              pt[2].y = _item_height /2 + posy;
              dev->setForeColor(_fg_no);
              dev->drawFillPoly(pt,3);
              dev->setLineWidth(1);
              dev->setForeColor(_bs_no);
              dev->drawPoly(pt,3);
            }else if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
              pt[0].x = w - 10;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 10;
              pt[1].y = _item_height /2 -5 + posy;
              pt[2].x = w - 10 +5;
              pt[2].y = _item_height /2 + posy;
              dev->setForeColor(_fg_no);
              dev->drawFillPoly(pt,3);
            }

            if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
              pt[0].x = w - 15;
              pt[0].y = _item_height /2 +5 + posy;
              pt[1].x = w - 15 +10;
              pt[1].y = _item_height /2 + posy;
              dev->setForeColor(_ts_no);
              dev->drawPoly(pt,2);
            }
            long wpos = str.getWordCharPos(i, _separator2);
            WSCstring tmp(_menu_string);
            if (wpos > -1){
              tmp.deleteChars(0,wpos);
            }
            wpos = tmp.getWordCharPos(1,"{");
            if (wpos > -1){
              tmp.deleteChars(0,wpos);
            }
            char* tstr = tmp.getString(WS_EN_UTF8);
            long len = strlen(tstr);
            long num_of_conma = 0;
            long j;
            long layers = 0;
            for(j=0; j< len; j++){
              if (tstr[j] == '}'){
                if (layers == 0){
                  tstr[j] = 0;
                  break;
                }else{
                  layers--;
                }
              }
              if (tstr[j] == '{'){
                 layers++;
              }
              if (tstr[j] == _separator2[0]){
                num_of_conma++;
              }
            }

            i += num_of_conma; // skip of "," in { }
            long num1 = _child_pld_list.getNum();
            WSCpulldownMenuPopup* child_popup = NULL;
            if (child_cnt < num1){
              child_popup = (WSCpulldownMenuPopup*)_child_pld_list[child_cnt];
            }
            if ( x < px  && px < x+w  &&
                 y < py  && py < y+h &&
                 child_popup != NULL && child_popup->getVisible() != False){
              popdownChildPld(child_cnt);
            }
            child_cnt++;
          }
          if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
            WSGFdrawShadow(dev, _shadow_type, st, _bg_no, _bg_no, _bg_no,_bg_no,
                         st, posy, w-st*2, _item_height,True);
          }
        }
        posy += _item_height;
        cnt++;
      }
    }
    _items = cnt;
    dev->endDraw();
  }

  updateChild();

  _mouse_no_check = 0;

  return WS_NO_ERR;

}

void WSCpulldownMenuPopup::popdownChildPld(short childnum){
  WSCpulldownMenuPopup* child = (WSCpulldownMenuPopup*)_child_pld_list.getData(childnum);
  if (child != NULL && child->getVisible() == True){
     child->setVisible(False);
  }
}
WSCbool WSCpulldownMenuPopup::isToggle(){
  WSCpulldownData* own_pld = (WSCpulldownData*)get_pld_data();
//printf("WSCpulldownMenuPopup::isToggle this=0x%x pld=0x%x parent=0x%x p=0x%x\n",this,own_pld,get_parent_pld_data(),_parent_pld_menu);
  if (own_pld != NULL){
    return own_pld->_is_toggle(get_parent_pld_data());
  }
  return False;
}
void WSCpulldownMenuPopup::popupChildPld(short childnum,char* menustr,short x,short y){
  WSCushort ww = 0;
  WSCushort len = 0;
  WSCushort st = _shadow_thick;
  WSCushort hh = st*2;
  WSCbool cascaded = False;

  WSCstring str(menustr);  
  WSDfont* fn = WSGIappFontSet()->getFont(_font);
  //--- [20041015]
  // We use this variable to determinate if menu will use
  // any pixmap on any option
  WSCbool use_pixmap = False;
  //---
  
  long num = str.getWords(_separator2);
  long i;
  for(i=0; i<num; i++){
    WSCstring item = str.getWord(i, _separator2);
    WSCstring itemName = item.getWord(0, _separator);
    WSCstring itemPrc = item.getWord(1, _separator);

    if (!strcmp(itemName.getString(),"SP") ||
        !strcmp(itemName.getString(),"SEPARATOR")){
      hh += st*2;
      if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
        hh += 4;
      }
    }else{
      if ( !strncmp(itemPrc.getString(),"{",1) ){
        cascaded = True;
        long wpos = itemPrc.getWordCharPos(i, _separator2);
        WSCstring tmp(str.getString());
        if (wpos > -1){
          tmp.deleteChars(0,wpos);
        }
        wpos = tmp.getWordCharPos(1,"{");
        if (wpos > -1){
          tmp.deleteChars(0,wpos);
        }
        char* tstr = tmp.getString(WS_EN_UTF8);
        long len = strlen(tstr);
        long num_of_conma = 0;
        long j;
        long layers = 0;
        for(j=0; j< len; j++){
          if (tstr[j] == '}'){
            if (layers == 0){
              tstr[j] = 0;
              break;
            }else{
              layers--;
            }
          }
          if (tstr[j] == '{'){
             layers++;
          }
          if (tstr[j] == _separator2[0]){
            num_of_conma++;
          }
        }
        i += num_of_conma;
        hh += _item_height;
      }else{
        hh += _item_height;
      }
    }
//--- [20041015]
    // Here, we have to determinate if puldownMenuPopup of first level
    // will have pixmaps. We need to activate use_pixmap only if there
    // is a fifth option in menu item string and if this menu item string
    // doesn't content a sub-menu. This is, if this menu item string
    // hasn't got "{" symbol at second option.
    WSCstring tmp_second_opt = item.getWord(1, _separator);
    if ((strlen(item.getWord(4, _separator).getString()) > 0) &&
        !(strchr(tmp_second_opt.getString(), '{'))){
    use_pixmap = True;
    }
//---

    if (len < (short)strlen(itemName.getString())) {
      len = (short)strlen(itemName.getString());
      WSCstring space(" ");
      WSCushort smargin = WSGIappFontSet()->getStringWidth(_font,&space);
      ww = (short)fn->getStringWidth(&itemName) + st * 2 + st * 2 + smargin;
    }
  }
  //--- [20041015]
  // Here, if there are pixmaps, we need to make pulldownMenuPopup
  // 24 pixles + smargin widest
  if (use_pixmap != False){
//    WSCstring space(" ");
//    WSCushort smargin = WSGIappFontSet()->getStringWidth(_font,&space);
    ww = ww + 32;
  }
  //---
  //for toggle function.
  if (cascaded != False){
    ww += 30;
  }

  WSCulong dw = WSGIappDev()->getWidth();
  if ( x < dw){
    if ( x + ww > dw){
      WSCushort width;
      getPropertyV(WSNwidth,&width);
      x -= (ww + width);
    }
  }
  WSCulong dh = WSGIappDev()->getHeight();
  if ( y < dh){
    if ( y + hh > dh){
//      WSCushort width;
//      getPropertyV(WSNwidth,&width);
      y -= (y + hh - dh);
    }
  }

  WSCpulldownMenuPopup* child_popup;
  if ( !(childnum < _child_pld_list.getNum()) ){
    child_popup = new WSCpulldownMenuPopup(NULL,"pld-menu-child");
    child_popup->initialize();
    child_popup->setInternalObject(True);
    _child_pld_list.add((void*)child_popup);
  }else{
    child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(childnum);
  }
  if (child_popup->getVisible() == False){
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      child_popup->setPropertyV(WSNx,                x);
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      child_popup->setProperty(WSNx,                x-5);
    }
    child_popup->setPropertyV(WSNy,                y);
    child_popup->setPropertyV(WSNheight,           hh);
    child_popup->setPropertyV(WSNmenuItemHeight,   _item_height);
    child_popup->setPropertyV(WSNseparator,        _separator);
    child_popup->setPropertyV(WSNseparator2,       _separator2);
    child_popup->setPropertyV(WSNmenuItems,        str.getString());
    child_popup->setParentMenu(this);
    if ( child_popup->isToggle() == False || use_pixmap != False){
      child_popup->setPropertyV(WSNwidth,            ww);
    }else{
      child_popup->setProperty(WSNwidth,            (ww+32));
    }

    child_popup->setPropertyV(WSNfont,             (WSCuchar)_font);
    child_popup->setPropertyV(WSNforeColor,        _fg_no);
    child_popup->setPropertyV(WSNbackColor,        _bg_no);
    child_popup->setPropertyV(WSNtopShadowColor,   _ts_no);
    child_popup->setPropertyV(WSNbottomShadowColor,_bs_no);
    child_popup->setPropertyV(WSNshadowType,       (char)_shadow_type);
    child_popup->setPropertyV(WSNshadowThickness,  (WSCuchar)_shadow_thick);
    child_popup->setPropertyV(WSNpixmapStyle,      (WSCuchar)WS_DYNAMIC_PIXMAP);
    child_popup->setEmboss(getEmboss());
    child_popup->_id_value = 0;
    child_popup->setVisible(True);
    //--- [20041015]
    child_popup->set_use_pixmap(use_pixmap);
    //---
  }
}

WSCbool WSCpulldownMenuPopup::checkChildStatus(){
  short px, py;
  WSGIappMouse()->getMousePosition(&px, &py);

  long num = _child_pld_list.getNum();
  long i;
  for(i=0; i <num; i++){
    WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
    if (child_popup->getVisible() != False){
      short x = _w;
	  short y = _y;
      WSCushort w = _w;
	  WSCushort h = _h;
      if (x < px && px < x+w &&
          y < py && py < y+h ){
        return True;
      }
      WSCbool ret = child_popup->checkChildStatus();
      if (ret == True){
        return True;
      }
    }
  }
  return False;
}
WSCpulldownMenuPopup* WSCpulldownMenuPopup::_check_child_status_no_mouse(){
  long num = _child_pld_list.getNum();
  long i;
  for(i=0; i <num; i++){
    WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
    if (child_popup->getVisible() != False){
//      short x = _w;
//      short y = _y;
//      WSCushort w = _w;
//      WSCushort h = _h;
      WSCpulldownMenuPopup* ret = child_popup->_check_child_status_no_mouse();
      if (ret != NULL){
        return ret;
      }
      return child_popup;
    }
  }
  return NULL;
}

void WSCpulldownMenuPopup::updateChild(){
  long num = _child_pld_list.getNum();
  long i;
  for(i=0; i <num; i++){
    WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
    if (child_popup->getVisible() != False){
      child_popup->setAbsoluteDraw(True);
      child_popup->draw();
    }
  }
}

long WSCpulldownMenuPopup::getItems(){
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->getItems();
  }
  return 0;
}

long WSCpulldownMenuPopup::setItemSensitive(short no,WSCbool fl){
  long ret = WS_ERR2;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->setSensitive(no,fl);
  }
  return ret;
}

long WSCpulldownMenuPopup::setValueSensitive(short id,WSCbool fl){
  long ret = WS_ERR2;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->setSensitiveWithId(id,fl);
  }
  return ret;
}
WSCbool WSCpulldownMenuPopup::getValueSensitive(short id){
  WSCbool ret = False;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->_get_sensitive_with_id(id,get_parent_pld_data());
  }
  return ret;
}
long WSCpulldownMenuPopup::setValueToggleMenu(short id,WSCbool fl){
  long ret = WS_ERR2;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
//printf("WSCpulldownMenuPopup::setValueToggleMenu this=0x%x pld=0x%x id=%d fl=%d!\n",this,data,id,fl);
    return data->setToggleWithId(id,fl);
  }
  return ret;
}
WSCbool WSCpulldownMenuPopup::getValueToggleMenu(short id){
  WSCbool ret = False;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->_get_toggle_with_id(id,get_parent_pld_data());
  }
  return ret;
}
long WSCpulldownMenuPopup::setValueToggleState(short id,WSCbool fl){
  long ret = WS_ERR2;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->setToggleStateWithId(id,fl);
  }
  return ret;
}
WSCbool WSCpulldownMenuPopup::getValueToggleState(short id){
  WSCbool ret = False;
  if (_pld_data != NULL){
    WSCpulldownData* data = (WSCpulldownData*) _pld_data;
    return data->_get_toggle_state_with_id(id,get_parent_pld_data());
  }
  return ret;
}


void WSCpulldownMenuPopup::onVisibleChange(WSCbool fl){
  if (fl != False){
    _selected_item = WS_NO_SELECTED;
    WSDdev* dev = getowndev();
    if (dev == NULL){
      WSDdev* new_dev = attachdev();
      if (new_dev != NULL){
        char title_bar = WS_NO_TITLE;
        new_dev->setValue(WSDEV_TITLE_BAR, (void*)&title_bar);
	    new_dev->setEnableEventBit(_event_mask);
        new_dev->setVisible(True);
      }
    }else{
      dev->setVisible(True);
    }
  }else{
    long num = _child_pld_list.getNum();
    long i;
    for(i=0; i <num; i++){
      WSCpulldownMenuPopup* child_popup = (WSCpulldownMenuPopup*)_child_pld_list.getData(i);
      child_popup->setVisible(False);
    }
    WSCbase::onVisibleChange(fl);
  }
}

WSCbool WSCpulldownMenuPopup::getSelected() {
  return _selected;
}
char* WSCpulldownMenuPopup::getProcName() {
  return _prc_name.getString();
}

WSCbool WSCpulldownMenuPopup::getNextPopup() {
  return _next_popup;
}

void WSCpulldownMenuPopup::setEmboss(WSCbool fl){
  _emboss = fl;
}

WSCbool WSCpulldownMenuPopup::getEmboss(){
  return _emboss;
}

WSCbool* WSCpulldownMenuPopup::getItemSensitive(){
static WSCbool * status_array = NULL;
  if (status_array != NULL){
    delete status_array;
    status_array = NULL;
  }
  WSCpulldownData* data = (WSCpulldownData*)_pld_data;
  if (data != NULL){
    long num = data->getItems();
    long i;
    status_array = new WSCbool[num];
    for(i=0; i<num; i++){
      status_array[i] = data->_get_sensitive(i,get_parent_pld_data());
    }
  }
  return status_array;
}

long WSCpulldownMenuPopup::getValue(){
  return _id_value;
}

void WSCpulldownMenuPopup::setParentMenu(WSCpulldownMenuPopup* parent){
//printf("WSCpulldownMenuPopup::setParentMenu parent=0x%x!!!\n");
  _parent_pld_menu = parent;
}

WSCpulldownMenuPopup* WSCpulldownMenuPopup::getParentMenu(){
  return _parent_pld_menu;
}

WSCuchar WSCpulldownMenuPopup::getFontNo(){
  return _font;
}

WSCushort WSCpulldownMenuPopup::getItemHeight(){
  return _item_height;
}
WSCstring WSCpulldownMenuPopup::_get_proc_name_by_sc(char* sc,int* val){
  WSCstring ret;
  WSCpulldownMenuPopup* child = _check_child_status_no_mouse();
  if (child != NULL && child != this){
    return child->_get_proc_name_by_sc(sc,val);
  }
  WSCpulldownData* own_pld = (WSCpulldownData*)_pld_data;
//  long num = own_pld->getItems();
//  long i;
//  for(i=0; i<num; i++){
  long i=0;
  while(1){
    WSCpulldownData* item = own_pld->getItem(i);
    if (item == NULL){
      break;
    }
    if (!strcmp(item->_sc.getString(),sc) &&
        own_pld->_get_sensitive(i,get_parent_pld_data())){
      *val = item->_id;
      ret = item->_op;
      return ret;
    }
    i++;
  }
  return ret;
}
void WSCpulldownMenuPopup::onKeyPress(WSDkeyboard* keyboard,WSCbool fl){
  long key = keyboard->getKey();
  WSCpulldownMenuPopup* child = _check_child_status_no_mouse();

  if (child != NULL && child != this){
    child->setUserData("KEY_PROCESSED",(void*)0);
    child->onKeyPress(keyboard,fl);
    if (child->getUserData("KEY_PROCESSED") != (void*)0){
      child->setUserData("KEY_PROCESSED",(void*)0);
      setUserData("KEY_PROCESSED",(void*)1);
    }
    return;
  }
  setUserData("KEY_PROCESSED",(void*)0);
  if (key == WSK_Left){
    _child_popup_waited = 0;
    if ( _parent_pld_menu != NULL){
      setUserData("KEY_PROCESSED",(void*)1);
      setVisible(False);
    }
  }else
  if (key == WSK_Right && _child_popup_waited != False){
    _mouse_no_check = 1;
    setUserData("KEY_PROCESSED",(void*)1);
  }else
  if (key == WSK_Down){
    _child_popup_waited = 0;
    _mouse_no_check = 1;
    _wait_child_popup = 1;
    if ( _selected_item == WS_NO_SELECTED){
      _selected_item = 0;
    }else
    if ( _selected_item == -1){
      _selected_item = 0;
    }else{
      _selected_item++;
    }
    if (_selected_item+1 > _items){
      _selected_item = 0;
    }
    WSCpulldownData* own_pld = (WSCpulldownData*)_pld_data;
    while(1){
      if (_selected_item+1 > _items){
        _selected_item = WS_NO_SELECTED;
        break;
      }
      if (own_pld->_get_sensitive(_selected_item,get_parent_pld_data()) == False){
        _selected_item++;
      }else{
        break;
      }
    }
  }else
  if (key == WSK_Up){
    _child_popup_waited = 0;
    _mouse_no_check = 1;
    _wait_child_popup = 1;
    if ( _selected_item == WS_NO_SELECTED){
      _selected_item = -1;
    }else
    if ( _selected_item == 0){
      _selected_item = -1;
    }else{
      _selected_item--;
    }
    if (_selected_item < 0){
      _selected_item = _items -1;
    }
    WSCpulldownData* own_pld = (WSCpulldownData*)_pld_data;
    while(1){
      if (_selected_item < 0){
        _selected_item = WS_NO_SELECTED;
        break;
      }
      if (own_pld->_get_sensitive(_selected_item,get_parent_pld_data()) == False){
        _selected_item--;
      }else{
        break;
      }
    }
  }
  setAbsoluteDraw(True);
  draw();
  _mouse_no_check = 0;
  _wait_child_popup = 0;
}
void WSCpulldownMenuPopup::setSelected(WSCbool fl){
  _selected = fl;
}

void(*WSCpulldownMenuPopup::_ext_draw_proc)(void*) = NULL;
char* WSCpulldownMenuPopup::_policy_name = NULL;

void WSCpulldownMenuPopup::onGuiPolicyChange(long policy){
  WSCbase::onGuiPolicyChange(policy);
  if (WSGIappDev()->getExtGuiPolicySelected() == False){
    _ext_draw_proc = NULL;
  }else{
    if (_policy_name != NULL &&
        !strcmp(_policy_name,(char*)WSGIappDev()->getExtGuiPolicyName())){
    }else{
      _ext_draw_proc = (void(*)(void*))WSGIappDev()->getExtGuiPolicyProc("WSCpulldownMenuPopup::draw");
      if (_policy_name != NULL){
        delete _policy_name;
      }
      _policy_name = WSGFstrdup(WSGIappDev()->getExtGuiPolicyName());

    }
  }
  needUpdate();
  setAbsoluteDraw(True);
  redraw();
}
void WSCpulldownMenuPopup::set_items(long items){
  _items = items;
}
void WSCpulldownMenuPopup::set_selected(WSCbool fl){
  _selected = fl;
}
void WSCpulldownMenuPopup::set_selected_item(long item){
  _selected_item = item;
}
WSCstring& WSCpulldownMenuPopup::get_prc_name(){
  return _prc_name;
}
WSClistData& WSCpulldownMenuPopup::get_child_pld_list(){
  return _child_pld_list;
}
void* WSCpulldownMenuPopup::get_parent_pld_data(){
  if (_parent_pld_menu == NULL){
    return _pld_data;
  }
  return _parent_pld_menu->get_pld_data();
}
void* WSCpulldownMenuPopup::get_pld_data(){
  return _pld_data;
}
void WSCpulldownMenuPopup::set_child_popup_waited(WSCbool fl){
  _child_popup_waited = fl;
}
void WSCpulldownMenuPopup::set_id_value(long v){
  _id_value = v;
}
//---
WSCbool WSCpulldownMenuPopup::get_use_pixmap()
{
  return _use_pixmap;
}
void WSCpulldownMenuPopup::set_use_pixmap(WSCbool px)
{
  _use_pixmap = px;
  return;
}
//---
#ifdef WS_EMBED
#ifndef NO_EXT_GUI_POLICY
class _gui_policy_register_{
  public: _gui_policy_register_(){
extern void WSCpulldownMenuPopup_draw_mdr1(void*);
    WSGIappGuiPolicy()->setExtGuiPolicyProc("Modern1","WSCpulldownMenuPopup::draw",WSCpulldownMenuPopup_draw_mdr1);
  }
};
static _gui_policy_register_ _run_register;
#endif
#endif
long WSCpulldownMenuPopup::getObjectType(){
  return (WS_TYPE_WINDOW | WS_TYPE_MANAGER | WS_TYPE_FORM | WS_TYPE_MENU_WINDOW);
}

