//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCvklabel.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCimageSet.h>
#include <WSDkeyboard.h>
#include <WSDtimer.h>
#include <WSCfontSet.h>
#include <WSDmouse.h>
#include <WSCpopupMenu.h>
#include <WSClist.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCvklabel,WSCvlabel);
WSMFversion(WSCvklabel,WSCvlabel);

WSCvklabel::WSCvklabel(WSCbase* base,char* objname):
                WSCvlabel(base,objname){

  _register_focus_move();
  _select_color = 0;
  _select_fore_color = 0;
  _select_color_work = 0;
  _select_fore_color_work = 0;
  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvklabel);
    WSMFpropertyCreate(WSNselectColor, short, _select_color_work,WSSselectColor );
    WSMFpropertyCreate(WSNselectForeColor, short, _select_fore_color_work,WSSselectForeColor );

    WSMFaddTrigger(WSEV_KEY_PRESS   );
    WSMFaddTrigger(WSEV_KEY_RELEASE );
    WSMFaddTrigger(WSEV_FOCUS_CH    );
    WSMFaddTrigger(WSEV_ACTIVATE    );

  WSMFpropertyCreateEnd
}
WSMFproperty(WSCvklabel,WSNselectColor, short, _select_color_work ,WS_DF_MENUSELECTCOLOR);
WSMFproperty(WSCvklabel,WSNselectForeColor, short, _select_fore_color_work ,WS_DF_MENUSELECTFORECOLOR);
void WSCvklabel::setWorkWSNselectColor(short ){
  _select_color = _select_color_work;
}
void WSCvklabel::getWorkWSNselectColor(short* ){}
void WSCvklabel::setWorkWSNselectForeColor(short ){
  _select_fore_color = _select_fore_color_work;
}
void WSCvklabel::getWorkWSNselectForeColor(short* ){}

WSCvklabel::~WSCvklabel(){
  if (WSGIappKeyboard()->getFocusInstance() == this){
    WSGIappKeyboard()->resetFocusInputWorkProc();
  }
//  if (getFocus() != False){
//    WSGIappKeyboard()->resetFocusInputWorkProc();
//  }
}

long WSCvklabel::_device_initialize(){
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  dev->setEnableEvent(WSEV_MOUSE_PRESS);

  WSCvlabel::_device_initialize();
  return WS_NO_ERR;
}

long WSCvklabel::draw(){
dbprintf("WSCvklabel::draw %s:%d strart this=0x%x %s\n",__FILE__,__LINE__,this,getInstanceName());
  if (getVisible() == False){
dbprintf("WSCvklabel::draw %s:%d done1 vis=False %s\n",__FILE__,__LINE__,getInstanceName());
    return WS_NO_ERR;
  }
  _hilight_draw = 0;
  if (_parent != NULL){
    WSClist* ptr = (WSClist*)_parent->cast("WSClist");
dbprintf("WSCvklabel::draw %s:%d %s ptr=0x%x\n",__FILE__,__LINE__,getInstanceName(),ptr);
    if (ptr != NULL){
      WSCuchar fl;
      _parent->getPropertyV(WSNtype,&fl);
      set_vk_draw(fl);

      WSCbool fl2;
      _parent->getPropertyV(WSNuseIcon,&fl2);
      if (fl2 == False){
        set_use_icon(False);
      }else{
        set_use_icon(True);
      }
#ifndef NO_INDEX_VARIANT_DATA
      long spos = _parent->getVariantData("mselect-pos2");
#else
      long spos = (long)_parent->getUserData("mselect-pos2");
#endif
      WSCbase* base = ptr->getLabel(spos);
      if (base == this && getFocus() != False){
        _hilight_draw = True;
      }
      if (get_vk_draw() == WS_VERBOSE){
        WSCstring tmp = _parent->getProperty(WSNbarValue);
        if (!strcmp((char*)tmp,"")){
//          set_vk_draw(WS_NORMAL);
          WSCstring str;
          str << (_w + 10);
          set_bar_pos(str);
        }else{
          set_bar_pos(_parent->getProperty(WSNbarValue));
        }
      }
    }
  }

  long ret = WSCvlabel::draw();
  _hilight_draw = 0;
  set_vk_draw(WS_NORMAL);
  set_use_icon(False);
  set_bar_pos("");
dbprintf("WSCvklabel::draw %s:%d done2 this=0x%x %s\n",__FILE__,__LINE__,this,getInstanceName());
  return ret;
}

void WSCvklabel::_key_handler(void* ptr,WSDkeyboard* keyboard,WSCbool fl){
  WSCvklabel* obj = (WSCvklabel*)ptr;
  if (obj->getVisible() == False){
    return;
  }
  if (obj->getSensitive() == False){
    return;
  }
  if (obj->_parent != NULL){
    WSClist* ptr = (WSClist*)obj->_parent->cast("WSClist");
    if (ptr != NULL){
      if (fl != False){
        ptr->onKey(keyboard,True);
        ptr->execProcedure(WSEV_KEY_PRESS);
      }else{
        ptr->onKey(keyboard,False);
        ptr->execProcedure(WSEV_KEY_RELEASE);
      }
    }
  }
  if (fl != False){
    obj->onKey(keyboard,True);
    obj->execProcedure(WSEV_KEY_PRESS);
  }else{
    obj->onKey(keyboard,False);
    obj->execProcedure(WSEV_KEY_RELEASE);
  }
}

void WSCvklabel::onKey(WSDkeyboard* kb,WSCbool fl){
  if (fl == False){
    return;
  }
  if (getParent() != NULL){
    WSClist* list = (WSClist*)getParent()->cast("WSClist");
    if (list != NULL){
      WSCbool mselect = list->getProperty(WSNmultiSelect);
      WSCbool with_shift = kb->withShift();
      WSCbool with_cntl = kb->withCntl();
      WSCulong key =  kb->getKey();
      if (key == WSK_Tab && with_shift == False){
         list->_focus_move(WS_TAB);
         return;
      }
      if (key == WSK_Tab && with_shift != False){
         list->_focus_move(WS_STAB);
         return;
      }
      if (key == WSK_Right){
         list->_focus_move(WS_RIGHT);
         return;
      }
      if (key == WSK_Left){
         list->_focus_move(WS_LEFT);
         return;
      }
      if (key == WSK_space){
        long i;
        WSClistData* lblist = list->getLabels();
        long num = lblist->getNum();
        WSCbool rev = list->getProperty(WSNreverseSelect);
        WSCbase** lbbuf = (WSCbase**)lblist->getBuf();
        for(i=0; i<num; i++){
          WSCbase* lb = (WSCbase*)lbbuf[i];
          WSCvlabel* vklb = (WSCvklabel*)lb->cast("WSCvklabel");
          if (vklb == this){
            list->setSelectPos(i);
            break;
          }
        }
        return;
      }
      if (key != WSK_Down &&
          key != WSK_Up ){
        return;
      }
      long spos = list->getSelectedPos();
      WSCbool not_selected = False;

      if (spos < 0){
        not_selected = True;
        long i;
        WSClistData* lblist = list->getLabels();
        long num = lblist->getNum();
        WSCbase** lbbuf = (WSCbase**)lblist->getBuf();
        for(i=0; i<num; i++){
          WSCbase* lb = (WSCbase*)lbbuf[i];
          WSCvlabel* vklb = (WSCvklabel*)lb->cast("WSCvklabel");
          if (vklb == this){
            spos = i;
          }
        }
      }

      if (spos < 0){
        return;
      }
      if (mselect ==  False){
        if (key == WSK_Down){
          long num = list->getNum();
          long spos2 = spos +1;
          long dpos = spos;
          while(spos2 < num){
            WSCbase* base = list->getLabel(spos2);
            WSCbool fl;
            base->getPropertyV(WSNvis,&fl);
            if (fl != False){
              spos = spos2;
              break;
            }else{
              spos2++;
            }
          }
          if ((spos != dpos) && (spos < num)){
            if (not_selected == False){
              list->setSelectPos(spos);
              list->WSCbase::update();
            }
            WSCbase* base = list->getLabel(spos);
            base->setFocus();
            long bpos = list->getBottomPos();
            if (bpos < spos){
              list->setBottomPos(spos);
            }else{
              long tpos = list->getTopPos();
              if (spos < tpos){
                list->setTopPos(spos);
              }
            }
            if (not_selected != False){
              list->resetUpdateFlag();
#ifndef NO_INDEX_VARIANT_DATA
              list->setVariantData("mselect-pos1",spos);
              list->setVariantData("mselect-pos2",spos);
#else
              list->setUserData("mselect-pos1",(void*)spos);
              list->setUserData("mselect-pos2",(void*)spos);
#endif
              base->redraw();
            }
          }
          if (spos == dpos){
            list->_focus_move(WS_DOWN);
            return;
          }
        }else
        if (key == WSK_Up){
          long spos2 = spos -1;
          long dpos = spos;
          while(spos2 > -1){
            WSCbase* base = list->getLabel(spos2);
            WSCbool fl;
            base->getPropertyV(WSNvis,&fl);
            if (fl != False){
              spos = spos2;
              break;
            }else{
              spos2--;
            }
          }
          if (spos != dpos){
            if (not_selected == False){
              list->setSelectPos(spos);
              list->WSCbase::update();
            }
            WSCbase* base = list->getLabel(spos);
            base->setFocus();
            long tpos = list->getTopPos();
            if (spos < tpos){
              list->setTopPos(spos);
            }else{
              long bpos = list->getBottomPos();
              if (bpos < spos){
                list->setBottomPos(spos);
              }
            }
            if (not_selected != False){
              list->resetUpdateFlag();
#ifndef NO_INDEX_VARIANT_DATA
              list->setVariantData("mselect-pos1",spos);
              list->setVariantData("mselect-pos2",spos);
#else
              list->setUserData("mselect-pos1",(void*)spos);
              list->setUserData("mselect-pos2",(void*)spos);
#endif
              base->redraw();
            }
          }
          if (spos == dpos){
            list->_focus_move(WS_UP);
            return;
          }
        }
      }else{
        if (with_shift == False && with_cntl == False){
#ifndef NO_INDEX_VARIANT_DATA
          spos = (long)list->getVariantData("mselect-pos2");
#else
          spos = (long)list->getUserData("mselect-pos2");
#endif
          WSCbool rev = list->getProperty(WSNreverseSelect);
          if (rev != False){
            list->setProperty(WSNreverseSelect,False);
          }
          list->setProperty(WSNmultiSelect,False);
          if (key == WSK_Down){
            long num = list->getNum();
            long spos2 = spos +1;
            long dpos = spos;
            while(spos2 < num){
              WSCbase* base = list->getLabel(spos2);
              WSCbool fl;
              base->getPropertyV(WSNvis,&fl);
              if (fl != False){
                spos = spos2;
                break;
              }else{
                spos2++;
              }
            }
            if ((spos != dpos) && (spos < num)){
              list->setSelectPos(spos);
              list->resetUpdateFlag();
#ifndef NO_INDEX_VARIANT_DATA
              list->setVariantData("mselect-pos1",spos);
              list->setVariantData("mselect-pos2",spos);
#else
              list->setUserData("mselect-pos1",(void*)spos);
              list->setUserData("mselect-pos2",(void*)spos);
#endif
              WSCbase* base = list->getLabel(spos);
              base->setFocus();
              long bpos = list->getBottomPos();
              if (bpos < spos){
                list->setBottomPos(spos);
              }else{
                long tpos = list->getTopPos();
                if (spos < tpos){
                  list->setTopPos(spos);
                }
              }
              list->resetUpdateFlag();
            }
            list->setProperty(WSNmultiSelect,True);
            if (rev != False){
              list->setProperty(WSNreverseSelect,True);
            }
            list->resetUpdateFlag();
            if (spos == dpos){
              list->_focus_move(WS_DOWN);
              return;
            }
          }else
          if (key == WSK_Up){
            long spos2 = spos -1;
            long dpos = spos;
            while(spos2 > -1){
              WSCbase* base = list->getLabel(spos2);
              WSCbool fl;
              base->getPropertyV(WSNvis,&fl);
              if (fl != False){
                spos = spos2;
                break;
              }else{
                spos2--;
              }
            }
            if (spos != dpos){
              list->setSelectPos(spos);
              list->resetUpdateFlag();
#ifndef NO_INDEX_VARIANT_DATA
              list->setVariantData("mselect-pos1",spos);
              list->setVariantData("mselect-pos2",spos);
#else
              list->setUserData("mselect-pos1",(void*)spos);
              list->setUserData("mselect-pos2",(void*)spos);
#endif
              WSCbase* base = list->getLabel(spos);
              base->setFocus();
              long tpos = list->getTopPos();
              if (spos < tpos){
                list->setTopPos(spos);
              }else{
                long bpos = list->getBottomPos();
                if (bpos < spos){
                  list->setBottomPos(spos);
                }
              }
            }
            list->setProperty(WSNmultiSelect,True);
            if (rev != False){
              list->setProperty(WSNreverseSelect,True);
            }
            list->resetUpdateFlag();
            if (spos == dpos){
              list->_focus_move(WS_UP);
              return;
            }
          }
        }else if (with_shift != False){
#ifndef NO_INDEX_VARIANT_DATA
          long spos1 = list->getVariantData("mselect-pos1");
          long spos2 = list->getVariantData("mselect-pos2");
#else
          long spos1 = (long)list->getUserData("mselect-pos1");
          long spos2 = (long)list->getUserData("mselect-pos2");
#endif
          long dpos = spos2;
          long num = list->getNum();
          if (key == WSK_Down){
            long spos3 = spos2 +1;
            while(spos3 < num){
              WSCbase* base = list->getLabel(spos3);
              WSCbool fl;
              base->getPropertyV(WSNvis,&fl);
              if (fl != False){
                spos2 = spos3;
                break;
              }else{
                spos3++;
              }
            }
          }else
          if (key == WSK_Up){
            long spos3 = spos2 -1;
            while(spos3 > -1){
              WSCbase* base = list->getLabel(spos3);
              WSCbool fl;
              base->getPropertyV(WSNvis,&fl);
              if (fl != False){
                spos2 = spos3;
                break;
              }else{
                spos3--;
              }
            }
          }
          if (spos2 != dpos){
            long bpos = list->getBottomPos();
            if (bpos < spos2){
              list->setBottomPos(spos2);
            }else{
              long tpos = list->getTopPos();
              if (spos2 < tpos){
                list->setTopPos(spos2);
              }
            }
#ifndef NO_INDEX_VARIANT_DATA
            list->setVariantData("mselect-pos2",spos2);
#else
            list->setUserData("mselect-pos2",(void*)spos2);
#endif
            WSCbase* base = list->getLabel(spos2);
            base->setFocus();
            long i;
            for(i=0; i<num; i++){
              if (spos1 < spos2){
                if (spos1 <= i && i <= spos2){
                  list->setSelected(i,True,False);
                }else{
                  list->setSelected(i,False,False);
                }
              }else{
                if (spos2 <= i && i <= spos1){
                  list->setSelected(i,True,False);
                }else{
                  list->setSelected(i,False,False);
                }
              }
            }
            list->WSCbase::update();
            if (list->getEnableActivate() != False){
              list->onActivate();
            }
            list->onItemSelected();
          }
        }else if (with_cntl != False){
          long i;
          WSClistData* lblist = list->getLabels();
          long num = lblist->getNum();
          WSCbool rev = list->getProperty(WSNreverseSelect);
          long pos = -1;
          WSCbase** lbbuf = (WSCbase**)lblist->getBuf();
          for(i=0; i<num; i++){
            WSCbase* lb = (WSCbase*)lbbuf[i];
            WSCvlabel* vklb = (WSCvklabel*)lb->cast("WSCvklabel");
            if (vklb == this){
              pos = i;
              break;
            }
          }
          if (pos != -1){
            long dpos = -1;
            if (key == WSK_Down){
              long pos2 = pos +1;
              while(pos2 < num){
                WSCbase* base = list->getLabel(pos2);
                WSCbool fl;
                base->getPropertyV(WSNvis,&fl);
                if (fl != False){
                  dpos = pos2;
                  break;
                }else{
                  pos2++;
                }
              }
            }else
            if (key == WSK_Up){
              long pos2 = pos -1;
              while(pos2 > -1){
                WSCbase* base = list->getLabel(pos2);
                WSCbool fl;
                base->getPropertyV(WSNvis,&fl);
                if (fl != False){
                  dpos = pos2;
                  break;
                }else{
                  pos2--;
                }
              }
            }
            if (dpos != -1){
              long bpos = list->getBottomPos();
              if (bpos < dpos){
                list->setBottomPos(dpos);
              }
              long tpos = list->getTopPos();
              if (dpos < tpos){
                list->setTopPos(dpos);
              }
#ifndef NO_INDEX_VARIANT_DATA
              list->setVariantData("mselect-pos1",dpos);
              list->setVariantData("mselect-pos2",dpos);
#else
              list->setUserData("mselect-pos1",(void*)dpos);
              list->setUserData("mselect-pos2",(void*)dpos);
#endif
              WSCbase* base = list->getLabel(dpos);
              base->setFocus();
            }
          }
        }
      }
    }else{
      WSCulong key =  kb->getKey();
      WSCbool with_shift = kb->withShift();
      if (key == WSK_Tab && with_shift == False){
         _focus_move(WS_TAB);
         return;
      }
      if (key == WSK_Tab && with_shift != False){
         _focus_move(WS_STAB);
         return;
      }
      if (key == WSK_Right){
         _focus_move(WS_RIGHT);
         return;
      }
      if (key == WSK_Left){
         _focus_move(WS_LEFT);
         return;
      }
      if (key == WSK_Down){
         _focus_move(WS_DOWN);
         return;
      }
      if (key == WSK_Up){
         _focus_move(WS_UP);
        return;
      }
 
    }
  }
}
void WSCvklabel::_focus_move(long direct){
  WSCbase* target = getFocusMoveInstance(direct);
  if (target != NULL){
    target->setFocus();
    target->draw();
  }
}
void WSCvklabel::onMousePress(WSCpoint* point){
//printf("WSCvklabel::onMousePress %s parent=%s\n",getInstanceName(),getParent()->getInstanceName());
  WSCvlabel::onMousePress(point);
  if ( point->x < 0 || _w < point->x  &&
       point->y < 0 || _h < point->y ){
    return;
  }
  if ((WSGIappMouse()->getStatus() & WS_MOUSE_BTN3)){
    if (_parent != NULL){
      WSClist* ptr = (WSClist*)_parent->cast("WSClist");
      if (ptr != NULL){
        long i;
        WSClistData* list = ptr->getLabels();
        long num = list->getNum();
        WSCbase** lbbuf = (WSCbase**)list->getBuf();
        for(i=0; i<num; i++){
          WSCbase* lb = (WSCbase*)lbbuf[i];
          WSCvlabel* vklb = (WSCvklabel*)lb->cast("WSCvklabel");
          if (this == vklb){
            ptr->setPreSelectPos(i);
            break;
          }
        }
      }
    }
    return;
  }
  if (!(WSGIappMouse()->getStatus() & WS_MOUSE_BTN1)){
    return;
  }
  WSCpopupMenu* obj = (WSCpopupMenu*)getUserData("PM-SERVER");
  if (obj != NULL && obj->getVisible() != False){
//printf("return2...\n");
    return;
  } 
  if (_parent != NULL){
    WSClist* ptr = (WSClist*)_parent->cast("WSClist");
    if (ptr != NULL){
      WSCuchar val;
      _parent->getPropertyV(WSNtype,&val);
      long indent = (long)getUserData(WS_LIST_INDENT_LEVEL);
      if (val == WS_TREE &&
          ((long)_h - (long)_shadow_thick*2) * indent < point->x &&
           point->x < (long)_h + ((long)_h - (long)_shadow_thick*2)*indent &&
           0 < point->y && point->y < _h ){
        long value = (long)getUserData(WS_LIST_TREE_OPEN);
        if (value == 0){
          setUserData(WS_LIST_TREE_OPEN,(void*)1);
        }else{
          setUserData(WS_LIST_TREE_OPEN,(void*)0);
        }
        setUserData(WS_LIST_TREE_OPEN_CH,(void*)1);
        ptr->updateList();
//        WSCuchar val = ptr->getProperty(WSNpixmapStyle);
        redraw();
        ptr->cdraw();
      }else{
        long i;
        WSClistData* list = ptr->getLabels();
        long num = list->getNum();
        WSCbool rev = ptr->getProperty(WSNreverseSelect);
        long spos = ptr->getSelectedPos();
        WSCbase** lbbuf = (WSCbase**)list->getBuf();
        for(i=0; i<num; i++){
          WSCbase* lb = (WSCbase*)lbbuf[i];
          WSCvlabel* vklb = (WSCvklabel*)lb->cast("WSCvklabel");
          if (this == vklb){
            if (i != spos || rev != False){
              WSCbool mselect = ptr->getProperty(WSNmultiSelect);
              WSCulong status = WSGIappMouse()->getMouseStatus();
              if (mselect != False &&
                  (status & WS_MOUSE_SHIFT) == False &&
                  (status & WS_MOUSE_CONTROL) == False){
                ptr->setProperty(WSNmultiSelect,False);
              }
              if (mselect != False &&
                  (status & WS_MOUSE_SHIFT) != False){
#ifndef NO_INDEX_VARIANT_DATA
                ptr->setVariantData("mselect-pos2",i);
                long spos1 = ptr->getVariantData("mselect-pos1");
#else
                ptr->setUserData("mselect-pos2",(void*)i);
                long spos1 = (long)ptr->getUserData("mselect-pos1");
#endif
                long spos2 = i;
                long j;
                for(j=0; j<num; j++){
                  if (spos1 < spos2){
                    if (spos1 <= j && j <= spos2){
                      ptr->setSelected(j,True,False);
                    }else{
                      ptr->setSelected(j,False,False);
                    }
                  }else{
                    if (spos2 <= j && j <= spos1){
                      ptr->setSelected(j,True,False);
                    }else{
                      ptr->setSelected(j,False,False);
                    }
                  }
                }
                if (ptr->getEnableActivate() != False){
                  ptr->onActivate();
                }
                ptr->onItemSelected();
                ptr->WSCbase::update();
#ifndef NO_INDEX_VARIANT_DATA
                ptr->setVariantData("mselect-pos1",spos1);
                ptr->setVariantData("mselect-pos2",spos2);
#else
                ptr->setUserData("mselect-pos2",(void*)spos1);
                ptr->setUserData("mselect-pos2",(void*)spos2);
#endif
                WSCbase* base = ptr->getLabel(spos2);
                base->setFocus();
              }else{
                ptr->setSelectPos(i);
                ptr->WSCbase::update();
#ifndef NO_INDEX_VARIANT_DATA
                ptr->setVariantData("mselect-pos1",i);
                ptr->setVariantData("mselect-pos2",i);
#else
                ptr->setUserData("mselect-pos1",(void*)i);
                ptr->setUserData("mselect-pos2",(void*)i);
#endif
                setFocus();
              }
              if (mselect != False &&
                  (status & WS_MOUSE_SHIFT) == False &&
                  (status & WS_MOUSE_CONTROL) == False){
                ptr->setProperty(WSNmultiSelect,True);
              }
            }
//            if (i != spos || rev != False){
//              ptr->cdraw();
//            }
            break;
          }
        }
        onActivate();
      }

    }
  }
  setFocus(True);
}
void WSCvklabel::onMouseDoubleClick(WSCpoint* point){
  WSCvlabel::onMouseDoubleClick(point);
  if ( point->x < 0 || _w < point->x  &&
       point->y < 0 || _h < point->y ){
    return;
  }
  if ((WSGIappMouse()->getStatus() & WS_MOUSE_BTN1)){
    if (_parent != NULL){
      WSClist* ptr = (WSClist*)_parent->cast("WSClist");
      if (ptr != NULL){
        long i;
        WSClistData* list = ptr->getLabels();
        long num = list->getNum();
        WSCbase** lbbuf = (WSCbase**)list->getBuf();
        for(i=0; i<num; i++){
          WSCbase* lb = (WSCbase*)lbbuf[i];
          WSCvlabel* vklb = (WSCvklabel*)lb->cast("WSCvklabel");
          if (this == vklb){
            ptr->onItemDoubleClicked();
            break;
          }
        }
      }
    }
    return;
  }
}
void WSCvklabel::onActivate(){
//  execEventProc(WSEV_ACTIVATE,NULL);
  execProcedure(WSEV_ACTIVATE);
}
void WSCvklabel::onFocusChange(WSCbool fl){
  if (getSensitive() == False && fl != False){
    return;
  }
  if (getParent() != NULL && getParent()->cast("WSClist")){
    WSClist* list = (WSClist*)getParent()->cast("WSClist");
    WSCbool rf = list->getProperty(WSNreturnKeyFocus);
    if (rf != False){
      if (fl == False){
        list->setSpecialFocus(False);
      }else{
        list->setSpecialFocus(True);
      }
    }
    WSCbool mselect = list->getProperty(WSNmultiSelect);
    WSCulong status = WSGIappMouse()->getMouseStatus();
    if (mselect != False &&
       (status & WS_MOUSE_CONTROL) != False){
    }else
    if (mselect != False &&
       (status & WS_MOUSE_SHIFT) != False){
      //keep mselect-pos data..
    }else{
      long spos = list->getSelectedPos();
#ifndef NO_INDEX_VARIANT_DATA
      list->setVariantData("mselect-pos1",spos);
      list->setVariantData("mselect-pos2",spos);
#else
      list->setUserData("mselect-pos1",(void*)spos);
      list->setUserData("mselect-pos2",(void*)spos);
#endif
    }
  }
  if (fl != False){
    WSGIappKeyboard()->setFocusInputWorkProc(_key_handler,NULL,this,this);
  }
  execEventProc(WSEV_FOCUS_CH, NULL);
  setAbsoluteDraw(True);
  draw();
}
