//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCvmeter.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCblink.h>

WSMFguiClassInitialize(WSCvmeter, WSCvpolyAttr);
WSMFversion(WSCvmeter, WSCvpolyAttr);

WSCvmeter::WSCvmeter(WSCbase* base, char* objname):
				WSCvpolyAttr(base, objname){
  _value1 = 80;
  _value2 = 20;
  _orientation = WS_HORIZONTAL;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvmeter);

    WSMFpropertyCreate(WSNvalue1,      WSCuchar, _value1,WSSvalue1);
    WSMFpropertyCreate(WSNvalue2,      WSCuchar, _value2,WSSvalue2);
    WSMFpropertyCreate(WSNorientation, WSCbool,  _orientation,WSSorientation);
    WSMFpropertySetSelection(WSRorientation, WSRorientationD);

  WSMFpropertyCreateEnd
}

WSMFproperty(WSCvmeter, WSNvalue1,      WSCuchar, _value1, 80);
WSMFproperty(WSCvmeter, WSNvalue2,      WSCuchar, _value2, 20);
WSMFproperty(WSCvmeter, WSNorientation, WSCbool,  _orientation, WS_HORIZONTAL);

void WSCvmeter::setWorkWSNvalue1(WSCuchar){}
void WSCvmeter::getWorkWSNvalue1(WSCuchar*){}
void WSCvmeter::setWorkWSNvalue2(WSCuchar){}
void WSCvmeter::getWorkWSNvalue2(WSCuchar*){}
void WSCvmeter::setWorkWSNorientation(WSCbool){}
void WSCvmeter::getWorkWSNorientation(WSCbool*){}

long WSCvmeter::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev*	dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  short xx, yy;
  WSCushort ww, hh;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == True){

  }else
  if (dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);
  if (_bl_fl == True &&
      blinkfore == True &&
      _tw_fl == False){
    return WS_NO_ERR;
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }
  WSCbase::update();
  setAbsoluteDraw(False);

  WSCbool stippled = _stippled;
  WSCushort line_w = _lw;

  xx = (short)line_w / 2;
  yy = (short)line_w / 2;
  ww = w - line_w;
  hh = h - line_w;

  short value1 = _value1;
  short value2 = _value2;

  if (value1 > 100){
    value1 = 100;
  }else if (value1 < 0){
      value1 = 0;
  }

  if(value2 > 100){
    value2 = 100;
  }else if (value2 < 0){
    value2 = 0;
  }

  if(value2 > value1){
    value2 = value1;
  }
  if (value2 != value1){
    long tmp_v1, tmp_v2;
    if (_orientation == WS_VERTICAL) {
      tmp_v1 = yy + hh - value1 * hh / 100;
      tmp_v2 = yy + hh - value2 * hh / 100;
      yy = (short)tmp_v1;
      hh = (WSCushort)(tmp_v2 - tmp_v1);
    }else{
      tmp_v1 = xx + value1 * ww / 100;
      tmp_v2 = xx + value2 * ww / 100;
      xx = (short)tmp_v2;
      ww = (WSCushort)(tmp_v1 - tmp_v2);
    }

    if (line_w == 1) {
      dev->setLineWidth((WSCushort)0);
    }else{
      dev->setLineWidth((WSCushort)line_w);
    }
    dev->setLineDashType(_lt);
  
    if (stippled == True){
      if (_back_color_flag == True){
        if (_blink_type != WS_FORE && _bl_fl == True &&
            blinkfore == True && _tw_fl == True) {
          dev->setForeColor(_back_blink_color);
        } else {
          dev->setForeColor(_back_color);
        }
        dev->setHatchPattern((char)0);
        dev->drawFillRect(xx, yy, ww, hh);
      }
      dev->setHatchPattern(_hatch_pattern);
      if (_blink_type != WS_FORE && _bl_fl == True &&
          blinkfore == True && _tw_fl == True){
        dev->setForeColor(_hatch_blink_color);
      }else{
        dev->setForeColor(_hatch_color);
      }
      dev->drawFillRect(xx, yy, ww, hh);
    }

    if(_blink_type != WS_BACK && _bl_fl == True &&
        blinkfore == True && _tw_fl == True) {
      dev->setForeColor(_blink_color);
    }else{
      dev->setForeColor(_fore_color);
    }

    dev->setHatchPattern((char)0);
  
    if (line_w != 0) {
      dev->drawRect(xx, yy, ww, hh);
    }
  }
  dev->endDraw();

  return WS_NO_ERR;
}
WSCvmeter::~WSCvmeter(){
}
char* WSCvmeter::getDefaultProperty(){
  return WSNvalue2;
}
