//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCstring.h>
#include <WSDdev.h>
#include <WSDfont.h>
#include <WSDappDev.h>

extern "C" {
WSDLEX32 void libwsc_func();
};
void libwsc_func(){
}

#ifdef WS_EMBED
#ifndef NO_EXT_GUI_POLICY
void libwsc_dummy_call(){
extern void _libwsc_extgui_policy();
  _libwsc_extgui_policy();
}
#endif
#endif

long WSGFcalcStringPosFromAddr(WSCushort* istr,WSCrect* area,
            char alignment,WSDfont* font,long x,long y,
            long* pos ,WSCbool intercur){
//printf("WSGFcalcStringPosFromAddr here...\n");
  x -= area->x;
  y -= area->y;
  if (font == NULL){
    *pos = 0;
    return WS_ERR;
  }
  long max = WSGFstrlenUCS2(istr);
  if (max == 0){
    *pos=0;
    return WS_NO_ERR;
  }

  if (intercur == False){
    max--;
  }
  if (max == -1){
    *pos=0;
    return WS_NO_ERR;
  }
//printf("WSGFcalcStringPosFromAddr x=%d y=%d\n",x,y);

//  short fw,fh;
  WSCstring str(" ");
//  fw = font->getStringWidth(&str);
  short fh = font->getStringHeight(&str);
//printf("WSGFcalcStringPosFromAddr fw=%d fh=%d\n",fw,fh);

  long lines = WSGFgetLinesUCS2(istr);
//printf("WSGFcalcStringPosFromAddr lines=%d\n",lines);
  if (alignment == WS_TOP ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_RIGHT_TOP){
    //do nothing
  }else 
  if (alignment == WS_LEFT ||
      alignment == WS_CENTER ||
      alignment == WS_RIGHT){
    long padh = (long)(area->height - fh * lines)/2;
    y -= padh;
  }else 
  if (alignment == WS_BOTTOM ||
      alignment == WS_LEFT_BOTTOM ||
      alignment == WS_RIGHT_BOTTOM ){
    long padh = area->height - fh * lines;
    y -= padh;
  }

  long yline = y / fh;
  
  WSCushort tmp[2];
  tmp[0] = (WSCushort)'\n';
  tmp[1] = 0;
  long ptr = WSGFgetWordCharPosUCS2(istr,yline,tmp);
//printf("WSGFcalcStringPosFromAddr ptr=%d yline=%d y=%d max=%d\n",ptr,yline,y,max);
  if (ptr == -1){
    *pos = max;
    return WS_NO_ERR;
  }
//#if 0//speed up
//#else
//  istr->seek(ptr);
//  WSCstring tstr = istr->gets();
//#endif

  WSCushort* line_str = WSGFgetWordUCS2(istr,yline,tmp);
  long fwidth = font->getStringWidthUCS2(line_str);

  if (alignment == WS_LEFT ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_LEFT_BOTTOM){
    //do nothing.
  }else
  if (alignment == WS_TOP ||
      alignment == WS_CENTER ||
      alignment == WS_BOTTOM){
    x -= (long)(area->width - fwidth)/2;
  }else
  if (alignment == WS_RIGHT ||
      alignment == WS_RIGHT_TOP ||
      alignment == WS_RIGHT_BOTTOM ){
    x -= area->width - fwidth;
  }

  long len = WSGFstrlenUCS2(line_str);
  if (intercur != False){
    len ++;
  }
  *pos = ptr;
  if (x < fwidth){
extern long _calc_rawx_to_pos(WSCushort* str,long x,WSDfont* font);
    long ret = _calc_rawx_to_pos(line_str, x, font);
    delete[] line_str;
    *pos = ptr+ ret;
    if (*pos < WSGFstrlenUCS2(istr)){
    }else{
      *pos =  WSGFstrlenUCS2(istr);
    }
    return WS_NO_ERR;
  }else{
    delete[] line_str;
    *pos = ptr+ len -1;
    if (*pos < WSGFstrlenUCS2(istr)){
    }else{
      *pos =  WSGFstrlenUCS2(istr);
    }
    return WS_NO_ERR;
  }
#if 0
  long p;
  for( p=0; p < len; p++){
    long ox = p * fw;

    long tmpdist = (x-ox)*(x-ox);
    if (dist > tmpdist || dist == -1 ){
      dist = tmpdist;
      *pos = p+ ptr;
    }
  }
#endif
  return WS_NO_ERR;
}

long _calc_rawx_to_pos(WSCushort* str,long x,WSDfont* font){
  long len = WSGFstrlenUCS2(str);
  if (len == 1){
    long fwidth = font->getStringWidthUCS2(str);
    if (x < fwidth/2 ){
      return 0;
    }
    return 1;
  }
  if (len == 0){
    return 0;
  }
  WSCushort* str2 = WSGFstrdupUCS2(str);
  str2[len/2] = 0;
  long fwidth2 = font->getStringWidthUCS2(str2);
  if (x < fwidth2){
    long ret = _calc_rawx_to_pos(str2,x,font);
    delete[] str2;
//printf("_calc_rawx_to_pos ret=%d\n",ret);
    return ret;
  }else{
    delete[] str2;
    str2 = WSGFstrdupUCS2(str);
    long ret = _calc_rawx_to_pos(&str2[len/2],x-fwidth2,font);
    delete[] str2;
//printf("_calc_rawx_to_pos ret+len/2=%d\n",ret+len/2);
    return ret+len/2;
  }
}

long WSGFcalcStringPosAddr(WSCushort* istr,WSCrect* area,
         char alignment,WSDfont* font,long pos,long* ox,long *oy){
  if (pos < 0){
    return WS_ERR;
  }

  long xpos = 0;
  long ypos = 0;
  if (istr == NULL){
    *ox = 0;
    *oy = 0;
    return WS_NO_ERR;
  }
  long ptr = 0;
  long i = 0;
  long k = 0;
  long col = 0;
  long line = 0;
  while(1){
    if (col == pos){
       break;
    }
    if (istr[i] == 0){
      ptr = i;
      break;
    }
    if (istr[i] == '\n'){
      k= 0;
      i++;
      line++;
      ptr = i;
      col++;
      continue;
    }
#if 0
    if(str[i] & 0x80){         //not ascii
      if (str[i] == (char)0x8e){       //ȾѲ̾2byte = 1column
        i++;
      }else if (str[i] == (char)0x8f){ //3byte = 2column
        i++;
        col++;
        k++;
        i++;
      }else{         //2byte = 2column
        col++;
        k++;
        i++;
      }
    }
#endif
    col++;
    k++;
    i++;
  }
  xpos = k;
  ypos = line;
//printf("WSGFcalcStringPosAddr %d %d\n",xpos,ypos);
//  istr->seek(ptr);
  WSCushort* lstr = WSGFstrdupUCS2(&istr[ptr]);
  lstr[xpos] = 0;
  WSCpoint pt;

  long n = line;
  i = ptr;
  while(1){
    if (istr[i] == 0){
      break;
    }
    if (istr[i] == '\n'){
      n++;
    }
    i++;
  }

  if (line > n){
    pt.x = 0;
    pt.y = 0;
    return 0;
  }

//   long fheight = font->getStringHeight(istr);
  long fheight = font->getFontHeight();
  long py = area->y;
  long by = area->height;
  if (alignment == WS_TOP ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_RIGHT_TOP){
    pt.y = py + fheight*line;
  }else
  if (alignment == WS_LEFT ||
      alignment == WS_CENTER ||
      alignment == WS_RIGHT){
    pt.y = py + by/2  - fheight*(line+1)/2 + fheight*line;
  }else
  if (alignment == WS_BOTTOM ||
      alignment == WS_LEFT_BOTTOM ||
      alignment == WS_RIGHT_BOTTOM ){
    pt.y = py + by + fheight*(line -n) ;
  }

  long px = area->x;
  long pw = area->width;
  if (alignment == WS_LEFT ||
      alignment == WS_LEFT_TOP ||
      alignment == WS_LEFT_BOTTOM){
    pt.x = px;
  }else
  if (alignment == WS_TOP ||
      alignment == WS_CENTER ||
      alignment == WS_BOTTOM){
    WSCushort tmp[2];
    tmp[0] = (WSCushort)'\n';
    tmp[1] = (WSCushort)0;
    WSCushort* line_str = WSGFgetWordUCS2(istr,line,tmp);
    long fwidth = font->getStringWidthUCS2(line_str);
    pt.x = px + (pw - fwidth)/2;
  }else
  if (alignment == WS_RIGHT ||
      alignment == WS_RIGHT_TOP ||
      alignment == WS_RIGHT_BOTTOM ){
    WSCushort tmp[2];
    tmp[0] = (WSCushort)'\n';
    tmp[1] = (WSCushort)0;
    WSCushort* line_str = WSGFgetWordUCS2(istr,line,tmp);
    long fwidth = font->getStringWidthUCS2(line_str);
    pt.x = px + pw - fwidth;
  }

  *ox = pt.x + font->getStringWidthUCS2(lstr);
  *oy = pt.y;
  delete[] lstr;
  return WS_NO_ERR;
}
void WSGFdrawArrow(WSDdev* dev,WSCbool fill,
                   WSCushort st,short bg_no,
                   short ts_no,short bs_no,char direction,
                   short x,short y,WSCushort w,WSCushort h ){

    WSCpoint pts[6];
    if (direction == WS_LEFT){
      if (fill == False){
        pts[0].setPoint( x,      y+h/2 );
        pts[1].setPoint( x +w,   y  );
        pts[2].setPoint( x +w,   y+h );
        dev->setForeColor(bg_no);
        dev->drawFillPoly(pts,3);

        pts[0].setPoint( x,      y + h/2 );
        pts[1].setPoint( x+st,   y + h/2 );
        pts[2].setPoint( x+w-st/2, y + st*173/200  );
        pts[3].setPoint( x+w,    y       );
        dev->setForeColor(ts_no);
        dev->drawFillPoly(pts,4);

        pts[0].setPoint( x,      y + h/2 );
        pts[1].setPoint( x+st,   y + h/2 );
        pts[2].setPoint( x+w-st/2, y + h -st*173/200 );
        pts[3].setPoint( x+w-st/2, y + st*173/200  );
        pts[4].setPoint( x+w,    y       );
        pts[5].setPoint( x+w,    y + h   );
        dev->setForeColor(bs_no);
        dev->drawFillPoly(pts,6);
      }else{
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          pts[0].setPoint( x,   y +w/2  );
          pts[1].setPoint( x+w, y       );
          pts[2].setPoint( x+w, y + h   );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pts[0].setPoint( x+w/4,   y +w/2  );
          pts[1].setPoint( x+w*3/4, y       );
          pts[2].setPoint( x+w*3/4, y + h   );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }
      }
    }else if (direction == WS_RIGHT){

      if (fill == False){
        pts[0].setPoint( x,      y );
        pts[1].setPoint( x +w,   y+h/2  );
        pts[2].setPoint( x,   y+h );
        dev->setForeColor(bg_no);
        dev->drawFillPoly(pts,3);

        pts[0].setPoint( x,      y + h   );
        pts[1].setPoint( x,      y       );
        pts[2].setPoint( x+w,    y + h/2 );
        pts[3].setPoint( x+w-st, y + h/2 );
        pts[4].setPoint( x+st/2,   y + st*173/200  );
        pts[5].setPoint( x+st/2,   y +h -st*173/200);
        dev->setForeColor(ts_no);
        dev->drawFillPoly(pts,6);

        pts[0].setPoint( x,      y + h   );
        pts[1].setPoint( x+w,    y + h/2 );
        pts[2].setPoint( x+w-st, y + h/2 );
        pts[3].setPoint( x+st/2,   y +h -st*173/200);
        dev->setForeColor(bs_no);
        dev->drawFillPoly(pts,4);
      }else{
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          pts[0].setPoint( x,   y      );
          pts[1].setPoint( x+w, y +h/2 );
          pts[2].setPoint( x,   y + h  );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pts[0].setPoint( x+w/4,   y      );
          pts[1].setPoint( x+w*3/4, y +h/2 );
          pts[2].setPoint( x+w/4,   y + h  );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }
      }
    }else if (direction == WS_UP){

      if (fill == False){
        pts[0].setPoint( x +w/2,      y );
        pts[1].setPoint( x ,   y+h  );
        pts[2].setPoint( x +w,   y+h );
        dev->setForeColor(bg_no);
        dev->drawFillPoly(pts,3);

        pts[0].setPoint( x,      y + h   );
        pts[1].setPoint( x +w/2, y       );
        pts[2].setPoint( x +w/2, y + st  );
        pts[3].setPoint( x + st*173/200, y +h -st/2);
        dev->setForeColor(ts_no);
        dev->drawFillPoly(pts,4);

        pts[0].setPoint( x,      y + h   );
        pts[1].setPoint( x +w, y + h   );
        pts[2].setPoint( x +w/2, y       );
        pts[3].setPoint( x + w/2,  y + st  );
        pts[4].setPoint( x +w-st*173/200,y+h-st/2  );
        pts[5].setPoint( x + st*173/200, y+h-st/2  );
        dev->setForeColor(bs_no);
        dev->drawFillPoly(pts,6);
      }else{

        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          pts[0].setPoint( x +w/2, y     );
          pts[1].setPoint( x+w,    y +h  );
          pts[2].setPoint( x,      y + h );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pts[0].setPoint( x +w/2, y +h/4   );
          pts[1].setPoint( x+w,    y +h*3/4+1  );
          pts[2].setPoint( x,      y +h*3/4+1 );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }
      }

    }else if (direction == WS_DOWN){

      if (fill == False){
        pts[0].setPoint( x ,      y );
        pts[1].setPoint( x +w,   y  );
        pts[2].setPoint( x +w/2,   y+h );
        dev->setForeColor(bg_no);
        dev->drawFillPoly(pts,3);

        pts[0].setPoint( x +w/2, y + h   );
        pts[1].setPoint( x,      y       );
        pts[2].setPoint( x + w,  y       );
        pts[3].setPoint( x+w-st*173/200, y+st/2  );
        pts[4].setPoint( x+st*173/200,   y+st/2  );
        pts[5].setPoint( x +w/2, y+h-st  );
        dev->setForeColor(ts_no);
        dev->drawFillPoly(pts,6);

        pts[0].setPoint( x +w/2, y + h   );
        pts[1].setPoint( x + w,  y       );
        pts[2].setPoint( x+w-st*173/200, y+st/2  );
        pts[3].setPoint( x +w/2, y+h-st  );
        dev->setForeColor(bs_no);
        dev->drawFillPoly(pts,4);
      }else{

        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
          pts[0].setPoint( x, y  );
          pts[1].setPoint( x + w, y );
          pts[2].setPoint( x + w / 2, y + h );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }else
        if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
          pts[0].setPoint( x, y +h/4  );
          pts[1].setPoint( x + w, y +h/4 );
          pts[2].setPoint( x + w / 2, y + h*3/4 );
          dev->setForeColor(bg_no);
          dev->drawFillPoly(pts,3);
        }
      }
    }
}

long WSGFcalcStringXYPos(WSCushort* istr,long pos,long* xpos,long* ypos){
  long i;
  *ypos = 0;
  *xpos = 0;
  for(i=0; i<pos; i++){
    if (istr[i] == (WSCushort)0){
      break;
    }
    if (istr[i] == (WSCushort)'\n'){
      (*ypos)++;
      (*xpos) = 0;
    }else{
      (*xpos)++;
    }
  }
  return WS_NO_ERR;
}

long WSGFcalcStringXYPosToPos(WSCushort* istr,long xpos,long ypos,long* pos){
  if (istr[0] == 0){
    *pos=0;
//printf("WSGFcalcStringXYPosToPos out pos=%d\n",*pos);
    return WS_NO_ERR;
  }
  if (ypos < 0){
    long lines = 1;
    long i = 0;
    while(1){
      if (istr[i] == (WSCushort)0){
        break;
      }
      if (istr[i] == (WSCushort)'\n'){
        lines++;
      }
      i++;
    }
    ypos = lines -1;
  }
  long lines = 0;
  long ptr = 0;
  while(1){
    if (lines == ypos){
      break;
    }
    if (istr[ptr] == (WSCushort)0){
      break;
    }
    if (istr[ptr] == (WSCushort)'\n'){
      lines++;
    }
    ptr++;
  }
  long x = 0;
  while(1){
    if (xpos == x){
      *pos = ptr;
//printf("WSGFcalcStringXYPosToPos out1 pos=%d\n",*pos);
      return WS_NO_ERR;
    }
    if (istr[ptr] == (WSCushort)0){
      *pos = ptr;
//printf("WSGFcalcStringXYPosToPos out2 pos=%d\n",*pos);
      return WS_NO_ERR;
    }
    if (istr[ptr] == (WSCushort)'\n'){
      *pos = ptr;
//printf("WSGFcalcStringXYPosToPos out3 pos=%d\n",*pos);
      return WS_NO_ERR;
    }
    ptr++;
    x++;
  }
//printf("WSGFcalcStringXYPosToPos out4 pos=%d\n",*pos);
  return WS_NO_ERR;
}

