//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCcomboBox.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCwindow.h>
#include <WSClist.h>
#include <WSDappDev.h>
#include <WSDwindowDev.h>
#include <WSDmouse.h>
#include <WSDprivateTimer.h>
#include <WSCvarrow.h>
#include <WSCvifield.h>
#include <WSCblink.h>
#include <WSCfontSet.h>
#include <WSDkeyboard.h>

WSMFguiClassInitialize(WSCcomboBox,WSCform);
WSMFversion(WSCcomboBox, WSCform);
#define WS_CM_BORDER 2
#define WS_STRETCH_HEIGHT 300
WSMFpropertyValueChange( WSCcomboBox, WSNshadowType , char,WS_SHADOW_IN);

WSCcomboBox::WSCcomboBox(WSCbase* base,char* objname):WSCform(base,objname){
  _register_focus_move();

  _menu_str = WSGFstrdup("item1,item2,item3");
  _max_height = 0;
  _win = NULL;
  _list = NULL;
  _btn = NULL;
  _if = NULL;
  _shadow_type = WS_SHADOW_IN;
  _bg_blink_color = WS_DF_NWBACKCOLOR;
  _work_back_color = WS_DF_WORKBACKCOLOR;
  _font = (char)WSGIappFontSet()->getDefaultFontNo();
  _increment = 10;
  _page_increment = 100;

  _item_height = 20;
  _selected_by_key = False;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCcomboBox);

    WSMFpropertyCreate(WSNmenuItems, char*, _menu_str,WSSmenuItems);
    WSMFpropertyCreate(WSNmaxHeight, WSCushort, _max_height,WSSmaxHeight);

    WSMFpropertyCreate(WSNbackBlinkColor, short, _bg_blink_color,WSSbackBlinkColor);
    WSMFpropertyCreate(WSNworkBackColor,short,_work_back_color,WSSworkBackColor);
    WSMFpropertyCreate(WSNfont,  WSCuchar, _font,WSSfont  );

    WSMFpropertyCreate(WSNitemHeight,  WSCuchar, _item_height,WSSitemHeight  );
    WSMFpropertyCreate(WSNincrement,    WSCushort, _increment,WSSincrement );
    WSMFpropertyCreate(WSNpageIncrement,WSCushort, _page_increment,WSSpageIncrement );

//    WSMFpropertyValueChangeDef( WSCcomboBox,WSNshadowType ,char);
    WSMFpropertyValueChangeDef( WSCcomboBox,WSNshadowType ,char);
    WSMFpropertyDelete(WSNupward);
    WSMFpropertyDelete(WSNdownward);
    WSMFpropertyDelete(WSNreturn);

    WSMFaddTrigger(WSEV_VALUE_CH    );
    WSMFaddTrigger(WSEV_ACTIVATE    );
    WSMFaddTrigger(WSEV_KEY_PRESS    );
    WSMFaddTrigger(WSEV_KEY_RELEASE   );
    WSMFaddTrigger(WSEV_KEY_HOOK   );

  WSMFpropertyCreateEnd
}
WSMFproperty(WSCcomboBox, WSNmenuItems,  char*, _menu_str, WSGFstrdup("item1,item2,item3"));
WSMFproperty(WSCcomboBox, WSNmaxHeight,  WSCushort, _max_height,       0);

WSMFproperty(WSCcomboBox, WSNworkBackColor, short, _work_back_color,WS_DF_NWBACKCOLOR);
WSMFproperty(WSCcomboBox, WSNbackBlinkColor, short, _bg_blink_color,WS_DF_WORKBACKCOLOR);
WSMFproperty(WSCcomboBox, WSNfont,        WSCuchar, _font,(char)WSGIappFontSet()->getDefaultFontNo());
WSMFproperty(WSCcomboBox, WSNitemHeight,     WSCuchar,  _item_height, 20);
WSMFproperty( WSCcomboBox, WSNincrement,     WSCushort, _increment,  10);
WSMFproperty( WSCcomboBox, WSNpageIncrement, WSCushort, _page_increment, 100);

void WSCcomboBox::setWorkWSNdet(WSCbool fl){
  WSCform::setWorkWSNdet(fl);
  if (_if != NULL){
    _if->setPropertyV(WSNdet,fl);
  }
}
void WSCcomboBox::setWorkWSNmenuItems(char*){}
void WSCcomboBox::getWorkWSNmenuItems(char**){}
void WSCcomboBox::setWorkWSNmaxHeight(WSCushort mh){
  if (_list != NULL){
    WSCulong barw = _list->getProperty(WSNbarThickness);
    if (_max_height > 0 && _max_height < barw *4){
      _max_height = barw *4;
    }
  }
}
void WSCcomboBox::getWorkWSNmaxHeight(WSCushort*){}
void WSCcomboBox::setWorkWSNworkBackColor(short data){
  _if->setPropertyV(WSNbackColor,data);
}
void WSCcomboBox::getWorkWSNworkBackColor(short* data){}

void WSCcomboBox::setWorkWSNbackBlinkColor(short data){
  _if->setPropertyV(WSNbackBlinkColor,data);
}
void WSCcomboBox::getWorkWSNbackBlinkColor(short*){}
void WSCcomboBox::setWorkWSNfont(WSCuchar data){
  _if->setPropertyV(WSNfont,data);
  if (_list != NULL){
    _list->setPropertyV(WSNfont,data);
  }
}
void WSCcomboBox::getWorkWSNfont(WSCuchar*){}
void WSCcomboBox::setWorkWSNitemHeight(WSCuchar data){
  if (_list != NULL){
    _list->setProperty(WSNitemHeight,data);
//    _list->setProperty(WSNincrement,data);
//    _list->setProperty(WSNscrollHeight,data-1);
    _list->setProperty(WSNscrollHeight,data);
  }
}
void WSCcomboBox::getWorkWSNitemHeight(WSCuchar*){}
void WSCcomboBox::setWorkWSNincrement(WSCushort val){
  if (_list != NULL){
    _list->setProperty(WSNincrement,val);
  }
}
void WSCcomboBox::getWorkWSNincrement(WSCushort*){}
void WSCcomboBox::setWorkWSNpageIncrement(WSCushort val){
  if (_list != NULL){
    _list->setProperty(WSNpageIncrement,val);
  }
}
void WSCcomboBox::getWorkWSNpageIncrement(WSCushort*){}

WSCcomboBox::~WSCcomboBox(){
  _menu_popdown();
  if (_win != NULL){
#ifndef WS_EMBED
    WSGFcleanupStretchAction(_win);
#endif
  }
  if (_win != NULL){
    delete _win;
  }
  if (_menu_str != NULL){
    delete[] _menu_str;
    _menu_str = NULL;
  }
}

WSCbase* WSCcomboBox::getPropertyInheritChild(){
  return _if;
}

long WSCcomboBox::initialize(){
  WSCform::initialize();
  WSCstring name;
  name = (WSCstring)"cw-btn-" + getInstanceName();
  _btn = new WSCvarrow(this,name);
  _btn->setInternalObject(True);
  _btn->initialize();
  _btn->setPropertyV(WSNarrowDirection,(char)WS_DOWN);
  _btn->setUserData("_CMB",(void*)this);
  WSCprocedure* op = new WSCprocedure("btn proc",WSEV_MOUSE_PRESS);
  op->setInternal(True);
  op->setFunction(_btn_work,"_btn_work");
  _btn->addProcedure(op);
  WSCprocedure* op6 = new WSCprocedure("key proc",WSEV_KEY_PRESS);
  op6->setInternal(True);
  op6->setFunction(_btn_key_press_work,"_btn_key_press_work");
  _btn->addProcedure(op6);

  name = (WSCstring)"cw-if-" + getInstanceName();
  _if = new WSCvifield(this,name);
  _if->setInternalObject(True);
  _if->initialize();
  _if->setPropertyV(WSNx,(short)0);
  _if->setPropertyV(WSNy,(short)0);
  _if->setPropertyV(WSNshadowType,(char)_shadow_type);
  _if->setProperty(WSNenableFocusMove,True);
  _if->setUserData("_CMB",(void*)this);
  WSCprocedure* op2 = new WSCprocedure("key press proc",WSEV_KEY_PRESS);
  op2->setInternal(True);
  op2->setFunction(_key_press_work,"_key_press_work");
  _if->addProcedure(op2);
  WSCprocedure* op3 = new WSCprocedure("key release proc",WSEV_KEY_RELEASE);
  op3->setInternal(True);
  op3->setFunction(_key_release_work,"_key_release_work");
  _if->addProcedure(op3);
  WSCprocedure* op4 = new WSCprocedure("key release proc",WSEV_KEY_HOOK);
  op4->setInternal(True);
  op4->setFunction(_key_hook_work,"_key_hook_work");
  _if->addProcedure(op4);
  WSCprocedure* op5 = new WSCprocedure("value ch proc",WSEV_VALUE_CH);
  op5->setInternal(True);
  op5->setFunction(_value_ch_work,"_value_ch_work");
  _if->addProcedure(op5);

  _btn->setProperty(WSNtab, name);
  _btn->setProperty(WSNbacktab, name);
  _btn->setProperty(WSNupward, name);
  _btn->setProperty(WSNdownward, name);
  _btn->setProperty(WSNleftward, name);
  _btn->setProperty(WSNrightward, name);

  _adjust();

  _btn->setVisible(True);
  _if->setVisible(True);
  return WS_NO_ERR;
}

void WSCcomboBox::setWorkWSNwidth(WSCushort data){
  WSCform::setWorkWSNwidth(data);
  _adjust();  
}
void WSCcomboBox::setWorkWSNheight(WSCushort data){
  WSCform::setWorkWSNheight(data);
  _adjust();  
}
void WSCcomboBox::setWorkWSNshadowType(char data){
  WSCform::setWorkWSNshadowType(data);
  _adjust();  
}
void WSCcomboBox::setWorkWSNshadowThickness(WSCuchar data){
  WSCform::setWorkWSNshadowThickness(data);
  _adjust();  
}
void WSCcomboBox::setWorkWSNforeColor(short data){
  WSCform::setWorkWSNforeColor(data);
  _adjust();  
}
void WSCcomboBox::setWorkWSNbackColor(short data){
  WSCform::setWorkWSNbackColor(data);
  _adjust();  
}
void WSCcomboBox::setWorkWSNtopShadowColor(short data){
  WSCform::setWorkWSNtopShadowColor(data);
  _adjust();  
}
void WSCcomboBox::setWorkWSNbottomShadowColor(short data){
  WSCform::setWorkWSNbottomShadowColor(data);
  _adjust();  
}

static WSDprivateTimer* _timer = NULL;
long WSCcomboBox::_menu_popup(){
  setUserData("Selected-cleard",(void*)0);
  if (_timer == NULL){
    _timer = WSDprivateTimer::getNewInstance();
    _timer->setRate(20);
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  short px, py;
  dev->getDispAddr(&px,&py);
  py += _h;
  WSCstring str(_menu_str);
  char tmp[2];
  tmp[0] = (char)-1;
  tmp[1] = 0;
 
  str.replaceString("\\,",tmp,0);

  long num  = str.getWords(",");
  WSCushort height = num * _item_height + _shadow_thick*2;
  if (_max_height != 0 && height > _max_height){
    height = _max_height;
  }

  if (height > WSGIappDev()->getHeight() - py){ 
    height = WSGIappDev()->getHeight() -py;
    if (height < 10){
      height = 10;
    }
  }
  if (_win == NULL){
    WSCstring name;
    name = (WSCstring)"cw-" + getInstanceName();
    _win = new WSCwindow(NULL,name);
    _win->setInternalObject(True);
    _win->initialize();
    name = (WSCstring)"cw-list-" + getInstanceName();
    _list = new WSClist(_win,name);
    _list->setInternalObject(True);
    _list->initialize();
    _list->setPropertyV(WSNhbarVisible,(WSCbool)False);
    _list->setPropertyV(WSNreverseSelect,(WSCbool)False);
    _list->setPropertyV(WSNmargin,(WSCuchar)_shadow_thick);
    _list->setProperty(WSNitemHeight,_item_height);
    _list->setProperty(WSNincrement,_increment);
    _list->setProperty(WSNpageIncrement,_page_increment);
    _list->setProperty(WSNscrollHeight,_item_height);

    _list->setUserData("_CMB",(void*)this);
    _list->setAbsoluteChangeSelectFlag(True);
    WSCprocedure* op = new WSCprocedure("select proc",WSEV_ACTIVATE);
    op->setFunction(_list_work,"_list_work");
    _list->addProcedure(op);
    WSCprocedure* op2 = new WSCprocedure("click proc",WSEV_MOUSE_PRESS);
    op2->setFunction(_list_ptr_work,"_list_ptr_work");
    _list->addProcedure(op2);

    WSCulong barw = _list->getProperty(WSNbarThickness);
    if (_max_height != 0 && _max_height < barw *4){
      _max_height = barw *4;
    }
  }
  _win->setPropertyV(WSNforeColor,_fore_color);
  _win->setPropertyV(WSNbackColor,_back_color);
  _win->setPropertyV(WSNtopShadowColor,_ts_color);
  _win->setPropertyV(WSNbottomShadowColor,_bs_color);
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    _win->setPropertyV(WSNshadowThickness,(WSCuchar)_shadow_thick);
    _win->setProperty(WSNshadowType,WS_SHADOW_OUT);
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _win->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    _win->setProperty(WSNshadowType,WS_SHADOW_BORDER);
  }
  _win->setPropertyV(WSNx,px);
  _win->setPropertyV(WSNy,py);
  _win->setPropertyV(WSNwidth,_w);
  _win->setPropertyV(WSNheight,height);
  _win->setPropertyV(WSNtitleBar,(char)WS_NO_TITLE);
  _list->setPropertyV(WSNforeColor,_fore_color);
  _list->setPropertyV(WSNbackColor,_back_color);
  _list->setPropertyV(WSNworkBackColor,_work_back_color);
  _list->setPropertyV(WSNtopShadowColor,_ts_color);
  _list->setPropertyV(WSNbottomShadowColor,_bs_color);
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    _list->setPropertyV(WSNx,(short)(_shadow_thick + WS_CM_BORDER));
    _list->setPropertyV(WSNy,(short)(_shadow_thick + WS_CM_BORDER));
    _list->setPropertyV(WSNwidth,(WSCushort)(_w - _shadow_thick*2 - WS_CM_BORDER*2));
    _list->setPropertyV(WSNheight,(WSCushort)(height - _shadow_thick*2 - WS_CM_BORDER*2));
    _list->setPropertyV(WSNshadowThickness,(WSCuchar)_shadow_thick);
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    _list->setPropertyV(WSNx,(short)(_shadow_thick));
    _list->setPropertyV(WSNy,(short)(_shadow_thick));
    _list->setPropertyV(WSNwidth,(WSCushort)(_w - _shadow_thick*2));
    _list->setPropertyV(WSNheight,(WSCushort)(height - _shadow_thick*2));
    _list->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  }

  _list->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _list->delAll();
  _list->setSelectItemChanged(False);
  _list->setProperty(WSNvbarValue,0);

  long i;
  for(i=0; i<num; i++){
    WSCstring item = str.getWord(i,",");
    item.replaceString(tmp,",",0);
    _list->addItem(item,-1);
  }

  WSDdev* wdev = _win->attachdev();
  if (wdev != NULL){
    WSCbool val = True;
    wdev->setValue(WSDEV_NO_FRAME,(void*)&val);
    wdev->setValue(WSDEV_FLOAT_ON_TOP,(void*)&val);
  }
  _list->setVisible(True);
  if (height < WS_STRETCH_HEIGHT){
    _win->setVisible(True);
  }else{
#ifdef WS_EMBED
    _win->setVisible(True);
#else
    WSGFstretchPopup(_win);
#endif
  }
  WSDdev* ldev = _list->getowndev();
  if (ldev != NULL){
    WSCbool val = True;
    ldev->setValue(WSDEV_GRAB_POINTER,(void*)&val);
    _list->setEnableActivate(False);
    _list->setFocus();
    _list->setSelectItemChanged(False);
    _list->setEnableActivate(True);
    WSGIappKeyboard()->setSpecialInputWorkProc(_special_key_handler,this,this);
  }
  if (_timer != NULL){
    _timer->setWorkProc(_list_timer_work,this);
    _timer->startTimer();
  }
  WSGIappMouse()->setMouseFocusClient(_list);
  return WS_NO_ERR;
}
void WSCcomboBox::_adjust(){
  if (_w - _h > 0){
    _if->setPropertyV(WSNwidth,(WSCushort)(_w - _h));
    _btn->setPropertyV(WSNx,(short)(_w - _h + _shadow_thick +1));
    _btn->setPropertyV(WSNy,(short)(_shadow_thick + 1));
  }else{
    _if->setPropertyV(WSNwidth,(WSCushort)1);
    _btn->setPropertyV(WSNx,(short)(_shadow_thick +1));
    _btn->setPropertyV(WSNy,(short)(_shadow_thick +1));
  }
  _if->setPropertyV(WSNheight,(WSCushort)_h);
  _if->setPropertyV(WSNshadowThickness,(WSCuchar)_shadow_thick);
  _if->setPropertyV(WSNshadowType,(char)_shadow_type);
  _if->setPropertyV(WSNbackColor,(short)_work_back_color);
  _if->setPropertyV(WSNforeColor,(short)_fore_color);
  _if->setPropertyV(WSNtopShadowColor,(short)_ts_color);
  _if->setPropertyV(WSNbottomShadowColor,(short)_bs_color);
  _btn->setPropertyV(WSNwidth,(WSCushort)(_h - _shadow_thick *2 -2));
  _btn->setPropertyV(WSNheight,(WSCushort)(_h - _shadow_thick *2 -2));
  _btn->setPropertyV(WSNshadowThickness,(WSCuchar)_shadow_thick);
  _btn->setPropertyV(WSNbackColor,(short)_back_color);
  _btn->setPropertyV(WSNforeColor,(short)_fore_color);
  _btn->setPropertyV(WSNtopShadowColor,(short)_ts_color);
  _btn->setPropertyV(WSNbottomShadowColor,(short)_bs_color);
}
long WSCcomboBox::_menu_popdown(){
  if (_list != NULL){
    WSDdev* ldev = _list->getowndev();
    if (ldev != NULL){
      WSCbool val = False;
      ldev->setValue(WSDEV_GRAB_POINTER,(void*)&val);
    }
  }
  if (_win != NULL){
    WSCushort height;
    _win->getPropertyV(WSNheight,&height);
    if (height < WS_STRETCH_HEIGHT){
      _win->setVisible(False);
    }else{
#ifdef WS_EMBED
      _win->setVisible(False);
#else
      WSGFstretchPopdown(_win);
#endif
    }
  }
  if (_timer != NULL){
    _timer->stopTimer();
  }
  long fl = (long)getUserData("Selected-cleard");
  if (fl != False){
    setFocus(True);
    WSGIappKeyboard()->resetSpecialInputWorkProc();
    return WS_NO_ERR;
  }
  if (_list == NULL){
    WSGIappKeyboard()->resetSpecialInputWorkProc();
    setFocus(True);
    return WS_NO_ERR;
  }
  if (_list->getSelectedPos() > -1){
    WSCstring data;
    data = _list->getSelectedItem();
    _if->setPropertyV(WSNlabelString,(char*)data);
    onActivate();
  }
  WSGIappKeyboard()->resetSpecialInputWorkProc();
  setFocus(True);
  return WS_NO_ERR;
}
long WSCcomboBox::_device_initialize(){
  WSCform::_device_initialize();
  return WS_NO_ERR;
}
void WSCcomboBox::onActivate(){
//  execEventProc(WSEV_ACTIVATE,NULL);
  execProcedure(WSEV_ACTIVATE);
}
long WSCcomboBox::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False  ){
    if (getDotMode() == False){
      if ( dev->isExposed(0,0,_w,_shadow_thick) == False &&
           dev->isExposed(0,0,_shadow_thick,_h) == False &&
           dev->isExposed(_w -_shadow_thick,0,_shadow_thick,_h) == False &&
           dev->isExposed(0,_h -_shadow_thick,_w,_shadow_thick) == False ){
        return WS_NO_ERR;
      }
    }else{
      if ( dev->isExposed(0,0,_w,_h) == False ){
        return WS_NO_ERR;
      }
    }
  }
  if (_shadow_thick > 0 || getDotMode() != False){
    long err = dev->beginDraw(0,0,_w,_h,absolute);
    if (err != WS_NO_ERR){
      return WS_NO_ERR;
    }
    short ex = _w - _h;
    if (ex < 0){
      ex = 0;
    }
    short ey = 0;
    WSCushort ew = _h;
    WSCushort eh = _h;
    WSCbase::update();
    setAbsoluteDraw(False);
    WSGFdrawShadow(dev,_shadow_type,_shadow_thick,_fore_color,_ts_color,_bs_color,_back_color,ex,ey,ew,eh);
    dev->endDraw();
  }
  return WS_NO_ERR;
}

void WSCcomboBox::_list_timer_work(void* ptr){
  WSCcomboBox* cmb = (WSCcomboBox*)ptr;
  WSClistData* lbs = cmb->_list->getLabels();
  long i;
  long num = lbs->getNum();
  WSCushort vx,vy;
  cmb->_list->getPropertyV(WSNhbarValue,&vx);
  cmb->_list->getPropertyV(WSNvbarValue,&vy);
//printf("void WSCcomboBox::_list_timer_work(void* ptr)\n");
  static short bx =0 ,by = 0;
  short tx =0 ,ty = 0;
  WSGIappMouse()->getMousePosition(&tx,&ty,cmb);
  if (tx != bx || ty != by ){
    cmb->_selected_by_key = False;
    bx = tx;
    by = ty;
  }

  for(i=0; i<num; i++){
    WSCbase* lb = (WSCbase*)(*lbs)[i];
    short px,py;
    WSGIappMouse()->getMousePosition(&px,&py,lb);
    WSCushort sw,sh;
    WSCbase* scrframe = cmb->_list->getdev()->getAttachedClient();
    scrframe->getPropertyV(WSNwidth,&sw);
    lb->getPropertyV(WSNheight,&sh);
//    px += vx;
//    py += vy;
    if (0 < px && px < sw && 
        0 < py && py < sh && cmb->_selected_by_key == False){
      cmb->_list->setEnableActivate(False);
      cmb->_list->setSelectPos(i);
      cmb->_list->setSelectItemChanged(False);
      cmb->_list->setEnableActivate(True);
      cmb->_list->cdraw();
      break;
    }
  }
}
WSCbool WSCcomboBox::_special_key_handler(void* ptr,WSDkeyboard* keyb,WSCbool fl){
  WSCcomboBox* _this = (WSCcomboBox*)ptr;
  if (_this->_win == NULL){
    return True;
  }
  if (_this->_win->getVisible() == False){
    WSGIappKeyboard()->resetSpecialInputWorkProc();
    return True;
  }
  long key = keyb->getKey();
  if (key == WSK_Escape || key == WSK_Super_L || key == WSK_Super_R ||
      key == WSK_Control_L || key == WSK_Control_R || key == WSK_Apps ||
      key == WSK_Alt_L || key == WSK_Alt_R ||
      key == WSK_Meta_L || key == WSK_Meta_R ){
    if (fl == False){
      return False;
    }
    WSDdev* ldev = _this->_list->getowndev();
    if (ldev != NULL){
      WSCbool val = False;
      ldev->setValue(WSDEV_GRAB_POINTER,(void*)&val);
    }
    _this->setUserData("Selected-cleard",(void*)1);
    _this->_menu_popdown();
    return False;
  }else
  if (key == WSK_Return){
    if (fl == False){
      return False;
    }
    _this->_menu_popdown();
    _this->_list->onActivate();
    return False;
  }else
  if (key == WSK_Up){
    if (fl == False){
      return False;
    }
    _this->_selected_by_key = True;
    long spos = _this->_list->getSelectedPos();
    if (spos > 0){
      spos--;
    }else{
      spos = 0;
    }
    _this->_list->setEnableActivate(False);
    _this->_list->setSelectPos(spos);
    long tpos = _this->_list->getTopPos();
    if (tpos > spos){
      _this->_list->setTopPos(spos);
    }
    WSCbase* cl = _this->_list->getLabel(spos);
    cl->setFocus();
    _this->_list->setSelectItemChanged(False);
    _this->_list->setEnableActivate(True);
    return False;
  }else if (key == WSK_Down){
    if (fl == False){
      return False;
    }
    _this->_selected_by_key = True;
    long spos = _this->_list->getSelectedPos();
    if (spos > -1){
      spos++;
    }else{
      spos = -1;
    }
    _this->_list->setEnableActivate(False);
    _this->_list->setSelectPos(spos);
    long bpos = _this->_list->getBottomPos();
    if (spos > bpos){
      _this->_list->setBottomPos(spos);
    }
    WSCbase* cl = _this->_list->getLabel(spos);
    cl->setFocus();
    _this->_list->setSelectItemChanged(False);
    _this->_list->setEnableActivate(True);
    return False;
  }else{
    if (fl == False){
      return False;
    }
    char* text = keyb->getText();
    if ( (text[0] > 'A' -1 && text[0] < 'Z' + 1) ||
         (text[0] > 'a' -1 && text[0] < 'z' + 1) ||
         (text[0] > '0' -1 && text[0] < '9' + 1) ){
      int i;
      int num = _this->_list->getNum();
      for(i=0; i<num; i++){
         WSCstring str = _this->_list->getItem(i);
         char* str2 = str.getString();
         if (text[0] == str2[0]){
           _this->_list->setEnableActivate(False);
           _this->_list->setTopPos(i);
           _this->_list->setSelectPos(i);
           WSCbase* cl = _this->_list->getLabel(i);
           cl->setFocus();
           _this->_list->setSelectItemChanged(False);
           _this->_list->setEnableActivate(True);
           return False;
         }
      }
    }
  }

  return True;
}


void WSCcomboBox::_list_ptr_work(WSCbase* list){
  WSCcomboBox* cmb = (WSCcomboBox*)list->getUserData("_CMB");
//printf("WSCcomboBox::_list_ptr_work cmb=0x%x\n",cmb);
  if (cmb == NULL){
    return;
  }
  // for touch pannel..
  _list_timer_work(cmb);

  short px,py;
  WSGIappMouse()->getMousePosition(&px,&py,list);
//  short sx=0,sy=0;
  WSCushort sw=0,sh=0;
  list->getPropertyV(WSNwidth,&sw);
  list->getPropertyV(WSNheight,&sh);
  long wx = list->getProperty(WSNhbarValue);
  px -= wx;
  long wy = list->getProperty(WSNvbarValue);
  py -= wy;
//printf("WSCcomboBox::_list_ptr_work x,y=%d,%d sw,sh=%d,%d\n",px,py,sw,sh);
  if (px < 0 || sw < px ||
      py < 0 || sh < py ){
    WSDdev* ldev = cmb->_list->getowndev();
    if (ldev != NULL){
      WSCbool val = False;
      ldev->setValue(WSDEV_GRAB_POINTER,(void*)&val);
    }
    cmb->setUserData("Selected-cleard",(void*)1);
    cmb->_menu_popdown();
  }

  WSDdev* ldev = list->getdev();
  if (ldev != NULL){
    WSCbase* scrframe = ldev->getAttachedClient();
    if (scrframe != NULL){
//      scrframe->getPropertyV(WSNx,&sx);
//      scrframe->getPropertyV(WSNy,&sy);
      scrframe->getPropertyV(WSNwidth,&sw);
      scrframe->getPropertyV(WSNheight,&sh);
    }
#if 0
    if (sx < px && px < sx+ sw && sy < py && py < sy+ sh ){
      WSCushort vx,vy;
      scrframe->getPropertyV(WSNhbarValue,&vx);
      scrframe->getPropertyV(WSNvbarValue,&vy);
      WSCpoint pt;
      pt.x = px + vx;
      pt.y = py + vy;
      ldev->execEvent(WSEV_MOUSE_PRESS,&pt);
    }
#endif
    if (0 < px && px < sw && 0 < py && py < sh ){
      long scrpos = list->getProperty(WSNvbarValue);
      WSCpoint pt;
//      pt.x = px - wx;
//      pt.y = py - wy;
      pt.x = px;
      pt.y = py + scrpos;
//printf("WSCcomboBox::_list_ptr_work pt.x,pt.y=%d,%d\n",pt.x,pt.y);
//      ldev->execEvent(WSEV_MOUSE_PRESS,&pt);
      cmb->_list->setSelectItemChanged(True);
      cmb->_list->onActivate();
    }
  }
}

void WSCcomboBox::_list_work(WSCbase* list){
  WSCcomboBox* cmb = (WSCcomboBox*)list->getUserData("_CMB");
  if (cmb == NULL){
    return;
  }
  if (cmb->_list->getSelectItemChanged() != False){
    WSDdev* ldev = cmb->_list->getowndev();
    if (ldev != NULL){
      WSCbool val = False;
      ldev->setValue(WSDEV_GRAB_POINTER,(void*)&val);
    }
    cmb->_menu_popdown();
  }
}
void WSCcomboBox::onFocusChange(WSCbool fl){
  if (_if != NULL){
//    WSCbool readonly = _if->getProperty(WSNdisplayOnly);
      _if->setFocus(fl);
  }
  if (_btn != NULL && fl == False){
    _btn->setFocus(fl);
  }
}
void WSCcomboBox::_value_ch_work(WSCbase* ifield){
  WSCcomboBox* cmb = (WSCcomboBox*)ifield->getUserData("_CMB");
  if (cmb == NULL){
    return;
  }
  cmb->execProcedure(WSEV_VALUE_CH);
}
void WSCcomboBox::_btn_key_press_work(WSCbase* btn){
  WSCcomboBox* cmb = (WSCcomboBox*)btn->getUserData("_CMB");
  if (cmb == NULL){
    return;
  }
  long key = WSGIappKeyboard()->getKey();
  if (key == WSK_Return || key == WSK_Up || key == WSK_Down){
    _btn_work(btn);
    btn->onMouseOut();
  }
}
void WSCcomboBox::_key_press_work(WSCbase* ifield){
  WSCcomboBox* cmb = (WSCcomboBox*)ifield->getUserData("_CMB");
  if (cmb == NULL){
    return;
  }
  cmb->execProcedure(WSEV_KEY_PRESS);
}
void WSCcomboBox::_key_release_work(WSCbase* ifield){
  WSCcomboBox* cmb = (WSCcomboBox*)ifield->getUserData("_CMB");
  if (cmb == NULL){
    return;
  }
  cmb->execProcedure(WSEV_KEY_RELEASE);
}
void WSCcomboBox::_key_hook_work(WSCbase* ifield){
  WSCcomboBox* cmb = (WSCcomboBox*)ifield->getUserData("_CMB");
  if (cmb == NULL){
    return;
  }
  cmb->execProcedure(WSEV_KEY_HOOK);
  long key = WSGIappKeyboard()->getKey();
  if (key == WSK_Up){
    if (cmb->_win == NULL || cmb->_win->getVisible() == False){
      cmb->_menu_popup();
      WSGIappKeyboard()->setKey(0);
    }
  }else
  if (key == WSK_Down){
    if (cmb->_win == NULL || cmb->_win->getVisible() == False){
      cmb->_menu_popup();
      WSGIappKeyboard()->setKey(0);
    }
  }
}
void WSCcomboBox::_btn_work(WSCbase* btn){
  WSCcomboBox* cmb = (WSCcomboBox*)btn->getUserData("_CMB");
  if (cmb == NULL){
    return;
  }
  //for popup menu..
  if ((WSGIappMouse()->getStatus() & WS_MOUSE_BTN3) == 0){
    if (cmb->_win == NULL || cmb->_win->getVisible() == False){
      cmb->_menu_popup();
    }else{
      cmb->_menu_popdown();
    }
  }

  short x,y;
  WSGIappMouse()->getMousePosition(&x,&y,btn);
  WSCpoint pt;
  pt.x = x;
  pt.y = y;
  btn->execEventProc(WSEV_MOUSE_RELEASE,(void*)&pt);
}
char* WSCcomboBox::getDefaultProperty(){
  return WSNlabelString;
}
WSCvifield* WSCcomboBox::getTextFrame(){
  return _if;
}
