//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <WSCradioGroup.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCfontSet.h>
#include <WSCvradio.h>
#include <WSDkeyboard.h>

WSMFguiClassInitialize(WSCradioGroup,WSCform);
WSMFversion(WSCradioGroup,WSCform);

WSMFpropertyValueChange( WSCradioGroup, WSNshadowType , char,WS_SHADOW_EIN);

WSCradioGroup::WSCradioGroup(WSCbase* base,char* objname):
                WSCform(base,objname){
  _register_focus_move();
  _upname = NULL;
  _dwname = NULL;
  _lname = NULL;
  _rname = NULL;
  _rtname = NULL;
  _tbname = NULL;
  _btbname = NULL;
  _sc_str = NULL;
  _enable_focus_move = False;

  _title_string = NULL;
  _menu_str = WSGFstrdup("item1,item2,item3");
  _value =0;
  _font = (char)WSGIappFontSet()->getDefaultFontNo();
  _shadow_type = WS_SHADOW_EIN;
  _item_height = 20;
  _margin = 4;
  _unique = 1;
  _indicator_on    = True;
  _indicator_type  = WS_IN_OUT;
  _indicator_size  = 16;
  _indicator_shadow_thick = 2;
  _indicator_color = WS_DF_WORKBACKCOLOR;
  _select_color    = WS_DF_MENUSELECTCOLOR;
  _indicator_pixmap = -1;
  _select_pixmap   = -1;
  _label_pixmap   = -1;
  _orientation = 1;//VERTICAL
  _return_key_focus = 0;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCradioGroup);

    WSMFpropertyCreate(WSNmenuItems,char*,_menu_str,WSSmenuItems);
    WSMFpropertyCreate(WSNvalue,WSCulong,_value,WSSvalue);
    WSMFpropertyCreate(WSNtitleString,char*,_title_string,WSStitleString);
    WSMFpropertyCreate(WSNmenuItemHeight,WSCushort,_item_height,WSSmenuItemHeight);
    WSMFpropertyCreate(WSNfont,         WSCuchar,   _font,WSSfont  );
    WSMFpropertyCreate(WSNmargin,WSCuchar,_margin,WSSmargin );

    WSMFpropertyValueChangeDef( WSCradioGroup,WSNshadowType ,char);

    WSMFpropertyCreate(WSNindicatorOn, WSCbool,_indicator_on,WSSindicatorOn );
    WSMFpropertySetSelection(WSRbool1, WSRbool1D);
    WSMFpropertyCreate(WSNindicatorType,WSCuchar, _indicator_type,WSSindicatorType);
    WSMFpropertySetSelection(WSRindicatorType, WSRindicatorTypeD);
    WSMFpropertyCreate(WSNindicatorSize,WSCuchar, _indicator_size,WSSindicatorSize);
    WSMFpropertyCreate(WSNindicatorShadow, WSCuchar, _indicator_shadow_thick,WSSindicatorShadow);
    WSMFpropertyCreate(WSNindicatorColor,  short,_indicator_color,WSSindicatorColor );
    WSMFpropertyCreate(WSNindicatorPixmap,short,_indicator_pixmap,WSSindicatorPixmap);
    WSMFpropertyCreate(WSNselectColor, short,_select_color,WSSselectColor );
    WSMFpropertyCreate(WSNselectPixmap, short, _select_pixmap,WSSselectPixmap );
    WSMFpropertyCreate(WSNlabelPixmap, short, _label_pixmap,WSSlabelPixmap );
    WSMFpropertyCreate(WSNorientation, WSCuchar, _orientation,WSSorientation );
    WSMFpropertySetSelection(WSRorientation, WSRorientationD);

    WSMFpropertyCreate(WSNkeepPixmapCache,WSCbool,_keep_pixmap_cache,WSSkeepPixmapCache );
      WSMFpropertySetSelection(WSRbool4,WSRbool4D);

    WSMFpropertyCreate(WSNupward, char*, _upname,WSSupward);
    WSMFpropertyCreate(WSNdownward,char*, _dwname,WSSdownward);
    WSMFpropertyCreate(WSNleftward,char*,_lname,WSSleftward);
    WSMFpropertyCreate(WSNrightward, char*,_rname,WSSrightward);
    WSMFpropertyCreate(WSNreturn,char*,_rtname,WSSreturn);
    WSMFpropertyCreate(WSNtab,char*,_tbname,WSStab);
    WSMFpropertyCreate(WSNbacktab,char*,_btbname,WSSbacktab);
    WSMFpropertyCreate(WSNenableFocusMove, WSCbool,_enable_focus_move,WSSenableFocusMove);
    WSMFpropertySetSelection(WSRbool1,WSRbool1D);

    WSMFpropertyCreate(WSNreturnKeyFocus,WSCbool,_return_key_focus,WSSreturnKeyFocus );
      WSMFpropertySetSelection(WSRbool1,WSRbool1D);

    WSMFpropertyCreate(WSNshortcut,char*,_sc_str,WSSshortcut);
    WSMFaddTrigger(WSEV_VALUE_CH    );

  WSMFpropertyCreateEnd

}

WSMFproperty(WSCradioGroup,WSNtitleString,char*,_title_string,NULL);
WSMFproperty(WSCradioGroup,WSNmenuItems,char*,_menu_str,WSGFstrdup("item1,item2,item3"));
WSMFproperty(WSCradioGroup,WSNmenuItemHeight,WSCushort,_item_height,20);
WSMFproperty(WSCradioGroup,WSNvalue,WSCulong,_value,0);
WSMFproperty(WSCradioGroup,WSNfont, WSCuchar, _font,(char)WSGIappFontSet()->getDefaultFontNo());
WSMFproperty(WSCradioGroup, WSNmargin, WSCuchar,_margin,4);

WSMFproperty( WSCradioGroup, WSNindicatorOn,      WSCbool,   _indicator_on     ,True    );
WSMFproperty( WSCradioGroup, WSNindicatorType,    WSCuchar,      _indicator_type   ,WS_IN_OUT );
WSMFproperty( WSCradioGroup, WSNindicatorSize,    WSCuchar,     _indicator_size   ,16      );
WSMFproperty( WSCradioGroup, WSNindicatorShadow,  WSCuchar,     _indicator_shadow_thick ,2       );
WSMFproperty( WSCradioGroup, WSNindicatorColor,   short, _indicator_color ,WS_DF_WORKBACKCOLOR);
WSMFproperty( WSCradioGroup, WSNselectColor,      short, _select_color    ,WS_DF_MENUSELECTCOLOR);
WSMFproperty( WSCradioGroup, WSNindicatorPixmap,  short, _indicator_pixmap ,-1      );
WSMFproperty( WSCradioGroup, WSNselectPixmap,     short,     _select_pixmap    ,-1      );
WSMFproperty( WSCradioGroup, WSNlabelPixmap,     short,     _label_pixmap    ,-1      );
WSMFproperty( WSCradioGroup, WSNorientation, WSCuchar, _orientation ,1 );
WSMFproperty( WSCradioGroup, WSNkeepPixmapCache, WSCbool,  _keep_pixmap_cache,True );
WSMFproperty( WSCradioGroup, WSNupward,    char*,   _upname, NULL);
WSMFproperty( WSCradioGroup, WSNdownward, char*,   _dwname, NULL);
WSMFproperty( WSCradioGroup, WSNleftward,   char*,   _lname, NULL);
WSMFproperty( WSCradioGroup, WSNrightward,  char*,   _rname, NULL);
WSMFproperty( WSCradioGroup, WSNreturn, char*,   _rtname, NULL);
WSMFproperty( WSCradioGroup, WSNtab, char*,   _tbname, NULL);
WSMFproperty( WSCradioGroup, WSNbacktab, char*,   _btbname, NULL);
WSMFproperty( WSCradioGroup, WSNenableFocusMove, WSCbool,    _enable_focus_move, False );
WSMFproperty( WSCradioGroup, WSNreturnKeyFocus, WSCbool, _return_key_focus, False);
WSMFproperty( WSCradioGroup, WSNshortcut, char*,   _sc_str, NULL);


void WSCradioGroup::setWorkWSNindicatorOn(WSCbool){}
void WSCradioGroup::getWorkWSNindicatorOn(WSCbool* ){}
void WSCradioGroup::setWorkWSNindicatorType(WSCuchar){}
void WSCradioGroup::getWorkWSNindicatorType(WSCuchar* ){}
void WSCradioGroup::setWorkWSNindicatorSize(WSCuchar){}
void WSCradioGroup::getWorkWSNindicatorSize(WSCuchar* ){}
void WSCradioGroup::setWorkWSNindicatorShadow(WSCuchar){}
void WSCradioGroup::getWorkWSNindicatorShadow(WSCuchar* ){}
void WSCradioGroup::setWorkWSNindicatorColor(short){}
void WSCradioGroup::getWorkWSNindicatorColor(short* ){}
void WSCradioGroup::setWorkWSNindicatorPixmap(short){}
void WSCradioGroup::getWorkWSNindicatorPixmap(short* ){}
void WSCradioGroup::setWorkWSNselectColor(short){}
void WSCradioGroup::getWorkWSNselectColor(short* ){}
void WSCradioGroup::setWorkWSNselectPixmap(short){}
void WSCradioGroup::getWorkWSNselectPixmap(short* ){}
void WSCradioGroup::setWorkWSNlabelPixmap(short){}
void WSCradioGroup::getWorkWSNlabelPixmap(short* ){}

void WSCradioGroup::setWorkWSNorientation(WSCuchar){}
void WSCradioGroup::getWorkWSNorientation(WSCuchar*){}

void WSCradioGroup::setWorkWSNreturnKeyFocus(WSCbool){}
void WSCradioGroup::getWorkWSNreturnKeyFocus(WSCbool*){}


void WSCradioGroup::setWorkWSNbackColor(short col){
  long rnum = _radio_list.getNum();
  long i;
  for(i=0; i<rnum; i++){
    WSCvradio* item = (WSCvradio*)_radio_list[i];
    item->setProperty(WSNbackColor,col);
  }
  WSCform::setWorkWSNbackColor(col);
}

void WSCradioGroup::setWorkWSNtitleString(char*){}
void WSCradioGroup::getWorkWSNtitleString(char**){}
void WSCradioGroup::setWorkWSNmenuItems(char*){
  _adjust();
}
void WSCradioGroup::getWorkWSNmenuItems(char**){}
void WSCradioGroup::setWorkWSNmenuItemHeight(WSCushort){}
void WSCradioGroup::getWorkWSNmenuItemHeight(WSCushort*){}
void WSCradioGroup::setWorkWSNvalue(WSCulong value){
#if 0
  WSCstring tmp;
  tmp = _menu_str;
  long num = tmp.getWords(",");
  if (num > 0){
    _adjust();
  }
#endif
  if (_radio_list.getNum() == 0){
    _update_registered = True;
    _adjust();
  }

  long rnum = _radio_list.getNum();
  if (rnum > 0){
    WSCvradio* item = (WSCvradio*)_radio_list[0];
    item->setGroupValue(value);
  }
}
void WSCradioGroup::getWorkWSNvalue(WSCulong* value){
  WSCstring tmp;
  tmp = _menu_str;
  long num = tmp.getWords(",");
  if (num > 0){
    long rnum = _radio_list.getNum();
    if (rnum > 0){
      WSCvradio* item = (WSCvradio*)_radio_list[0];
      *value = item->getGroupValue();
      _value = *value;
    }
  }
}
void WSCradioGroup::setWorkWSNfont(WSCuchar){
  _adjust();
}
void WSCradioGroup::getWorkWSNfont(WSCuchar*){}
void WSCradioGroup::setWorkWSNmargin(WSCuchar){
  _adjust();
}
void WSCradioGroup::getWorkWSNmargin(WSCuchar*){}
void WSCradioGroup::setWorkWSNkeepPixmapCache(WSCbool){}
void WSCradioGroup::getWorkWSNkeepPixmapCache(WSCbool*){}

void WSCradioGroup::setWorkWSNenableFocusMove(WSCbool){}
void WSCradioGroup::getWorkWSNenableFocusMove(WSCbool*){}
void WSCradioGroup::setWorkWSNupward(char*){} 
void WSCradioGroup::getWorkWSNupward(char**){}
void WSCradioGroup::setWorkWSNdownward(char*){}
void WSCradioGroup::getWorkWSNdownward(char**){} 
void WSCradioGroup::setWorkWSNleftward(char*){}
void WSCradioGroup::getWorkWSNleftward(char**){}
void WSCradioGroup::setWorkWSNrightward(char*){}   
void WSCradioGroup::getWorkWSNrightward(char**){}
void WSCradioGroup::setWorkWSNreturn(char*){}
void WSCradioGroup::getWorkWSNreturn(char**){}   
void WSCradioGroup::setWorkWSNtab(char*){}
void WSCradioGroup::getWorkWSNtab(char**){}
void WSCradioGroup::setWorkWSNbacktab(char*){}
void WSCradioGroup::getWorkWSNbacktab(char**){}
void WSCradioGroup::setWorkWSNshortcut(char*){
  _adjust();
}
void WSCradioGroup::getWorkWSNshortcut(char**){}

WSCradioGroup::~WSCradioGroup(){
  if (getFocus() != False){
    setFocus(False);
  }
  if (_return_key_focus != False && getSpecialFocus() != False){
    setSpecialFocus(False);
  }

  if (_title_string != NULL){
    delete[] _title_string;
    _title_string = NULL;
  }
  if (_menu_str != NULL){
    delete[] _menu_str;
    _menu_str = NULL;
  }
  if (_upname != NULL){
    delete[] _upname;
    _upname = NULL;
  }
  if (_dwname != NULL){
    delete[] _dwname;
    _dwname = NULL;
  }
  if (_lname != NULL){
    delete[] _lname;
    _lname = NULL;
  }
  if (_rname != NULL){
    delete[] _rname;
    _rname = NULL;
  }
  if (_rtname != NULL){
    delete[] _rtname;
    _rtname = NULL;
  }
  if (_tbname != NULL){
    delete[] _tbname;
    _tbname = NULL;
  }
  if (_btbname != NULL){
    delete[] _btbname;
    _btbname = NULL;
  }
  if (_sc_str != NULL){
    delete[] _sc_str;
    _sc_str = NULL;
  }
}

long WSCradioGroup::draw(){

  if (_no_refresh != False){
    WSCbase::update();
    setAbsoluteDraw(False);
    return WS_NO_ERR;
  }
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  _adjust();
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False  ){
    if ( dev->isExposed(0,0,_w,_h) == False ){
      return WS_NO_ERR;
    }
  }
  long err = dev->beginDraw(0,0,_w,_h,absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }
  short ex = 0;
  short ey = 0;
  WSCushort ew = _w;
  WSCushort eh = _h;
  if (absolute == False){
    dev->getExposedArea(&ex,&ey,&ew,&eh);
  }
  WSCbase::update();
  setAbsoluteDraw(False);
  if (_bp_color == -1){
#ifndef NO_GRADATION
    if (_grad_no == 0){
#endif
      dev->setForeColor(_back_color);
      dev->drawFillRect(0,0,_w,_h);
#ifndef NO_GRADATION
    }else{
      dev->drawGradation(_grad_no,_ts_color,_back_color,_bs_color,0,0,_w,_h,_grad_margin);
    }
#endif
  }
  if (getDotMode() == True){
    dev->setForeColor(_fore_color);
    long i,j;
    for(i=0; i<_w; i+=10){
      for(j=0; j<_h; j+=10){
        if (ex < i && i < ex+ ew &&
            ey < j && j < ey+ eh ){
          dev->drawFillRect(i,j,1,1);
        }
      }
    }
  }

  WSDfont* fn = WSGIappFontSet()->getFont(_font);
  WSCstring tmp;
  if (_title_string != NULL){
    tmp << " " << (_title_string);
  }
  tmp << " ";
  long fw = fn->getStringWidth(&tmp); 
  long fh = fn->getStringHeight(&tmp); 
  WSGFdrawShadow(dev,_shadow_type,_shadow_thick,_fore_color,
                 _ts_color,_bs_color,_back_color,fh/2,fh/2,_w-fh/2,_h-fh/2);

  dev->setForeColor(_fore_color);
  dev->setBackColor(_back_color);
  if (_title_string != NULL){
    dev->drawFillString(fh, 1, fw, fh, &tmp, _font, WS_CENTER,-1,0);
  }
  dev->endDraw();
  return WS_NO_ERR;
}

void WSCradioGroup::onValueChange(){
//printf("WSCradioGroup::onValueChange() val=%d\n",(long)getProperty(WSNvalue));
  execProcedure(WSEV_VALUE_CH);
}

void WSCradioGroup::update(){
  _adjust();
  if (isNeedUpdate() != False){
    WSCform::update();
  }
}
void WSCradioGroup::onVisibleChange(WSCbool fl){
  WSCform::onVisibleChange(fl);
  if (fl != False){
    _adjust();
  }
}
void WSCradioGroup::_adjust(){
  if (_update_registered == 0){
    return;
  }
  WSCstring str(_menu_str);
  WSCstring sc_str;
  if (_sc_str != NULL){
    sc_str = _sc_str;
  }
  long num = str.getWords(",");
  long i =0;
  long rnum = _radio_list.getNum();

  WSDfont* fn = WSGIappFontSet()->getFont(_font);
  WSCstring tmp;
  if (_title_string != NULL){
    tmp << " " << (_title_string);
  }
  tmp << " ";
  long fh = fn->getStringHeight(&tmp); 


  WSCstring gname;
  gname << getInstanceName() << "-group" << i;
  for(i=0; i<num; i++){
    WSCvradio* item;
    if (i < rnum){
      item = (WSCvradio*)_radio_list[i];
    }else{
      WSCstring rname;
      rname << getInstanceName() << "-" << i;
      item = new WSCvradio(this,rname);
      item->setInternalObject(True);
      item->initialize();
      item->setProperty(WSNmarginTop,0);
      item->setProperty(WSNmarginBottom,0);
      item->setProperty(WSNmarginLeft,15);
      item->setUserData("parentptr",(void*)this);
      if (i==0 || _unique == 0){
        WSCprocedure* op = new WSCprocedure("valuech-op",WSEV_VALUE_CH);
        op->setFunction(_value_ch_handler,"_value_ch_handler");
        item->addProcedure(op);
      }
      _radio_list.add((void*)item);
    }
    if (_orientation == 1){
      item->setProperty(WSNx,fh);
      item->setProperty(WSNy,(long)(fh*1.5 + _item_height*i + _margin*i));
      item->setProperty(WSNwidth,_w - fh*2);
      item->setProperty(WSNheight,_item_height);
    }else{
      long tw = (_w - fh*2)/ num;
      item->setProperty(WSNx,fh + tw * i);
//      item->setProperty(WSNy,(short)(fh + (_h -fh - _item_height)/2));
      item->setProperty(WSNy,(short)(fh/2 + (_h -fh/2 - _item_height)/2));
      item->setProperty(WSNwidth,tw);
      item->setProperty(WSNheight,_item_height);
    }
    WSCstring rstr = str.getWord(i,",");
    item->setProperty(WSNlabelString,rstr);
    item->setProperty(WSNgroup,gname);
    item->setProperty(WSNunique,_unique);
    item->setProperty(WSNalignmentH,WS_LEFT);
    item->setProperty(WSNid,i+1);
    item->setProperty(WSNfont,_font);
    item->setProperty(WSNbackColor,_back_color);
    item->setProperty(WSNforeColor,_fore_color);
    item->setProperty(WSNindicatorOn,_indicator_on);
    item->setProperty(WSNindicatorType,_indicator_type);
    item->setProperty(WSNindicatorSize,_indicator_size);
    item->setProperty(WSNindicatorShadow,_indicator_shadow_thick);
    item->setProperty(WSNindicatorColor,_indicator_color);
    item->setProperty(WSNindicatorPixmap,_indicator_pixmap);
    item->setProperty(WSNselectColor,_select_color);
    item->setProperty(WSNselectPixmap,_select_pixmap);
    item->setProperty(WSNlabelPixmap,_label_pixmap);
    item->setProperty(WSNtopShadowColor,_ts_color);
    item->setProperty(WSNbottomShadowColor,_bs_color);
    item->setProperty(WSNreturnKeyFocus,_return_key_focus);
    if (_sc_str != NULL){
      WSCstring sc = sc_str.getWord(i,",");
      item->setProperty(WSNshortcut,sc);
    }
    item->setVisible(True);
  }
  if (num < rnum){
    for(i=num; i<rnum; i++){
      WSCvradio* item = (WSCvradio*)_radio_list[i];
      item->setVisible(False);
      item->setStatus(False,False);
    }
  }
}
void WSCradioGroup::_value_ch_handler(WSCbase* obj){
  WSCradioGroup* ptr = (WSCradioGroup*)obj->getUserData("parentptr");
  WSCstring tmp;
  tmp = ptr->_menu_str;
  long num = tmp.getWords(",");
  if (num > 0){
    long rnum = ptr->_radio_list.getNum();
    if (rnum > 0){
      WSCvradio* item = (WSCvradio*)ptr->_radio_list[0];
      WSCulong value = item->getGroupValue();
      if (ptr->_value != value){
        ptr->_value = value;
        ptr->onValueChange();
      }
    }
  }
}
long WSCradioGroup::setItemSensitive(short no,WSCbool fl){
  if (no == -1){
    no = _radio_list.getNum()-1;
  }
  if (no < 0){
    return WS_ERR;
  }
  WSCvradio* item = (WSCvradio*)_radio_list[no];
  if (item == NULL){
    return WS_ERR;
  }
  item->setSensitive(fl);
  return WS_NO_ERR;
}

WSCbool WSCradioGroup::getItemSensitive(short no){
  if (no == -1){
    no = _radio_list.getNum()-1;
  }
  if (no < 0){
    return False;
  }
  WSCvradio* item = (WSCvradio*)_radio_list[no];
  if (item == NULL){
    return False;
  }
  return item->getSensitive();
}
WSCvradio* WSCradioGroup::getItem(short no){
  if (no == -1){
    no = _radio_list.getNum()-1;
  }
  if (no < 0){
    return NULL;
  }
  WSCvradio* item = (WSCvradio*)_radio_list[no];
  return item;
}

char* WSCradioGroup::getDefaultProperty(){
  return WSNvalue;
}
void WSCradioGroup::onFocusChange(WSCbool fl){
  if (fl != False){
    if (_return_key_focus != False){
      WSGIappKeyboard()->resetSpecialInputWorkProc();
      setSpecialFocus(True);
    }

    long rnum = _radio_list.getNum();
    long i;
    for(i=0; i<rnum; i++){
      WSCvradio* item = (WSCvradio*)_radio_list[i];
      //item->getVisible() != False causes it will be not focused
      //in VISIBLE_CH event procedure
      if (item->getStatus() != False && item->getSensitive() != False){
        item->setFocus(fl);
        return;
      }
    }
    for(i=0; i<rnum; i++){
      WSCvradio* item = (WSCvradio*)_radio_list[i];
      if (item->getSensitive() != False){
        item->setFocus(fl);
        if (_unique == False){
          item->setSpecialFocus(fl);
        }
        return;
      }
    }
  }else{
    if (_return_key_focus != False){
      WSGIappKeyboard()->resetSpecialInputWorkProc();
      setSpecialFocus(False);
    }
  }
}


