//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <basic.h>
#include <WScom.h>
#ifndef NO_DRAG_DROP
#include <WSCbase.h>
#include <btron/WSDbtronDragDrop.h>
#include <btron/WSDbtronAppDev.h>
#include <btron/WSDbtronFormDev.h>
#include <btron/WSDbtronMouse.h>

#define MAX_ARGS 10

WSMFclassInit(WSDbtronDragDrop,WSDdragDrop);

WSDdragDrop* _btronDrag_drop_create_handler_(){
  return new WSDbtronDragDrop;
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _wsd_btronDragdrop_init{
  public:
    _wsd_btronDragdrop_init(){
        WSDdragDrop::setCreateHandler(_btronDrag_drop_create_handler_);
    };
};
static _wsd_btronDragdrop_init  execute_init;
#endif

WSDbtronDragDrop* WSGIbtronAppDragDrop(){
  WSDdragDrop* dd = WSGIappDragDrop();
  if (dd != NULL){
    WSDbtronDragDrop* xdd = (WSDbtronDragDrop*)dd->cast("WSDbtronDragDrop");
	return xdd;
  }else{
    return NULL;
  }
}

WSCbase* WSDbtronDragDrop::_drag_client = NULL;

WSDbtronDragDrop::WSDbtronDragDrop(){
  _under_dragging = 0;
}

WSDbtronDragDrop::~WSDbtronDragDrop(){
}

void WSDbtronDragDrop::executeDrop(){
//printf("WSDbtronDragDrop::executeDrop..\n");
  if (_under_dragging == 0){
    _drag_client = NULL;
    return;
  }
  _under_dragging = 0;
//printf("WSDbtronDragDrop::executeDrop.. here1\n");

  WSCbase* drop_site = NULL;
  long num = _drop_site_list.getNum();
  long i;
  for(i=num -1; i>-1; i--){
     WSCbase* site = (WSCbase*)_drop_site_list.getData(i);
     WSDdev* dev = site->getdev();
     if (dev == NULL){
       continue;
     }



     WSDbtronFormDev* bdev = (WSDbtronFormDev*)dev->cast("WSDbtronFormDev");
     if (bdev == NULL){
       continue;
     }
     short px,py;
	 WSGIappMouse()->getMousePosition(&px,&py);

     PNT pt;
     pt.x = px;
     pt.y = py;
     gcnv_rel(bdev->getParentGID(),&pt);
//printf("bdev=0x%x pt=%d,%d\n",bdev,pt.x,pt.y); 
     WSDbtronFormDev* tdev = bdev->getChildWithPoint(pt.x,pt.y);
     while(1){
       if (tdev == NULL){
         break;
       }
       WSCbase* client = tdev->getAttachedClient();
       if (client != NULL){
         if (client->getUserData("DROP-PROC") != NULL){
           break;
         }
       }
       tdev = tdev->getParentAreaDev();
       if (tdev == bdev){
         break;
       }
     }

//printf("WSDbtronDragDrop::executeDrop.. pt=%d,%d\n",px,py);
     if (tdev != NULL){
       drop_site = tdev->getAttachedClient();
       break;
     }
  }
//printf("WSDbtronDragDrop::executeDrop.. here2 drop_site=0x%x\n",drop_site);
  if (drop_site != NULL){
    void (*hd)(WSCbase*,WSCbase*) =
       (void(*)(WSCbase*,WSCbase*))drop_site->getUserData("DROP-PROC");
//printf("WSDbtronDragDrop::executeDrop.. hd=0x%x\n",hd);
    if (hd != NULL){
      hd(drop_site,_drag_client);
//printf("WSDbtronDragDrop::executeDrop.. done hd=0x%x\n",hd);
    }
  }
#if 0
  WSDdev* dev = _drag_client->getowndev();
  WSDbtronFormDev* bdev = (WSDbtronFormDev*)dev->cast("WSDbtronFormDev");
  if (bdev == NULL){
    bdev = (WSDbtronFormDev*)dev->getParentDev()->cast("WSDbtronFormDev");
  }
  if (bdev != NULL){
    WSCushort mno =  xdev->getMouseNo();
    long val = WSGIappMouse()->getMouseCursor(mno);
    if (val != 0){
      XDefineCursor(XtDisplay(xdev->getWidget()),
                    XtWindow(xdev->getWidget()),val);
    }
  }
#endif
}


WSCbool WSDbtronDragDrop::getDragState(){
  return _under_dragging;
}

void WSDbtronDragDrop::_btn_press_drag_start(WSCbase* client){
   WSDbtronDragDrop* obj = (WSDbtronDragDrop*)client->getUserData("WSDRAG-SERV");
   if (obj->_under_dragging == True){
     return;
   }
   obj->_under_dragging = True;
   _drag_client = client;
#if 0
  WSDdev* dev = client->getowndev();
  WSDbtronFormDev* xdev = (WSDbtronFormDev*)dev->cast("WSDbtronFormDev");
  if (xdev == NULL){
    xdev = (WSDbtronFormDev*)dev->getParentDev()->cast("WSDbtronFormDev");
  }
  if (xdev != NULL){
    WSCushort mno =  154; //mouse no
    long val = WSGIappMouse()->getMouseCursor(mno);
    if (val != 0){
      XDefineCursor(XtDisplay(xdev->getWidget()),
                    XtWindow(xdev->getWidget()),val);
    }
  }
#endif
}

long WSDbtronDragDrop::registerDragSite(WSCbase* client,char* msg){
  WSCprocedure* ac = new WSCprocedure("WSDRAG-START",WSEV_MOUSE_PRESS);
  ac->setFunction(_btn_press_drag_start,"_btn_press_drag_start");
  client->addProcedure(ac);
  client->setUserData("WSDRAG-AC",(void*)ac);
  client->setUserData("WSDRAG-MSG",(void*)WSGFstrdup(msg));
  client->setUserData("WSDRAG-SERV",(void*)this);
  return WS_NO_ERR;
}

long WSDbtronDragDrop::unregisterDragSite(WSCbase* client){
  WSCprocedure* ac = (WSCprocedure*)client->getUserData("WSDRAG-AC");
  char* msg = (char*)client->getUserData("WSDRAG-MSG");
  if (msg != NULL){
    delete msg;
  }
  client->delProcedure(ac);
  delete ac;
  client->setUserData("WSDRAG-AC",(void*)NULL);
  client->setUserData("WSDRAG-MSG",(void*)NULL);
  return WS_NO_ERR;
}

long WSDbtronDragDrop::registerDropSite(WSCbase* dropc,char* msg,void(*hd)(WSCbase*,WSCbase*)){
#ifdef PDBG
  printf("WSDbtronDragDrop::registerDropSite #%s# num=%d 0x%x\n",
  dropc->getInstanceName(),_drop_site_list.getNum(),dropc);
#endif

//printf("WSDbtronDragDrop::registerDropSite site=0x%x client=%s\n",dropc,dropc->getInstanceName());
  dropc->setUserData("WSDRAG-MSG",(void*)WSGFstrdup(msg));
  dropc->setUserData("DROP-PROC",(void*)hd);
  _drop_site_list.add((void*)dropc);

  return WS_NO_ERR;
}

long WSDbtronDragDrop::unregisterDropSite(WSCbase* client){
#ifdef PDBG
  printf("WSDbtronDragDrop::unregisterDropSite #%s# num=%d 0x%x\n",
  client->getInstanceName(),_drop_site_list.getNum(),client);
#endif
  char* msg = (char*)client->getUserData("WSDRAG-MSG");
  if (msg != NULL){
    delete msg;
  }
  client->setUserData("WSDRAG-MSG",(void*)NULL);
  _drop_site_list.del(client);
#ifdef PDBG
  printf("WSDbtronDragDrop::unregisterDropSite done. num=%d\n",
  _drop_site_list.getNum());
#endif

  return WS_NO_ERR;
}

#endif
