//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <WScom.h>
#include <devfb/devfb.h>
#include <devfb/devfb_dep.h>

extern int _add_event(WSDdeviceEventList* evt);
extern int _device_check_event_available();
extern int _search_window(short x,short y);

int _get_event(WSDdeviceEvent* evt,unsigned int mode){
//printf("_get_event start..\n");
//printf("_get_event()\n");
  if (_evt_list == NULL){
    if ( _device_check_event_available() != False ){
      evt->s.type = EV_MSG;
//printf("_get_event done0..\n");
      return WS_NO_ERR;
    }
//printf("_get_event done1..\n");
    return WS_ERR;
  }

  WSDdeviceEventList* item = _evt_list;
  WSDdeviceEventList* item_bak = NULL;
  while(1){
    if (item == NULL){ 
      break;
    }
    if ((mode & 0xfff0 ) == DSPEVT){
      if (item->_event.r.type != EV_REQUEST){
        item_bak = item;
        item = item->_next;
        continue;
      }
      if (item->_event.r.cmd != W_REDISP){
        item_bak = item;
        item = item->_next;
        continue;
      }
    }
    if (item_bak == NULL){
      _evt_list = item->_next;
    }else{
      item_bak->_next = item->_next;
    }
    memcpy(evt,&(item->_event),sizeof(WSDdeviceEvent));
    free(item);
//printf("_get_event done2..\n");
    return WS_NO_ERR;
  }
//printf("_get_event done3..\n");
  if ((mode & 0xfff0 ) == DSPEVT){
    return WS_ERR;
  }
  //TODO: get mouse event..
  //TODO: get key event..
  if ( _device_check_event_available() != False ){
    evt->s.type = EV_MSG;
    return WS_NO_ERR;
  }
  return WS_NO_ERR;
}

extern int _touch_pannel_x;
extern int _touch_pannel_y;
extern int _mouse_status;

void _add_mouse_move_evt(int px,int py){
  int wid = _search_window(px,py);
  if (wid == 0){
    return;
  }
  WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);
  evt->s.type = EV_NULL;
  evt->s.cmd = W_WORK;
  evt->s.wid = wid;
  short wx = _window_list[wid -1]._x;
  short wy = _window_list[wid -1]._y;
  evt->s.wid = wid;
  evt->e.pos.x = px -wx;
  evt->e.pos.y = py -wy;
//  evt->s.stat = _mouse_status;
  evt->s.stat = ES_BUT;
  _touch_pannel_x = px;
  _touch_pannel_y = py;
//    _draw_mouse_cursor();
//printf("add butmove.. %d,%d\n",px,py);
  _add_event(evtl);
}

void _add_mouse_evt(int px,int py,int pressed){
  int wid = _search_window(px,py);
  if (wid == 0){
    return;
  }
  WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
  WSDdeviceEvent* evt = &(evtl->_event);
  if (pressed == 0){
    evt->s.type = EV_BUTUP;
    evt->s.stat = ES_BUT;
//printf("add butup.. %d,%d\n",px,py);
  }else{
    evt->s.type = EV_BUTDWN;
    evt->s.stat = ES_BUT;
//printf("add butdown.. %d,%d\n",px,py);
  }
  evt->s.cmd = W_WORK;
  evt->s.wid = wid;
  short wx = _window_list[wid -1]._x;
  short wy = _window_list[wid -1]._y;
  evt->s.wid = wid;
  evt->e.pos.x = px -wx;
  evt->e.pos.y = py -wy;
  _touch_pannel_x = px;
  _touch_pannel_y = py;
//    _draw_mouse_cursor();
  _add_event(evtl);
}
