//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <WScom.h>
#include <devfb/devfb.h>
#include <unistd.h>
#ifndef NO_PNG
#include <png.h>
#endif
#ifndef NO_JPEG
extern "C" {
#include <jpeglib.h>
#include <jerror.h>
#include <setjmp.h>
};
#endif

#include <WSCimageSet.h>
#include <WSDfileSystem.h>
#include <WStcpcom.h>
#include <devfb/WSDdevfbImage.h>
#include <devfb/WSDdevfbAppDev.h>
#include <devfb/WSDdevfbColor.h>
#include <WSDfile.h>

extern char* WSGFdevfbAllocNewMemory(long);
extern void WSGFdevfbDeleteMemory(char*);

long WSGFdevfbBufToPixmap(unsigned char *buf,W* pixmap,long width,long height,long* vw,long* vh,long row_bytes,UB**,WSCbool reuse_mem);
long WSGFdevfbBufToPixmap2(unsigned char *buf,W* pixmap,W*,long width,long height,long* vw,long* vh,long row_bytes,UB**,UB**,WSCbool reuse_mem);
long WSGFdevfbBufToPixmapG(unsigned char *buf,W* pixmap,long width,long height,long* vw,long* vh,long row_bytes,UB**,WSCbool reuse_mem);
long WSGFdevfbBmpReadFpToPixmap(WSDfile* ifile,W* pixmap,W*,long* w,long* h,UB**,UB**);
long WSGFdevfbBmpReadFileToPixmap(char* filename,W* pixmap,W*,long* w,long* h,UB**,UB**);
long PngReadFileToPixmap(char* filename,GID* mem_gid,GID* mem_gid2,long* w,long* h,UB**,UB**);
#ifndef NO_JPEG
extern long JpegReadFileToPixmap(char* filename,long size,GID* mem_gid,GID* mem_gid2,long* w,long* h,UB**,UB**,WSCbool reuse_mem);
#endif

WSMFclassInit(WSDdevfbImage,WSDimage);

WSDimage* _devfbImage_create_handler(){
  WSDimage* image = new WSDdevfbImage();
  return image;
};

void  _devfbImage_init(){
    WSGIappImageSet()->setCreateHandler(_devfbImage_create_handler);
};

WSDdevfbImage::WSDdevfbImage(){
  _pix_buf = NULL;
  _pix_buf2 = NULL;
}

WSDdevfbImage::~WSDdevfbImage(){
  destroy();
}

long WSDdevfbImage::initialize(){
dbprintf("IMG>> WSDdevfbImage::initialize start..\n");
  if (WSGIdevfbAppDev()->getGidInitialized() == False){
    return WS_ERR;
  }
  if (_value1 > 0){
    return WS_NO_ERR;
  }
  char* iname = getSrc();
  if (iname == NULL || !strcmp(iname,"") ){
    return WS_NO_ERR;
  }

  WSCstring tmp;
  tmp.setString(iname);
#ifdef TE
  tmp.replaceString("$(WSDIR)/sys/pixmaps/","/SYS/",1);
#endif
  WSCstring in;
  in.setString( WSGIappFileSystem()->adjustFileName(tmp.getString()) );
dbprintf("IMG>> WSDdevfbImage::initialize img=%s\n",in.getString());
  if (in.isExist(".xpm") != -1 || in.isExist(".XPM") != -1){
//    long words = in.getWords("/");
//    WSCstring in2 = in.getWord(words-1,"/");
    WSCstring in2 = in;
    in2.replaceString(".xpm",".png",1);
    in2.replaceString(".XPM",".png",1);
    in = in2;
  }
#ifndef NO_JPEG
  if (in.isExist(".jpg") != -1 || in.isExist(".JPG") != -1){
     GID mem_gid = 0;
     GID mem_gid2 = 0;
     long width = _w;
     long height = _h;
     char* load_file_name = in.getString();
     long reti = 0;

     if (strncmp("http://",in.getString(),7)){
       if (_mode & WS_IMAGE_MODE_REUSE_MEM){
         reti = JpegReadFileToPixmap( load_file_name,0, &mem_gid,&mem_gid2,
                                  &width,&height,&_pix_buf,&_pix_buf2,True);
       }else{
         reti = JpegReadFileToPixmap( load_file_name,0, &mem_gid,&mem_gid2,
                                  &width,&height,&_pix_buf,&_pix_buf2,False);
       }
     }else{
       char*  pbuf = NULL;
       long size = 0;
       long reti;
       char*  ctype = NULL;
       long  ishtml = 0;
#ifndef NO_SOCKET
       WSGFloadRemoteFile(in.getString(),&pbuf,&ctype,&size,&ishtml,1);
#endif
       if (pbuf != NULL){
         if (_mode & WS_IMAGE_MODE_REUSE_MEM){
           reti = JpegReadFileToPixmap( pbuf,size, &mem_gid,&mem_gid2,
                                  &width,&height,&_pix_buf,&_pix_buf2,True);
         }else{
           reti = JpegReadFileToPixmap( pbuf,size, &mem_gid,&mem_gid2,
                                  &width,&height,&_pix_buf,&_pix_buf2,False);
         }
         free(pbuf);
       }else{
         reti = 1;
       }
     }
     if (mem_gid == 0){
       mem_gid = -1;
     }
     if (reti == 0){
       setImageWidth(width);
       setImageHeight(height);
       setValue1((long)mem_gid);
       setValue2((long)mem_gid2);
     }else{
//WSMFtrace("ERROR. WSDdevfbImage::initialize file open error. file=%s\n",load_file_name);
     }
  }else
#endif
#ifndef NO_PNG
  if (in.isExist(".png") != -1 || in.isExist(".PNG") != -1){
//WSMFtrace("WSDdevfbImage::initialize %s\n",in.getString());
     W mem_gid;
     W mem_gid2;
     long width = _w;
     long height = _h;
     char* load_file_name = in.getString();
dbprintf("IMG>> WSDdevfbImage::initialize png..\n");
     long reti = PngReadFileToPixmap( load_file_name, &mem_gid,&mem_gid2,
                                      &width,&height,&_pix_buf,&_pix_buf2);
dbprintf("IMG>> WSDdevfbImage::initialize png done..\n");
     if (mem_gid == 0){
       mem_gid = -1;
     }
     if (reti == 0){
       setImageWidth(width);
       setImageHeight(height);
       setValue1((long)mem_gid);
       setValue2((long)mem_gid2);
     }else{
//WSMFtrace("ERROR. WSDdevfbImage::initialize file open error. file=%s\n",load_file_name);
     }

  }else
#endif
//WSMFtrace("WSDdevfbImage::initialize %s\n",in.getString());
  if (in.isExist(".bmp") != -1 || in.isExist(".BMP") != -1){
     W mem_gid;
     W mem_gid2;
     long width = _w;
     long height = _h;
     char* load_file_name = in.getString();
//     WSDdevfbAppDev* app   = WSGIxwinAppDev(); 
     in.delHeadSpace();
//     GC gc = WSGIxwinAppDev()->appGC2();

     long reti = WSGFdevfbBmpReadFileToPixmap(
                       load_file_name, &mem_gid,&mem_gid2, &width,&height,&_pix_buf,&_pix_buf2);
     if (mem_gid == 0){
       mem_gid = -1;
     }
     if (reti == 0){
       setImageWidth(width);
       setImageHeight(height);
       setValue1((long)mem_gid);
       setValue2((long)mem_gid2);
     }else{
//WSMFtrace("ERROR. WSDdevfbImage::initialize file open error. file=%s\n",load_file_name);
     }
  }
dbprintf("IMG>> WSDdevfbImage::initialize done.\n",in.getString());

  return WS_NO_ERR;
}

long WSDdevfbImage::destroy(){
  W memgid1 = (W)_value1;
  if (memgid1 != 0 && memgid1 != -1 ){
    if (_mode & WS_IMAGE_MODE_REUSE_MEM){
      WSGFdevfbDeleteMemory((char*)_pix_buf);
    }else{
      delete _pix_buf;
    }
    _pix_buf = NULL;
    gcls_env(memgid1);
    setValue1((long)-1);
  }
  W memgid2 = (W)_value2;
  if (memgid2 != 0 && memgid2 != -1 ){
    delete _pix_buf2;
    _pix_buf2 = NULL;
    gcls_env(memgid2);
    setValue2((long)-1);
  }

  return WS_NO_ERR;
}
long WSDdevfbImage::createImage(){
  return WS_NO_ERR;
}

int WSGFdevfbgetbyte(WSDfile* fp) {
  WSCuchar c[1];
  if (fp->read(c,1) < 1){
    return -1;
  }
  return c[0];
}

int WSGFdevfbreadLittleShort(WSDfile* fp, short *d) {
  WSCuchar c[1]; 
  if (fp->read(c,1) < 1){
    return -1; 
  }
  *d = c[0] & 0xff;
  if (fp->read(c,1) < 1){
    return -1;
  }
  *d |= (c[0] & 0xff) << 8;
  return 0;
}

int WSGFdevfbreadLittleLong(WSDfile* fp, long *d) {
  WSCuchar c[1];
  if (fp->read(c,1) < 1){
    return -1;
  }
  *d = c[0] & 0xff;
  if (fp->read(c,1) < 1){
    return -1;
  }
  *d |= ((c[0] & 0xff) << 8);
  if (fp->read(c,1) < 1){
    return -1;
  }
  *d |= ((c[0] & 0xff) << 16);
  if (fp->read(c,1) < 1){
    return -1;
  }
  *d |= ((c[0] & 0xff) << 24);
  return 0;
}

long WSGFdevfbBmpReadFpToPixmap(WSDfile* ifile,W* pixmap,W* pixmap2,long* w,long* h,UB** ptr,UB** ptr2){

  // bmp (Windows 3.x) header
  //       implemented
  //            1. uncompressed 1bit black & white
  //            2. uncompressed 4bit  16 color
  //            3. uncompressed 8bit 256 color
  //            4. uncompressed 24bit true color
  //            5. RLE 4bit  16 color
  //            6. RLE 8bit 256 color
  unsigned char red[256], green[256], blue[256];
  if ((WSGFdevfbgetbyte(ifile) != 'B') || (WSGFdevfbgetbyte(ifile) != 'M')){  //  0
    // not a .bmp file
    return -1;
  }
  long width, height, long_tmp, fsize, foffs, cmapsize, cmptype;
  short bit_cnt, short_tmp;
  if (WSGFdevfbreadLittleLong(ifile, &fsize) == -1){                //  2
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &long_tmp) == -1){             //  6
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &foffs) == -1){                 // 10
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &long_tmp) == -1){             // 14
    return -1;
  }
  if (long_tmp != 40){
    // not a Windows 3.x bmp file
    if (long_tmp != 0x6c){
      return -1;
    }
  }
  if (WSGFdevfbreadLittleLong(ifile, &width) == -1){                 // 18
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &height) == -1){                // 22
    return -1;
  }
  if (WSGFdevfbreadLittleShort(ifile, &short_tmp) == -1){            // 26
    return -1;
  }
  if (short_tmp != 1){
    // plane != 1 is not supported
    return -1;
  }
  if (WSGFdevfbreadLittleShort(ifile, &bit_cnt) == -1){              // 28
    return -1;
  }
  if ((bit_cnt != 1) && (bit_cnt != 4) && (bit_cnt != 8) &&
      (bit_cnt != 24) && (bit_cnt != 32)){
    // bit_cnt=16 is not supported
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &cmptype) == -1){              // 30
    return -1;
  }
  if (cmptype > 2){
    if (cmptype == 3 && bit_cnt == 32){
      // 24bit + mask.
    }else{
      // compressed file is not supported
      return -1;
    }
  }
  if (WSGFdevfbreadLittleLong(ifile, &long_tmp) == -1){              // 34
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &long_tmp) == -1){              // 38
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &long_tmp) == -1){              // 42
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &cmapsize) == -1){              // 46
    return -1;
  }
  if (WSGFdevfbreadLittleLong(ifile, &long_tmp) == -1){              // 50
    return -1;
  }
  if ((cmapsize == 0) && (bit_cnt <=8)){
    cmapsize = 1 << bit_cnt;
  }
  int n, c;
  for (n = 0; n < cmapsize; n++) {
    if ((c = WSGFdevfbgetbyte(ifile)) == -1){
      return -1;
    }
    blue[n] = (unsigned char)c;
    if ((c = WSGFdevfbgetbyte(ifile)) == -1){
      return -1;
    }
    green[n] = (unsigned char)c;
    if ((c = WSGFdevfbgetbyte(ifile)) == -1){
      return -1;
    }
    red[n] = (unsigned char)c;
    if (WSGFdevfbgetbyte(ifile) == -1){
        return -1;
    }
  }
  if (ifile->seek(foffs) != WS_NO_ERR){
    return -1;
  }
  unsigned char* fbuf = new unsigned char[fsize - foffs];
  if (ifile->read(fbuf, fsize - foffs) != (fsize - foffs)) {
    delete fbuf;
    return -1;
  }
  unsigned char* buf = new unsigned char[width * height * 3];
  unsigned char* buf_mask = NULL;
  if (cmptype == 3){
    buf_mask = new unsigned char[width * height*3];
  }
  unsigned char *tmp, *ftmp;
  unsigned char *tmp_mask;

  int line, dat, x, y;

  if (cmptype) {
    for (y = 0; y < height; y++) {
      tmp = buf + (height - 1 - y) * width * 3;
      for (x = 0; x < width; x++) {
        *(tmp++) = red[0];        // red
        *(tmp++) = green[0];      // green
        *(tmp++) = blue[0];       // blue
      }
    }
  }
  if (cmptype == 1) {
    // BI_RLE8
    x = 0;
    y = 0;
    ftmp = fbuf;
    while (1) {
      if (*ftmp) {
        // copy N times
        tmp = buf + (((height - 1 - y) * width) + x) * 3;
        for (n = 0; n < *ftmp; n++, x++) {
          if (x<width){
            *(tmp++) = red[*(ftmp + 1)];        // red
            *(tmp++) = green[*(ftmp + 1)];      // green
            *(tmp++) = blue[*(ftmp + 1)];       // blue
          }
        }
        ftmp += 2;
      } else {
        if (*(ftmp + 1) == 0) {
          // newline
          x = 0;
          y++;
          ftmp += 2;
        } else if (*(ftmp + 1) == 1) {
          // end
          break;
        } else if (*(ftmp + 1) == 2) {
          // jump
          x += *(ftmp + 2);
          y += *(ftmp + 3);
          ftmp += 4;
        } else {
          // copy
          tmp = buf + (((height - 1 - y) * width) + x) * 3;
          for (n = 0; n < *(ftmp + 1); n++, x++) {
            if (x<width){
              *(tmp++) = red[*(ftmp + n + 2)];        // red
              *(tmp++) = green[*(ftmp + n + 2)];      // green
              *(tmp++) = blue[*(ftmp + n + 2)];       // blue
            }
          }
          ftmp += (*(ftmp + 1) + 2 + (*(ftmp + 1) % 2)?1:0);
        }
      }
    }
  } else if (cmptype == 2) {
    // BI_RLE4
    int m;
    x = 0;
    y = 0;
    ftmp = fbuf;
    while (1) {
      if (*ftmp) {
        // copy N times
        tmp = buf + (((height - 1 - y) * width) + x) * 3;
        for (n = 0; n < *ftmp; n++, x++) {
          if (x % 2)
            dat = *(ftmp + 1) & 0x0f;         // left
          else
            dat = (*(ftmp + 1) & 0xf0) >> 4;  // right
          *(tmp++) = red[dat];        // red
          *(tmp++) = green[dat];      // green
          *(tmp++) = blue[dat];       // blue
        }
        ftmp += 2;
      } else {
        if (*(ftmp + 1) == 0) {
          // newline
          x = 0;
          y++;
          ftmp += 2;
        } else if (*(ftmp + 1) == 1) {
          // end
          break;
        } else if (*(ftmp + 1) == 2) {
          // jump
          x += *(ftmp + 2);
          y += *(ftmp + 3);
          ftmp += 4;
        } else {
          // copy
          m = 0;
          tmp = buf + (((height - 1 - y) * width) + x) * 3;
          for (n = 0; n < *(ftmp + 1); n++, x++) {
            if (x % 2) {
              dat = *(ftmp + m + 2) & 0x0f;         // left
              m++;
            } else
              dat = (*(ftmp + m + 2) & 0xf0) >> 4;  // right
            *(tmp++) = red[dat];        // red
            *(tmp++) = green[dat];      // green
            *(tmp++) = blue[dat];       // blue
          }
          m = (*(ftmp + 1) + 1) / 2;
          ftmp += (m + 2 + ((m % 2)?1:0));
        }
      }
    }
  } else {
    // uncompress
    switch(bit_cnt) {
      case 1:
        line = ((width + 31) / 32) * 4;
        tmp = buf;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height - 1 - y) * line);
          for (x = 0; x < width; x++){
            dat = (*ftmp >> (7 - (x % 8))) & 0x01;
            if ((x % 8) == 7){
              ftmp++;
            }
            *(tmp++) = red[dat];          // red
            *(tmp++) = green[dat];        // green
            *(tmp++) = blue[dat];         // blue
          }
        }
        break;
      case 4:
        line = ((width + 7) / 8) * 4;
        tmp = buf;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height - 1 - y) * line);
          for (x = 0; x < width; x++){
            if (x % 2) {
              dat = *ftmp & 0x0f;         // left
              ftmp++;
            }else{
              dat = (*ftmp & 0xf0) >> 4;  // right
            }
            *(tmp++) = red[dat];          // red
            *(tmp++) = green[dat];        // green
            *(tmp++) = blue[dat];         // blue
          }
        }
        break;
      case 8:
        line = ((width + 3) / 4) * 4;
        tmp = buf;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height - 1 - y) * line);
          for (x = 0; x < width; x++){
            *(tmp++) = red[*ftmp];        // red
            *(tmp++) = green[*ftmp];      // green
            *(tmp++) = blue[*ftmp];       // blue
            ftmp++;
          }
        }
        break;
      case 24:
        tmp = buf;
        tmp_mask = buf_mask;
        for (y = 0; y < height; y++){
          if (cmptype != 3){
//            ftmp = fbuf + (height - 1 - y) * width * 3;
            ftmp = fbuf + (height - 1 - y) * (((width * 3)+3)/4)*4;
          }else{
            ftmp = fbuf + ((height - 1 - y) * width * 4);
          }
          for (x = 0; x < width; x++){
            *(tmp++) = *(ftmp + 2);       // red
            *(tmp++) = *(ftmp + 1);       // green
            *(tmp++) = *(ftmp + 0);       // blue
            if (cmptype != 3){
              ftmp += 3;
            }else{
              *(tmp_mask++) = *(ftmp + 3);
              ftmp += 4;
            }
          }
        }
        break;
      case 32:
        tmp = buf;
        tmp_mask = buf_mask;
        for (y = 0; y < height; y++){
          ftmp = fbuf + ((height - 1 - y) * width * 4);
          for (x = 0; x < width; x++){
            *(tmp++) = *(ftmp + 2);       // red
            *(tmp++) = *(ftmp + 1);       // green
            *(tmp++) = *(ftmp + 0);       // blue

            if (cmptype == 3){
              *(tmp_mask++) = *(ftmp + 3);       // blue
//printf("i=%d j=%d pt=%d mask=0x%x\n",y,x,tmp_mask-1 - buf_mask,*(tmp_mask -1));
            }
            ftmp += 4;
          }
        }
        break;
    }
  }
  delete fbuf;
//  long reti = WSGFdevfbBufToPixmap(buf, pixmap, width, height,w,h,width*3,ptr,False);
  long reti =0;
  if (cmptype == 3){
    reti = WSGFdevfbBufToPixmap2(buf, pixmap, pixmap2,width, height,w,h,width*3,ptr,ptr2,False);
    delete buf;
    delete buf_mask;
  }else{
    reti = WSGFdevfbBufToPixmap(buf, pixmap, width, height,w,h,width*3,ptr,False);
    *pixmap2 = 0;
    delete buf;
  }

//  *w = width;
//  *h = height;
  return reti;
}

long WSGFdevfbBufToPixmap(unsigned char *buf,W* mem_gid,long rwidth,long rheight,long* w,long* h,long row_bytes,UB** _gid_buf,WSCbool reuse_mem){

  long stretched = False;
  long vwidth = *w;
  long vheight = *h;
  if (vwidth == 0 || vheight == 0){
    vwidth = rwidth;
    vheight = rheight;
  }else{
    if ((long)(rwidth * vheight/vwidth) < rheight){
      vwidth = (long)(vheight * rwidth/rheight);
    }else{
      vheight = (long)(vwidth * rheight/rwidth);
    }
    if (vwidth == rwidth && vheight == rheight){
      stretched = False;
    }else{
      stretched = True;
    }
  }
  *w = vwidth;
  *h = vheight;
  long i,j;
  UB* buf2 = NULL;
  DEV_SPEC* dspec = WSGIdevfbAppDev()->getDevSpec();
  int ddepth = dspec->pixbits>>8;
  int bits = dspec->pixbits & 0xf;
  int red_shift = dspec->color[0] >> 8;
  int green_shift = dspec->color[1] >> 8;
  int blue_shift = dspec->color[2] >> 8;
  int red_bits = dspec->color[0] & 0xf;
  int green_bits = dspec->color[1] & 0xf;
  int blue_bits = dspec->color[2] & 0xf;
//printf("devspec bits=0x%x 0x%x 0x%x 0x%x\n",dspec->pixbits,dspec->color[0],dspec->color[1],dspec->color[2]);
  long cnt = 0;
  long ptr = 0;
  WSCbool duplicate = False;
  if ((dspec->attr & 0xf) != 1){
    duplicate = True;
    ddepth = 0x10;
    red_shift = 0xb;
    green_shift = 0x5;
    blue_shift = 0;
    red_bits = 5;
    green_bits = 6;
    blue_bits = 5;
    bits = 0x10;
#if 0
  }else{
    if (dspec->color[0] == 0x0b05 &&
        dspec->color[1] == 0x0506 &&
        dspec->color[2] == 0x0005){
      //OK
    }else{
      duplicate = True;
    }
#endif
  }
  if (reuse_mem){
    buf2 = (UB*)WSGFdevfbAllocNewMemory( rheight * rwidth * ddepth/8);
  }else{
    buf2 = new UB [rheight * rwidth * ddepth/8];
  }
  unsigned short* buf2_s = (unsigned short*)buf2;
  unsigned int* buf2_i = (unsigned int*)buf2;
  unsigned char* buf2_c = (unsigned char*)buf2;

  unsigned int val_i;
  unsigned int val_s;
  int rbt = 8-red_bits;
  int gbt = 8-green_bits;
  int bbt = 8-blue_bits;
  if (ddepth == 32){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB r = buf[ptr++];
        UB g = buf[ptr++];
        UB b = buf[ptr++];
        val_i = (r >> rbt) << red_shift |
                (g >> gbt) << green_shift |
                (b >> bbt) << blue_shift;
        buf2_i[cnt++] = val_i;
      }
    }
  }else
  if (ddepth == 24){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB r = buf[ptr++];
        UB g = buf[ptr++];
        UB b = buf[ptr++];
        val_i = (r >> rbt) << red_shift |
                (g >> gbt) << green_shift |
                (b >> bbt) << blue_shift;
        buf2_c[cnt++] = (val_i >> 16) & 0xff;
        buf2_c[cnt++] = (val_i >> 8)  & 0xff;
        buf2_c[cnt++] = (val_i)       & 0xff;
      }
    }
  }else
  if (ddepth == 16){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB r = buf[ptr++];
        UB g = buf[ptr++];
        UB b = buf[ptr++];
        val_s = (r >> rbt) << red_shift |
                (g >> gbt) << green_shift |
                (b >> bbt) << blue_shift;
        buf2_s[cnt++] = val_s;
      }
    }
  }

  BMP bmp;
  bmp.planes = 1;
#if 0
  bmp.pixbits = 0x1010;
#endif
  bmp.pixbits = ddepth << 8 | bits;
  bmp.rowbytes = rwidth* ddepth /8;
  bmp.bounds.c.left = 0;
  bmp.bounds.c.top = 0;
  bmp.bounds.c.right = rwidth;
  bmp.bounds.c.bottom = rheight;
  bmp.baseaddr[0] = buf2;

  CSPEC   csp;
  csp.attr = DA_COLOR_RGB;
//  csp.info[0] = 0x1008;
//  csp.info[1] = 0x0808;
//  csp.info[2] = 0x0008;
//  csp.info[3] = 0;
#if 0
  csp.info[0] = 0x0b05;
  csp.info[1] = 0x0506;
  csp.info[2] = 0x0005;
  csp.info[3] = 0;
#endif
  csp.info[0] = (red_shift << 8) | red_bits;
  csp.info[1] = (green_shift << 8) | green_bits;
  csp.info[2] = (blue_shift << 8) | blue_bits;
  csp.info[3] = 0;

  csp.colmap = NULL;
//printf("shoft=%d,%d,%d bits=%d,%d,%d\n",red_shift,green_shift,blue_shift,red_bits,green_bits,blue_bits);
//printf("0x%x,0x%x,0x%x\n",csp.info[0],csp.info[1],csp.info[2]);
  W bgid = gopn_mem(NULL,&bmp,(B*)(&csp));
//printf("bgid=0x%x\n",bgid);
  if (duplicate == False && stretched == False){
    *mem_gid = bgid;
    *_gid_buf = buf2;
  }else{
    RECT r;
    RECT r2;
    r.c.left = 0;
    r.c.top = 0;
    r.c.right = rwidth;
    r.c.bottom = rheight;
    r2.c.left = 0;
    r2.c.top = 0;
    r2.c.right = vwidth;
    r2.c.bottom = vheight;
    if (stretched != 0){
      r2.c.left = 0;
      r2.c.top = 0;
      r2.c.right = rwidth;
      r2.c.bottom = rheight;
    }

    *mem_gid = WSGIdevfbAppDev()->getNewMemGid(vwidth,vheight,_gid_buf);
//printf(">>>> mem_gid=0x%x  w,h=%d,%d\n",*mem_gid,vwidth,vheight);
    if (*mem_gid == 0){
      if (reuse_mem){
        WSGFdevfbDeleteMemory((char*)buf2);
      }else{
        delete buf2;
      }
      return -1;
    }
    gcop_bmp(bgid,&r2,*mem_gid,&r,NULL,G_CVCOLOR | G_CVFORM | G_STORE);
//  W ret = grst_bmp(*mem_gid,&r,&bmp,&r2,NULL,G_CVCOLOR | G_CVFORM | G_STORE);

    if (reuse_mem){
      WSGFdevfbDeleteMemory((char*)buf2);
    }else{
      delete buf2;
    }
    gcls_env(bgid);
  }
  return 0;
}
long WSGFdevfbBufToPixmapG(unsigned char *buf,W* mem_gid,long rwidth,long rheight,long* w,long* h,long row_bytes,UB** _gid_buf,WSCbool reuse_mem){
  long stretched = False;
  long vwidth = *w;
  long vheight = *h;
  if (vwidth == 0 || vheight == 0){
    vwidth = rwidth;
    vheight = rheight;
  }else{
    if ((long)(rwidth * vheight/vwidth) < rheight){
      vwidth = (long)(vheight * rwidth/rheight);
    }else{
      vheight = (long)(vwidth * rheight/rwidth);
    }
    if (vwidth == rwidth && vheight == rheight){
      stretched = False;
    }else{
      stretched = True;
    }
  }
  *w = vwidth;
  *h = vheight;
  long i,j;
  UB* buf2 = NULL;
  DEV_SPEC* dspec = WSGIdevfbAppDev()->getDevSpec();
  int ddepth = dspec->pixbits>>8;
  int bits = dspec->pixbits & 0xf;
  int red_shift = dspec->color[0] >> 8;
  int green_shift = dspec->color[1] >> 8;
  int blue_shift = dspec->color[2] >> 8;
  int red_bits = dspec->color[0] & 0xf;
  int green_bits = dspec->color[1] & 0xf;
  int blue_bits = dspec->color[2] & 0xf;

  long cnt = 0;
  long ptr = 0;
  WSCbool duplicate = False;
  if ((dspec->attr & 0xf) != 1){
    duplicate = True;
    ddepth = 0x10;
    red_shift = 0xb;
    green_shift = 0x5;
    blue_shift = 0;
    red_bits = 5;
    green_bits = 6;
    blue_bits = 5;
    bits = 0x10;
  }else{
#if 0
    if (dspec->color[0] == 0x0b05 &&
        dspec->color[1] == 0x0506 &&
        dspec->color[2] == 0x0005){
      //OK
    }else{
      duplicate = True;
    }
#endif
  }

  if (reuse_mem){
    buf2 = (UB*)WSGFdevfbAllocNewMemory( rheight * rwidth * ddepth/8);
  }else{
    buf2 = new UB [rheight * rwidth * ddepth/8];
  }
  unsigned short* buf2_s = (unsigned short*)buf2;
  unsigned int* buf2_i = (unsigned int*)buf2;
  unsigned char* buf2_c = (unsigned char*)buf2;

  unsigned int val_i;
  unsigned short val_s;
  int rbt = 8-red_bits;
  int gbt = 8-green_bits;
  int bbt = 8-blue_bits;

  if (ddepth == 32){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB v = buf[ptr++];
        val_i = (v >> rbt) << red_shift |
                (v >> gbt) << green_shift |
                (v >> bbt) << blue_shift;
        buf2_i[cnt++] = val_i;
      }
    }
  }else
  if (ddepth == 24){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB v = buf[ptr++];
        val_i = (v >> rbt) << red_shift |
                (v >> gbt) << green_shift |
                (v >> bbt) << blue_shift;
        buf2_c[cnt++] = (val_i >> 16) & 0xff;
        buf2_c[cnt++] = (val_i >> 8)  & 0xff;
        buf2_c[cnt++] = (val_i)       & 0xff;
      }
    }
  }else
  if (ddepth == 16){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB v = buf[ptr++];
        val_s = (v >> rbt) << red_shift |
                (v >> gbt) << green_shift |
                (v >> bbt) << blue_shift;
        buf2_s[cnt++] = val_s;
      }
    }
  }

  BMP bmp;
  bmp.planes = 1;
#if 0
  bmp.pixbits = 0x1010;
#endif
  bmp.pixbits = ddepth << 8 | bits;
  bmp.rowbytes = rwidth*ddepth/8;
  bmp.bounds.c.left = 0;
  bmp.bounds.c.top = 0;
  bmp.bounds.c.right = rwidth;
  bmp.bounds.c.bottom = rheight;
  bmp.baseaddr[0] = buf2;

  CSPEC   csp;
  csp.attr = DA_COLOR_RGB;
//  csp.info[0] = 0x1008;
//  csp.info[1] = 0x0808;
//  csp.info[2] = 0x0008;
//  csp.info[3] = 0;
#if 0
  csp.info[0] = 0x0b05;
  csp.info[1] = 0x0506;
  csp.info[2] = 0x0005;
  csp.info[3] = 0;
#endif
  csp.info[0] = (red_shift << 8) | red_bits;
  csp.info[1] = (green_shift << 8) | green_bits;
  csp.info[2] = (blue_shift << 8) | blue_bits;
  csp.info[3] = 0;

  csp.colmap = NULL;

  W bgid = gopn_mem(NULL,&bmp,(B*)(&csp));
//printf("bgid=0x%x\n",bgid);
  if (duplicate == False && stretched == False){
    *mem_gid = bgid;
    *_gid_buf = buf2;
  }else{
    RECT r;
    RECT r2;
    r.c.left = 0;
    r.c.top = 0;
    r.c.right = rwidth;
    r.c.bottom = rheight;
    r2.c.left = 0;
    r2.c.top = 0;
    r2.c.right = vwidth;
    r2.c.bottom = vheight;
    if (stretched != 0){
      r2.c.left = 0;
      r2.c.top = 0;
      r2.c.right = rwidth;
      r2.c.bottom = rheight;
    }

    *mem_gid = WSGIdevfbAppDev()->getNewMemGid(vwidth,vheight,_gid_buf);
//printf(">>>> mem_gid=0x%x  w,h=%d,%d\n",*mem_gid,vwidth,vheight);
    if (*mem_gid == 0){
      if (reuse_mem){
        WSGFdevfbDeleteMemory((char*)buf2);
      }else{
        delete buf2;
      }
      return -1;
    }
    gcop_bmp(bgid,&r2,*mem_gid,&r,NULL,G_CVCOLOR | G_CVFORM | G_STORE);
//  W ret = grst_bmp(*mem_gid,&r,&bmp,&r2,NULL,G_CVCOLOR | G_CVFORM | G_STORE);

    if (reuse_mem){
      WSGFdevfbDeleteMemory((char*)buf2);
    }else{
      delete buf2;
    }
    gcls_env(bgid);
  }
  return 0;
#if 0
  long stretched = 0;
  long vwidth = *w;
  long vheight = *h;
  if (vwidth == 0 || vheight == 0){
    vwidth = rwidth;
    vheight = rheight;
  }else{
    if ((long)((double)rwidth * vheight/vwidth) < rheight){
      vwidth = (long)((double)vheight * rwidth/rheight);
    }else{
      vheight = (long)((double)vwidth * rheight/rwidth);
    }
    stretched = 1;
  }
  *w = vwidth;
  *h = vheight;

  *mem_gid = WSGIdevfbAppDev()->getNewMemGid(vwidth,vheight,_gid_buf);
//printf(">>>> mem_gid=0x%x  w,h=%d,%d\n",*mem_gid,vwidth,vheight);
  if (*mem_gid == 0){
    return -1;
  }
  long i,j;
  long ptr=0;
  unsigned char r,g,b;
  for(i=0; i<vheight; i++){
    ptr = row_bytes*i;
    for(j=0; j<vwidth; j++){
      if (stretched != 0){
        ptr = (long)((double)i*rheight/vheight)*rwidth
             + (long)((double)j*rwidth/vwidth);
      }
      r = buf[ptr];
      g = buf[ptr];
      b = buf[ptr++];
      unsigned long val = 0x10000000;
      PIXVAL pixval = 0;
//      if (speed_up == False){
        val |= r << 16;
        val |= g << 8;
        val |= b;
        gcnv_col(*mem_gid,val,&pixval);
//      }else{
//        pixval |=  (r >> (8 - red_bits)) << red_shift;
//        pixval |=  (g >> (8 - green_bits)) << green_shift;
//        pixval |=  (b >> (8 - blue_bits)) << blue_shift;
//      }
      PNT pt;
      pt.x = j;
      pt.y = i;
      gdra_pnt(*mem_gid,pt,pixval,G_STORE);
    }
  }
  return 0;
#endif
}
long WSGFdevfbBufToPixmap2(unsigned char *buf,W* mem_gid,W* mem_gid2,long rwidth,long rheight,long* w,long* h,long row_bytes,UB** _gid_buf1,UB** _gid_buf2,WSCbool reuse_mem){
#if 1
  long stretched = False;
  long vwidth = *w;
  long vheight = *h;
  if (vwidth == 0 || vheight == 0){
    vwidth = rwidth;
    vheight = rheight;
  }else{
    if ((long)(rwidth * vheight/vwidth) < rheight){
      vwidth = (long)(vheight * rwidth/rheight);
    }else{
      vheight = (long)(vwidth * rheight/rwidth);
    }
    if (vwidth == rwidth && vheight == rheight){
      stretched = False;
    }else{
      stretched = True;
    }
  }
  *w = vwidth;
  *h = vheight;
  long i,j;
  UB* buf2 = NULL;
  UB* buf3 = NULL;
  DEV_SPEC* dspec = WSGIdevfbAppDev()->getDevSpec();
  int ddepth = dspec->pixbits>>8;
  int bits = dspec->pixbits & 0xf;
  int red_shift = dspec->color[0] >> 8;
  int green_shift = dspec->color[1] >> 8;
  int blue_shift = dspec->color[2] >> 8;
  int red_bits = dspec->color[0] & 0xf;
  int green_bits = dspec->color[1] & 0xf;
  int blue_bits = dspec->color[2] & 0xf;


  long cnt = 0;
  long ptr = 0;
  WSCbool duplicate = False;
  if ((dspec->attr & 0xf) != 1){
    duplicate = True;
    ddepth = 0x10;
    red_shift = 0xb;
    green_shift = 0x5;
    blue_shift = 0;
    red_bits = 5;
    green_bits = 6;
    blue_bits = 5;
    bits = 0x10;
#if 0
  }else{
    if (dspec->color[0] == 0x0b05 &&
        dspec->color[1] == 0x0506 &&
        dspec->color[2] == 0x0005){
      //OK
    }else{
      duplicate = True;
    }
#endif
  }

  if (reuse_mem){
    buf2 = (UB*)WSGFdevfbAllocNewMemory( rheight * rwidth * ddepth/8);
    buf3 = (UB*)WSGFdevfbAllocNewMemory( rheight * rwidth * ddepth/8);
  }else{
    buf2 = new UB [rheight * rwidth * ddepth/8];
    buf3 = new UB [rheight * rwidth * ddepth/8];
  }
  unsigned short* buf2_s = (unsigned short*)buf2;
  unsigned int* buf2_i = (unsigned int*)buf2;
  unsigned char* buf2_c = (unsigned char*)buf2;
  unsigned short* buf3_s = (unsigned short*)buf3;
  unsigned int* buf3_i = (unsigned int*)buf3;
  unsigned char* buf3_c = (unsigned char*)buf3;

  unsigned int val_i;
  unsigned int val_s;
  int rbt = 8-red_bits;
  int gbt = 8-green_bits;
  int bbt = 8-blue_bits;

  if (ddepth == 32){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB r = buf[ptr++];
        UB g = buf[ptr++];
        UB b = buf[ptr++];
        UB a = buf[ptr++];

        val_i = (r >> rbt) << red_shift |
                (g >> gbt) << green_shift |
                (b >> bbt) << blue_shift;
        buf2_i[cnt] = val_i;
        if (a != 0){
          buf3_i[cnt++] = 0;
        }else{
          buf3_i[cnt++] = 0xffffffff;
        }
      }
    }
  }else
  if (ddepth == 24){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB r = buf[ptr++];
        UB g = buf[ptr++];
        UB b = buf[ptr++];
        UB a = buf[ptr++];

        val_i = (r >> rbt) << red_shift |
                (g >> gbt) << green_shift |
                (b >> bbt) << blue_shift;
        buf2_c[cnt++] = (val_i >> 16) & 0xff;
        buf2_c[cnt++] = (val_i >> 8)  & 0xff;
        buf2_c[cnt++] = (val_i)       & 0xff;
        if (a != 0){
          buf3_c[cnt++] = 0;
          buf3_c[cnt++] = 0;
          buf3_c[cnt++] = 0;
        }else{
          buf3_c[cnt++] = 0xff;
          buf3_c[cnt++] = 0xff;
          buf3_c[cnt++] = 0xff;
        }
      }
    }
 
  }else
  if (ddepth == 16){
    for(i=0; i<vheight; i++){
      ptr = row_bytes*i;
      for(j=0; j<vwidth; j++){
        UB r = buf[ptr++];
        UB g = buf[ptr++];
        UB b = buf[ptr++];
        UB a = buf[ptr++];

        val_s = (r >> rbt) << red_shift |
                (g >> gbt) << green_shift |
                (b >> bbt) << blue_shift;
        buf2_s[cnt] = val_s;
        if (a != 0){
          buf3_s[cnt++] = 0;
        }else{
          buf3_s[cnt++] = 0xffff;
        }
      }
    }
  }


  BMP bmp;
  bmp.planes = 1;
#if 0
  bmp.pixbits = 0x1010;
#endif
  bmp.pixbits = ddepth << 8 | bits;
  bmp.rowbytes = rwidth* ddepth /8;
  bmp.bounds.c.left = 0;
  bmp.bounds.c.top = 0;
  bmp.bounds.c.right = rwidth;
  bmp.bounds.c.bottom = rheight;
  bmp.baseaddr[0] = buf2;

  BMP bmp2;
  bmp2.planes = 1;
#if 0
  bmp2.pixbits = 0x1010;
#endif
  bmp2.pixbits = ddepth << 8 | bits;
  bmp2.rowbytes = rwidth* ddepth /8;
  bmp2.bounds.c.left = 0;
  bmp2.bounds.c.top = 0;
  bmp2.bounds.c.right = rwidth;
  bmp2.bounds.c.bottom = rheight;
  bmp2.baseaddr[0] = buf3;


  CSPEC   csp;
  csp.attr = DA_COLOR_RGB;
//  csp.info[0] = 0x1008;
//  csp.info[1] = 0x0808;
//  csp.info[2] = 0x0008;
//  csp.info[3] = 0;
#if 0
  csp.info[0] = 0x0b05;
  csp.info[1] = 0x0506;
  csp.info[2] = 0x0005;
  csp.info[3] = 0;
#endif
  csp.info[0] = (red_shift << 8) | red_bits;
  csp.info[1] = (green_shift << 8) | green_bits;
  csp.info[2] = (blue_shift << 8) | blue_bits;
  csp.info[3] = 0;

  csp.colmap = NULL;

  W bgid = gopn_mem(NULL,&bmp,(B*)(&csp));
  W bgid2 = gopn_mem(NULL,&bmp2,(B*)(&csp));
//printf("bgid=0x%x\n",bgid);
  if (duplicate == False && stretched == False){
    *mem_gid = bgid;
    *_gid_buf1 = buf2;
    *mem_gid2 = bgid2;
    *_gid_buf2 = buf3;
//printf(">>>> mem_gid=0x%x,0x%x  w,h=%d,%d\n",*mem_gid,*mem_gid2,vwidth,vheight);
  }else{
    RECT r;
    RECT r2;
    r.c.left = 0;
    r.c.top = 0;
    r.c.right = rwidth;
    r.c.bottom = rheight;
    r2.c.left = 0;
    r2.c.top = 0;
    r2.c.right = vwidth;
    r2.c.bottom = vheight;
    if (stretched != 0){
      r2.c.left = 0;
      r2.c.top = 0;
      r2.c.right = rwidth;
      r2.c.bottom = rheight;
    }

    *mem_gid = WSGIdevfbAppDev()->getNewMemGid(vwidth,vheight,_gid_buf1);
//printf(">>>> mem_gid=0x%x  w,h=%d,%d\n",*mem_gid,vwidth,vheight);
    if (*mem_gid == 0){
      if (reuse_mem){
        WSGFdevfbDeleteMemory((char*)buf2);
        WSGFdevfbDeleteMemory((char*)buf3);
      }else{
        delete buf2;
        delete buf3;
      }
      return -1;
    }
    *mem_gid2 = WSGIdevfbAppDev()->getNewMemGid(vwidth,vheight,_gid_buf2);
    if (*mem_gid2 == 0){
      gcls_env(*mem_gid);
      if (reuse_mem){
        WSGFdevfbDeleteMemory((char*)buf2);
        WSGFdevfbDeleteMemory((char*)buf3);
      }else{
        delete buf2;
        delete buf3;
      }
      return -1;
    }
    W ret = gcop_bmp(bgid,&r2,*mem_gid,&r,NULL,G_CVCOLOR | G_CVFORM | G_STORE);
    ret = gcop_bmp(bgid2,&r2,*mem_gid2,&r,NULL,G_CVCOLOR | G_CVFORM | G_STORE);
//  W ret = grst_bmp(*mem_gid,&r,&bmp,&r2,NULL,G_CVCOLOR | G_CVFORM | G_STORE);

    if (reuse_mem){
      WSGFdevfbDeleteMemory((char*)buf2);
      WSGFdevfbDeleteMemory((char*)buf3);
    }else{
      delete buf2;
      delete buf3;
    }
    gcls_env(bgid);
    gcls_env(bgid2);
  }
  return 0;
#else
  long stretched = 0;
  long vwidth = *w;
  long vheight = *h;
  if (vwidth == 0 || vheight == 0){
    vwidth = rwidth;
    vheight = rheight;
  }else{
    if ((long)(rwidth * vheight/vwidth) < rheight){
      vwidth = (long)(vheight * rwidth/rheight);
    }else{
      vheight = (long)(vwidth * rheight/rwidth);
    }
    stretched = 1;
  }
  *w = vwidth;
  *h = vheight;

  *mem_gid = WSGIdevfbAppDev()->getNewMemGid(vwidth,vheight,_gid_buf1);
  *mem_gid2 = WSGIdevfbAppDev()->getNewMemGid(vwidth,vheight,_gid_buf2);
//printf(">>>> mem_gid=0x%x  w,h=%d,%d\n",*mem_gid,vwidth,vheight);
  if (*mem_gid == 0){
    return -1;
  }
  long i,j;
  long ptr=0;
  unsigned char r,g,b,a;
  for(i=0; i<vheight; i++){
    ptr = row_bytes*i;
    for(j=0; j<vwidth; j++){
      if (stretched != 0){
        ptr = (long)(i*rheight*rwidth/vheight)
             + (long)(j*rwidth/vwidth);
        ptr *= 3;
      }
      r = buf[ptr++];
      g = buf[ptr++];
      b = buf[ptr++];
      a = buf[ptr++];
      unsigned long val = DEVFB_BLACK;
      val |= r << 16;
      val |= g << 8;
      val |= b;
      PIXVAL pixval = 0;
      gcnv_col(*mem_gid,val,&pixval);
      PNT pt;
      pt.x = j;
      pt.y = i;
      gdra_pnt(*mem_gid,pt,pixval,G_STORE);
      if (a != 0){
        a=0xff;
      }
      a = ~a;
      val = DEVFB_BLACK;
      val |= a << 16;
      val |= a << 8;
      val |= a;
      gcnv_col(*mem_gid2,val,&pixval);
      gdra_pnt(*mem_gid2,pt,pixval,G_STORE);
    }
  }
  return 0;
#endif
}
long WSGFdevfbBmpReadFileToPixmap(char* filename,W* pixmap,W* pixmap2,long* w,long* h,UB** ptr,UB** ptr2){

  WSDfile* ifile = WSDfile::getNewInstance();
  if (ifile == NULL){
    return -1;
  }
  if (ifile->open(filename,"r") != WS_NO_ERR){
    return -1;
  }

  long reti = WSGFdevfbBmpReadFpToPixmap(ifile, pixmap,pixmap2, w, h,ptr,ptr2);
  delete ifile;
  return reti;
}

//PNG
#ifndef NO_PNG
void png_cexcept_error(png_structp png_ptr, png_const_charp msg){
   if(png_ptr){
     fprintf(stderr, "png file read error: %s\n", msg);
     bool*  png_err_flag_ptr = (bool*) png_get_error_ptr(png_ptr);
     *png_err_flag_ptr = true;
   }
}
void png_read_data_fn(png_structp png_ptr,png_bytep data,png_size_t length){
  png_size_t check;
   check = (png_size_t)fread(data, (png_size_t)1, length,
      (png_FILE_p)png_ptr->io_ptr);
   if (check != length)
      png_error(png_ptr, "Read Error");
}
long PngReadFileToPixmap(char* filename,GID* mem_gid,GID* mem_gid2,long* w,long* h,UB** ptr1,UB** ptr2){

    FILE* ifile = fopen(filename,"r");
    if (ifile == NULL){
      return -1;
    }

    png_byte            sig[8];
    fread(sig, 1, 8, ifile);
    if (!png_check_sig(sig, 8)){
      fclose(ifile);
      return -1;
    }
    bool png_err_flag = false;
    png_structp png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING,
      (png_voidp) &png_err_flag,
      (png_error_ptr)png_cexcept_error, (png_error_ptr)NULL);
    if (png_ptr == NULL){
      fclose(ifile);
      return -1;
    } 
    png_infop info_ptr = png_create_info_struct(png_ptr);
    if (info_ptr == NULL){
      png_destroy_read_struct(&png_ptr, NULL, NULL);
      fclose(ifile);
      return -1;
    }

//    png_init_io(png_ptr, ifile);
//    png_ptr->io_ptr = (png_voidp)ifile;
    png_set_read_fn(png_ptr,(png_voidp)ifile,png_read_data_fn);
    png_set_sig_bytes(png_ptr, 8);
    png_read_info(png_ptr, info_ptr);

    if (png_err_flag != false)  {
      png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
      fclose(ifile);
      return -1;
    }

    png_uint_32 png_width;
    png_uint_32 png_height;
    int png_depth;
    int png_color_type;
    png_get_IHDR(png_ptr, info_ptr, &png_width, &png_height, &png_depth,
            &png_color_type, NULL, NULL, NULL);
    if (png_depth == 16){
      png_set_strip_16(png_ptr);
    }
#if 1 //replace new logic
    if (png_depth < 8)
        png_set_packing(png_ptr);
    //  Transformations
    //  from readpng2_info_callback() in contrib/gregbook/readpng2.c
    if (png_color_type == PNG_COLOR_TYPE_PALETTE)
        png_set_expand(png_ptr);
    if (png_color_type == PNG_COLOR_TYPE_GRAY && png_depth < 8)
        png_set_expand(png_ptr);
    if (png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS))
        png_set_expand(png_ptr);
    if (png_color_type == PNG_COLOR_TYPE_GRAY ||
        png_color_type == PNG_COLOR_TYPE_GRAY_ALPHA)
        png_set_gray_to_rgb(png_ptr);

    // Ignore background color with transparent and alpha
    // png_get_bKGD(), png_set_background()

    // Gamma conversion
    //  example.c 
    int intent;
    //screen_gamma = 2.2; // A good guess for a PC monitor
    //                    //   in a bright office or a dim room
    //screen_gamma = 2.0; // A good guess for a PC monitor
    //                    //   in a dark room
    const double screen_gamma = 2.2;
    if (png_get_sRGB(png_ptr, info_ptr, &intent))
       png_set_gamma(png_ptr, screen_gamma, 0.45455);
    else
    {
       double image_gamma;
       if (png_get_gAMA(png_ptr, info_ptr, &image_gamma))
          png_set_gamma(png_ptr, screen_gamma, image_gamma);
       else
          png_set_gamma(png_ptr, screen_gamma, 0.45455);
    }

    // after the transformations have been registered update info_ptr data
    png_read_update_info(png_ptr, info_ptr);

    // need this code?
    // get again width, height and the new bit-depth and color-type
    png_get_IHDR(png_ptr, info_ptr, &png_width, &png_height, &png_depth,
            &png_color_type, NULL, NULL, NULL);

    png_uint_32 png_row_bytes = png_get_rowbytes(png_ptr, info_ptr);
    png_uint_32 png_channels = png_get_channels(png_ptr, info_ptr);
#else
    png_uint_32 png_row_bytes = png_get_rowbytes(png_ptr, info_ptr);
    png_uint_32 png_channels = png_get_channels(png_ptr, info_ptr);
    if (png_depth < 8){
      if (png_color_type == PNG_COLOR_TYPE_GRAY ){
        png_set_gray_1_2_4_to_8(png_ptr);
        png_row_bytes = png_width * 3;
        png_channels = 3;
dbprintf("IMG> PNG_COLOR_TYPE_GRAY c=%d\n",png_channels);
      }else if (png_color_type == PNG_COLOR_TYPE_GRAY_ALPHA){
        png_set_gray_1_2_4_to_8(png_ptr);
        png_row_bytes = png_width * 4;
        png_channels = 4;
dbprintf("IMG> PNG_COLOR_TYPE_GRAY_ALPHA c=%d\n",png_channels);
      }else{
        png_set_expand(png_ptr);
        png_row_bytes = png_width * 3;
        png_channels = 3;
dbprintf("IMG> other c=%d\n",png_channels);
      }
    }
    if (png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS)){
      png_set_expand(png_ptr);
      png_row_bytes = png_width;
dbprintf("IMG> PNG_INFO_tRNS c=%d\n",png_channels);
      if (png_channels == 1){
        png_row_bytes = png_width * 4;
        png_channels = 4;
dbprintf("IMG> PNG_INFO_tRNS fixed c=%d\n",png_channels);
      }
      if (png_channels == 3){
        png_row_bytes = png_width * 4;
        png_channels = 4;
dbprintf("IMG> PNG_INFO_tRNS fixed c=%d\n",png_channels);
      }
    }
    if (png_color_type == PNG_COLOR_TYPE_GRAY ||
        png_color_type == PNG_COLOR_TYPE_GRAY_ALPHA){
      png_set_gray_to_rgb(png_ptr);
dbprintf("IMG> PNG_COLOR_TYPE_GRAY || GRAY_ALPHA c=%d\n",png_channels);
      if (png_channels < 2){
        png_row_bytes = png_width;
      }
    }

    if (png_color_type == PNG_COLOR_TYPE_PALETTE){
      png_set_palette_to_rgb(png_ptr);
      png_row_bytes = png_width * 3;
      png_channels = 3;
dbprintf("IMG> PNG_COLOR_TYPE_PALETTE\n");
    }
    if (png_channels == 2){
      png_row_bytes = png_width * 4;
      png_channels = 4;
    }
    if (png_channels == 1){
      png_row_bytes = png_width * 3;
      png_channels = 3;
    }
#endif

//    long rwidth = png_width;
//    long rheight = png_height;
    long components = png_channels;

dbprintf("IMG> png_depth=%d w,h=%d,%d row_bytes=%d c=%d\n",png_depth,png_width,png_height,png_row_bytes,png_channels);
    unsigned char* buf = NULL;
//    if (components == 2){
//      buf = new unsigned char[png_row_bytes * png_height * sizeof(png_byte)*2];
//    }else{
      buf = new unsigned char[png_row_bytes * png_height * sizeof(png_byte)];
//    }
    if (buf == NULL){
fprintf(stderr,"png read error: out of memory..\n");
      png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
      fclose(ifile);
      return -1;
    }
    png_byte** png_row_ptrs = new png_bytep[png_height];
    if (png_row_ptrs == NULL){
fprintf(stderr,"png read error: out of memory..\n");
      png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
      fclose(ifile);
      delete buf;
      return -1;
    }
    int i;
    for(i = 0; i < (int)png_height; i++){
//      if (components == 2){
//        png_row_ptrs[i] = (png_byte*)(buf + i * png_row_bytes*2);
//      }else{
        png_row_ptrs[i] = (png_byte*)(buf + i * png_row_bytes);
//      }
    }
    png_read_image(png_ptr, png_row_ptrs);
    png_read_end(png_ptr,NULL);
    delete png_row_ptrs;
    if (components == 4){
      WSGFdevfbBufToPixmap2(buf, mem_gid,mem_gid2,png_width,png_height,w,h,png_row_bytes,ptr1,ptr2,False);
    }else if (components == 3){
      *mem_gid2 = 0;
      WSGFdevfbBufToPixmap(buf, mem_gid,png_width,png_height,w,h,png_row_bytes,ptr1,False);
    }else if (components == 2){
      WSGFdevfbBufToPixmap2(buf, mem_gid,mem_gid2,png_width,png_height,w,h,png_row_bytes,ptr1,ptr2,False);
    }else{
      delete buf;
      png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
      fclose(ifile);
      return -1;
    }
    delete buf;
    png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
    fclose(ifile);
    return 0;
}
#endif

#ifndef NO_JPEG
struct jpeg_error_mgr2 {
  struct jpeg_error_mgr pub;
  jmp_buf setjmp_buffer;
};


static void ehandler(j_common_ptr jinf,int level){
}

static void exhandler(j_common_ptr jinf){
  struct jpeg_error_mgr2* jerr = (struct jpeg_error_mgr2*)jinf->err;
  longjmp(jerr->setjmp_buffer,1);
}
static int chandler(j_decompress_ptr jinf){
return TRUE;
}

#define BTRON_ADDED
#ifdef BTRON_ADDED
typedef struct {
  struct jpeg_source_mgr pub;   /* public fields */
  FILE * infile;        /* source stream */
  JOCTET * buffer;      /* start of buffer */
  boolean start_of_file;    /* have we gotten any data yet? */
} _source_mgr;

#define JFREAD(file,buf,sizeofbuf)  \
  ((size_t) fread((void *) (buf), (size_t) 1, (size_t) (sizeofbuf), (file)))

void init_source (j_decompress_ptr cinfo)
{
  _source_mgr* src = (_source_mgr*) cinfo->src;
  src->start_of_file = TRUE;
}
boolean fill_input_buffer (j_decompress_ptr cinfo){
  _source_mgr* src = (_source_mgr*) cinfo->src;
  size_t nbytes;
  nbytes = JFREAD(src->infile, src->buffer, 4096);
  if (nbytes <= 0) {
    if (src->start_of_file) /* Treat empty input file as fatal error */
      ERREXIT(cinfo, JERR_INPUT_EMPTY);
    WARNMS(cinfo, JWRN_JPEG_EOF);
    /* Insert a fake EOI marker */
    src->buffer[0] = (JOCTET) 0xFF;
    src->buffer[1] = (JOCTET) JPEG_EOI;
    nbytes = 2;
  }
                                                                                
  src->pub.next_input_byte = src->buffer;
  src->pub.bytes_in_buffer = nbytes;
  src->start_of_file = FALSE;
                                                                                
  return TRUE;
}
void skip_input_data (j_decompress_ptr cinfo, long num_bytes){
  _source_mgr* src = (_source_mgr*) cinfo->src;
  if (num_bytes > 0) {
    while (num_bytes > (long) src->pub.bytes_in_buffer) {
      num_bytes -= (long) src->pub.bytes_in_buffer;
      (void) fill_input_buffer(cinfo);
    }
    src->pub.next_input_byte += (size_t) num_bytes;
    src->pub.bytes_in_buffer -= (size_t) num_bytes;
  }
}
void term_source(j_decompress_ptr){
}
void jpeg_stdio_src (j_decompress_ptr cinfo, FILE * infile){
  _source_mgr* src;
  if (cinfo->src == NULL) { /* first time for this JPEG object? */
    cinfo->src = (struct jpeg_source_mgr *)
      (*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_PERMANENT,
                  sizeof(_source_mgr));
    src = (_source_mgr*) cinfo->src;
    src->buffer = (JOCTET *)
      (*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_PERMANENT,
                  4096 * sizeof(JOCTET));
  }
  src = (_source_mgr*) cinfo->src;
  src->pub.init_source = init_source;
  src->pub.fill_input_buffer = fill_input_buffer;
  src->pub.skip_input_data = skip_input_data;
  src->pub.resync_to_restart = jpeg_resync_to_restart; /* use default method */
  src->pub.term_source = term_source;
  src->infile = infile;
  src->pub.bytes_in_buffer = 0; /* forces fill_input_buffer on first read */
  src->pub.next_input_byte = NULL; /* until buffer loaded */
}
#endif //BTRON_ADDED

typedef struct {
  struct jpeg_source_mgr pub;
  char* buf;
  char buf_term[2];
  long buf_size;
  long pos;
  WSCbool read_started;
}buf_source_mgr;

void init_source_from_buf(j_decompress_ptr cinfo){
  buf_source_mgr* src = (buf_source_mgr*) cinfo->src;
  src->read_started = True;
}

void skip_input_data_from_buf(j_decompress_ptr cinfo, long nbytes){
  buf_source_mgr* src = (buf_source_mgr*) cinfo->src;
  if (nbytes > 0) {
    src->pub.next_input_byte += (size_t) nbytes;
    src->pub.bytes_in_buffer -= (size_t) nbytes;
  }
}

boolean fill_input_buffer_from_buf(j_decompress_ptr cinfo){
  buf_source_mgr* src = (buf_source_mgr*) cinfo->src;

  if (src->pos == src->buf_size){
    src->buf_term[0] = (JOCTET) 0xFF;
    src->buf_term[1] = (JOCTET) JPEG_EOI;
    src->pub.next_input_byte = (JOCTET*)src->buf_term;
    src->pub.bytes_in_buffer = 2;
    src->read_started = False;
    return TRUE;
  }

  src->pub.next_input_byte = (JOCTET*)src->buf;
  src->pub.bytes_in_buffer = src->buf_size;
  src->pos = src->buf_size;
  src->read_started = False;

  return TRUE;
}

void term_source_from_buf(j_decompress_ptr cinfo){
}

void jpeg_buf_src (j_decompress_ptr cinfo, char* buf,long size){
  buf_source_mgr* src = (buf_source_mgr*) cinfo->src;
  if (cinfo->src == NULL) {
    cinfo->src = (struct jpeg_source_mgr *)
      (*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_PERMANENT,
                 sizeof(buf_source_mgr));
    src = (buf_source_mgr*) cinfo->src;
  }

  src = (buf_source_mgr*) cinfo->src;
  src->pub.init_source = init_source_from_buf;
  src->pub.fill_input_buffer = fill_input_buffer_from_buf;
  src->pub.skip_input_data = skip_input_data_from_buf;
  src->pub.resync_to_restart = jpeg_resync_to_restart;
  src->pub.term_source = term_source_from_buf;
  src->pub.bytes_in_buffer = 0;
  src->pub.next_input_byte = (JOCTET*)NULL;

  src->buf = buf;
  src->read_started = False;
  src->buf_size = size;
  src->pos = 0;
}


long JpegReadFileToPixmap(char* filename,long size,GID* mem_gid,GID* mem_gid2,long* w,long* h,UB** ptr1,UB** ptr2,WSCbool reuse_mem){
    FILE* ifile = NULL;
    if (size == 0){
      ifile = fopen(filename,"r");
      if (ifile == NULL){
        return -1;
      }
    }
    struct jpeg_decompress_struct    jinf;
    struct jpeg_error_mgr2            jerr;
    jinf.err = jpeg_std_error((jpeg_error_mgr*)&jerr);
    jinf.err->emit_message = ehandler;
    jinf.err->error_exit = exhandler;

    if (setjmp(jerr.setjmp_buffer)){
      jpeg_destroy_decompress(&jinf);
      if (size == 0){
        fclose(ifile);
      }
      return -1;
    }

    jpeg_create_decompress(&jinf);
    jpeg_set_marker_processor(&jinf,JPEG_COM,chandler);
    if (size == 0){
      jpeg_stdio_src(&jinf,ifile);
    }else{
      jpeg_buf_src(&jinf,filename,size);
    }
    long reti = jpeg_read_header(&jinf,TRUE);
    if (reti != JPEG_HEADER_OK){
      jpeg_destroy_decompress(&jinf);
      if (size == 0){
        fclose(ifile);
      }
      return -1;
    }
    jpeg_calc_output_dimensions(&jinf);
    jpeg_start_decompress(&jinf);

    long rwidth = jinf.output_width;
    long rheight = jinf.output_height;
    long vwidth = *w;
    long vheight = *h;
    long stretched =0;
    if (*w == 0 || *h == 0){
      *w = rwidth;
      *h = rheight;
    }else{
      if ((long)(rwidth * vheight/vwidth) < rheight){
        *w = (long)(vheight * rwidth/rheight);
      }else{
        *h = (long)(vwidth * rheight/rwidth);
      }
      stretched = 1;
    }
    vwidth = *w;
    vheight = *h;

    long components = jinf.output_components;

    unsigned char* buf = NULL;
    if (reuse_mem){
      buf = (unsigned char*)
         WSGFdevfbAllocNewMemory(components * rheight * rwidth*sizeof(JSAMPLE));
    }else{
      buf = new unsigned char[components * rheight * rwidth*sizeof(JSAMPLE)];
    }

    JSAMPROW rowptr[1];
//printf("before read scanline..\n");
    long i;
    for(i=0; i< rheight; i++){
      rowptr[0] = (JSAMPROW)&(buf[i * rwidth * components]);
      jpeg_read_scanlines(&jinf, rowptr,1);
    }
//printf("before read scanline done.. components=%d\n",components);
    if (components == 4){
      WSGFdevfbBufToPixmap2(buf, mem_gid,mem_gid2,rwidth,rheight,w,h,components*rwidth*sizeof(JSAMPLE),ptr1,ptr2,reuse_mem);
    }else
    if (components == 3){
//printf("before move scanline..\n");
      *mem_gid2 = 0;
      WSGFdevfbBufToPixmap(buf, mem_gid,rwidth,rheight,w,h,components*rwidth*sizeof(JSAMPLE),ptr1,reuse_mem);
    }else
    if (components == 1){
      *mem_gid2 = 0;
      WSGFdevfbBufToPixmapG(buf, mem_gid,rwidth,rheight,w,h,components*rwidth*sizeof(JSAMPLE),ptr1,reuse_mem);

    }else{
      if (reuse_mem){
        WSGFdevfbDeleteMemory((char*)buf);
      }else{
        delete[] buf;
      }
      jpeg_finish_decompress(&jinf);
      jpeg_destroy_decompress(&jinf);
      if (size == 0){
        fclose(ifile);
      }
      return -1;
    }
//printf("before move scanline done..\n");
    if (reuse_mem){
      WSGFdevfbDeleteMemory((char*)buf);
    }else{
      delete[] buf;
    }
    jpeg_finish_decompress(&jinf);
    jpeg_destroy_decompress(&jinf);
    if (size == 0){
      fclose(ifile);
    }
    return 0;
}
#endif
