//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <WScom.h>
#include <devfb/devfb.h>
#include <devfb/devfb_dep.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <WSDkeyboard.h>
#include "fbconfig.h"

extern int _add_event(WSDdeviceEventList* evt);
extern int _device_check_event_available();
extern int _search_window(short x,short y);

extern int _init_for_event_function();
extern int _wake_up_event();
extern int _wait_event();

Display* _disp = NULL;
Window   _window = 0;

#ifndef ROOT_LESS
XImage* _ximage = NULL;
GC _xgc = 0;
#endif

int x11_update_frame_buffer(Window _window,XImage* _ximage,GC _xgc,unsigned char* _buffer,int x,int y,unsigned int w,unsigned int h,unsigned int _device_width,unsigned int _device_height,unsigned int _device_depth);

long _display_depth = 0; 
Visual* _visual = NULL;
int red_mask, green_mask, blue_mask;
int red_shift, green_shift, blue_shift;
int msb_flag = 0;
short _mouse_pos_x = 0;
short _mouse_pos_y = 0;
#ifdef NO_THREAD
extern void (*_create_window_handler)(WSDdeviceWindow*);
extern void (*_update_window_handler)(WSDdeviceWindow*);
extern void (*_destroy_window_handler)(WSDdeviceWindow*);
extern void x11_create_window(WSDdeviceWindow*);
extern void x11_update_window(WSDdeviceWindow*);
extern void x11_destroy_window(WSDdeviceWindow*);
#else
//pthread_sem_t _event_sem;
#endif
pthread_t _input_thr = 0;
unsigned int _mouse_status = 0;
extern void* _x11_input_thread(void*);

//regular internal functions -------------------------
void _get_mouse_pos(short* x,short* y){
  *x = _mouse_pos_x;
  *y = _mouse_pos_y;
}

int _init_frame_buffer(){
  //TODO: init frame buffer..
  _disp = XOpenDisplay((char*)NULL);
  if (_disp == NULL){
    return WS_ERR;
  }
#ifdef ROOT_LESS
  _device_width = DisplayWidth(_disp,DefaultScreen(_disp));
  _device_height = DisplayHeight(_disp,DefaultScreen(_disp));
  _create_window_handler = x11_create_window;
  _update_window_handler = x11_update_window;
  _destroy_window_handler = x11_destroy_window;
#else
  if (getenv("WSWIDTH") != NULL){
    _device_width = atoi(getenv("WSWIDTH"));
  }
  if (getenv("WSHEIGHT") != NULL){
    _device_height = atoi(getenv("WSHEIGHT"));
  }
  WSCstring* conf = WSGFreadTextFile("wsfbrc");
  if (conf != NULL){
    while(!conf->eof()){
      WSCstring line = conf->gets();
      WSCstring sec = line.getWord(0,":");
      WSCstring value = line.getWord(1,":");
      if (!strcmp(sec,"width")){
        _device_row_bytes = atoi((char*)value);
      }
      if (!strcmp(sec,"height")){
        _device_height = atoi((char*)value);
      }
    }
    delete conf;
  }
#endif
#ifdef DOUBLE_SCALE
  _device_row_bytes = _device_width * _device_depth /8 *4;
//printf("w,h=%d,%d\n",_device_width,_device_height);
  unsigned long w = _device_width*2;
  unsigned long h = _device_height*2;
#else
  _device_row_bytes = _device_width * _device_depth /8;
//printf("w,h=%d,%d\n",_device_width,_device_height);
  unsigned long w = _device_width;
  unsigned long h = _device_height;
#endif
  unsigned long row_b = _device_row_bytes;
  _window = XCreateSimpleWindow(_disp,DefaultRootWindow(_disp),0,0,w,h,
                          0,BlackPixel(_disp,0),BlackPixel(_disp,0));
  XSelectInput(_disp,_window,ButtonPressMask |
                             ButtonReleaseMask |
                             ExposureMask |
                             KeyPressMask |
                             KeyReleaseMask |
                             EnterWindowMask |
                             LeaveWindowMask |
                             PointerMotionMask |
                             StructureNotifyMask |
                             FocusChangeMask);
#ifndef ROOT_LESS
  XMapWindow(_disp,_window);
#endif

  _display_depth = XDefaultDepth(_disp,XDefaultScreen(_disp));
  _visual = XDefaultVisual(_disp,XDefaultScreen(_disp));

#ifndef ROOT_LESS
  long buf_size = row_b * h;
  _buffer = (unsigned char*)malloc(buf_size);
  memset(_buffer,0xff,buf_size);
  _xgc = XCreateGC(_disp,_window,0,0);
#endif


#ifndef ROOT_LESS
  if (_display_depth >16){
    _ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, w,h, 32,0);
  }else if (_display_depth >8){
    _ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, w,h, 16,0);
  }else{
    _ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, w,h, 8,0);
  }
  _ximage->data = (char*)malloc(_ximage->bytes_per_line * h);
#endif

  int start_shift;
  unsigned int start_mask;
  XWindowAttributes win_attr;

  red_mask = green_mask = blue_mask = 0;
  red_shift = green_shift = blue_shift = 0;
  msb_flag = (ImageByteOrder(_disp) == MSBFirst)?1:0;

  if (XGetWindowAttributes(_disp,
            RootWindow(_disp, DefaultScreen(_disp)), &win_attr) == 0){
    return -1;
  }
  if ((win_attr.depth == 24) || (win_attr.depth == 16)) {
    if (win_attr.depth == 24) {
      start_shift = 24;
      start_mask = 0x80000000;
    }else{
      start_shift = 8;
      start_mask = 0x8000;
    }
    red_mask = win_attr.visual->red_mask;
    red_shift = start_shift;
    unsigned int n = start_mask;
    while (!(n & red_mask)) {
      n >>= 1;
      red_shift--;
    }
    green_mask = win_attr.visual->green_mask;
    green_shift = start_shift;
    n = start_mask;
    while (!(n & green_mask)) {
      n >>= 1;
      green_shift--;
    }
    blue_mask = win_attr.visual->blue_mask;
    blue_shift = start_shift;
    n = start_mask;
    while (!(n & blue_mask)) {
      n >>= 1;
      blue_shift--;
    }
  }
#ifndef NO_THREAD
//  pthread_sem_init_np(&_event_sem);
//  pthread_sem_lock_np(&_event_sem);
  pthread_create(&_input_thr,NULL,_x11_input_thread,NULL);
#endif
  return WS_NO_ERR;
}

int _update_frame_buffer(int x,int y,unsigned int w,unsigned int h){
//static long cnt=0;
//cnt++;
//printf("update_frame_buffer.. cnt=%d x,y,w,h=%d,%d,%d,%d\n",cnt,x,y,w,h);
#ifdef ROOT_LESS
  return WS_NO_ERR;
#else
  long x2,y2;
  unsigned long w2,h2;

#ifdef ROTATE90
  long tmp = x;
  x = y;
  y = _device_height - tmp - w;
  tmp = w;
  w = h;
  h = tmp;
#endif

#ifdef DOUBLE_SCALE
  x *=2;
  y *=2;
  w *=2;
  h *=2;
  WSGFandArea(x,y,w,h,0,0,_device_width*2,_device_height*2,&x2,&y2,&w2,&h2);
  return x11_update_frame_buffer(_window,_ximage,_xgc,_buffer,x2,y2,w2,h2,_device_width*2,_device_height*2,_device_depth);
#else
  WSGFandArea(x,y,w,h,0,0,_device_width,_device_height,&x2,&y2,&w2,&h2);
  return x11_update_frame_buffer(_window,_ximage,_xgc,_buffer,x2,y2,w2,h2,_device_width,_device_height,_device_depth);
#endif

#endif
}

int x11_update_frame_buffer(Window _window,XImage* _ximage,GC _xgc,unsigned char* _buffer,int x,int y,unsigned int w,unsigned int h,unsigned int _device_width,unsigned int _device_height,unsigned int _device_depth){
  unsigned char r=0,g=0,b=0;
//printf("x11_update_frame_buffer start x,y,w,h=%d,%d,%d,%d\n",x,y,w,h);
//  long ptr = 0;
  long ptr2 = 0;
  long i, j;
  unsigned int udat;
  unsigned int depth =   _device_depth;
  unsigned int start_red =   _device_start_red;
  unsigned int start_green = _device_start_green;
  unsigned int start_blue =  _device_start_blue;
  unsigned int red_bits =    _device_red_bits;
  unsigned int green_bits =  _device_green_bits;
  unsigned int blue_bits =   _device_blue_bits;
  unsigned int row_bytes =   _device_row_bytes;

  if (_ximage->bits_per_pixel ==32){
    for(i=y; i<y+h; i++){
      ptr2 = i * _ximage->bytes_per_line + x*4;
      memcpy(&_ximage->data[ptr2],&_buffer[i*row_bytes + x*depth/8],w*4);
#if 0
      for(j=x; j<x+w; j++){
        if (depth == 32){
          unsigned int* ptr = (unsigned int*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = *ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }else if (depth == 16){
          unsigned short* ptr = (unsigned short*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = (unsigned int)*ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }
//        r = _buffer[ptr++];
//        g = _buffer[ptr++];
//        b = _buffer[ptr++];
//        a = _buffer[ptr++];
        udat = 0;
        if (red_shift >= 0){
          udat |= (((int)r << red_shift) & red_mask);
        }else{
          udat |= (((int)r >> (-red_shift)) & red_mask);
        }
        if (green_shift >= 0){
          udat |= (((int)g << green_shift) & green_mask);
        }else{
          udat |= (((int)g >> (-green_shift)) & green_mask);
        }
        if (blue_shift >= 0){
          udat |= (((int)b << blue_shift) & blue_mask);
        }else{
          udat |= (((int)b >> (-blue_shift)) & blue_mask);
        }
        if (msb_flag){
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff000000)>>24;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff0000)>>16;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
        }else{
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff0000)>>16;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff000000)>>24;
        }
      }
#endif
    }
  }else if (_ximage->bits_per_pixel ==24){
//printf("update_window 24..\n");
    for(i=y; i<y+h; i++){
      ptr2 = i * _ximage->bytes_per_line + x*3;
      memcpy(&_ximage->data[ptr2],&_buffer[i*row_bytes + x*depth/8],w*3);
#if 0
      for(j=x; j<x+w; j++){
        if (depth == 32){
          unsigned int* ptr = (unsigned int*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = *ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }else if (depth == 16){
          unsigned short* ptr = (unsigned short*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = (unsigned int)*ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }

//        r = _buffer[ptr++];
//        g = _buffer[ptr++];
//        b = _buffer[ptr++];
//        a = _buffer[ptr++];

        udat = 0;
        if (red_shift >= 0){
          udat |= (((int)r << red_shift) & red_mask);
        }else{
          udat |= (((int)r >> (-red_shift)) & red_mask);
        }
        if (green_shift >= 0){
          udat |= (((int)g << green_shift) & green_mask);
        }else{
          udat |= (((int)g >> (-green_shift)) & green_mask);
        }
        if (blue_shift >= 0){
          udat |= (((int)b << blue_shift) & blue_mask);
        }else{
          udat |= (((int)b >> (-blue_shift)) & blue_mask);
        }
        if (msb_flag){
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff0000)>>16;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
        }else{
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff0000)>>16;
        }
      }
#endif
    }
  }else if (_ximage->bits_per_pixel ==16){
//printf("update_window 16..\n");
    for(i=y; i<y+h; i++){
      ptr2 = i * _ximage->bytes_per_line + x*2;
      memcpy(&_ximage->data[ptr2],&_buffer[i*row_bytes + x*depth/8],w*2);
#if 0
      for(j=x; j<x+w; j++){
        if (depth == 32){
          unsigned int* ptr = (unsigned int*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = *ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }else if (depth == 16){
          unsigned short* ptr = (unsigned short*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = (unsigned int)*ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }


//        unsigned int rr = _buffer[ptr++];
//        unsigned int gg = _buffer[ptr++];
//        unsigned int bb = _buffer[ptr++];
//        unsigned int aa = _buffer[ptr++];

        udat = 0;
        if (red_shift >= 0){
                udat |= (((int)r << red_shift) & red_mask);
        }else{
          udat |= (((int)r >> (-red_shift)) & red_mask);
        }
        if (green_shift >= 0){
          udat |= (((int)g << green_shift) & green_mask);
        }else{
          udat |= (((int)g >> (-green_shift)) & green_mask);
        }
        if (blue_shift >= 0){
          udat |= (((int)b << blue_shift) & blue_mask);
        }else{
          udat |= (((int)b >> (-blue_shift)) & blue_mask);
        }
        if (msb_flag) {
          ((unsigned char*)_ximage->data)[ptr2++] = (udat >> 8) & 0xff;
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
        }else{
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff);
          ((unsigned char*)_ximage->data)[ptr2++] = (udat & 0xff00)>>8;
        }
      }
#endif
    }
  }else if (_ximage->bits_per_pixel == 8){
//printf("update_window 8..\n");
    XColor col[5*5*5];
    Colormap cm = DefaultColormap(_disp,DefaultScreen(_disp));
    long k;
    long cnt=0;
    for(i=0; i<5; i++){
      for(j=0; j<5; j++){
        for(k=0; k<5; k++){
          if (i != 4){
            col[cnt].red = i*64*256;
          }else{
            col[cnt].red = 0xffff;
          }
          if (j != 4){
            col[cnt].green = j*64*256;
          }else{
            col[cnt].green = 0xffff;
          }
          if (k != 4){
            col[cnt].blue = k*64*256;
          }else{
            col[cnt].blue = 0xffff;
          }
          XAllocColor(_disp,cm,&(col[cnt]));
          cnt++;
        }
      }
    }
    long colptr = 0;
    long rr = 0,gg = 0,bb = 0;
//    long tr1,tg1,tb1;
    signed char dr1,dg1,db1;
    for(i=y; i<y+h; i++){
      dr1 = 0;
      dg1 = 0;
      db1 = 0;
      ptr2 = i * _ximage->bytes_per_line + x;
      for(j=x; j< x+w; j++){
        if (depth == 32){
          unsigned int* ptr = (unsigned int*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = *ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }else if (depth == 16){
          unsigned short* ptr = (unsigned short*)&_buffer[i*row_bytes + j*depth/8];
          unsigned int val = (unsigned int)*ptr;
          r = (val >> start_red) << (8 -red_bits);
          g = (val >> start_green) << (8 -green_bits);
          b = (val >> start_blue) << (8 -blue_bits);
        }


//        tr1 = _buffer[ptr++];
//        tg1 = _buffer[ptr++];
//        tb1 = _buffer[ptr++];
//        ta1 = _buffer[ptr++];

        if ((0 < r + dr1) && (r + dr1) < 256){
          if ((-32 < dr1) && (dr1 < 32)){
            rr = (r + dr1 + 31) & 0x1c0;
          }else if (dr1 > 31){
            rr = (r + 63) & 0x1c0;
          }else{
            rr = r  & 0x1c0;
          }
        }else if (r + dr1 > 255){
          rr = 0x100;
        }else{
          rr = 0;
        }
        dr1 += (r - rr);
        if (0 < g + dg1  &&g + dg1 < 256){
          if (-32 < dg1 && dg1 < 32 ){
            gg = (g + dg1 + 31) & 0x1c0;
          }else if (dg1 > 31){
            gg = (g + 63) & 0x1c0;
          }else{
            gg = g  & 0x1c0;
          }
        }else if (g + dg1 > 255){
          gg = 0x100;
        }else{
          gg = 0;
        }
        dg1 += (g - gg);
        if (0 < b + db1 && b + db1 < 256){
          if (-32 < db1 && db1 < 32){
            bb = (b + db1 + 31) & 0x1c0;
          }else if (db1 > 31){
            bb = (b + 63) & 0x1c0;
          }else{
            bb = b & 0x1c0;
          }
        }else if (b + db1 > 255){
            bb = 0x100;
        }else{
          bb = 0;
        }
        db1 += (b - bb);
        db1 += (b - bb);
        colptr = (rr>>6)*5*5  + (gg>>6)*5 + (bb>>6);
        _ximage->data[ptr2++] =  col[colptr].pixel;
      }
    }
  }
//printf("put!!!! w,d=%d,%d\n",_device_width,_device_height);
  XPutImage(_disp,_window,_xgc,_ximage,x,y,x,y,
            w,h);
  return 0;
}

int _get_event(WSDdeviceEvent* evt,unsigned int mode){
//printf("_get_event start");
#ifdef ROOT_LESS
  int i;
  for(i=0; i<WS_MAX_GC;i++){
    if (_gc_list[i]._gid == 0){
      continue;
    }
    if (_gc_list[i]._updated == 0){
      continue;
    }
    if (_gc_list[i]._window_id == 0){
      continue;
    }
    x11_update_window(&_window_list[_gc_list[i]._window_id-1]);
    _gc_list[i]._updated = 0;
  }
#endif
#ifdef NO_THREAD
   _x11_input_thread(NULL);
#endif
   if (_evt_list == NULL){
    if ( _device_check_event_available() != False ){
      evt->s.type = EV_MSG;
//printf("_get_event1\n");
      return WS_NO_ERR;
    }
    return WS_ERR;
  }
  WSDdeviceEventList* item = _evt_list;
  WSDdeviceEventList* item_bak = NULL;
  while(1){
    if (item == NULL){
      break;
    }
    if ((mode & 0xfff0 ) == DSPEVT){
      if (item->_event.r.type != EV_REQUEST){
        item_bak = item;
        item = item->_next;
        continue;
      }
      if (item->_event.r.cmd != W_REDISP){
        item_bak = item;
        item = item->_next;
        continue;
      }
    }
    if (item_bak == NULL){
      _evt_list = item->_next;
    }else{
      item_bak->_next = item->_next;
    }
    memcpy(evt,&(item->_event),sizeof(WSDdeviceEvent));
    free(item);
//printf("_get_event2\n");
    return WS_NO_ERR;
  }
  if ((mode & 0xfff0 ) == DSPEVT){
    return WS_ERR;
  }
  //TODO: get mouse event..
  //TODO: get key event..
  if ( _device_check_event_available() != False ){
    evt->s.type = EV_MSG;
//printf("_get_event3\n");
    return WS_NO_ERR;
  }
  return WS_ERR;
}
//---------------------------------------------- 
void* _x11_input_thread(void*){
  while(1){
  XEvent e; 
#ifndef NO_THREAD
  XNextEvent(_disp,&e);
#else
#ifdef ROOT_LESS
  int i;
  int fl = 0;
  int target_win = 0;
  for(i=0; i<WS_MAX_WINDOW;i++){
    if (_window_list[i]._window_id != i+1){
      continue;
    }
    if (_window_list[i]._native_window == 0){
      continue;
    }
    Window win = _window_list[i]._native_window;
    Bool ret = XCheckWindowEvent(_disp,win,0xffffffff,&e);
    if (ret != False){
      target_win = i+1;
      break;
    }
  }
  if (target_win == 0){
    return NULL;
  }
#else
  Bool ret = XCheckWindowEvent(_disp,_window,0xffffffff,&e);
  if (ret == False){
    return NULL;
  }
#endif
#endif
//printf("XNextEvent event=%d\n",e.type);
  switch(e.type){
#ifdef ROOT_LESS
    case Expose:{
//XXZZ XXXXXXXXXXXXXXXXXXXXXXXZZZZZZZZZZZZZZZZ
// reduce expose event !!!!!!!
//printf("Expose.. win=%d\n",target_win);
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      evt->s.wid = target_win;
      evt->s.type = EV_SWITCH;
//      evt->s.type = EV_REQUEST;
//      evt->r.cmd = W_REDISP;
#ifndef NO_THREAD
        WSGFdeviceSemLock(_event_sem_id);
#endif
        _add_event(evtl);
#ifndef NO_THREAD
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
//        pthread_sem_unlock_np(&_event_sem);
#endif
       break;
    }
#endif
    case ButtonPress:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xbutton.x;
      int py = e.xbutton.y;
#ifdef ROTATE90
      {
         int tmp = px;
#ifdef DOUBLE_SCALE
         px = _device_height*2 - py-1;
#else
         px = _device_height - py-1;
#endif
         py = tmp;
      }
#endif
#ifdef DOUBLE_SCALE
      px /= 2;
      py /= 2;
#endif
      int bt = e.xbutton.button;
#ifdef ROOT_LESS
      int wid = target_win;
#else
      int wid = _search_window(px,py);
#endif
      if (wid > 0){
#ifdef ROOT_LESS
        short wx = 0;
        short wy = 0;
#else
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
#endif
        evt->s.stat = 0;
        if (bt == 1){
          _mouse_status |= Button1Mask;
        }
        if (bt == 2){
          _mouse_status |= Button2Mask;
        }
        if (bt == 3){
          _mouse_status |= Button3Mask;
        }
        if (_mouse_status & Button1Mask){
          evt->s.stat |= ES_BUT;
        }
        if (_mouse_status & Button3Mask){
          evt->s.stat |= ES_BUT2;
        }
#ifdef ROOT_LESS
        _mouse_pos_x = px + _window_list[wid -1]._x;
        _mouse_pos_y = py + _window_list[wid -1]._y;
        evt->e.pos.x = px;
        evt->e.pos.y = py;
#else
        _mouse_pos_x = px;
        _mouse_pos_y = py;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
#endif
//printf("ButtonPress wid=%d  p=%d,%d d=%d,%d bt=%d\n",wid,px,py,evt->e.pos.x,evt->e.pos.y,evt->s.stat);
        evt->s.type = EV_BUTDWN;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
#ifndef NO_THREAD
        WSGFdeviceSemLock(_event_sem_id);
#endif
        _add_event(evtl);
#ifndef NO_THREAD
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
//        pthread_sem_unlock_np(&_event_sem);
#endif
      }else{
        delete evtl;
      }
      break;
    }
    case ButtonRelease:{
//printf("btn release\n");
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xbutton.x;
      int py = e.xbutton.y;
#ifdef ROTATE90
      {
         int tmp = px;
#ifdef DOUBLE_SCALE
         px = _device_height*2 - py-1;
#else
         px = _device_height - py-1;
#endif
         py = tmp;
      }
#endif
#ifdef DOUBLE_SCALE
      px /= 2;
      py /= 2;
#endif
      int bt = e.xbutton.button;
#ifdef ROOT_LESS
      int wid = target_win;
#else
      int wid = _search_window(px,py);
#endif
      if (wid > 0){
#ifdef ROOT_LESS
        short wx = 0;
        short wy = 0;
#else
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
#endif
        evt->s.stat = 0;
        if (bt == 1){
          _mouse_status &= ~Button1Mask;
        }
        if (bt == 2){
          _mouse_status &= ~Button2Mask;
        }
        if (bt == 3){
          _mouse_status &= ~Button3Mask;
        }
        if (_mouse_status & Button1Mask){
          evt->s.stat |= ES_BUT;
        }
        if (_mouse_status & Button3Mask){
          evt->s.stat |= ES_BUT2;
        }

#ifdef ROOT_LESS
        _mouse_pos_x = px + _window_list[wid -1]._x;
        _mouse_pos_y = py + _window_list[wid -1]._y;
        evt->e.pos.x = px;
        evt->e.pos.y = py;
#else
        _mouse_pos_x = px;
        _mouse_pos_y = py;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
#endif
//printf("ButtonRelease wid=%d  p=%d,%d d=%d,%d bt=%d\n",wid,px,py,evt->e.pos.x,evt->e.pos.y,bt);
        evt->s.type = EV_BUTUP;
        evt->s.cmd = W_WORK;
        evt->s.wid = wid;
#ifndef NO_THREAD
        WSGFdeviceSemLock(_event_sem_id);
#endif
        _add_event(evtl);
#ifndef NO_THREAD
        WSGFdeviceSemUnlock(_event_sem_id);
        _wake_up_event();
//        pthread_sem_unlock_np(&_event_sem);
#endif
      }else{
        delete evtl;
      }
      break;
    }
    case EnterNotify:{
//printf("Enter\n");
      break;
    }
    case LeaveNotify:{
//printf("Leave\n");
      break;
    }
    case MotionNotify:{
//XXZZ todo optimize..
//      if (_evt_list != NULL){
//        continue;
//      }
//printf("mouse move..\n");
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      int px = e.xmotion.x;
      int py = e.xmotion.y;
#ifdef ROTATE90
      {
         int tmp = px;
#ifdef DOUBLE_SCALE
         px = _device_height*2 - py-1;
#else
         px = _device_height - py-1;
#endif
         py = tmp;
      }
#endif
#ifdef DOUBLE_SCALE
      px /= 2;
      py /= 2;
#endif
      int bt = e.xmotion.state;
#ifdef ROOT_LESS
      int wid = target_win;
#else
      int wid = _search_window(px,py);
#endif
      if (wid > 0){
#ifdef ROOT_LESS
        short wx = 0;
        short wy = 0;
#else
        short wx = _window_list[wid -1]._x;
        short wy = _window_list[wid -1]._y;
#endif
        evt->s.wid = wid;
#ifdef ROOT_LESS
        _mouse_pos_x = px + _window_list[wid -1]._x;
        _mouse_pos_y = py + _window_list[wid -1]._y;
        evt->e.pos.x = px;
        evt->e.pos.y = py;
#else
        _mouse_pos_x = px;
        _mouse_pos_y = py;
        evt->e.pos.x = px -wx;
        evt->e.pos.y = py -wy;
#endif
      }else{
        evt->s.wid = 0;
        _mouse_pos_x = px;
        _mouse_pos_y = py;
        evt->e.pos.x = px;
        evt->e.pos.y = py;
      }
      evt->s.stat = 0;
      if (bt & Button1Mask){
        evt->s.stat |= ES_BUT;
      }
      if (bt & Button3Mask){
        evt->s.stat |= ES_BUT2;
      }
      evt->e.type = EV_NULL;
//printf("e.xbutton.button=%d ret stat=0x%x move!! %d,%d\n",bt,evt->s.stat,evt->e.pos.x,evt->e.pos.y);
#ifndef NO_THREAD
      WSGFdeviceSemLock(_event_sem_id);
#endif
      _add_event(evtl);
#ifndef NO_THREAD
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
//      pthread_sem_unlock_np(&_event_sem);
#endif
      break;
    }
    case FocusIn:{
//printf("FocusIn\n");
      break;
    }
    case FocusOut:{
//printf("FocusIn\n");
      break;
    }
    case KeyPress:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      KeySym key;
      char buffer[1024];
      int len = XLookupString((XKeyEvent *)&e,buffer,1022,&key,(XComposeStatus*)NULL);
      WSGIappKeyboard()->setText(buffer);
      evt->s.wid = (short)key;
      evt->e.type = EV_KEYDWN;
      evt->s.stat = 0;
      if (e.xkey.state & ShiftMask){
        evt->s.stat |= 0x10;
      }
      if (e.xkey.state & LockMask){
        evt->s.stat |= 0x08;
      }
      if (e.xkey.state & ControlMask){
        evt->s.stat |= 0x80;
      }
      if (e.xkey.state & Mod1Mask){
        evt->s.stat |= 0x40;
      }
//printf("KeyPress key=0x%x 0x%x\n",key,evt->s.wid);
      buffer[len]=0;

#ifndef NO_THREAD
      WSGFdeviceSemLock(_event_sem_id);
#endif
      _add_event(evtl);
#ifndef NO_THREAD
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
//      pthread_sem_unlock_np(&_event_sem);
#endif
 
      break;
    }
    case KeyRelease:{
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      KeySym key;
      char buffer[1024];
      int len = XLookupString((XKeyEvent *)&e,buffer,1022,&key,(XComposeStatus*)NULL);
      evt->s.wid = key;
      evt->e.type = EV_KEYUP;
//printf("KeyRelease key=0x%x\n",key);
      buffer[len]=0;

#ifndef NO_THREAD
      WSGFdeviceSemLock(_event_sem_id);
#endif
      _add_event(evtl);
#ifndef NO_THREAD
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
//      pthread_sem_unlock_np(&_event_sem);
#endif
 
      break;
    }
#ifdef ROOT_LESS
    case ConfigureNotify:{
//printf("configure norify..\n");
      WSDdeviceEventList* evtl = (WSDdeviceEventList*)malloc(sizeof(WSDdeviceEventList));
      WSDdeviceEvent* evt = &(evtl->_event);
      evt->s.wid = target_win;
      evt->s.cmd = W_FRAM;
      evt->e.type = EV_BUTDWN;
      int x = e.xconfigure.x;
      int y = e.xconfigure.y;
      int w = e.xconfigure.width;
      int h = e.xconfigure.height;
      WSGFdeviceSemLock(_sem_id);
extern int check_wid(int wid);
      if (check_wid(target_win) == WS_NO_ERR){
        _window_list[target_win-1]._x = x;
        _window_list[target_win-1]._y = y;
        _window_list[target_win-1]._w = w;
        _window_list[target_win-1]._h = h;
//printf("configure notify x,y,w,h=%d,%d,%d,%d\n",x,y,w,h);
      }
      WSGFdeviceSemUnlock(_sem_id);

#ifndef NO_THREAD
      WSGFdeviceSemLock(_event_sem_id);
#endif
      _add_event(evtl);
#ifndef NO_THREAD
      WSGFdeviceSemUnlock(_event_sem_id);
      _wake_up_event();
//      pthread_sem_unlock_np(&_event_sem);
#endif
      break;
    }
#endif
    default:{
//printf("other..\n");
      break;
    }
  }
  }
  return NULL;
}

#ifdef ROOT_LESS
void x11_create_window(WSDdeviceWindow* win){
  long x = win->_x;
  long y = win->_y;
  WSCulong w = win->_w;
  WSCulong h = win->_h;
//printf("x11_create_window x,y,w,h=%d,%d,%d,%d\n",x,y,w,h);
  long r,g,b;
  r = (win->_bg_color&0xff0000) >> 16;
  g = (win->_bg_color&0xff00) >> 8;
  b = (win->_bg_color&0xff);
  char cname[16];
  sprintf(cname,"#%02x%02x%02x",r,g,b);
  Colormap cmap;
  XColor c0;
  XColor c1;
  cmap = DefaultColormap(_disp,DefaultScreen(_disp));
  XAllocNamedColor(_disp,cmap,cname,&c1,&c0);
  long pix = (long)c1.pixel;

//  Window window = XCreateSimpleWindow(_disp,DefaultRootWindow(_disp),x,y,w,h,0,
//                          BlackPixel(_disp,0),BlackPixel(_disp,0));
  Window window = XCreateSimpleWindow(_disp,DefaultRootWindow(_disp),x,y,w,h,0,
                          pix,pix);
  if (win->_attr & WA_NOFRAME){
    XSetWindowAttributes attr;
    attr.override_redirect = 1;
    XChangeWindowAttributes(_disp,window,CWOverrideRedirect,&attr);
  }
  XSelectInput(_disp,window,ButtonPressMask |
                             ButtonReleaseMask |
                             ExposureMask |
                             KeyPressMask |
                             KeyReleaseMask |
                             EnterWindowMask |
                             LeaveWindowMask |
                             PointerMotionMask |
                             StructureNotifyMask |
                             FocusChangeMask);
  XMapWindow(_disp,window);
  GC gc = XCreateGC(_disp,window,0,0);
  XImage* ximage = NULL;
  if (_display_depth >16){
    ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, w,h, 32,0);
  }else if (_display_depth >8){
    ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, w,h, 16,0);
  }else{
    ximage = XCreateImage(_disp,_visual, _display_depth,
                         ZPixmap,0,0, w,h, 8,0);
  }
  ximage->data = (char*)malloc(ximage->bytes_per_line * h);

  win->_native_window = (long)window;
  win->_native_context = (long)gc;
  win->_native_image = (long)ximage;
  WSDdeviceGC* gid = &_gc_list[win->_gc-1];

  long buf_size = w * h * _device_depth /8;
  unsigned char* buffer = (unsigned char*)malloc(buf_size);

  memset(buffer,0xff,buf_size);
  gid->_x = 0;
  gid->_y = 0;
  gid->_buf = buffer;
  gid->_row_bytes = w * _device_depth/8;
}

void x11_update_window(WSDdeviceWindow* win){
  Window window = (Window)win->_native_window;
  GC gc = (GC)win->_native_context;
  XImage* image = (XImage*)win->_native_image;
  unsigned char* buf = _gc_list[win->_gc -1]._buf;
  int x = _gc_list[win->_gc -1]._x;
  int y = _gc_list[win->_gc -1]._y;
  unsigned int w = _gc_list[win->_gc -1]._w;
  unsigned int h = _gc_list[win->_gc -1]._h;
  unsigned int d = _gc_list[win->_gc -1]._depth;
  x11_update_frame_buffer(window,image,gc,buf,x,y,w,h,d);
}

void x11_destroy_window(WSDdeviceWindow* win){
  Window window = (Window)win->_native_window;
  GC gc = (GC)win->_native_context;
  XDestroyWindow(_disp,window);
  XFreeGC(_disp,gc);
  win->_native_window = 0;
  win->_native_context = 0;
}

#endif //ROOT_LESS
