//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <stdio.h>
#include <WScom.h>
#ifndef NO_PCF_FONT

#include <WSCstring.h>
#include <devfb/WSDdeviceFont.h>
#include <devfb/devfb.h>
#include <fbconfig.h>
#include <WSCindexData.h>

#define WS_PCF_PROPERTIES       (1 << 0)
#define WS_PCF_ACCELERATORS     (1 << 1)
#define WS_PCF_METRICS          (1 << 2)
#define WS_PCF_BITMAPS          (1 << 3)
#define WS_PCF_INK_METRICS      (1 << 4)
#define WS_PCF_BDF_ENCODINGS    (1 << 5)
#define WS_PCF_SWIDTHS          (1 << 6)
#define WS_PCF_GLYPH_NAMES      (1 << 7)
#define WS_PCF_BDF_ACCELERATORS (1 << 8)

#define WS_PCF_DEFAULT_FORMAT     0
#define WS_PCF_INKBOUNDS          2
#define WS_PCF_ACCEL_W_INKBOUNDS  1
#define WS_PCF_COMPRESSED_METRICS 1

//#define TDBG
unsigned char rev_tab[256];

struct _pcf_format{
  unsigned id   :24;
  unsigned dummy:2;
  unsigned scan :2;
  unsigned bit  :1;
  unsigned byte :1;
  unsigned glyph:2;
};

_pcf_format bdf_fmt={
  WS_PCF_DEFAULT_FORMAT,
  0,
  0,
  1,
  1,
  0
};

struct _pcf_table{
  unsigned int type;
  _pcf_format format;
  int size;
  int offset;
};

void swap2(unsigned char* buf, int size){
  int i;
  size &= 0xfffe;
  unsigned char t = 0;
  for (i = 0; i < size; i +=2){
    t = buf[i];
    buf[i] = buf[i+1];
    buf[i+1] = t;
  }
}
void swap4(unsigned char* buf, int size){
  int i;
  size &= 0xfffc;
  unsigned char t = 0;
  for (i = 0; i < size; i +=4){
    t = buf[i];
    buf[i] = buf[i+3];
    buf[i+3] = t;
    t = buf[i+1];
    buf[i+1] = buf[i+2];
    buf[i+1] = t;
  }
}

void invert_data(unsigned char* buf, int size){
  int i;
  for (i = 0; i < size; i++){
    buf[i] = rev_tab[buf[i]];
  }
}
unsigned char invert(unsigned char val){
  int j;
  unsigned short val2 = 0;
  for (j = 0x80; j > 0; j>>=1){
    if (val & j){
     val2 |= 0x100;
    }
    val2 >>= 1;
  }
  return val2;
}

#if 0
int bytes_per_row(int bits,int bytes){
  if (bytes == 1){
    return((bits +  7) >> 3);
  }else
  if (bytes == 2){
    return(((bits + 15) >> 3) & ~1);
  }else
  if (bytes == 4){
    return(((bits + 31) >> 3) & ~3);
  }else
  if (bytes == 8){
    return(((bits + 63) >> 3) & ~7);
  }else{
    return 0;
  }
}
#endif

inline unsigned short get_16(unsigned char v1, unsigned char v2){
  unsigned short v = (unsigned short)(v1) << 8;
  v |= (unsigned short)(v2);
  return v;
}

inline unsigned int get_32(unsigned char v1, unsigned char v2, unsigned char v3, unsigned char v4){
  unsigned int v = (unsigned int)(v1) << 24;
  v |= (unsigned int)(v2) << 16;
  v |= (unsigned int)(v3) <<  8;
  v |= (unsigned int)(v4);
  return v;
}

inline unsigned short read_16b(FILE* file){
  unsigned char buf[2];
  int ret =  fread(buf, 1, sizeof(unsigned char)*2, file);
  if (ret != sizeof(unsigned char)*2){ 
    return 0;
  }
  return get_16(buf[0], buf[1]);
}

inline unsigned short read_16l(FILE* file){
  unsigned char buf[2];
  int ret =  fread(buf, 1, sizeof(unsigned char)*2, file);
  if (ret != sizeof(unsigned char)*2){ 
    return 0;
  }
  return get_16(buf[1], buf[0]);
}

inline unsigned short read_16(FILE* file,_pcf_format fmt){
  if (fmt.byte){
    return read_16b(file);
  }else{
    return read_16l(file);
  }
}

inline unsigned short read_16(char* buf,_pcf_format fmt){
  if (fmt.byte){
    return get_16(buf[0], buf[1]);
  }else{
    return get_16(buf[1], buf[0]);
  }
}
inline unsigned int read_32b(FILE* file){
  unsigned char buf[4];
  int ret =  fread(buf, 1, sizeof(unsigned char)*4, file);
  if (ret != sizeof(unsigned char)*4){ 
    return 0;
  }
  return get_32(buf[0], buf[1],buf[2],buf[3]);
}

inline unsigned int read_32l(FILE* file){
  unsigned char buf[4];
  int ret =  fread(buf, 1, sizeof(unsigned char)*4, file);
  if (ret != sizeof(unsigned char)*4){ 
    return 0;
  }
  return get_32(buf[3],buf[2],buf[1],buf[0]);
}

inline unsigned int read_32(FILE* file,_pcf_format fmt){
  if (fmt.byte){
    return read_32b(file);
  }else{
    return read_32l(file);
  }
}

inline unsigned int read_32(char* buf,_pcf_format fmt){
  if (fmt.byte){
    return get_32(buf[0], buf[1],buf[2],buf[3]);
  }else{
    return get_32(buf[3],buf[2],buf[1],buf[0]);
  }
}

_pcf_format read_format(FILE* file){
  unsigned int v = read_32l(file);
  _pcf_format fmt;
  fmt.id = v >>8;
  fmt.dummy = 0;
  fmt.scan = v >>4;
  fmt.bit = v >>3;
  fmt.byte = v >>2;
  fmt.glyph = v;
  return fmt;
}

extern WSCindexData _font_list;
WSDdeviceFont* WSGFdeviceReadPcfFont(char* file_name,char* fname,int fenc){
TIME_TRACE("WSGFdeviceReadPcfFont() start");
#ifdef TDBG
  printf("WSGFdeviceReadPcfFont start.:%d\n",WSGFdiffTimePoint());
  WSMFtrace("WSGFdeviceReadPcfFont start.:%d\n",WSGFdiffTimePoint());
  WSGFsetTimePoint();
#endif
static long init = 0;
  if (init == 0){
    int i;
    for(i=0; i<256; i++){
      rev_tab[i] = invert(i);
    }
    init = 1;
  }
  WSDdeviceFont* cache = (WSDdeviceFont*)_font_list[file_name];
  if (cache != NULL){
    WSDdeviceFont* ret = new WSDdeviceFont;
    *ret = *cache;
    ret->_font_glyph = new WSDdeviceFontGlyph[ret->_chars];
    memcpy(ret->_font_glyph,cache->_font_glyph,sizeof(WSDdeviceFontGlyph)*ret->_chars);
    ret->_glyph_buf = NULL;
#if 0 // REMOVED.. This causes a segmentation fault because size diff from original size..
    long size = ret->_height * ((ret->_height-1)/8 + 1)*ret->_chars;
    ret->_glyph_buf = new unsigned char[size];
    memcpy(ret->_glyph_buf,cache->_glyph_buf,size);
#endif
TIME_TRACE("WSGFdeviceReadPcfFont()0 done");
#ifdef TDBG
  printf("WSGFdeviceReadPcfFont load done.:%d\n",WSGFdiffTimePoint());
  WSMFtrace("WSGFdeviceReadPcfFont load done.:%d\n",WSGFdiffTimePoint());
  WSGFsetTimePoint();
#endif
    return ret;
  }
  FILE* ffile = fopen(file_name,"r");
  if (ffile == NULL){
TIME_TRACE("WSGFdeviceReadPcfFont()1 done");
    return NULL;
  }

  WSDdeviceFont* font = new WSDdeviceFont();
  if (font == NULL){
dbprintf("Error. %s:%d\n",__FILE__,__LINE__);
TIME_TRACE("WSGFdeviceReadPcfFont()2 done");
    return NULL; 
  }
  font->_font_name = fname;
  font->_font_encode = fenc;

  unsigned int val = read_32b(ffile);
//printf("%s val=0x%x 0x%x\n",file_name,val,get_32(1,'f','c','p'));
  if (val != get_32(1,'f','c','p')){
    fclose(ffile);
    return NULL;
  }

  int tables = read_32l(ffile);
  _pcf_table* tb = new _pcf_table[tables];
  int i;
  for (i = 0; i < tables; i++){
    tb[i].type   = read_32l(ffile);
    tb[i].format = read_format(ffile);
    tb[i].size   = read_32l(ffile);
    tb[i].offset = read_32l(ffile);
//printf("tb[%d].offset=%d type=%d\n",i,tb[i].offset,tb[i].type);
  } 
  int metrics = 0;

  for (i = 0; i < tables; i++){
    if (tb[i].type == WS_PCF_METRICS){
      fseek(ffile,tb[i].offset,SEEK_SET);
      _pcf_format fmt = read_format(ffile);
//printf("tb[%d] format.id=%d\n",i,fmt.id);
      if (fmt.id == WS_PCF_DEFAULT_FORMAT){
        metrics = read_16(ffile,fmt);
        font->_font_glyph = new WSDdeviceFontGlyph[metrics];
        font->_chars = metrics;
        int cnt;
        int slen = sizeof(char)*metrics*12;
        char* buf = new char[metrics*12];
        if (buf == NULL){
          delete font;
          fclose(ffile);
          delete[] tb;
          return NULL;
        }
        int ret = fread((char*)buf, 1, slen, ffile);
        if (ret != slen){
          delete buf;
          delete font;
          fclose(ffile);
          delete[] tb;
          return NULL;
        }
        long ptr = 0;
        for(cnt = 0; cnt < metrics; cnt++){
          font->_font_glyph[cnt]._left_bearing = read_16(&buf[ptr++],fmt);
          ptr++;
          font->_font_glyph[cnt]._right_bearing = read_16(&buf[ptr++],fmt);
          ptr++;
          font->_font_glyph[cnt]._width = read_16(&buf[ptr++],fmt);
          ptr++;
          font->_font_glyph[cnt]._ascent = read_16(&buf[ptr++],fmt);
          ptr++;
          font->_font_glyph[cnt]._descent = read_16(&buf[ptr++],fmt);
          ptr++;
          font->_font_glyph[cnt]._data = NULL;
          ptr++;
          ptr++;
        }
      }else
      if (fmt.id == WS_PCF_COMPRESSED_METRICS){
        metrics = read_16(ffile,fmt);
        font->_font_glyph = new WSDdeviceFontGlyph[metrics];
//        font->_font_glyph = (WSDdeviceFontGlyph*)
//                               malloc(sizeof(WSDdeviceFontGlyph)*metrics);
        font->_chars = metrics;
        int cnt;
        unsigned char* buf = new unsigned char[metrics*5];
        if (buf == NULL){
          delete font;
          fclose(ffile);
          delete[] tb;
          return NULL;
        }
        int ret = fread((char*)buf, 1, sizeof(unsigned char)*5*metrics, ffile);
        if (ret != sizeof(unsigned char) *5 *metrics){
          delete buf;
          delete font;
          fclose(ffile);
          delete[] tb;
          return NULL;
        }
        int ptr = 0;
        for(cnt = 0; cnt < metrics; cnt++){
          font->_font_glyph[cnt]._left_bearing = buf[ptr++] & 0x7f;
          font->_font_glyph[cnt]._right_bearing = buf[ptr++] & 0x7f;
          font->_font_glyph[cnt]._width = buf[ptr++] & 0x7f;
          font->_font_glyph[cnt]._ascent = buf[ptr++] & 0x7f;
          font->_font_glyph[cnt]._descent = buf[ptr++] & 0x7f;
          font->_font_glyph[cnt]._data = NULL;
        }
      }
    }else
    if (tb[i].type == WS_PCF_BITMAPS){
      fseek(ffile,tb[i].offset,SEEK_SET);
      _pcf_format fmt = read_format(ffile);
      if (!(fmt.id == WS_PCF_DEFAULT_FORMAT)){
        delete font;
        fclose(ffile);
        delete[] tb;
        return NULL;
      }
      int bitmaps = read_32(ffile,fmt);
      int* bmp_offset = new int[bitmaps];
      int cnt;
      char* buf = new char[bitmaps*sizeof(int)];
      int rlen = fread((char*)buf, 1, sizeof(int)*bitmaps, ffile);
      if (rlen != sizeof(int) * bitmaps){
        delete buf;
        delete font;
        fclose(ffile);
        delete[] tb;
        return NULL;
      }
      for(cnt = 0; cnt < bitmaps; cnt++){
        bmp_offset[cnt] = read_32(&buf[cnt*4],fmt);
//printf("bmp_offset[%d]=%d\n",cnt,bmp_offset[cnt]);
      }
      delete buf;
      int bitmap_sizes[4];
      for(cnt = 0; cnt < 4; cnt++){
        bitmap_sizes[cnt] = read_32(ffile,fmt);
//printf("bitmap_sizes[%d]=%d\n",cnt,bitmap_sizes[cnt]);
      }
      unsigned char* glyph_buf = new unsigned char[bitmap_sizes[fmt.glyph]];
      font->_glyph_buf = new unsigned char[bitmap_sizes[fmt.scan]];
      int ret = fread((char*)glyph_buf, 1, 
                      sizeof(unsigned char)*bitmap_sizes[fmt.glyph], ffile);
//printf("bitmaps=%d bitmap read=%d\n",bitmaps,ret);fflush(stdout);
      if (fmt.bit != bdf_fmt.bit){
        invert_data(glyph_buf,bitmap_sizes[fmt.glyph]);
      }

      if ((fmt.bit == fmt.byte) != (bdf_fmt.bit == bdf_fmt.byte)){
        if ((bdf_fmt.bit == bdf_fmt.byte && fmt.scan == 1) ||
            (bdf_fmt.bit != bdf_fmt.byte && bdf_fmt.scan == 1)){
          swap2(glyph_buf,bitmap_sizes[fmt.glyph]);
        }
        if ((bdf_fmt.bit == bdf_fmt.byte && fmt.scan == 2) ||
            (bdf_fmt.bit != bdf_fmt.byte && bdf_fmt.scan == 2)){
          swap4(glyph_buf,bitmap_sizes[fmt.glyph]);
        }

      }
//printf("fmt.scan=%d fmt.glyph=%d\n",fmt.scan,fmt.glyph);fflush(stdout);
      int row_width = 1 << fmt.glyph;
      int t,tc;
      for (cnt = 0; cnt < metrics; cnt++){
        int font_wb = (font->_font_glyph[cnt]._width + 7)/8;

        font->_font_glyph[cnt]._data = font->_glyph_buf +
                                       bmp_offset[cnt]*font_wb/row_width;
        int num = (font->_font_glyph[cnt]._ascent
                   + font->_font_glyph[cnt]._descent) * font_wb;
        unsigned char* ptr = glyph_buf + bmp_offset[cnt];
        for(t=0; t<num;){
          for(tc=0; tc<font_wb; tc++){
            font->_font_glyph[cnt]._data[t] = ptr[tc];
            t++;
          }
          ptr += row_width;
        }
#if 0
dbprintf("f=%d font_wb=%d row=%d glyph[%d]=0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x\n",font->_font_glyph[cnt]._width,font_wb,row_width,cnt,
        font->_font_glyph[cnt]._data[0],
        font->_font_glyph[cnt]._data[1],
        font->_font_glyph[cnt]._data[2],
        font->_font_glyph[cnt]._data[3],
        font->_font_glyph[cnt]._data[4],
        font->_font_glyph[cnt]._data[5],
        font->_font_glyph[cnt]._data[6],
        font->_font_glyph[cnt]._data[7]);
#endif
      }
      delete[] glyph_buf;
      delete[] bmp_offset;
    }else
    if (tb[i].type == WS_PCF_BDF_ACCELERATORS){
      fseek(ffile,tb[i].offset,SEEK_SET); _pcf_format fmt = read_format(ffile);
      if ((fmt.id != WS_PCF_DEFAULT_FORMAT) && 
          (fmt.id != WS_PCF_ACCEL_W_INKBOUNDS)){
        delete font;
        fclose(ffile);
        delete[] tb;
        return NULL;
      }
      unsigned char buf[8];
      int ret = fread((char*)buf, 1,sizeof(unsigned char)*8,ffile);
      font->_ascent = read_32(ffile,fmt);
      font->_descent = read_32(ffile,fmt);
      font->_height = font->_ascent + font->_descent;
      font->_width = font->_font_glyph[0]._width;
//printf("font w,h=%d,%d\n",font->_width,font->_height);
      unsigned max_overlap = read_32(ffile,fmt);
    }else
    if (tb[i].type == WS_PCF_BDF_ENCODINGS){
      fseek(ffile,tb[i].offset,SEEK_SET); _pcf_format fmt = read_format(ffile);
      if (fmt.id != WS_PCF_DEFAULT_FORMAT){
        delete font;
        fclose(ffile);
        delete[] tb;
        return NULL;
      }
      char tbuf[10];
      int ret = fread((char*)tbuf, 1,10, ffile);
      if (ret != 10){
        delete font;
        fclose(ffile);
        delete[] tb;
        return NULL;
      }
       
      short first_col  = read_16(tbuf,fmt);
      short last_col   = read_16(&tbuf[2],fmt);
      short first_row  = read_16(&tbuf[4],fmt);
      short last_row   = read_16(&tbuf[6],fmt);
      short default_char = read_16(&tbuf[8],fmt);

      short encodings = (last_col - first_col +1) * (last_row - first_row +1);

      int cnt;
      long slen = encodings * sizeof(short);
      char* buf = new char[slen];
      if (buf == NULL){
        delete font;
        fclose(ffile);
        delete[] tb;
        return NULL;
      } 
      ret = fread((char*)buf, 1,slen, ffile);
      if (ret != slen){
        delete buf;
        delete font;
        fclose(ffile);
        delete[] tb;
        return NULL;
      } 
      int ptr =0;
      for(cnt = 0; cnt < encodings; cnt++){
        unsigned int c = read_16(&buf[ptr++],fmt);
        ptr++;
        if (c == 0xffff){
          continue;
        }
        int col = cnt % (last_col - first_col + 1) + first_col;
        int row = cnt / (last_col - first_col + 1) + first_row;
        int p = row *256 + col;
        font->_font_glyph[c]._char_code = p;
      }
      delete buf;
    }
  }
  delete[] tb;
  fclose(ffile);
  _font_list[file_name] = (void*)font;
#ifdef TDBG
  printf("WSGFdeviceReadPcfFont load done.:%d\n",WSGFdiffTimePoint());
  WSMFtrace("WSGFdeviceReadPcfFont load done.:%d\n",WSGFdiffTimePoint());
  WSGFsetTimePoint();
#endif
  return font;
}

#endif
