//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//

#include <devfb/devfb.h>
#include <WScom.h>
#ifndef NO_DRAG_DROP
#include <WSCbase.h>
#include <devfb/WSDdevfbDragDrop.h>
#include <devfb/WSDdevfbAppDev.h>
#include <devfb/WSDdevfbFormDev.h>
#include <devfb/WSDdevfbMouse.h>

#define MAX_ARGS 10

WSMFclassInit(WSDdevfbDragDrop,WSDdragDrop);

WSDdragDrop* _devfbDrag_drop_create_handler_(){
  return new WSDdevfbDragDrop;
}
#ifndef NO_GLOBAL_CONSTRUCTORS
class _wsd_devfbDragdrop_init{
  public:
    _wsd_devfbDragdrop_init(){
        WSDdragDrop::setCreateHandler(_devfbDrag_drop_create_handler_);
    };
};
static _wsd_devfbDragdrop_init  execute_init;
#endif

WSDdevfbDragDrop* WSGIdevfbAppDragDrop(){
  WSDdragDrop* dd = WSGIappDragDrop();
  if (dd != NULL){
    WSDdevfbDragDrop* xdd = (WSDdevfbDragDrop*)dd->cast("WSDdevfbDragDrop");
	return xdd;
  }else{
    return NULL;
  }
}

WSCbase* WSDdevfbDragDrop::_drag_client = NULL;

WSDdevfbDragDrop::WSDdevfbDragDrop(){
  _under_dragging = 0;
}

WSDdevfbDragDrop::~WSDdevfbDragDrop(){
}

void WSDdevfbDragDrop::executeDrop(){
//printf("WSDdevfbDragDrop::executeDrop..\n");
  if (_under_dragging == 0){
    _drag_client = NULL;
    return;
  }
  _under_dragging = 0;
//printf("WSDdevfbDragDrop::executeDrop.. here1\n");

  WSCbase* drop_site = NULL;
  long num = _drop_site_list.getNum();
  long i;
  for(i=num -1; i>-1; i--){
     WSCbase* site = (WSCbase*)_drop_site_list.getData(i);
     WSDdev* dev = site->getdev();
     if (dev == NULL){
       continue;
     }



     WSDdevfbFormDev* bdev = (WSDdevfbFormDev*)dev->cast("WSDdevfbFormDev");
     if (bdev == NULL){
       continue;
     }
     short px,py;
	 WSGIappMouse()->getMousePosition(&px,&py);

     PNT pt;
     pt.x = px;
     pt.y = py;
     gcnv_rel(bdev->getParentGID(),&pt);
//printf("bdev=0x%x pt=%d,%d\n",bdev,pt.x,pt.y); 
     WSDdevfbFormDev* tdev = bdev->getChildWithPoint(pt.x,pt.y);
     while(1){
       if (tdev == NULL){
         break;
       }
       WSCbase* client = tdev->getAttachedClient();
       if (client != NULL){
         if (client->getUserData("DROP-PROC") != NULL){
           break;
         }
       }
       tdev = tdev->getParentAreaDev();
       if (tdev == bdev){
         break;
       }
     }

//printf("WSDdevfbDragDrop::executeDrop.. pt=%d,%d\n",px,py);
     if (tdev != NULL){
       drop_site = tdev->getAttachedClient();
       break;
     }
  }
//printf("WSDdevfbDragDrop::executeDrop.. here2 drop_site=0x%x\n",drop_site);
  if (drop_site != NULL){
    void (*hd)(WSCbase*,WSCbase*) =
       (void(*)(WSCbase*,WSCbase*))drop_site->getUserData("DROP-PROC");
//printf("WSDdevfbDragDrop::executeDrop.. hd=0x%x\n",hd);
    if (hd != NULL){
      hd(drop_site,_drag_client);
//printf("WSDdevfbDragDrop::executeDrop.. done hd=0x%x\n",hd);
    }
  }
#if 0
  WSDdev* dev = _drag_client->getowndev();
  WSDdevfbFormDev* bdev = (WSDdevfbFormDev*)dev->cast("WSDdevfbFormDev");
  if (bdev == NULL){
    bdev = (WSDdevfbFormDev*)dev->getParentDev()->cast("WSDdevfbFormDev");
  }
  if (bdev != NULL){
    WSCushort mno =  xdev->getMouseNo();
    long val = WSGIappMouse()->getMouseCursor(mno);
    if (val != 0){
      XDefineCursor(XtDisplay(xdev->getWidget()),
                    XtWindow(xdev->getWidget()),val);
    }
  }
#endif
}


WSCbool WSDdevfbDragDrop::getDragState(){
  return _under_dragging;
}

void WSDdevfbDragDrop::_btn_press_drag_start(WSCbase* client){
   WSDdevfbDragDrop* obj = (WSDdevfbDragDrop*)client->getUserData("WSDRAG-SERV");
   if (obj->_under_dragging == True){
     return;
   }
   obj->_under_dragging = True;
   _drag_client = client;
#if 0
  WSDdev* dev = client->getowndev();
  WSDdevfbFormDev* xdev = (WSDdevfbFormDev*)dev->cast("WSDdevfbFormDev");
  if (xdev == NULL){
    xdev = (WSDdevfbFormDev*)dev->getParentDev()->cast("WSDdevfbFormDev");
  }
  if (xdev != NULL){
    WSCushort mno =  154; //mouse no
    long val = WSGIappMouse()->getMouseCursor(mno);
    if (val != 0){
      XDefineCursor(XtDisplay(xdev->getWidget()),
                    XtWindow(xdev->getWidget()),val);
    }
  }
#endif
}

long WSDdevfbDragDrop::registerDragSite(WSCbase* client,char* msg){
  WSCprocedure* ac = new WSCprocedure("WSDRAG-START",WSEV_MOUSE_PRESS);
  ac->setFunction(_btn_press_drag_start,"_btn_press_drag_start");
  client->addProcedure(ac);
  client->setUserData("WSDRAG-AC",(void*)ac);
  client->setUserData("WSDRAG-MSG",(void*)WSGFstrdup(msg));
  client->setUserData("WSDRAG-SERV",(void*)this);
  return WS_NO_ERR;
}

long WSDdevfbDragDrop::unregisterDragSite(WSCbase* client){
  WSCprocedure* ac = (WSCprocedure*)client->getUserData("WSDRAG-AC");
  char* msg = (char*)client->getUserData("WSDRAG-MSG");
  if (msg != NULL){
    delete msg;
  }
  client->delProcedure(ac);
  delete ac;
  client->setUserData("WSDRAG-AC",(void*)NULL);
  client->setUserData("WSDRAG-MSG",(void*)NULL);
  return WS_NO_ERR;
}

long WSDdevfbDragDrop::registerDropSite(WSCbase* dropc,char* msg,void(*hd)(WSCbase*,WSCbase*)){
#ifdef PDBG
  printf("WSDdevfbDragDrop::registerDropSite #%s# num=%d 0x%x\n",
  dropc->getInstanceName(),_drop_site_list.getNum(),dropc);
#endif

//printf("WSDdevfbDragDrop::registerDropSite site=0x%x client=%s\n",dropc,dropc->getInstanceName());
  dropc->setUserData("WSDRAG-MSG",(void*)WSGFstrdup(msg));
  dropc->setUserData("DROP-PROC",(void*)hd);
  _drop_site_list.add((void*)dropc);

  return WS_NO_ERR;
}

long WSDdevfbDragDrop::unregisterDropSite(WSCbase* client){
#ifdef PDBG
  printf("WSDdevfbDragDrop::unregisterDropSite #%s# num=%d 0x%x\n",
  client->getInstanceName(),_drop_site_list.getNum(),client);
#endif
  char* msg = (char*)client->getUserData("WSDRAG-MSG");
  if (msg != NULL){
    delete msg;
  }
  client->setUserData("WSDRAG-MSG",(void*)NULL);
  _drop_site_list.del(client);
#ifdef PDBG
  printf("WSDdevfbDragDrop::unregisterDropSite done. num=%d\n",
  _drop_site_list.getNum());
#endif

  return WS_NO_ERR;
}

#endif //NO_DRAG_DROP
